/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.GridBagLayout;
import java.util.Collection;
import javax.swing.JOptionPane;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.geom.Geometry;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.gui.geom.Point3DPanel;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.objs.GeomUtil;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.geometry.objs.transform.MatrixXform;
import thunderheadeng.geometry.objs.transform.TransformInfo;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.PropertyUtil;
import thunderheadeng.util.theUtil;

public class TransformEditor
extends guiPanel
implements IGeomEditor<IGeom> {
    private static final long serialVersionUID = -218588775812816631L;
    private final Point3DPanel d_rotAxisPnl;
    private final ValueField<UnitDouble> d_rotAngleFld;
    private final Point3DPanel d_offsetPnl;
    private final Point3DPanel d_scalePnl;
    private final PropertyUtil.IProp<IPyroGeomSrc, TransformInfo> xformProp = new PropertyUtil.AProp<IPyroGeomSrc, TransformInfo>(IPyroGeomSrc.class){

        @Override
        public Object get(IPyroGeomSrc iPyroGeomSrc) {
            return iPyroGeomSrc.getGeom().getLocalTransform();
        }

        @Override
        public void set(IPyroGeomSrc iPyroGeomSrc, TransformInfo transformInfo) {
            if (transformInfo == null) {
                return;
            }
            iPyroGeomSrc.setGeom(iPyroGeomSrc.getGeom().applyLocalTransform(transformInfo.xform));
        }
    };

    public TransformEditor() {
        super(new GridBagLayout());
        this.d_offsetPnl = new Point3DPanel(Intl.intl("Location") + ":", true);
        this.d_rotAxisPnl = new Point3DPanel(Intl.intl("Rotation Axis") + ":", true, 28);
        guiLabel guiLabel2 = new guiLabel(Intl.intl("Rotation Angle") + ":");
        this.d_rotAngleFld = ValueFields.udFld(0.0, SI.RADIAN, UnitSystem.getSource(29));
        this.d_rotAngleFld.setNullAllowed(true);
        this.d_scalePnl = new Point3DPanel(Intl.intl("Scale") + ":", true, 28);
        int n = 0;
        this.d_offsetPnl.addToPanel(this, 0, n);
        this.d_rotAxisPnl.addToPanel(this, 0, ++n);
        GridBagUtil.add(this, guiLabel2, 0, ++n, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_rotAngleFld, 2, n, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        this.d_scalePnl.addToPanel(this, 0, ++n);
        GridBagUtil.addGlue(this);
    }

    public static boolean isNeeded(Collection<? extends IPyroGeomSrc> collection) {
        return collection.stream().anyMatch(iPyroGeomSrc -> !iPyroGeomSrc.getGeom().getLocalTransform().isIdentity());
    }

    @Override
    public String getGeomName() {
        return Intl.intl("Transformation");
    }

    @Override
    public guiPanel getPanel() {
        return this;
    }

    @Override
    public boolean validateData(Collection<? extends IPyroGeomSrc> collection, boolean bl, boolean bl2) {
        UnitPoint3D unitPoint3D = this.d_rotAxisPnl.save();
        if (unitPoint3D != null && unitPoint3D.x() == 0.0 && unitPoint3D.y() == 0.0 && unitPoint3D.z() == 0.0) {
            if (bl) {
                JOptionPane.showMessageDialog(this.getParent(), Intl.intl("The rotation axis must have non-zero length."), Intl.intl("Invalid Rotation Axis"), 0);
            }
            return false;
        }
        UnitPoint3D unitPoint3D2 = this.d_scalePnl.save();
        if (unitPoint3D2 != null && (unitPoint3D2.x() == 0.0 || unitPoint3D2.y() == 0.0 || unitPoint3D2.z() == 0.0)) {
            if (bl) {
                JOptionPane.showMessageDialog(this.getParent(), Intl.intl("The scale must be non-zero in every dimension."), Intl.intl("Invalid Scale"), 0);
            }
            return false;
        }
        return true;
    }

    private void load(ITransform iTransform) {
        if (iTransform == null) {
            this.d_rotAngleFld.setValue(null);
            this.d_rotAxisPnl.load(null);
            this.d_offsetPnl.load(null);
            this.d_scalePnl.load(null);
            return;
        }
        Matrix4d matrix4d = iTransform.toMatrix(false);
        AxisAngle4d[] axisAngle4dArray = new AxisAngle4d[]{null};
        UnitPoint3D[] unitPoint3DArray = new UnitPoint3D[]{null};
        UnitPoint3D[] unitPoint3DArray2 = new UnitPoint3D[]{null};
        GeomUtil.decompose(matrix4d, 1.0E-9, vector3d -> {
            unitPoint3DArray[0] = new UnitPoint3D((Tuple3d)vector3d, Geometry.LU);
        }, axisAngle4d -> {
            axisAngle4dArray[0] = axisAngle4d;
        }, vector3d -> {
            unitPoint3DArray[0] = new UnitPoint3D((Tuple3d)vector3d, Unit.ONE);
        });
        if (axisAngle4dArray[0] != null) {
            AxisAngle4d axisAngle4d2 = axisAngle4dArray[0];
            this.d_rotAngleFld.setValue(new UnitDouble(axisAngle4d2.angle, SI.RADIAN));
            Vector3d vector3d2 = new Vector3d(axisAngle4d2.x, axisAngle4d2.y, axisAngle4d2.z);
            vector3d2.normalize();
            this.d_rotAxisPnl.load(new UnitPoint3D(vector3d2.x, vector3d2.y, vector3d2.z, Unit.ONE));
        } else {
            this.d_rotAngleFld.setValue(null);
            this.d_rotAxisPnl.load(null);
        }
        assert (unitPoint3DArray[0] != null);
        this.d_offsetPnl.load(unitPoint3DArray[0]);
        this.d_scalePnl.load(unitPoint3DArray2[0]);
    }

    private static double getScale(double d, double d2, double d3) {
        if (d == 0.0 && d2 == 0.0 && d3 == 0.0) {
            return 0.0;
        }
        if (d == 0.0 && d2 == 0.0) {
            return d3;
        }
        if (d == 0.0 && d3 == 0.0) {
            return d2;
        }
        if (d2 == 0.0 && d3 == 0.0) {
            return d;
        }
        if (d == 0.0) {
            return theUtil.eq(d2, d3, 1.0E-5) ? d2 : Double.NaN;
        }
        if (d2 == 0.0) {
            return theUtil.eq(d, d3, 1.0E-5) ? d : Double.NaN;
        }
        if (d3 == 0.0) {
            return theUtil.eq(d, d2, 1.0E-5) ? d : Double.NaN;
        }
        return theUtil.eq(d, d2, 1.0E-5) && theUtil.eq(d, d3, 1.0E-5) ? d : Double.NaN;
    }

    private ITransform save() {
        UnitPoint3D unitPoint3D = this.d_rotAxisPnl.save();
        UnitDouble unitDouble = (UnitDouble)this.d_rotAngleFld.getValue();
        UnitPoint3D unitPoint3D2 = this.d_offsetPnl.save();
        UnitPoint3D unitPoint3D3 = this.d_scalePnl.save();
        if (unitPoint3D == null || unitDouble == null || unitPoint3D2 == null || unitPoint3D3 == null) {
            return null;
        }
        Matrix4d matrix4d = new Matrix4d();
        matrix4d.setIdentity();
        matrix4d.setRotation(new AxisAngle4d(unitPoint3D.x(), unitPoint3D.y(), unitPoint3D.z(), unitDouble.getValue(SI.RADIAN)));
        matrix4d.m03 = unitPoint3D2.x(Geometry.LU);
        matrix4d.m13 = unitPoint3D2.y(Geometry.LU);
        matrix4d.m23 = unitPoint3D2.z(Geometry.LU);
        matrix4d.m00 *= unitPoint3D3.x();
        matrix4d.m10 *= unitPoint3D3.x();
        matrix4d.m20 *= unitPoint3D3.x();
        matrix4d.m01 *= unitPoint3D3.y();
        matrix4d.m11 *= unitPoint3D3.y();
        matrix4d.m21 *= unitPoint3D3.y();
        matrix4d.m02 *= unitPoint3D3.z();
        matrix4d.m12 *= unitPoint3D3.z();
        matrix4d.m22 *= unitPoint3D3.z();
        return new MatrixXform(matrix4d).optimize();
    }

    @Override
    public void load(Collection<? extends IPyroGeomSrc> collection) {
        Object object = PropertyUtil.getProperty(this.xformProp, collection);
        if (!(object instanceof ITransform)) {
            object = null;
        }
        this.load((ITransform)object);
    }

    @Override
    public void save(Collection<? extends IPyroGeomSrc> collection) {
        ITransform iTransform = this.save();
        TransformInfo transformInfo = iTransform != null ? iTransform.getInfo() : null;
        PropertyUtil.setProperty(this.xformProp, transformInfo, collection);
    }

    @Override
    public int getNumFaces() {
        return 0;
    }

    @Override
    public String[] getFaceNames() {
        return new String[0];
    }

    @Override
    public int[] getFaceOrder(IGeomNode iGeomNode) {
        return null;
    }
}

