/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Observable;
import java.util.Observer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.tasks.TransformTask;
import pyrosim.util.GeomUtil;
import thunderheadeng.geometry.objs.IDOF;
import thunderheadeng.geometry.objs.transform.ITransform;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.IntVR;

public class TransformDialog
extends guiDialog {
    private static final long serialVersionUID = 1063878245649086790L;
    private final PyroMod d_mediator;
    private final Collection<? extends IPyroObject> d_objs;
    private final UnitPoint3D d_objCenter;
    private final JButton d_useCenterForBase;
    private final guiRadioButton d_copyButton;
    private final guiRadioButton d_moveButton;
    private final ValueField<Integer> d_numCopiesField;
    private final guiPanel d_modePanel;
    private final JButton d_previewButton;
    private final Observer d_changedObserver;
    private final boolean d_previewEnabled;
    private boolean d_transformDirty = true;
    private boolean d_transformed = false;
    private final int d_maxNumCopies;

    protected void setBase(UnitPoint3D unitPoint3D) {
    }

    protected boolean isIdentityTransform() {
        return false;
    }

    protected TransformTask taskTransform(Collection<? extends IPyroObject> collection) {
        return null;
    }

    public TransformDialog(String string, PyroMod pyroMod, Collection<? extends IPyroObject> collection, boolean bl, boolean bl2) {
        super((Window)Application.getApp().getActiveFrame(), string, 9);
        this.d_mediator = pyroMod;
        this.d_previewEnabled = bl2;
        this.d_objs = collection;
        this.d_maxNumCopies = bl ? Integer.MAX_VALUE : 1;
        this.d_objCenter = GeomUtil.getCenter(Hierarchy.flatten(this.d_objs, IPyroGeomSrc.class));
        this.d_useCenterForBase = new JButton(Intl.intl("Use Center"));
        this.d_useCenterForBase.setToolTipText("Use the center of the selected objects as the base.");
        this.d_useCenterForBase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TransformDialog.this.setBase(TransformDialog.this.d_objCenter);
            }
        });
        this.d_copyButton = new guiRadioButton(Intl.intl("Copy"));
        this.d_moveButton = new guiRadioButton(Intl.intl("Move"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.d_copyButton);
        buttonGroup.add(this.d_moveButton);
        this.d_numCopiesField = ValueFields.intFld(1, IntVR.above(1, true));
        guiLabel guiLabel2 = new guiLabel(Intl.intl("Number of Copies") + ":");
        LinkStatus.link((AbstractButton)this.d_copyButton, this.d_numCopiesField, guiLabel2);
        this.d_modePanel = new guiPanel(new GridBagLayout());
        TitleSeparator titleSeparator = new TitleSeparator(Intl.intl("Mode"));
        int n = 0;
        GridBagUtil.add(this.d_modePanel, titleSeparator, 0, n, 0, 1, 0, 0, 0, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this.d_modePanel, this.d_moveButton, 0, ++n, 1, 1, 0, 12, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this.d_modePanel, this.d_copyButton, 0, ++n, 1, 1, 0, 12, 0, 6, 0, 0.0, 0.0, 17);
        if (this.d_maxNumCopies > 1) {
            GridBagUtil.add(this.d_modePanel, guiLabel2, 1, n, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this.d_modePanel, this.d_numCopiesField, 2, n, 1, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 17);
        }
        this.d_moveButton.setSelected(true);
        if (bl2) {
            this.d_previewButton = new JButton(new AbstractAction(Intl.intl("Preview")){
                private static final long serialVersionUID = -8495383746911170601L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (TransformDialog.this.validateData(true, true)) {
                        TransformDialog.this.transform();
                    }
                }
            });
            this.addButton(this.d_previewButton);
            this.d_changedObserver = new Observer(){

                @Override
                public void update(Observable observable, Object object) {
                    TransformDialog.this.transformChanged();
                }
            };
            this.getDialogPane().addObserver(this.d_changedObserver);
        } else {
            this.d_changedObserver = null;
            this.d_previewButton = null;
        }
    }

    protected void init() {
        this.setBase(this.d_objCenter);
        if (this.d_previewEnabled) {
            this.updatePreviewableStatus(true);
        }
    }

    protected IDOF getDOF() {
        return GeomUtil.getDOF(Hierarchy.flatten(this.d_objs, IPyroGeomSrc.class));
    }

    protected String getTaskDesc() {
        return Intl.intl("Transform Objects");
    }

    public int getNumCopies() {
        if (this.d_copyButton.isSelected()) {
            if (this.d_maxNumCopies == 1) {
                return 1;
            }
            return (Integer)this.d_numCopiesField.getValue();
        }
        return 0;
    }

    protected guiPanel getModePanel() {
        return this.d_modePanel;
    }

    protected PyroMod getMediator() {
        return this.d_mediator;
    }

    protected JButton getCenterForBaseButton() {
        return this.d_useCenterForBase;
    }

    private void updatePreviewableStatus(boolean bl) {
        if (!this.d_previewEnabled) {
            return;
        }
        boolean bl2 = bl;
        this.d_previewButton.setEnabled(bl2);
    }

    private void transformChanged() {
        if (!this.d_previewEnabled) {
            return;
        }
        this.d_transformDirty = true;
        this.updatePreviewableStatus(true);
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        this.getDialogPane().removeObserver(this.d_changedObserver);
        boolean bl3 = super.validateData(bl, bl2);
        this.getDialogPane().addObserver(this.d_changedObserver);
        if (!bl3) {
            return false;
        }
        TransformTask transformTask = this.taskTransform(this.d_objs);
        int n = Math.max(1, this.getNumCopies());
        for (int i = 0; i < n; ++i) {
            ITransform iTransform = transformTask.getXFormForIteration(i + 1);
            IDOF iDOF = this.getDOF();
            if (iTransform.getInfo().isAccepted(iDOF)) continue;
            if (bl) {
                LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
                iDOF.describeRules(linkedHashSet);
                String string = Intl.intl("The transformation must obey the following rules:");
                for (String string2 : linkedHashSet) {
                    string = string + "\n    " + string2;
                }
                TransformDialog.showInvalidEntryMessage(this, string);
            }
            return false;
        }
        return true;
    }

    private void transform() {
        if (!this.d_transformDirty) {
            return;
        }
        this.cancelTransform();
        TransformTask transformTask = this.taskTransform(this.d_objs);
        if (transformTask == null) {
            return;
        }
        this.getMediator().getTaskManager().exec(transformTask, this.getTaskDesc());
        this.d_transformDirty = false;
        this.d_transformed = true;
        this.updatePreviewableStatus(false);
    }

    private void cancelTransform() {
        if (!this.d_transformed) {
            return;
        }
        this.getMediator().getTaskManager().undo();
        this.d_transformed = false;
        this.d_transformDirty = true;
    }

    protected JButton getPreviewButton() {
        return this.d_previewButton;
    }

    @Override
    public int doModal() {
        int n = super.doModal();
        if (n == 1) {
            this.transform();
        } else {
            this.cancelTransform();
        }
        return n;
    }
}

