/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.GridBagLayout;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import javax.swing.AbstractButton;
import javax.vecmath.Point2d;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.Composite;
import pyrosim.domain.geom.FDSUtil;
import pyrosim.domain.geom.ISurfObj;
import pyrosim.domain.geom.TexOrigin;
import pyrosim.gui.geom.Point3DPanel;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitPoint3D;

public class TexMapperPnl
extends guiPanel {
    private static final long serialVersionUID = -1965219916619717061L;
    private final guiMultiStateCheckBox d_customMapperCB;
    private final TitleSeparator d_texOriginLbl;
    private final guiMultiStateCheckBox d_objRelativeCB;
    private final Point3DPanel d_loc;

    public TexMapperPnl() {
        this.setLayout(new GridBagLayout());
        this.d_customMapperCB = new guiMultiStateCheckBox(Intl.intl("Use Imported Texture Coordinates"));
        this.d_texOriginLbl = new TitleSeparator(Intl.intl("Texture Origin"));
        this.d_loc = new Point3DPanel(null, true);
        this.d_objRelativeCB = new guiMultiStateCheckBox(Intl.intl("Relative to object"));
        LinkStatus.link((AbstractButton)this.d_customMapperCB, true, this.d_texOriginLbl, this.d_loc, this.d_objRelativeCB);
        this.addToPanel(this, 0);
    }

    public int addToPanel(guiPanel guiPanel2, int n) {
        int n2 = n;
        GridBagUtil.add(guiPanel2, this.d_customMapperCB, 0, n2, 10, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_texOriginLbl, 0, ++n2, 10, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_objRelativeCB, 0, ++n2, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_loc, 0, ++n2, 1, 1, 0, 12, 0, 0, 0, 0.0, 0.0, 17);
        return n2;
    }

    public void load(Collection<? extends ISurfObj> collection) {
        TexOrigin texOrigin;
        Object object = Composite.getProperty(ISurfObj.texMapperProp, collection);
        if (!(object instanceof Map)) {
            this.d_customMapperCB.setState(2);
        } else {
            this.d_customMapperCB.setSelected(((Map)object).values().stream().anyMatch(iElemSource -> !FDSUtil.isDefaultTexMapper(iElemSource)));
        }
        this.d_customMapperCB.setVisible(this.d_customMapperCB.getState() != 0);
        Object object2 = Composite.getProperty(ISurfObj.texOriginProp, collection);
        TexOrigin texOrigin2 = texOrigin = object2 instanceof TexOrigin ? (TexOrigin)object2 : null;
        if (texOrigin != null) {
            this.d_loc.load(texOrigin.getLocal());
            this.d_objRelativeCB.setSelected(texOrigin.isRelativeToObj());
        } else {
            this.d_loc.load(null);
            this.d_objRelativeCB.setState(2);
        }
    }

    public UnitPoint3D getTexOrigin() {
        return this.d_loc.save();
    }

    public Optional<Boolean> isRelativeToObj() {
        switch (this.d_objRelativeCB.getState()) {
            case 1: {
                return Optional.of(true);
            }
            case 0: {
                return Optional.of(false);
            }
            case 2: {
                return Optional.empty();
            }
        }
        assert (false);
        return Optional.empty();
    }

    public Optional<Boolean> isCustomMapper() {
        switch (this.d_customMapperCB.getState()) {
            case 1: {
                return Optional.of(true);
            }
            case 0: {
                return Optional.of(false);
            }
            case 2: {
                return Optional.empty();
            }
        }
        assert (false);
        return Optional.empty();
    }

    public void save(PyroMod pyroMod, Collection<? extends ISurfObj> collection) {
        this.isCustomMapper().ifPresent(bl -> {
            if (bl.booleanValue()) {
                Map<String, IElemSource<Point2d>> map = FDSUtil.getDefaultTexMapperSets();
                Composite.setProperty(ISurfObj.texMapperProp, map, collection);
            }
        });
        UnitPoint3D unitPoint3D = this.getTexOrigin();
        this.isRelativeToObj().ifPresent(bl -> {
            if (unitPoint3D != null) {
                TexOrigin texOrigin = new TexOrigin(unitPoint3D, (boolean)bl);
                Composite.setProperty(ISurfObj.texOriginProp, texOrigin, collection);
            }
        });
    }
}

