/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.Component;
import java.awt.Container;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagLayout;
import java.util.Collection;
import javax.swing.JButton;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.tasks.ScaleTask;
import pyrosim.domain.tasks.TransformTask;
import pyrosim.gui.geom.TransformDialog;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.DoubleVR;

public class ScaleDialog
extends TransformDialog {
    private static final long serialVersionUID = 1518400242791892604L;
    private final ValueField<Double> d_bx;
    private final ValueField<Double> d_by;
    private final ValueField<Double> d_bz;
    private final JButton d_centerButton;
    private final ValueField<Double> d_sx;
    private final ValueField<Double> d_sy;
    private final ValueField<Double> d_sz;
    private final Unit d_lu;
    private JButton d_okButton;

    public ScaleDialog(PyroMod pyroMod, Collection<? extends IPyroObject> collection) {
        super(Intl.intl("Scale Objects"), pyroMod, collection, true, true);
        UnitSystem unitSystem = ((PyroSim)Application.getApp()).getUnitSystem();
        this.d_lu = unitSystem.getLengthUnit();
        this.d_bx = ValueFields.doubleFld(0.0);
        this.d_by = ValueFields.doubleFld(0.0);
        this.d_bz = ValueFields.doubleFld(0.0);
        this.d_centerButton = this.getCenterForBaseButton();
        this.d_okButton = super.getButton(1);
        DoubleVR doubleVR = DoubleVR.above(0.0, false);
        this.d_sx = ValueFields.doubleFld(1.0, doubleVR);
        this.d_sy = ValueFields.doubleFld(1.0, doubleVR);
        this.d_sz = ValueFields.doubleFld(1.0, doubleVR);
        int n = 6;
        this.d_bx.setColumns(n);
        this.d_by.setColumns(n);
        this.d_bz.setColumns(n);
        this.d_sx.setColumns(n);
        this.d_sy.setColumns(n);
        this.d_sz.setColumns(n);
        guiLabel guiLabel2 = new guiLabel("X:");
        guiLabel guiLabel3 = new guiLabel("Y:");
        guiLabel guiLabel4 = new guiLabel("Z:");
        guiLabel guiLabel5 = new guiLabel("X:");
        guiLabel guiLabel6 = new guiLabel("Y:");
        guiLabel guiLabel7 = new guiLabel("Z:");
        TitleSeparator titleSeparator = new TitleSeparator(Intl.intl("Base Point") + " (" + this.d_lu + ")");
        TitleSeparator titleSeparator2 = new TitleSeparator(Intl.intl("Scale"));
        guiPanel guiPanel2 = new guiPanel(new GridBagLayout());
        int n2 = 0;
        GridBagUtil.add(guiPanel2, titleSeparator, 0, n2, 6, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, guiLabel2, 0, ++n2, 1, 1, 0, 12, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_bx, 1, n2, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, guiLabel3, 0, ++n2, 1, 1, 0, 12, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_by, 1, n2, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.getCenterForBaseButton(), 2, n2, 1, 1, 0, 6, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, guiLabel4, 0, ++n2, 1, 1, 0, 12, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_bz, 1, n2, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        guiPanel guiPanel3 = new guiPanel(new GridBagLayout());
        n2 = 0;
        GridBagUtil.add(guiPanel3, titleSeparator2, 0, ++n2, 6, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(guiPanel3, guiLabel5, 0, ++n2, 1, 1, 0, 12, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel3, this.d_sx, 1, n2, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel3, guiLabel6, 2, n2, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel3, this.d_sy, 3, n2, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel3, guiLabel7, 4, n2, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel3, this.d_sz, 5, n2, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        guiPanel guiPanel4 = super.getDialogPane();
        guiPanel4.setLayout(new GridBagLayout());
        n2 = 0;
        GridBagUtil.add(guiPanel4, this.getModePanel(), 0, n2, 1, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(guiPanel4, guiPanel3, 0, ++n2, 1, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(guiPanel4, guiPanel2, 0, ++n2, 1, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        CustomFocusTraversalPolicy customFocusTraversalPolicy = new CustomFocusTraversalPolicy(this.getFocusTraversalPolicy());
        this.setFocusTraversalPolicy(customFocusTraversalPolicy);
        super.init();
    }

    @Override
    protected String getTaskDesc() {
        return this.getNumCopies() > 0 ? Intl.intl("Copy/Scale Objects") : Intl.intl("Scale Objects");
    }

    private UnitPoint3D getBasePoint() {
        return new UnitPoint3D((Double)this.d_bx.getValue(), (Double)this.d_by.getValue(), (Double)this.d_bz.getValue(), this.d_lu);
    }

    private Tuple3d getScale() {
        return new Vector3d((Double)this.d_sx.getValue(), (Double)this.d_sy.getValue(), (Double)this.d_sz.getValue());
    }

    @Override
    protected void setBase(UnitPoint3D unitPoint3D) {
        this.d_bx.setValue(unitPoint3D.x(this.d_lu));
        this.d_by.setValue(unitPoint3D.y(this.d_lu));
        this.d_bz.setValue(unitPoint3D.z(this.d_lu));
    }

    @Override
    protected TransformTask taskTransform(Collection<? extends IPyroObject> collection) {
        UnitPoint3D unitPoint3D = this.getBasePoint();
        Tuple3d tuple3d = this.getScale();
        return new ScaleTask(this.getMediator(), collection, this.getNumCopies(), unitPoint3D, tuple3d);
    }

    private class CustomFocusTraversalPolicy
    extends ContainerOrderFocusTraversalPolicy {
        private static final long serialVersionUID = -2723723486849775357L;
        private final FocusTraversalPolicy oldPolicy;

        public CustomFocusTraversalPolicy(FocusTraversalPolicy focusTraversalPolicy) {
            this.oldPolicy = focusTraversalPolicy;
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            if (component.equals(ScaleDialog.this.d_by)) {
                return ScaleDialog.this.d_bz;
            }
            if (component.equals(ScaleDialog.this.d_bz)) {
                return ScaleDialog.this.d_centerButton;
            }
            if (component.equals(ScaleDialog.this.d_centerButton)) {
                return ScaleDialog.this.d_okButton;
            }
            return this.oldPolicy.getComponentAfter(container, component);
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            if (component.equals(ScaleDialog.this.d_okButton)) {
                return ScaleDialog.this.d_centerButton;
            }
            if (component.equals(ScaleDialog.this.d_centerButton)) {
                return ScaleDialog.this.d_bz;
            }
            if (component.equals(ScaleDialog.this.d_bz)) {
                return ScaleDialog.this.d_by;
            }
            return this.oldPolicy.getComponentBefore(container, component);
        }

        @Override
        public Component getFirstComponent(Container container) {
            return this.oldPolicy.getFirstComponent(container);
        }
    }
}

