/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JOptionPane;
import javax.vecmath.Point3d;
import pyrosim.Intl;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.gui.geom.PointListEditor;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.util.PropertyUtil;

public class PolygonEditor
extends guiPanel
implements IGeomEditor<IPolygon> {
    private static final long serialVersionUID = -2681259453484325881L;
    public static final String FACE_NAME = Intl.intl("Face");
    private final PointListEditor d_pointEditor;
    private final PropertyUtil.IProp<IPyroGeomSrc, IPolygon> polyProp = new PropertyUtil.AProp<IPyroGeomSrc, IPolygon>(IPyroGeomSrc.class){

        @Override
        public Object get(IPyroGeomSrc iPyroGeomSrc) {
            return (IPolygon)iPyroGeomSrc.getGeom().getLocalGeom();
        }

        @Override
        public void set(IPyroGeomSrc iPyroGeomSrc, IPolygon iPolygon) {
            iPyroGeomSrc.setGeom(iPyroGeomSrc.getGeom().applyLocalGeom(iPolygon));
        }

        @Override
        public boolean equal(IPolygon iPolygon, IPolygon iPolygon2) {
            return PolyUtil.polysEqual(iPolygon, iPolygon2);
        }
    };

    public PolygonEditor() {
        super(new BorderLayout());
        this.d_pointEditor = new PointListEditor(true);
        this.add((Component)this.d_pointEditor, "Center");
    }

    public int getNumSides() {
        return this.d_pointEditor.getNumPoints();
    }

    @Override
    public String[] getFaceNames() {
        return new String[]{FACE_NAME};
    }

    @Override
    public int getNumFaces() {
        return 1;
    }

    @Override
    public int[] getFaceOrder(IGeomNode iGeomNode) {
        return null;
    }

    @Override
    public String getGeomName() {
        return Intl.intl("Polygon");
    }

    @Override
    public guiPanel getPanel() {
        return this;
    }

    @Override
    public boolean validateData(Collection<? extends IPyroGeomSrc> collection, boolean bl, boolean bl2) {
        Point3d[] point3dArray = this.getPoints();
        if (point3dArray == null) {
            this.error(bl, Intl.intl("Empty cells are not permitted."));
            return false;
        }
        if (point3dArray.length == 0 && collection.size() > 1) {
            return true;
        }
        if (point3dArray.length < 3) {
            this.error(bl, Intl.intl("Polygons must have at least 3 points."));
            return false;
        }
        int[] nArray = Util3D.getNonCoplanar(1.0E-6, point3dArray);
        if (nArray.length > 0) {
            this.d_pointEditor.markRows(nArray);
            this.error(bl, Intl.intl("All points must be coplanar."));
            return false;
        }
        return true;
    }

    private void error(boolean bl, String string) {
        JOptionPane.showMessageDialog(this, string, Intl.intl("Invalid Polygon"), 0);
    }

    @Override
    public void load(Collection<? extends IPyroGeomSrc> collection) {
        Object object = PropertyUtil.getProperty(this.polyProp, collection);
        if (!(object instanceof IPolygon)) {
            object = null;
        }
        this.load((IPolygon)object);
    }

    @Override
    public void save(Collection<? extends IPyroGeomSrc> collection) {
        IPolygon iPolygon = this.save();
        if (iPolygon != null) {
            PropertyUtil.setProperty(this.polyProp, iPolygon, collection);
        }
    }

    private Point3d[] getPoints() {
        List<Point3d> list = this.d_pointEditor.save();
        if (list == null) {
            return null;
        }
        return list.toArray(new Point3d[list.size()]);
    }

    public void load(IPolygon iPolygon) {
        if (iPolygon == null) {
            this.d_pointEditor.load(Collections.EMPTY_LIST);
            return;
        }
        assert (iPolygon.getNumLoops() == 1);
        Point3d[] point3dArray = PolyUtil.getLoop(iPolygon, 0, false);
        this.d_pointEditor.load(Arrays.asList(point3dArray));
    }

    public IPolygon save() {
        Point3d[] point3dArray = this.getPoints();
        return point3dArray == null || point3dArray.length == 0 ? null : PolyUtil.newPoly(point3dArray);
    }
}

