/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.geom.Geometry;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.UnitDouble;

public class PointListEditor
extends guiPanel {
    private static final long serialVersionUID = -805333547767312186L;
    private final guiDefaultTableModel d_model;
    private final guiTable d_table;
    private final boolean d_autoWrap;

    public PointListEditor(boolean bl) {
        super(new GridBagLayout());
        this.d_autoWrap = bl;
        Class[] classArray = new Class[]{UnitDouble.class, UnitDouble.class, UnitDouble.class};
        String[] stringArray = new String[]{Intl.intl("X"), Intl.intl("Y"), Intl.intl("Z")};
        guiTableEditor guiTableEditor2 = new guiTableEditor(guiTableUtil.fixedColumnTable(stringArray, classArray), 30);
        this.d_table = guiTableEditor2.getTable();
        guiTable.UnitDoubleEditor unitDoubleEditor = new guiTable.UnitDoubleEditor(PyroSim.getApp().getUnitSystem().getLengthUnit());
        this.d_table.getColumnModel().getColumn(0).setCellEditor(unitDoubleEditor);
        this.d_table.getColumnModel().getColumn(1).setCellEditor(unitDoubleEditor);
        this.d_table.getColumnModel().getColumn(2).setCellEditor(unitDoubleEditor);
        this.d_table.setPreferredScrollableViewportSize(new Dimension(200, 100));
        this.d_table.setNullValuesAllowed(false);
        this.d_model = (guiDefaultTableModel)this.d_table.getModel();
        guiLabel guiLabel2 = new guiLabel(Intl.intl("Points:"));
        GridBagUtil.add(this, guiLabel2, 0, 0, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 18);
        GridBagUtil.add(this, guiTableEditor2, 1, 0, 1, 1, 0, 0, 0, 0, 1, 1.0, 1.0, 18);
    }

    public void markRows(int ... nArray) {
        if (nArray.length > 0) {
            this.d_table.getSelectionModel().clearSelection();
            for (int n : nArray) {
                this.d_table.getSelectionModel().addSelectionInterval(n, n);
            }
        }
    }

    public int getNumPoints() {
        return this.d_model.getRowCount();
    }

    public void load(Collection<Point3d> collection) {
        Unit unit = PyroSim.getApp().getUnitSystem().getLengthUnit();
        this.d_model.setNumRows(collection.size());
        int n = 0;
        for (Point3d point3d : collection) {
            this.d_model.setValueAt(UnitDouble.from(point3d.x, Geometry.LU, unit), n, 0);
            this.d_model.setValueAt(UnitDouble.from(point3d.y, Geometry.LU, unit), n, 1);
            this.d_model.setValueAt(UnitDouble.from(point3d.z, Geometry.LU, unit), n, 2);
            ++n;
        }
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        if (!super.validateData(bl, bl2)) {
            return false;
        }
        if (bl2) {
            int n;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            Point3d point3d = null;
            Tuple3d tuple3d = null;
            for (n = 0; n < this.d_model.getRowCount(); ++n) {
                UnitDouble unitDouble = (UnitDouble)this.d_model.getValueAt(n, 0);
                UnitDouble unitDouble2 = (UnitDouble)this.d_model.getValueAt(n, 1);
                UnitDouble unitDouble3 = (UnitDouble)this.d_model.getValueAt(n, 2);
                assert (unitDouble != null && unitDouble2 != null && unitDouble3 != null);
                Point3d point3d2 = new Point3d(unitDouble.getValue(Geometry.LU), unitDouble2.getValue(Geometry.LU), unitDouble3.getValue(Geometry.LU));
                if (point3d == null) {
                    point3d = point3d2;
                }
                if (point3d2.equals(tuple3d)) {
                    arrayList.add(n);
                }
                tuple3d = point3d2;
            }
            if (this.d_autoWrap && tuple3d != null && tuple3d.equals(point3d) && !arrayList.contains(n = this.d_model.getRowCount() - 1)) {
                arrayList.add(n);
            }
            if (!arrayList.isEmpty()) {
                n = JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(this), Intl.intl("Points table contains duplicate entries. Would you like to remove the duplicates?"), Intl.intl("Duplicate Points"), 1);
                if (n == 0) {
                    for (int i = arrayList.size() - 1; i >= 0; --i) {
                        this.d_model.removeRow((Integer)arrayList.get(i));
                    }
                } else if (n != 1) {
                    return false;
                }
            }
        }
        return true;
    }

    public List<Point3d> save() {
        ArrayList<Point3d> arrayList = new ArrayList<Point3d>();
        for (int i = 0; i < this.d_model.getRowCount(); ++i) {
            UnitDouble unitDouble = (UnitDouble)this.d_model.getValueAt(i, 0);
            UnitDouble unitDouble2 = (UnitDouble)this.d_model.getValueAt(i, 1);
            UnitDouble unitDouble3 = (UnitDouble)this.d_model.getValueAt(i, 2);
            if (unitDouble == null || unitDouble2 == null || unitDouble3 == null) {
                return null;
            }
            Point3d point3d = new Point3d(unitDouble.getValue(Geometry.LU), unitDouble2.getValue(Geometry.LU), unitDouble3.getValue(Geometry.LU));
            arrayList.add(point3d);
        }
        return arrayList;
    }
}

