/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.GridBagLayout;
import java.util.Collection;
import javax.vecmath.Point3d;
import pyrosim.Intl;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.Property;
import pyrosim.geom.Geometry;
import pyrosim.gui.geom.GeomGuiUtil;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.gui.geom.Point3DPanel;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class PointGeomEditor
extends guiPanel
implements IGeomEditor<Point> {
    private static final long serialVersionUID = 1621134734853455553L;
    private Point3DPanel d_locPanel;

    public PointGeomEditor() {
        this.setLayout(new GridBagLayout());
        GridBagHelper gridBagHelper = new GridBagHelper(this);
        this.d_locPanel = new Point3DPanel(Intl.intl("Location"));
        this.d_locPanel.addToPanel(gridBagHelper);
        gridBagHelper.finalizeRows();
        this.load(Property.of(new Point(new Point3d(0.0, 0.0, 0.0))));
    }

    @Override
    public boolean validateData(Collection<? extends IPyroGeomSrc> collection, boolean bl, boolean bl2) {
        return true;
    }

    @Override
    public guiPanel getPanel() {
        return this;
    }

    @Override
    public String getGeomName() {
        return Intl.intl("Location");
    }

    @Override
    public int getNumFaces() {
        return 0;
    }

    @Override
    public String[] getFaceNames() {
        return null;
    }

    @Override
    public int[] getFaceOrder(IGeomNode iGeomNode) {
        return null;
    }

    @Override
    public void load(Collection<? extends IPyroGeomSrc> collection) {
        UnitDouble[] unitDoubleArray = GeomGuiUtil.getDataVals(collection, new LocProp(), 3, Geometry.LU);
        this.d_locPanel.setX(unitDoubleArray[0]);
        this.d_locPanel.setY(unitDoubleArray[1]);
        this.d_locPanel.setZ(unitDoubleArray[2]);
    }

    @Override
    public void save(Collection<? extends IPyroGeomSrc> collection) {
        UnitDouble[] unitDoubleArray = new UnitDouble[]{this.d_locPanel.x(), this.d_locPanel.y(), this.d_locPanel.z()};
        GeomGuiUtil.setDataVals(collection, new LocProp(), Geometry.LU, unitDoubleArray);
    }

    public void load(Property<Point> property) {
        this.d_locPanel.load(property.map(point -> new UnitPoint3D(point.loc, Geometry.LU)).orElse(null));
    }

    public Property<Point> save() {
        UnitPoint3D unitPoint3D2 = this.d_locPanel.save();
        return Property.ofNullable(unitPoint3D2).map(unitPoint3D -> new Point(unitPoint3D.getPoint3dValue(Geometry.LU)));
    }

    private static class LocProp
    extends GeomGuiUtil.AGeomProp<Point> {
        private LocProp() {
        }

        @Override
        protected Point constructGeom(Point point, double[] dArray) {
            return new Point(new Point3d(dArray));
        }

        @Override
        protected double[] saveData(Point point) {
            double[] dArray = new double[3];
            point.loc.get(dArray);
            return dArray;
        }
    }
}

