/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.GridBagLayout;
import pyrosim.Intl;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class Point3DPanel
extends guiPanel {
    private static final long serialVersionUID = -6913201894682830905L;
    private final guiLabel d_locLabel;
    private final ValueField<UnitDouble> d_xLoc;
    private final ValueField<UnitDouble> d_yLoc;
    private final ValueField<UnitDouble> d_zLoc;
    private boolean d_emptyAllowed;

    public Point3DPanel(String string) {
        this(string, false);
    }

    public Point3DPanel(String string, boolean bl) {
        this(string, bl, 0);
    }

    public Point3DPanel(String string, boolean bl, int n) {
        this.setLayout(new GridBagLayout());
        this.d_locLabel = string != null ? new guiLabel(string) : null;
        this.d_xLoc = Point3DPanel.newField(0.0, n);
        this.d_yLoc = Point3DPanel.newField(0.0, n);
        this.d_zLoc = Point3DPanel.newField(0.0, n);
        this.d_emptyAllowed = bl;
        this.addToPanel(this, 0, 0);
    }

    private static ValueField<UnitDouble> newField(double d, int n) {
        IUnitSrc iUnitSrc = UnitSystem.getSource(n);
        ValueField<UnitDouble> valueField = ValueFields.udFld(new UnitDouble(d, iUnitSrc.getUnit()), iUnitSrc);
        valueField.setNullAllowed(true);
        return valueField;
    }

    public void addToPanel(guiPanel guiPanel2, int n, int n2) {
        guiLabel guiLabel2 = new guiLabel(Intl.intl("X") + ":");
        guiLabel guiLabel3 = new guiLabel(Intl.intl("Y") + ":");
        guiLabel guiLabel4 = new guiLabel(Intl.intl("Z") + ":");
        int n3 = n2;
        int n4 = n;
        if (this.d_locLabel != null) {
            GridBagUtil.add(guiPanel2, this.d_locLabel, n4++, n3, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        }
        GridBagUtil.add(guiPanel2, guiLabel2, n4++, n3, 1, 1, 0, 0, 3, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_xLoc, n4++, n3, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, guiLabel3, n4++, n3, 1, 1, 0, 0, 3, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_yLoc, n4++, n3, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, guiLabel4, n4++, n3, 1, 1, 0, 0, 3, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_zLoc, n4++, n3, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
    }

    public void addToPanel(GridBagHelper gridBagHelper) {
        gridBagHelper.addRow(this.d_locLabel, Intl.intl("X:"), this.d_xLoc, Intl.intl("Y:"), this.d_yLoc, Intl.intl("Z:"), this.d_zLoc);
    }

    public void load(UnitPoint3D unitPoint3D) {
        if (unitPoint3D == null) {
            this.d_xLoc.setValue(null);
            this.d_yLoc.setValue(null);
            this.d_zLoc.setValue(null);
        } else {
            this.d_xLoc.setValue(unitPoint3D.xu());
            this.d_yLoc.setValue(unitPoint3D.yu());
            this.d_zLoc.setValue(unitPoint3D.zu());
        }
    }

    public UnitDouble x() {
        return (UnitDouble)this.d_xLoc.getValue();
    }

    public UnitDouble y() {
        return (UnitDouble)this.d_yLoc.getValue();
    }

    public UnitDouble z() {
        return (UnitDouble)this.d_zLoc.getValue();
    }

    public void setX(UnitDouble unitDouble) {
        this.d_xLoc.setValue(unitDouble);
    }

    public void setY(UnitDouble unitDouble) {
        this.d_yLoc.setValue(unitDouble);
    }

    public void setZ(UnitDouble unitDouble) {
        this.d_zLoc.setValue(unitDouble);
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        if (!super.validateData(bl, bl2)) {
            return false;
        }
        if (!this.d_emptyAllowed && (this.d_xLoc.isEmpty() || this.d_yLoc.isEmpty() || this.d_zLoc.isEmpty())) {
            if (bl) {
                guiDialog.showInvalidEntryMessage(this, Intl.intl("Error: Empty value field detected."));
            }
            return false;
        }
        return true;
    }

    public UnitPoint3D save() {
        if (this.d_xLoc.isEmpty() || this.d_yLoc.isEmpty() || this.d_zLoc.isEmpty()) {
            return null;
        }
        return new UnitPoint3D((UnitDouble)this.d_xLoc.getValue(), (UnitDouble)this.d_yLoc.getValue(), (UnitDouble)this.d_zLoc.getValue());
    }

    public void setEditable(boolean bl) {
        this.d_xLoc.setEditable(bl);
        this.d_yLoc.setEditable(bl);
        this.d_zLoc.setEditable(bl);
    }
}

