/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.geom.plane.AAPlane;
import pyrosim.domain.geom.plane.EuclideanPlane;
import pyrosim.domain.geom.plane.IPlane;
import pyrosim.domain.geom.plane.PointNormalPlane;
import pyrosim.geom.Geometry;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.Plane3d;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.TypeFilter;

public class PlaneDialog
extends guiDialog {
    private static final long serialVersionUID = -1067265634156487241L;
    private final guiComboBox<IEditor<? extends IPlane>> d_editorCB;
    private final CardLayout d_cards;

    public PlaneDialog(Window window) {
        super(window, Intl.intl("Edit Plane"), 9);
        List<IEditor> list = Arrays.asList(new AAEditor(), new PointNormalEditor(), new EuclideanEditor());
        this.d_editorCB = new guiComboBox<IEditor>((Collection<IEditor>)list);
        this.d_cards = new CardLayout();
        guiPanel guiPanel2 = new guiPanel(this.d_cards);
        for (IEditor iEditor : list) {
            guiPanel2.add((Component)iEditor.getComponent(), iEditor.toString());
        }
        this.d_editorCB.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() != 1) {
                return;
            }
            IEditor iEditor = (IEditor)itemEvent.getItem();
            this.d_cards.show(guiPanel2, iEditor.toString());
        });
        GridBagHelper gridBagHelper = new GridBagHelper(this.getDialogPane());
        gridBagHelper.addRow(Intl.intl("Plane type:"), this.d_editorCB);
        gridBagHelper.addFilledRow(new JSeparator());
        gridBagHelper.indent();
        gridBagHelper.addFilledRow(guiPanel2);
        gridBagHelper.finalizeRows();
    }

    public void load(IPlane iPlane) {
        for (IEditor<? extends IPlane> iEditor : this.d_editorCB.getAllItems()) {
            iEditor.load(iPlane);
            if (!iEditor.getFilter().test(iPlane)) continue;
            this.d_editorCB.setSelectedItem(iEditor);
        }
    }

    public IPlane save() {
        return this.d_editorCB.getSelectedItem().save();
    }

    private static class PointNormalEditor
    extends AEditor<PointNormalPlane> {
        private static final long serialVersionUID = 2172327532059096893L;
        private final ValueField<Double> d_nx = ValueFields.doubleFld();
        private final ValueField<Double> d_ny = ValueFields.doubleFld();
        private final ValueField<Double> d_nz = ValueFields.doubleFld();
        private final ValueField<UnitDouble> d_x;
        private final ValueField<UnitDouble> d_y;
        private final ValueField<UnitDouble> d_z;

        public PointNormalEditor() {
            super(PointNormalPlane.class);
            IUnitSrc iUnitSrc = UnitSystem.getSource(0);
            this.d_x = ValueFields.udFld(iUnitSrc);
            this.d_y = ValueFields.udFld(iUnitSrc);
            this.d_z = ValueFields.udFld(iUnitSrc);
            GridBagHelper gridBagHelper = new GridBagHelper(this);
            gridBagHelper.addRow(Intl.intl("Point on Plane:"), "X:", this.d_x, "Y:", this.d_y, "Z:", this.d_z);
            gridBagHelper.addRow(Intl.intl("Normal to Plane:"), "X:", this.d_nx, "Y:", this.d_ny, "Z:", this.d_nz);
            gridBagHelper.finalizeRows();
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            if (!super.validateData(bl, bl2)) {
                return false;
            }
            if ((Double)this.d_nx.getValue() == 0.0 && (Double)this.d_ny.getValue() == 0.0 && (Double)this.d_nz.getValue() == 0.0) {
                if (bl) {
                    JOptionPane.showMessageDialog(this, Intl.intl("At least one of normal's x,y, or z components must not be zero."), Intl.intl("Invalid Plane Equation"), 0);
                }
                return false;
            }
            return true;
        }

        @Override
        public void load(IPlane iPlane) {
            Point3d point3d;
            Vector3d vector3d;
            Serializable serializable;
            if (iPlane instanceof PointNormalPlane) {
                serializable = (PointNormalPlane)iPlane;
                vector3d = ((PointNormalPlane)serializable).normal;
                point3d = ((PointNormalPlane)serializable).point;
            } else {
                serializable = iPlane.get();
                vector3d = ((Plane3d)serializable).getNormal();
                point3d = ((Plane3d)serializable).getPointOnPlane();
            }
            this.d_nx.setValue(vector3d.x);
            this.d_ny.setValue(vector3d.y);
            this.d_nz.setValue(vector3d.z);
            serializable = Geometry.LU;
            this.d_x.setValue(new UnitDouble(point3d.x, (Unit)serializable));
            this.d_y.setValue(new UnitDouble(point3d.y, (Unit)serializable));
            this.d_z.setValue(new UnitDouble(point3d.z, (Unit)serializable));
        }

        @Override
        public PointNormalPlane save() {
            Unit unit = Geometry.LU;
            Point3d point3d = new Point3d(((UnitDouble)this.d_x.getValue()).get(unit), ((UnitDouble)this.d_y.getValue()).get(unit), ((UnitDouble)this.d_z.getValue()).get(unit));
            Vector3d vector3d = new Vector3d((Double)this.d_nx.getValue(), (Double)this.d_ny.getValue(), (Double)this.d_nz.getValue());
            vector3d.normalize();
            return new PointNormalPlane(point3d, vector3d);
        }

        @Override
        public String toString() {
            return Intl.intl("Point+Normal");
        }
    }

    private static class EuclideanEditor
    extends AEditor<EuclideanPlane> {
        private static final long serialVersionUID = -3442108797140848653L;
        private final ValueField<Double> d_x;
        private final ValueField<Double> d_y;
        private final ValueField<Double> d_z;
        private final ValueField<UnitDouble> d_w;

        public EuclideanEditor() {
            super(EuclideanPlane.class);
            IUnitSrc iUnitSrc = UnitSystem.getSource(0);
            this.d_x = ValueFields.doubleFld();
            this.d_y = ValueFields.doubleFld();
            this.d_z = ValueFields.doubleFld();
            this.d_w = ValueFields.udFld(iUnitSrc);
            GridBagHelper gridBagHelper = new GridBagHelper(this);
            gridBagHelper.addFilledRow(Intl.intl("Enter the plane equation (ax + by + cz + d = 0):"));
            gridBagHelper.addRow("a:", this.d_x, "b:", this.d_y, "c:", this.d_z, "d:", this.d_w);
            gridBagHelper.finalizeRows();
        }

        @Override
        public void load(IPlane iPlane) {
            if (iPlane instanceof EuclideanPlane) {
                EuclideanPlane euclideanPlane = (EuclideanPlane)iPlane;
                this.d_x.setValue(euclideanPlane.x);
                this.d_y.setValue(euclideanPlane.y);
                this.d_z.setValue(euclideanPlane.z);
                this.d_w.setValue(new UnitDouble(euclideanPlane.w, Geometry.LU));
            } else {
                Plane3d plane3d = iPlane.get();
                this.d_x.setValue(plane3d.x);
                this.d_y.setValue(plane3d.y);
                this.d_z.setValue(plane3d.z);
                this.d_w.setValue(new UnitDouble(plane3d.w, Geometry.LU));
            }
        }

        @Override
        public EuclideanPlane save() {
            return new EuclideanPlane((Double)this.d_x.getValue(), (Double)this.d_y.getValue(), (Double)this.d_z.getValue(), ((UnitDouble)this.d_w.getValue()).get(Geometry.LU));
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            if (!super.validateData(bl, bl2)) {
                return false;
            }
            if ((Double)this.d_x.getValue() == 0.0 && (Double)this.d_y.getValue() == 0.0 && (Double)this.d_z.getValue() == 0.0) {
                if (bl) {
                    JOptionPane.showMessageDialog(this, Intl.intl("At least one of a, b, or c must not be zero."), Intl.intl("Invalid Plane Equation"), 0);
                }
                return false;
            }
            return true;
        }

        @Override
        public String toString() {
            return Intl.intl("Equation");
        }
    }

    private static class AAEditor
    extends AEditor<AAPlane> {
        private static final long serialVersionUID = -605447132620261232L;
        private final guiComboBox<AAPlane.Axis> d_axis = new guiComboBox<AAPlane.Axis>(AAPlane.Axis.values());
        private final ValueField<UnitDouble> d_val = ValueFields.udFld(UnitSystem.getSource(0));
        private final guiComboBox<Boolean> d_dirCB = new guiComboBox<Boolean>((T[])new Boolean[]{true, false});

        public AAEditor() {
            super(AAPlane.class);
            this.d_dirCB.setRenderer(new DefaultListCellRenderer(){
                private static final long serialVersionUID = -726292616128815378L;

                @Override
                public Component getListCellRendererComponent(JList<?> jList, Object object, int n, boolean bl, boolean bl2) {
                    super.getListCellRendererComponent(jList, object, n, bl, bl2);
                    Boolean bl3 = (Boolean)object;
                    char c = bl3 != false ? (char)'+' : '-';
                    String string = String.format("%c%s", Character.valueOf(c), d_axis.getSelectedItem());
                    this.setText(string);
                    return this;
                }
            });
            this.d_axis.addItemListener(itemEvent -> this.d_dirCB.repaint());
            GridBagHelper gridBagHelper = new GridBagHelper(this);
            guiPanel guiPanel2 = new guiPanel(new FlowLayout(0, gridBagHelper.d_colSpace, 0));
            guiPanel2.add(this.d_axis);
            guiPanel2.add(new guiLabel("="));
            guiPanel2.add(this.d_val);
            gridBagHelper.addRow(guiPanel2, 0);
            gridBagHelper.addRow(Intl.intl("Normal:"), this.d_dirCB, 0);
            gridBagHelper.finalizeRows();
        }

        @Override
        public void load(IPlane iPlane) {
            if (iPlane instanceof AAPlane) {
                AAPlane aAPlane = (AAPlane)iPlane;
                this.d_axis.setSelectedItem((Object)aAPlane.axis);
                this.d_val.setValue(new UnitDouble(aAPlane.val, Geometry.LU));
                this.d_dirCB.setSelectedItem(aAPlane.pnormal);
            }
        }

        @Override
        public AAPlane save() {
            return new AAPlane(this.d_axis.getSelectedItem(), ((UnitDouble)this.d_val.getValue()).get(Geometry.LU), this.d_dirCB.getSelectedItem());
        }

        @Override
        public String toString() {
            return Intl.intl("Axis-aligned");
        }
    }

    private static abstract class AEditor<T extends IPlane>
    extends guiPanel
    implements IEditor<T> {
        private static final long serialVersionUID = 7079981840797444311L;
        private final Class<T> d_clazz;

        public AEditor(Class<T> clazz) {
            this.d_clazz = clazz;
        }

        @Override
        public Predicate<IPlane> getFilter() {
            return new TypeFilter<IPlane>(this.d_clazz);
        }

        @Override
        public JComponent getComponent() {
            return this;
        }
    }

    private static interface IEditor<T extends IPlane> {
        public Predicate<IPlane> getFilter();

        public JComponent getComponent();

        public void load(IPlane var1);

        public T save();
    }
}

