/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Composite;
import pyrosim.domain.INamed;
import pyrosim.domain.Property;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.geom.PartCloud;
import pyrosim.domain.particle.Particle;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.comboboxes.ParticleComboBox;
import pyrosim.gui.controls.ControlSelPnl;
import pyrosim.gui.geom.ModelObjectDialog;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.gui.ComponentGroup;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.theUtil;

public class PartCloudEditor
implements ModelObjectDialog.IEditor<PartCloud> {
    private final ModelObjectDialog d_parent;
    private final ParticleComboBox d_particleCombo;
    private final DropletCountPanel d_dropletCountPanel;
    private final InsertionPanel d_insertPanel;
    private final JButton d_editPartBtn;
    private Property<Boolean> d_geom3d;
    private Collection<? extends PartCloud> d_loadedObjs = Collections.EMPTY_LIST;
    Composite.AObjectProp<PartCloud, Boolean> hasVolumeProp = new Composite.AObjectProp<PartCloud, Boolean>(PartCloud.class){

        @Override
        public Object get(PartCloud partCloud) {
            return !(partCloud.getGeom().getLocalGeom() instanceof Point);
        }

        @Override
        public void set(PartCloud partCloud, Boolean bl) {
        }
    };

    public PartCloudEditor(ModelObjectDialog modelObjectDialog, PyroMod pyroMod) {
        this.d_parent = modelObjectDialog;
        this.d_dropletCountPanel = new DropletCountPanel(true);
        this.d_insertPanel = new InsertionPanel(pyroMod, modelObjectDialog.getNameSource(), true);
        this.d_geom3d = Property.nonUniform();
        this.d_particleCombo = new ParticleComboBox(PyroSim.getApp().getMediator().getPartList(), null, null);
        this.d_particleCombo.addItemListener(itemEvent -> {
            if (itemEvent.getStateChange() == 1) {
                this.updateEnabled();
            }
        });
        this.d_editPartBtn = new JButton(Intl.intl("Edit Particles") + "...");
        this.d_editPartBtn.addActionListener(actionEvent -> {
            Actions.editParticles((Particle)this.d_particleCombo.getSelectedItem());
            if (this.d_particleCombo.getSelectedItem() == null && this.d_particleCombo.getItemCount() > 0 && this.d_parent.getMode() == 0) {
                this.d_particleCombo.setSelectedIndex(0);
            }
            this.updateEnabled();
        });
    }

    @Override
    public boolean isControllable(PartCloud partCloud) {
        return false;
    }

    public void updateEnabled() {
        Property<Boolean> property = this.d_particleCombo.getSelectedItem() == null ? Property.nonUniform() : Property.of(((Particle)this.d_particleCombo.getSelectedItem()).isType(Particle.Type.TRACER));
        this.d_insertPanel.updateEnabled(property, this.d_geom3d);
        this.d_dropletCountPanel.updateEnabled(property, this.d_geom3d);
    }

    @Override
    public String getDialogTitle() {
        return Intl.intl("Particle Cloud Properties");
    }

    @Override
    public Class<PartCloud> getType() {
        return PartCloud.class;
    }

    @Override
    public boolean validateData(Component component, boolean bl, boolean bl2) {
        if (this.d_particleCombo.getSelectedItem() == null && this.d_parent.getMode() == 0) {
            if (bl) {
                guiDialog.showInvalidEntryMessage(component, Intl.intl("A valid particle must be selected."));
            }
            return false;
        }
        return true;
    }

    @Override
    public void add(ModelObjectDialog modelObjectDialog, GridBagHelper gridBagHelper) {
        gridBagHelper.addRow(Intl.intl("Particle") + ":", this.d_particleCombo, this.d_editPartBtn, 0);
        gridBagHelper.addFilledRow(new TitleSeparator(Intl.intl("Droplet Count")));
        gridBagHelper.addIdentRow(this.d_dropletCountPanel, 1.0, 0);
        gridBagHelper.addFilledRow(new TitleSeparator(Intl.intl("Insertion")));
        gridBagHelper.addIdentRow(this.d_insertPanel, 1.0, 0);
    }

    @Override
    public List<Pair<String, guiPanel>> getExtraTabs() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public void load(PyroMod pyroMod, Collection<? extends PartCloud> collection) {
        this.d_insertPanel.loadData(collection);
        Property property = Composite.getProp(PartCloud.partProp, collection);
        this.d_particleCombo.setSelectedItem(property.orElse(null));
        this.d_dropletCountPanel.loadData(collection);
        this.d_geom3d = Composite.getProp(this.hasVolumeProp, collection);
        this.updateEnabled();
        this.d_loadedObjs = collection;
    }

    @Override
    public void save(PyroMod pyroMod, Collection<? extends PartCloud> collection) {
        this.d_insertPanel.saveData(collection);
        Property property = Property.ofNullable(this.d_particleCombo.getSelectedItem());
        Composite.setProp(PartCloud.partProp, property, collection);
        this.d_dropletCountPanel.saveData(collection);
    }

    private static abstract class AProp<PropT>
    extends Composite.AObjectProp<PartCloud, PropT> {
        public AProp() {
            super(PartCloud.class);
        }
    }

    public static class DropletCountPanel
    extends guiPanel {
        private static final long serialVersionUID = 4753295072047403454L;
        private final guiRadioButton d_densityRB;
        private final guiRadioButton d_constantRB;
        private final guiRadioButton d_cellDensityRB;
        private final ValueField<Integer> d_constant;
        private final ValueField<UnitDouble> d_density;
        private final ValueField<Integer> d_cellDensity;
        private final guiMultiStateCheckBox d_cellCenteredCB;
        private final ButtonGroup d_group;
        private Collection<? extends PartCloud> d_loadedObjs = Collections.EMPTY_LIST;
        private AProp<Type> typeProp = new AProp<Type>(){

            @Override
            public Object get(PartCloud partCloud) {
                PartCloud.IDropletCount iDropletCount = partCloud.getInitDrops();
                Type type = Type.get(iDropletCount);
                return type == null ? Composite.NOT_SUPPORTED : type;
            }

            @Override
            public void set(PartCloud partCloud, Type type) {
                PartCloud.IDropletCount iDropletCount;
                if (type == this.get(partCloud)) {
                    return;
                }
                switch (type) {
                    case DENSITY: {
                        iDropletCount = new PartCloud.DropDensityCount();
                        break;
                    }
                    case CONSTANT: {
                        iDropletCount = new PartCloud.ConstDropletCount();
                        break;
                    }
                    case CELL_DENSITY: {
                        iDropletCount = new PartCloud.PerCellCount();
                        break;
                    }
                    default: {
                        return;
                    }
                }
                partCloud.setInitDrops(iDropletCount);
            }
        };
        private AProp<Integer> constCountProp = new AProp<Integer>(){

            @Override
            public Object get(PartCloud partCloud) {
                return ((PartCloud.ConstDropletCount)partCloud.getInitDrops()).d_dropCount;
            }

            @Override
            public void set(PartCloud partCloud, Integer n) {
                partCloud.setInitDrops(new PartCloud.ConstDropletCount(n));
            }
        };
        private AProp<UnitDouble> densityProp = new AProp<UnitDouble>(){

            @Override
            public Object get(PartCloud partCloud) {
                return ((PartCloud.DropDensityCount)partCloud.getInitDrops()).d_density;
            }

            @Override
            public void set(PartCloud partCloud, UnitDouble unitDouble) {
                partCloud.setInitDrops(new PartCloud.DropDensityCount(unitDouble));
            }
        };
        private AProp<Integer> perCellProp = new AProp<Integer>(){

            @Override
            public Object get(PartCloud partCloud) {
                return ((PartCloud.PerCellCount)partCloud.getInitDrops()).partPerCell;
            }

            @Override
            public void set(PartCloud partCloud, Integer n) {
                partCloud.setInitDrops(new PartCloud.PerCellCount(n, ((PartCloud.PerCellCount)partCloud.getInitDrops()).cellCentered));
            }
        };
        private AProp<Boolean> cellCenteredProp = new AProp<Boolean>(){

            @Override
            public Object get(PartCloud partCloud) {
                return ((PartCloud.PerCellCount)partCloud.getInitDrops()).cellCentered;
            }

            @Override
            public void set(PartCloud partCloud, Boolean bl) {
                partCloud.setInitDrops(new PartCloud.PerCellCount(((PartCloud.PerCellCount)partCloud.getInitDrops()).partPerCell, bl));
            }
        };

        public DropletCountPanel(boolean bl) {
            this.setLayout(new GridBagLayout());
            this.d_densityRB = new guiRadioButton(Intl.intl("Density") + ":");
            this.d_cellDensityRB = new guiRadioButton(Intl.intl("Droplets/cell:"));
            this.d_constantRB = new guiRadioButton(Intl.intl("Constant") + ":");
            this.d_densityRB.setSelected(true);
            this.d_density = ValueFields.udFld(10.0, SIUS.unit(55), UnitSystem.getSource(55));
            this.d_cellDensity = ValueFields.intFld(1);
            this.d_cellCenteredCB = new guiMultiStateCheckBox(Intl.intl("Cell-centered"));
            this.d_constant = ValueFields.intFld();
            this.d_cellDensity.setNullAllowed(bl);
            this.d_constant.setNullAllowed(bl);
            this.d_density.setNullAllowed(bl);
            this.d_group = guiUtil.group(new AbstractButton[]{this.d_densityRB, this.d_cellDensityRB, this.d_constantRB});
            LinkStatus.link((AbstractButton)this.d_densityRB, this.d_density);
            LinkStatus.link((AbstractButton)this.d_constantRB, this.d_constant);
            LinkStatus.link((AbstractButton)this.d_cellDensityRB, this.d_cellDensity, this.d_cellCenteredCB);
            GridBagHelper gridBagHelper = new GridBagHelper(this);
            gridBagHelper.addRow(this.d_densityRB, this.d_density, 0);
            gridBagHelper.addRow(this.d_cellDensityRB, this.d_cellDensity, this.d_cellCenteredCB, 0);
            gridBagHelper.addRow(this.d_constantRB, this.d_constant, 0);
            gridBagHelper.finalizeRows();
            this.d_density.setValue(new PartCloud.DropDensityCount().d_density);
            this.d_constant.setValue(new PartCloud.ConstDropletCount().d_dropCount);
            this.d_cellDensity.setValue(new PartCloud.PerCellCount().partPerCell);
            this.d_cellCenteredCB.setSelected(new PartCloud.PerCellCount().cellCentered);
        }

        public void unselect() {
            this.d_group.clearSelection();
        }

        public void updateEnabled(Property<Boolean> property, Property<Boolean> property2) {
            boolean bl = property2.orElse(true);
            if (bl != this.d_densityRB.isVisible()) {
                this.d_densityRB.setVisible(bl);
                this.d_density.setVisible(bl);
                if (!bl && this.d_densityRB.isSelected()) {
                    this.d_constantRB.setSelected(true);
                }
                SwingUtilities.invokeLater(() -> SwingUtilities.getWindowAncestor(this).pack());
            }
        }

        public void loadData(Collection<? extends PartCloud> collection) {
            Property property = Composite.getProp(this.typeProp, collection);
            if (!property.isUniform()) {
                this.unselect();
            } else {
                switch ((Type)((Object)property.get())) {
                    case DENSITY: {
                        this.d_densityRB.setSelected(true);
                        Property property2 = Composite.getProp(this.densityProp, collection);
                        this.d_density.setValue(property2.orElse(null));
                        break;
                    }
                    case CONSTANT: {
                        this.d_constantRB.setSelected(true);
                        Property property3 = Composite.getProp(this.constCountProp, collection, Type.CONSTANT.getFilter());
                        this.d_constant.setValue(property3.orElse(null));
                        break;
                    }
                    case CELL_DENSITY: {
                        this.d_cellDensityRB.setSelected(true);
                        Property property4 = Composite.getProp(this.perCellProp, collection, Type.CELL_DENSITY.getFilter());
                        this.d_cellDensity.setValue(property4.orElse(null));
                        Property property5 = Composite.getProp(this.cellCenteredProp, collection, Type.CELL_DENSITY.getFilter());
                        if (!property5.isUniform()) {
                            this.d_cellCenteredCB.setState(2);
                            break;
                        }
                        this.d_cellCenteredCB.setSelected((Boolean)property5.get());
                    }
                }
            }
            this.d_loadedObjs = collection;
        }

        public void loadData(Property<PartCloud.IDropletCount> property) {
            if (!property.isUniform()) {
                this.unselect();
            } else if (property.get() instanceof PartCloud.DropDensityCount) {
                this.d_densityRB.setSelected(true);
                this.d_density.setValue(((PartCloud.DropDensityCount)property.get()).d_density);
            } else if (property.get() instanceof PartCloud.ConstDropletCount) {
                this.d_constantRB.setSelected(true);
                this.d_constant.setValue(((PartCloud.ConstDropletCount)property.get()).getNumDrops(null));
            } else if (property.get() instanceof PartCloud.PerCellCount) {
                PartCloud.PerCellCount perCellCount = (PartCloud.PerCellCount)property.get();
                this.d_cellDensityRB.setSelected(true);
                this.d_cellDensity.setValue(perCellCount.partPerCell);
                this.d_cellCenteredCB.setSelected(perCellCount.cellCentered);
            }
        }

        public void saveData(Collection<? extends PartCloud> collection) {
            collection = theUtil.filter(collection, this.getSaveFilter());
            if (this.d_densityRB.isSelected()) {
                Composite.setProperty(this.typeProp, Type.DENSITY, collection);
                Composite.setProp(this.densityProp, Property.ofNullable(this.d_density.getValue()), collection);
            } else if (this.d_constantRB.isSelected()) {
                Composite.setProperty(this.typeProp, Type.CONSTANT, collection);
                Composite.setProp(this.constCountProp, Property.ofNullable(this.d_constant.getValue()), collection);
            } else if (this.d_cellDensityRB.isSelected()) {
                Composite.setProperty(this.typeProp, Type.CELL_DENSITY, collection);
                Composite.setProp(this.perCellProp, Property.ofNullable(this.d_cellDensity.getValue()), collection);
                Property property = this.d_cellCenteredCB.getState() == 2 ? Property.nonUniform() : Property.of(this.d_cellCenteredCB.isSelected());
                Composite.setProp(this.cellCenteredProp, property, collection);
            }
        }

        public Predicate<PartCloud> getSaveFilter() {
            if (this.d_densityRB.isSelected()) {
                return partCloud -> !(partCloud.getGeom().getLocalGeom() instanceof Point);
            }
            return Predicates.alwaysTrue();
        }

        public Property<PartCloud.IDropletCount> saveData() {
            if (this.d_densityRB.isSelected()) {
                return Property.of(new PartCloud.DropDensityCount((UnitDouble)this.d_density.getValue()));
            }
            if (this.d_constantRB.isSelected()) {
                return Property.of(new PartCloud.ConstDropletCount((Integer)this.d_constant.getValue()));
            }
            if (this.d_cellDensityRB.isSelected()) {
                return Property.of(new PartCloud.PerCellCount((Integer)this.d_cellDensity.getValue(), this.d_cellCenteredCB.isSelected()));
            }
            return Property.nonUniform();
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            if (!super.validateData(bl, bl2)) {
                return false;
            }
            if (!this.d_loadedObjs.stream().allMatch(this.getSaveFilter()) && bl) {
                String string = Intl.intl("Some objects in the selection have point-geometry specified. Only\nthose with non-point geometry will have their droplet count updated.");
                int n = JOptionPane.showConfirmDialog(SwingUtilities.getWindowAncestor(this), string, Intl.intl("Point Geometry"), 2);
                if (n != 0) {
                    return false;
                }
            }
            return true;
        }

        private static enum Type {
            DENSITY,
            CONSTANT,
            CELL_DENSITY;


            public static Type get(PartCloud.IDropletCount iDropletCount) {
                if (iDropletCount instanceof PartCloud.DropDensityCount) {
                    return DENSITY;
                }
                if (iDropletCount instanceof PartCloud.ConstDropletCount) {
                    return CONSTANT;
                }
                if (iDropletCount instanceof PartCloud.PerCellCount) {
                    return CELL_DENSITY;
                }
                return null;
            }

            public boolean isType(PartCloud.IDropletCount iDropletCount) {
                return Type.get(iDropletCount) == this;
            }

            public Predicate<PartCloud> getFilter() {
                return partCloud -> this.isType(partCloud.getInitDrops());
            }
        }
    }

    public static class InsertionPanel
    extends guiPanel {
        private static final long serialVersionUID = 8172418242064934739L;
        private static final String ONCE_CARD = "ONCE";
        private static final String PERIODIC_CARD = "PERIODIC";
        private static final String NULL_CARD = "NULL";
        private final guiRadioButton d_insertOnceBtn;
        private final guiRadioButton d_insertPerBtn;
        private final ValueField<UnitDouble> d_massPerVol;
        private final ValueField<UnitDouble> d_dt;
        private final ValueField<UnitDouble> d_massPerTime;
        private final ButtonGroup d_typeGroup;
        private final ComponentGroup d_dtGroup;
        private final ComponentGroup d_massPerVolGroup;
        private final ComponentGroup d_massPerTimeGroup;
        private final ControlSelPnl d_controlPnl;
        private final Pair<guiPanel, CardLayout> d_cards;
        private final ControlSelPnl.INameSource d_nameSrc;
        private final AProp<Type> typeProp = new AProp<Type>(){

            @Override
            public Object get(PartCloud partCloud) {
                return Type.get(partCloud.getInsertion());
            }

            @Override
            public void set(PartCloud partCloud, Type type) {
                PartCloud.IInsertion iInsertion;
                if (type == this.get(partCloud)) {
                    return;
                }
                switch (type) {
                    case ONCE: {
                        iInsertion = new PartCloud.InsertOnce();
                        break;
                    }
                    case PERIODIC: {
                        iInsertion = new PartCloud.InsertPeriodically();
                        break;
                    }
                    default: {
                        return;
                    }
                }
                partCloud.setInsertion(iInsertion);
            }
        };
        private final AProp<UnitDouble> massPerVolProp = new AProp<UnitDouble>(){

            @Override
            public Object get(PartCloud partCloud) {
                return ((PartCloud.InsertOnce)partCloud.getInsertion()).massPerVolume;
            }

            @Override
            public void set(PartCloud partCloud, UnitDouble unitDouble) {
                partCloud.setInsertion(new PartCloud.InsertOnce(unitDouble));
            }
        };
        private final AProp<UnitDouble> massPerTimeProp = new AProp<UnitDouble>(){

            @Override
            public Object get(PartCloud partCloud) {
                return ((PartCloud.InsertPeriodically)partCloud.getInsertion()).massPerTime;
            }

            @Override
            public void set(PartCloud partCloud, UnitDouble unitDouble) {
                partCloud.setInsertion(new PartCloud.InsertPeriodically(((PartCloud.InsertPeriodically)partCloud.getInsertion()).dt, unitDouble));
            }
        };
        private final AProp<UnitDouble> dtProp = new AProp<UnitDouble>(){

            @Override
            public Object get(PartCloud partCloud) {
                return ((PartCloud.InsertPeriodically)partCloud.getInsertion()).dt;
            }

            @Override
            public void set(PartCloud partCloud, UnitDouble unitDouble) {
                partCloud.setInsertion(new PartCloud.InsertPeriodically(unitDouble, ((PartCloud.InsertPeriodically)partCloud.getInsertion()).massPerTime));
            }
        };
        private final Composite.IObjectProp<PartCloud, ControlBridge> ctrlProp = ControlSelPnl.getControlProp(PartCloud.class);

        public InsertionPanel(PyroMod pyroMod, ControlSelPnl.INameSource iNameSource, boolean bl) {
            super(new GridBagLayout());
            this.d_nameSrc = iNameSource;
            this.d_insertOnceBtn = new guiRadioButton(Intl.intl("Insert Once"));
            this.d_insertPerBtn = new guiRadioButton(Intl.intl("Insert Periodically"));
            this.d_typeGroup = new guiButtonGroup(this.d_insertOnceBtn, this.d_insertPerBtn);
            this.d_massPerVol = ValueFields.udFld(new PartCloud.InsertOnce().massPerVolume, UnitSystem.getSource(4));
            this.d_massPerVol.setNullAllowed(bl);
            this.d_massPerTime = ValueFields.udFld(new PartCloud.InsertPeriodically().massPerTime, UnitSystem.getSource(76));
            this.d_massPerTime.setNullAllowed(bl);
            this.d_dt = ValueFields.udFld(new PartCloud.InsertPeriodically().dt, UnitSystem.getSource(2));
            this.d_dt.setNullAllowed(bl);
            this.d_controlPnl = new ControlSelPnl(pyroMod.getControls());
            this.d_controlPnl.setNameSrc(this.d_nameSrc, (Collection<? extends INamed>)Collections.EMPTY_LIST);
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Insertion Interval") + ":");
            guiLabel guiLabel3 = new guiLabel(Intl.intl("Mass Per Volume") + ":");
            guiLabel guiLabel4 = new guiLabel(Intl.intl("Mass Per Time") + ":");
            this.d_massPerVolGroup = new ComponentGroup(new Component[]{guiLabel3, this.d_massPerVol});
            this.d_massPerTimeGroup = new ComponentGroup(new Component[]{guiLabel4, this.d_massPerTime});
            this.d_dtGroup = new ComponentGroup(new Component[]{guiLabel2, this.d_dt});
            guiPanel guiPanel2 = new guiPanel();
            GridBagHelper gridBagHelper = new GridBagHelper(guiPanel2);
            gridBagHelper.addRow(guiLabel3, this.d_massPerVol);
            gridBagHelper.finalizeRows();
            guiPanel guiPanel3 = new guiPanel();
            gridBagHelper = new GridBagHelper(guiPanel3);
            this.d_controlPnl.add(gridBagHelper);
            gridBagHelper.addRow(guiLabel2, this.d_dt);
            gridBagHelper.addRow(guiLabel4, this.d_massPerTime);
            gridBagHelper.finalizeRows();
            CardLayout cardLayout = new CardLayout();
            guiPanel guiPanel4 = new guiPanel(cardLayout);
            this.d_cards = new Pair<guiPanel, CardLayout>(guiPanel4, cardLayout);
            guiPanel4.add((Component)guiPanel2, ONCE_CARD);
            guiPanel4.add((Component)guiPanel3, PERIODIC_CARD);
            guiPanel4.add((Component)new guiPanel(), NULL_CARD);
            Function<String, ItemListener> function = string -> itemEvent -> {
                if (itemEvent.getStateChange() == 1) {
                    cardLayout.show(guiPanel4, (String)string);
                    SwingUtilities.invokeLater(() -> SwingUtilities.getWindowAncestor(this).pack());
                }
            };
            this.d_insertOnceBtn.addItemListener(function.apply(ONCE_CARD));
            this.d_insertPerBtn.addItemListener(function.apply(PERIODIC_CARD));
            gridBagHelper = new GridBagHelper(this);
            gridBagHelper.addRow(this.d_insertOnceBtn, this.d_insertPerBtn);
            gridBagHelper.addFilledRow(guiPanel4);
            gridBagHelper.finalizeRows();
            this.d_insertPerBtn.setSelected(true);
        }

        public void unselect() {
            this.d_typeGroup.clearSelection();
            ((CardLayout)this.d_cards.v2).show((Container)this.d_cards.v1, NULL_CARD);
            SwingUtilities.invokeLater(() -> SwingUtilities.getWindowAncestor(this).pack());
        }

        public void updateEnabled(Property<Boolean> property, Property<Boolean> property2) {
            this.d_massPerTimeGroup.setEnabled(property.orElse(false) == false);
            this.d_massPerVolGroup.setEnabled(property.orElse(false) == false && property2.orElse(true) != false);
        }

        public void loadData(PartCloud.IInsertion iInsertion, ControlBridge controlBridge) {
            if (iInsertion instanceof PartCloud.InsertOnce) {
                PartCloud.InsertOnce insertOnce = (PartCloud.InsertOnce)iInsertion;
                this.d_insertOnceBtn.setSelected(true);
                this.d_massPerVol.setValue(insertOnce.massPerVolume);
            } else if (iInsertion instanceof PartCloud.InsertPeriodically) {
                PartCloud.InsertPeriodically insertPeriodically = (PartCloud.InsertPeriodically)iInsertion;
                this.d_insertPerBtn.setSelected(true);
                this.d_dt.setValue(insertPeriodically.dt);
                this.d_massPerTime.setValue(insertPeriodically.massPerTime);
                this.d_controlPnl.load(Property.of(controlBridge));
            }
        }

        public Pair<PartCloud.IInsertion, ControlBridge> saveData() {
            if (this.d_insertOnceBtn.isSelected()) {
                return new Pair<PartCloud.InsertOnce, Object>(new PartCloud.InsertOnce((UnitDouble)this.d_massPerVol.getValue()), null);
            }
            if (this.d_insertPerBtn.isSelected()) {
                return new Pair<PartCloud.InsertPeriodically, Object>(new PartCloud.InsertPeriodically((UnitDouble)this.d_dt.getValue(), (UnitDouble)this.d_massPerTime.getValue()), this.d_controlPnl.save().orElse(null));
            }
            assert (false);
            return null;
        }

        public void loadData(Collection<? extends PartCloud> collection) {
            this.d_controlPnl.setNameSrc(this.d_nameSrc, collection);
            Property property = Composite.getProp(this.typeProp, collection);
            if (!property.isUniform()) {
                this.unselect();
            } else {
                switch ((Type)((Object)property.get())) {
                    case ONCE: {
                        this.d_insertOnceBtn.setSelected(true);
                        Property property2 = Composite.getProp(this.massPerVolProp, collection);
                        this.d_massPerVol.setValue(property2.orElse(null));
                        break;
                    }
                    case PERIODIC: {
                        this.d_insertPerBtn.setSelected(true);
                        Property property3 = Composite.getProp(this.massPerTimeProp, collection);
                        this.d_massPerTime.setValue(property3.orElse(null));
                        Property property4 = Composite.getProp(this.dtProp, collection);
                        this.d_dt.setValue(property4.orElse(null));
                        this.d_controlPnl.load(Composite.getProp(this.ctrlProp, collection));
                    }
                }
            }
        }

        public void saveData(Collection<? extends PartCloud> collection) {
            if (this.d_insertOnceBtn.isSelected()) {
                Composite.setProp(this.typeProp, Property.of(Type.ONCE), collection);
                Composite.setProp(this.massPerVolProp, Property.ofNullable(this.d_massPerVol.getValue()), collection);
                Composite.setProp(this.ctrlProp, Property.of(null), collection);
            } else if (this.d_insertPerBtn.isSelected()) {
                Composite.setProp(this.typeProp, Property.of(Type.PERIODIC), collection);
                Composite.setProp(this.massPerTimeProp, Property.ofNullable(this.d_massPerTime.getValue()), collection);
                Composite.setProp(this.dtProp, Property.ofNullable(this.d_dt.getValue()), collection);
                Composite.setProp(this.ctrlProp, this.d_controlPnl.save(), collection);
            }
        }

        private static enum Type {
            ONCE,
            PERIODIC;


            public static Type get(PartCloud.IInsertion iInsertion) {
                if (iInsertion instanceof PartCloud.InsertPeriodically) {
                    return PERIODIC;
                }
                return ONCE;
            }
        }
    }
}

