/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.AbstractButton;
import javax.swing.JScrollPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import javax.vecmath.Point2d;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Composite;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.boundcond.surf.LayeredSurfDesc;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.FDSUtil;
import pyrosim.domain.geom.IObstruction;
import pyrosim.gui.comboboxes.SurfaceComboBox;
import pyrosim.gui.geom.EvacPanel;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.gui.geom.ModelDialogsUtil;
import pyrosim.gui.geom.ModelObjectDialog;
import pyrosim.gui.geom.TexMapperPnl;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import pyrosim.util.Util;
import thunderheadeng.geometry.objs.elem.ElementBuilder;
import thunderheadeng.geometry.objs.elem.Elements;
import thunderheadeng.geometry.objs.elem.IElemSource;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.IPropertySet;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.LinkedIdentityHashMap;
import thunderheadeng.util.ListMap;
import thunderheadeng.util.Pair;
import thunderheadeng.util.PropertyUtil;
import thunderheadeng.util.theUtil;

public class ObstructionEditor
implements ModelObjectDialog.IEditor<IObstruction>,
Observer {
    private final OptionProp[] d_optionProps;
    private final TexMapperPnl d_texOriginPanel;
    private final guiMultiStateCheckBox d_densityCB;
    private final ValueField<UnitDouble> d_densityFld;
    private final SurfPnl d_surfPnl;
    private final IGeomEditor d_geomEditor;
    private final EvacPanel d_evacPanel;

    public ObstructionEditor(PyroMod pyroMod, IGeomEditor iGeomEditor) {
        this.d_geomEditor = iGeomEditor;
        if (this.d_geomEditor != null) {
            this.d_geomEditor.getPanel().addObserver(this);
        }
        ArrayList<OptionProp> arrayList = new ArrayList<OptionProp>();
        arrayList.addAll(Arrays.asList(new OptionProp(Intl.intl("Thicken"), 1), new OptionProp(Intl.intl("Record BNDF"), 16), new OptionProp(Intl.intl("Permit Holes"), 4), new OptionProp(Intl.intl("Allow Vents"), 8), new OptionProp(Intl.intl("Removable"), 64), new OptionProp(Intl.intl("Display as Outline"), 32)));
        if (PyroSim.FDS7) {
            arrayList.add(new OptionProp("Write as GEOM", 128));
        }
        this.d_optionProps = (OptionProp[])theUtil.toArray(arrayList);
        this.d_densityCB = new guiMultiStateCheckBox(Intl.intl("Bulk Density") + ":");
        this.d_densityFld = ValueFields.udFld(DoubleVR.above(0.0, false), SIUS.unit(4), UnitSystem.getSource(4));
        this.d_densityCB.setToolTipText(Intl.intl("Override density properties from surface."));
        LinkStatus.link((AbstractButton)this.d_densityCB, this.d_densityFld);
        this.d_texOriginPanel = new TexMapperPnl();
        this.d_surfPnl = new SurfPnl(pyroMod);
        this.d_evacPanel = pyroMod.getFdsEvacEnabled() ? new EvacPanel() : null;
    }

    @Override
    public void add(ModelObjectDialog modelObjectDialog, GridBagHelper gridBagHelper) {
        modelObjectDialog.addControlInput(gridBagHelper);
        modelObjectDialog.addColor(gridBagHelper);
        gridBagHelper.addFilledRow(this.d_texOriginPanel);
        TitleSeparator titleSeparator = new TitleSeparator(Intl.intl("Obstruction Properties"));
        gridBagHelper.addFilledRow(titleSeparator);
        int n = 3;
        gridBagHelper.indent();
        for (int i = 0; i < this.d_optionProps.length; ++i) {
            OptionProp optionProp = this.d_optionProps[i];
            if (i >= n && i % n == 0) {
                gridBagHelper.nextRow();
            }
            gridBagHelper.addCol((Component)optionProp.cb, new Object[0]);
        }
        gridBagHelper.nextRow();
        gridBagHelper.unindent();
        gridBagHelper.addRow(this.d_densityCB, this.d_densityFld, 0);
    }

    @Override
    public List<Pair<String, guiPanel>> getExtraTabs() {
        ArrayList<Pair<String, guiPanel>> arrayList = new ArrayList<Pair<String, guiPanel>>();
        arrayList.add(new Pair<String, SurfPnl>(Intl.intl("Surfaces"), this.d_surfPnl));
        if (this.d_evacPanel != null) {
            arrayList.add(new Pair<String, EvacPanel>(Intl.intl("Evac"), this.d_evacPanel));
        }
        return arrayList;
    }

    @Override
    public String getDialogTitle() {
        return Intl.intl("Obstruction Properties");
    }

    @Override
    public Class<IObstruction> getType() {
        return IObstruction.class;
    }

    @Override
    public void update(Observable observable, Object object) {
        assert (this.d_geomEditor != null);
        this.syncFaceCount();
    }

    private void syncFaceCount() {
        if (this.d_geomEditor == null) {
            return;
        }
        int n = this.d_geomEditor.getNumFaces();
        if (n == -1) {
            this.d_surfPnl.resetSurfs();
            return;
        }
        if (n == this.d_surfPnl.d_model.d_surfaces.length) {
            return;
        }
        Surface[] surfaceArray = ObstructionEditor.matchPrimCount(PyroSim.getApp().getMediator(), this.d_surfPnl.d_model.d_surfaces, n);
        this.d_surfPnl.d_model.load(surfaceArray, this.d_geomEditor.getFaceNames());
    }

    private static Surface[] matchPrimCount(PyroMod pyroMod, Surface[] surfaceArray, int n) {
        int n2;
        if (n == surfaceArray.length) {
            return surfaceArray;
        }
        Surface[] surfaceArray2 = new Surface[n];
        for (n2 = 0; n2 < Math.min(n, surfaceArray.length); ++n2) {
            surfaceArray2[n2] = surfaceArray[n2];
        }
        Surface surface = pyroMod.getSurfaceMgr().get(PredefSurf.INERT);
        while (n2 < n) {
            surfaceArray2[n2] = surface;
            ++n2;
        }
        return surfaceArray2;
    }

    /*
     * WARNING - void declaration
     */
    private static IGeomNode matchElementPrimCount(IGeomNode iGeomNode) {
        void var5_8;
        IElemSource<Point2d> iElemSource;
        IElemSource<Point2d> iElemSource2;
        int n = iGeomNode.getLocalGeom().getNumPrims(7);
        IPropertySet iPropertySet = iGeomNode.getLocalElements();
        IPropertySet iPropertySet2 = null;
        for (Elements.ElemProp<?> object22 : Elements.FIXED) {
            IElemSource iElemSource3 = (IElemSource)iPropertySet.get(object22);
            iElemSource = ObstructionEditor.matchElementPrimCount((IElemSource)object22.defVal, iElemSource3, n, iElemSource2 = (IElemSource<Point2d>)object22.defVal);
            if (iElemSource == iElemSource3) continue;
            if (iPropertySet2 == null) {
                iPropertySet2 = Elements.copyOf(iPropertySet);
            }
            iPropertySet2.setIfNotDefault(object22, iElemSource);
        }
        Object object4 = null;
        for (Map.Entry<String, IElemSource<Point2d>> entry : iPropertySet.get(Elements.UV).entrySet()) {
            iElemSource2 = entry.getValue();
            iElemSource = ObstructionEditor.matchElementPrimCount(Elements.NO_UV, iElemSource2, n, FDSUtil.getDefaultTexMapper());
            if (iElemSource == iElemSource2) continue;
            if (object4 == null) {
                object4 = new ListMap<String, IElemSource<Point2d>>(iPropertySet.get(Elements.UV));
            }
            object4.put(entry.getKey(), iElemSource);
        }
        if (object4 != null) {
            if (iPropertySet2 == null) {
                iPropertySet2 = Elements.copyOf(iPropertySet);
            }
            iPropertySet2.setIfNotDefault(Elements.UV, object4);
        }
        Object var5_7 = null;
        boolean bl = false;
        iElemSource2 = iGeomNode.getChildren();
        iElemSource = iElemSource2.iterator();
        while (iElemSource.hasNext()) {
            void var6_14;
            IGeomNode iGeomNode2 = (IGeomNode)iElemSource.next();
            IGeomNode iGeomNode3 = ObstructionEditor.matchElementPrimCount(iGeomNode2);
            if (iGeomNode3 != iGeomNode2) {
                if (var5_8 == null) {
                    ArrayList arrayList = new ArrayList(iElemSource2);
                }
                var5_8.set((int)var6_14, iGeomNode3);
            }
            ++var6_14;
        }
        if (var5_8 == null && iPropertySet2 == null) {
            return iGeomNode;
        }
        if (iPropertySet2 != null) {
            iPropertySet = Elements.finalizeElements(iPropertySet2);
        }
        if (var5_8 != null) {
            iElemSource2 = var5_8;
        }
        return GeomNodeUtil.newNode(iGeomNode.getLocalTransform(), iGeomNode.getLocalGeom(), iPropertySet, (Collection<? extends IGeomNode>)((Object)iElemSource2));
    }

    private static <T> IElemSource<T> matchElementPrimCount(IElemSource<T> iElemSource, IElemSource<T> iElemSource2, int n, IElemSource<T> iElemSource3) {
        int n2;
        if (iElemSource2.isUnbounded() || iElemSource2.getNumPrims() == n) {
            return iElemSource2;
        }
        ElementBuilder<T> elementBuilder = new ElementBuilder<T>(iElemSource);
        Iterator<IElemSource<T>> iterator = iElemSource2.getPrimIterator();
        for (n2 = 0; n2 < n && iterator.hasNext(); ++n2) {
            elementBuilder.add(iterator.next(), 1);
        }
        if (n2 >= n && !iterator.hasNext()) {
            return iElemSource2;
        }
        while (n2 < n) {
            elementBuilder.add(iElemSource3, 1);
            ++n2;
        }
        return elementBuilder.finish();
    }

    @Override
    public boolean validateData(Component component, boolean bl, boolean bl2) {
        return true;
    }

    private void loadBulkDensity(Collection<? extends IObstruction> collection) {
        Object object = Composite.getProperty(IObstruction.bulkDensityProp, collection);
        if (object == Composite.NON_UNIFORM || object == Composite.NOT_SUPPORTED) {
            this.d_densityCB.setState(2);
        } else if (object == null) {
            this.d_densityCB.setSelected(false);
        } else {
            this.d_densityCB.setSelected(true);
            this.d_densityFld.setValue((UnitDouble)object);
        }
    }

    private void saveBulkDensity(Collection<? extends IObstruction> collection) {
        if (this.d_densityCB.getState() != 2) {
            UnitDouble unitDouble = this.d_densityCB.isSelected() ? (UnitDouble)this.d_densityFld.getValue() : null;
            Composite.setProperty(IObstruction.bulkDensityProp, unitDouble, collection);
        }
    }

    @Override
    public boolean isControllable(IObstruction iObstruction) {
        return iObstruction.isControllable();
    }

    @Override
    public void load(PyroMod pyroMod, Collection<? extends IObstruction> collection) {
        for (OptionProp optionProp : this.d_optionProps) {
            optionProp.load(collection);
        }
        ObstructionEditor.loadObstTextureOrigin(collection, this.d_texOriginPanel);
        this.loadBulkDensity(collection);
        this.d_surfPnl.load(pyroMod, collection, this.d_geomEditor);
        if (this.d_evacPanel != null) {
            this.d_evacPanel.load(pyroMod, collection);
        }
    }

    @Override
    public void save(PyroMod pyroMod, Collection<? extends IObstruction> collection) {
        for (OptionProp optionProp : this.d_optionProps) {
            optionProp.save(pyroMod, collection);
        }
        ObstructionEditor.saveObstTexOrigin(pyroMod, collection, this.d_texOriginPanel);
        this.saveBulkDensity(collection);
        this.d_surfPnl.save(pyroMod, collection, this.d_geomEditor);
        if (this.d_evacPanel != null) {
            this.d_evacPanel.save(pyroMod, collection);
        }
    }

    private static void loadObstTextureOrigin(Collection<? extends IObstruction> collection, TexMapperPnl texMapperPnl) {
        texMapperPnl.load(collection);
    }

    private static void saveObstTexOrigin(PyroMod pyroMod, Collection<? extends IObstruction> collection, TexMapperPnl texMapperPnl) {
        texMapperPnl.save(pyroMod, collection);
    }

    private static Collection<Surface> getAllowableSurfs(PyroMod pyroMod) {
        List<Surface> list = Util.sort(pyroMod.getSurfaceMgr());
        list.remove(pyroMod.getSurfaceMgr().get(PredefSurf.OPEN));
        list.remove(pyroMod.getSurfaceMgr().get(PredefSurf.MIRROR));
        list.remove(pyroMod.getSurfaceMgr().get(PredefSurf.HVAC));
        list.remove(pyroMod.getSurfaceMgr().get(PredefSurf.PERIODIC));
        return list;
    }

    private static SurfaceComboBox createSurfCombo(PyroMod pyroMod) {
        final Collection<Surface> collection = ObstructionEditor.getAllowableSurfs(pyroMod);
        SurfaceComboBox surfaceComboBox = new SurfaceComboBox(pyroMod.getSurfaceMgr(), pyroMod.getSurfaceMgr().get(PredefSurf.INERT));
        surfaceComboBox.setFilter(new Predicate<Surface>(){

            @Override
            public boolean test(Surface surface) {
                return collection.contains(surface);
            }
        });
        return surfaceComboBox;
    }

    private static String[] getNames(Collection<Surface> collection) {
        String[] stringArray = new String[collection.size()];
        int n = 0;
        for (Surface surface : collection) {
            stringArray[n++] = surface.getName();
        }
        return stringArray;
    }

    private static class SurfPnl
    extends guiPanel {
        private static final long serialVersionUID = -8087558908276601923L;
        private final SurfaceComboBox d_allFaces;
        private final guiRadioButton d_allSame;
        private final guiRadioButton d_eachFace;
        private final TableModel d_model;
        private final guiTable d_table;
        private Surface[] d_origSurfs = new Surface[0];
        private String[] d_origNames = new String[0];
        private final PropertyUtil.IProp<IPyroGeomSrc, Integer> numFacesProp = new PropertyUtil.AProp<IPyroGeomSrc, Integer>(IPyroGeomSrc.class){

            @Override
            public Object get(IPyroGeomSrc iPyroGeomSrc) {
                return iPyroGeomSrc.getGeom().getNumPrims(1);
            }

            @Override
            public void set(IPyroGeomSrc iPyroGeomSrc, Integer n) {
            }
        };

        public SurfPnl(PyroMod pyroMod) {
            super(new GridBagLayout());
            this.d_allSame = new guiRadioButton(Intl.intl("Single"));
            this.d_eachFace = new guiRadioButton(Intl.intl("Multiple"));
            this.d_allFaces = ObstructionEditor.createSurfCombo(pyroMod);
            this.d_model = new TableModel();
            this.d_table = new guiTable((javax.swing.table.TableModel)this.d_model, 0);
            this.d_table.setPreferredScrollableViewportSize(new Dimension(150, 100));
            JScrollPane jScrollPane = new JScrollPane(this.d_table);
            this.d_table.setColumnOptions(1, ObstructionEditor.getNames(ObstructionEditor.getAllowableSurfs(pyroMod)));
            new guiButtonGroup(this.d_allSame, this.d_eachFace);
            LinkStatus.link((AbstractButton)this.d_allSame, this.d_allFaces);
            LinkStatus.link((AbstractButton)this.d_eachFace, jScrollPane);
            GridBagUtil.add(this, this.d_allSame, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_allFaces, 1, 1, 1, 1, 0, 6, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_eachFace, 0, 2, 1, 1, 6, 0, 0, 0, 0, 0.0, 0.0, 18);
            GridBagUtil.add(this, jScrollPane, 1, 2, 1, 1, 6, 6, 0, 0, 1, 1.0, 1.0, 17);
            GridBagUtil.addGlue(this);
        }

        protected void addListener(final ItemListener itemListener) {
            this.d_allSame.addItemListener(itemListener);
            this.d_eachFace.addItemListener(itemListener);
            this.d_allFaces.addItemListener(itemListener);
            this.d_model.addTableModelListener(new TableModelListener(){

                @Override
                public void tableChanged(TableModelEvent tableModelEvent) {
                    itemListener.itemStateChanged(null);
                }
            });
        }

        protected boolean isBurnAway() {
            if (this.d_allSame.isSelected()) {
                return this.isBurnAway(this.d_allFaces);
            }
            for (Surface surface : this.d_model.d_surfaces) {
                if (!this.isBurnAway(surface)) continue;
                return true;
            }
            return false;
        }

        private boolean isBurnAway(SurfaceComboBox surfaceComboBox) {
            Surface surface = (Surface)surfaceComboBox.getSelectedItem();
            return this.isBurnAway(surface);
        }

        private boolean isBurnAway(Surface surface) {
            if (surface != null && surface.getSurfDesc() instanceof LayeredSurfDesc) {
                LayeredSurfDesc layeredSurfDesc = (LayeredSurfDesc)surface.getSurfDesc();
                return layeredSurfDesc.d_burnAway;
            }
            return false;
        }

        public void resetSurfs() {
            this.d_model.load(this.d_origSurfs, this.d_origNames);
        }

        private static Map<IObstruction, int[]> getFaceOrders(Collection<? extends IObstruction> collection, IGeomEditor iGeomEditor) {
            if (iGeomEditor == null) {
                return Collections.emptyMap();
            }
            IdentityHashMap<IObstruction, int[]> identityHashMap = new IdentityHashMap<IObstruction, int[]>();
            for (IObstruction iObstruction : collection) {
                int[] nArray = iGeomEditor.getFaceOrder(iObstruction.getGeom());
                if (nArray == null) continue;
                identityHashMap.put(iObstruction, nArray);
            }
            return identityHashMap;
        }

        public void load(PyroMod pyroMod, Collection<? extends IObstruction> collection, IGeomEditor iGeomEditor) {
            Map<IObstruction, int[]> map;
            String[] stringArray;
            this.d_model.load(new Surface[0], new String[0]);
            if (collection.isEmpty()) {
                return;
            }
            if (iGeomEditor != null && iGeomEditor.getNumFaces() > 0) {
                stringArray = iGeomEditor.getFaceNames();
            } else {
                map = PropertyUtil.getProperty(this.numFacesProp, collection);
                if (!(map instanceof Integer)) {
                    this.d_allSame.setSelected(false);
                    this.d_eachFace.setSelected(false);
                    return;
                }
                stringArray = new String[((Integer)((Object)map)).intValue()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = String.format(Intl.intl("Face %d"), i + 1);
                }
            }
            map = SurfPnl.getFaceOrders(collection, iGeomEditor);
            SurfProp surfProp = new SurfProp(map);
            Surface[] surfaceArray = new Surface[stringArray.length];
            for (int i = 0; i < surfaceArray.length; ++i) {
                surfProp.ix = i;
                Object object = PropertyUtil.getProperty(surfProp, collection);
                if (!(object instanceof Surface)) {
                    object = null;
                }
                surfaceArray[i] = (Surface)object;
            }
            this.d_origSurfs = surfaceArray;
            this.d_origNames = stringArray;
            this.d_model.load(surfaceArray, stringArray);
            if (GeomUtil.isUniform(surfaceArray) && surfaceArray[0] != null) {
                this.d_allSame.setSelected(true);
                this.d_allFaces.setSelectedItem(surfaceArray[0]);
            } else {
                this.d_eachFace.setSelected(true);
                this.d_allFaces.setSelectedItem(null);
            }
        }

        public void save(PyroMod pyroMod, Collection<? extends IObstruction> collection, IGeomEditor iGeomEditor) {
            block10: {
                Object object;
                int n2;
                block9: {
                    for (IObstruction object32 : collection) {
                        n2 = object32.getGeom().getNumPrims(1);
                        Surface[] surfaceArray = object32.getSurfaces();
                        if (surfaceArray.length != 1 && n2 != surfaceArray.length) {
                            Surface[] surfaceArray2 = ObstructionEditor.matchPrimCount(pyroMod, surfaceArray, n2);
                            object32.setSurfaces(surfaceArray2);
                        }
                        IGeomNode iGeomNode = ObstructionEditor.matchElementPrimCount(object32.getGeom());
                        object32.setGeom(iGeomNode);
                    }
                    if (!this.d_allSame.isSelected()) break block9;
                    object = (Surface)this.d_allFaces.getSelectedItem();
                    if (object == null) break block10;
                    Set<String> set = ((Surface)object).getAttributes().getUVSets();
                    Surface[] surfaceArray = new Surface[]{object};
                    for (IObstruction iObstruction : collection) {
                        Object object2;
                        Surface[] surfaceArray3 = iObstruction.getSurfaces();
                        HashSet<Integer> hashSet = new HashSet<Integer>();
                        int n3 = iObstruction.getNumFaces();
                        for (int i = 0; i < n3; ++i) {
                            Object object3 = object2 = surfaceArray3.length == 1 ? surfaceArray3[0] : surfaceArray3[i];
                            if (object2 == object) continue;
                            hashSet.add(i);
                        }
                        if (hashSet.size() <= 0) continue;
                        iObstruction.setSurfaces(surfaceArray);
                        IGeomNode iGeomNode = iObstruction.getGeom();
                        object2 = set.iterator();
                        while (object2.hasNext()) {
                            String string = (String)object2.next();
                            iGeomNode = iGeomNode.applyUVElements(string, (n, iElemSource) -> hashSet.contains(n) ? FDSUtil.getDefaultTexMapper() : iElemSource);
                        }
                        iObstruction.setGeom(iGeomNode);
                    }
                    break block10;
                }
                if (this.d_eachFace.isSelected()) {
                    if (this.d_model.d_surfaces.length == 0) {
                        return;
                    }
                    object = SurfPnl.getFaceOrders(collection, iGeomEditor);
                    SurfProp surfProp = new SurfProp((Map<IObstruction, int[]>)object);
                    for (n2 = 0; n2 < this.d_model.d_surfaces.length; ++n2) {
                        Surface surface = this.d_model.d_surfaces[n2];
                        if (surface == null) continue;
                        surfProp.ix = n2;
                        PropertyUtil.setProperty(surfProp, surface, collection);
                    }
                    for (IObstruction iObstruction : collection) {
                        surfProp.apply(iObstruction);
                    }
                }
            }
        }

        private static class TableModel
        extends AbstractTableModel {
            private static final long serialVersionUID = 4777606949118088408L;
            private String[] d_faceNames = new String[0];
            private Surface[] d_surfaces = new Surface[0];

            private TableModel() {
            }

            public void load(Surface[] surfaceArray, String[] stringArray) {
                this.d_faceNames = stringArray;
                this.d_surfaces = surfaceArray;
                this.fireTableDataChanged();
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public Class<?> getColumnClass(int n) {
                if (n == 0) {
                    return String.class;
                }
                return String.class;
            }

            @Override
            public String getColumnName(int n) {
                if (n == 0) {
                    return Intl.intl("Face");
                }
                return Intl.intl("Surface");
            }

            @Override
            public int getRowCount() {
                return this.d_surfaces.length;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 == 1;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                switch (n2) {
                    case 0: {
                        return this.d_faceNames[n];
                    }
                    case 1: {
                        return this.d_surfaces[n] == null ? null : this.d_surfaces[n].getName();
                    }
                }
                return null;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                switch (n2) {
                    case 1: {
                        Surface surface;
                        this.d_surfaces[n] = object == null ? null : (surface = (Surface)PyroSim.getApp().getMediator().getSurfaceMgr().get((String)object));
                        this.fireTableCellUpdated(n, n2);
                    }
                }
            }
        }

        private static class SurfProp
        extends PropertyUtil.AProp<IObstruction, Surface> {
            private final Map<IObstruction, int[]> d_faceOrder;
            private final Set<IObstruction> d_modObjs = new IdentityHashSet<IObstruction>();
            private int ix;
            private Map<IObstruction, Map<Integer, Surface>> d_newSurfaces = new LinkedIdentityHashMap<IObstruction, Map<Integer, Surface>>();

            public SurfProp(Map<IObstruction, int[]> map) {
                super(IObstruction.class);
                this.d_faceOrder = map;
                this.ix = 0;
            }

            @Override
            public Object get(IObstruction iObstruction) {
                Surface[] surfaceArray = iObstruction.getSurfaces();
                if (surfaceArray.length == 1) {
                    return surfaceArray[0];
                }
                int[] nArray = this.d_faceOrder.get(iObstruction);
                assert (nArray == null || nArray.length == surfaceArray.length);
                int n = nArray == null ? this.ix : nArray[this.ix];
                return surfaceArray[n];
            }

            @Override
            public void set(IObstruction iObstruction2, Surface surface) {
                Surface surface2;
                int n;
                Surface[] surfaceArray = iObstruction2.getSurfaces();
                int[] nArray = this.d_faceOrder.get(iObstruction2);
                assert (nArray == null || nArray.length == surfaceArray.length);
                int n2 = n = nArray == null ? this.ix : nArray[this.ix];
                assert (surfaceArray.length == 1 || n >= 0 && n < surfaceArray.length);
                Surface surface3 = surface2 = surfaceArray.length == 1 ? surfaceArray[0] : surfaceArray[n];
                if (surface2 != surface) {
                    Map map = this.d_newSurfaces.computeIfAbsent(iObstruction2, iObstruction -> new LinkedIdentityHashMap());
                    map.put(n, surface);
                }
            }

            public boolean apply(IObstruction iObstruction) {
                Object object;
                Map<Integer, Surface> map = this.d_newSurfaces.get(iObstruction);
                if (map == null) {
                    Surface[] surfaceArray = iObstruction.getSurfaces();
                    surfaceArray = GeomUtil.optimize(surfaceArray);
                    iObstruction.setSurfaces(surfaceArray);
                    return false;
                }
                Surface[] surfaceArray = GeomUtil.matchPrimCount(iObstruction.getGeom(), 1, iObstruction.getSurfaces(), Surface.class, true);
                for (Map.Entry<Integer, Surface> object32 : map.entrySet()) {
                    surfaceArray[object32.getKey().intValue()] = object32.getValue();
                }
                iObstruction.setSurfaces(GeomUtil.optimize(surfaceArray));
                LinkedIdentityHashMap linkedIdentityHashMap = new LinkedIdentityHashMap();
                Function<String, Set> function = string -> new HashSet();
                IdentityHashMap<Surface, Set> identityHashMap = new IdentityHashMap<Surface, Set>();
                Function<Surface, Set> function2 = surface -> surface.getAttributes().getUVSets();
                for (Map.Entry<Integer, Surface> entry : map.entrySet()) {
                    for (String string2 : identityHashMap.computeIfAbsent(entry.getValue(), function2)) {
                        object = linkedIdentityHashMap.computeIfAbsent(string2, function);
                        object.add(entry.getKey());
                    }
                }
                Object object2 = iObstruction.getGeom();
                IElemSource<Point2d> iElemSource = FDSUtil.getDefaultTexMapper();
                for (Map.Entry entry : linkedIdentityHashMap.entrySet()) {
                    object = (String)entry.getKey();
                    Set set = (Set)entry.getValue();
                    object2 = object2.applyUVElements((String)object, (n, iElemSource2) -> set.contains(n) ? iElemSource : iElemSource2);
                }
                iObstruction.setGeom((IGeomNode)object2);
                return true;
            }
        }
    }

    private static class OptionProp {
        public final int optionFlag;
        public final guiMultiStateCheckBox cb;

        public OptionProp(String string, int n) {
            this.cb = new guiMultiStateCheckBox(string);
            this.optionFlag = n;
        }

        public OptionProp(String string, int n, ItemListener itemListener) {
            this(string, n);
            this.cb.addItemListener(itemListener);
        }

        public void save(PyroMod pyroMod, Collection<? extends IObstruction> collection) {
            ModelDialogsUtil.saveBoolean(pyroMod, collection, this.cb, new IObstruction.OptionProp(this.optionFlag));
        }

        public void load(Collection<? extends IObstruction> collection) {
            ModelDialogsUtil.loadBoolean(collection, this.cb, new IObstruction.OptionProp(this.optionFlag));
        }
    }
}

