/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.APyroObject;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacDuctLoss;
import pyrosim.domain.hvac.HvacNode;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;

public class NodeLossDialog
extends guiDialog {
    private static final long serialVersionUID = -9104088842241941997L;
    private final guiTable d_lossTable;
    protected final guiTableEditor d_editor;
    private String[] d_colHeader;

    public NodeLossDialog(Window window, String[] stringArray, Class[] classArray) {
        super(window, Intl.intl("Node Loss Editor"), 9);
        int n;
        this.d_colHeader = stringArray;
        this.d_lossTable = NodeLossDialog.createTable(stringArray, classArray, stringArray.length - 1);
        this.d_lossTable.setColumnEditable(0, false);
        guiTable.UnitDoubleEditor unitDoubleEditor = new guiTable.UnitDoubleEditor(PyroSim.getApp().getUnitSystem().getUnitlessUnit());
        this.d_lossTable.setDefaultEditor(UnitDouble.class, unitDoubleEditor);
        if (stringArray.length > 1) {
            for (n = 0; n < stringArray.length - 1; ++n) {
                this.d_lossTable.setValueAt(stringArray[n + 1], n, 0);
            }
        }
        for (n = 0; n < stringArray.length; ++n) {
            this.d_lossTable.setValueAt(new UnitDouble(0.0, Unit.ONE), n, n + 1);
        }
        this.d_editor = new guiTableEditor(this.d_lossTable, 0);
        GridBagHelper gridBagHelper = new GridBagHelper(this.getDialogPane(), true);
        gridBagHelper.addRow(this.d_editor);
        gridBagHelper.addRow(new guiLabel(Intl.intl("Losses are read from column to row.")));
    }

    private static guiTable createTable(String[] stringArray, Class[] classArray, int n) {
        if (stringArray.length != classArray.length) {
            throw new IllegalArgumentException("Must have same number of column headers as column classes.");
        }
        guiDefaultTableModel guiDefaultTableModel2 = new guiDefaultTableModel(n, stringArray.length, false, n, false, stringArray.length){
            private static final long serialVersionUID = 1036391040630374576L;

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n + 1 != n2;
            }
        };
        final NoDiagEditsRenderer noDiagEditsRenderer = new NoDiagEditsRenderer();
        guiTable guiTable2 = new guiTable((TableModel)guiDefaultTableModel2, 0){
            private static final long serialVersionUID = 2639925487622037469L;

            @Override
            public TableCellRenderer getCellRenderer(int n, int n2) {
                TableCellRenderer tableCellRenderer = super.getCellRenderer(n, n2);
                noDiagEditsRenderer.setDefaultRenderer(tableCellRenderer);
                return noDiagEditsRenderer;
            }
        };
        TableColumnModel tableColumnModel = guiTable2.getColumnModel();
        for (int i = 0; i < stringArray.length; ++i) {
            tableColumnModel.getColumn(i).setHeaderValue(stringArray[i]);
            guiDefaultTableModel2.setColumnClass(i, classArray[i]);
        }
        return guiTable2;
    }

    public void loadLosses(ModelComposite modelComposite, List<HvacDuctLoss> list) {
        guiDefaultTableModel guiDefaultTableModel2 = (guiDefaultTableModel)this.d_lossTable.getModel();
        if (list.isEmpty()) {
            return;
        }
        HashMap<Pair<HvacDuct, HvacDuct>, UnitDouble> hashMap = new HashMap<Pair<HvacDuct, HvacDuct>, UnitDouble>();
        for (APyroObject aPyroObject : list) {
            hashMap.put(new Pair<HvacDuct, HvacDuct>(aPyroObject.duct1, aPyroObject.duct2), aPyroObject.fwdLoss);
            hashMap.put(new Pair<HvacDuct, HvacDuct>(aPyroObject.duct2, aPyroObject.duct1), aPyroObject.revLoss);
        }
        for (int i = 1; i < this.d_colHeader.length; ++i) {
            APyroObject aPyroObject;
            aPyroObject = NodeLossDialog.findDuctByName(modelComposite, this.d_colHeader[i]);
            for (int j = 1; j < this.d_colHeader.length; ++j) {
                HvacDuct hvacDuct = NodeLossDialog.findDuctByName(modelComposite, this.d_colHeader[j]);
                Pair<HvacDuct, HvacDuctLoss> pair = new Pair<HvacDuct, HvacDuctLoss>(hvacDuct, (HvacDuctLoss)aPyroObject);
                UnitDouble unitDouble = (UnitDouble)hashMap.get(pair);
                if (unitDouble == null) {
                    unitDouble = new UnitDouble(0.0, Unit.ONE);
                }
                guiDefaultTableModel2.setValueAt(unitDouble, i - 1, j);
            }
        }
    }

    public List<HvacDuctLoss> getLosses(ModelComposite modelComposite, HvacNode hvacNode) {
        ArrayList<HvacDuctLoss> arrayList = new ArrayList<HvacDuctLoss>();
        guiDefaultTableModel guiDefaultTableModel2 = (guiDefaultTableModel)this.d_lossTable.getModel();
        for (int i = 1; i < this.d_colHeader.length; ++i) {
            HvacDuct hvacDuct = NodeLossDialog.findDuctByName(modelComposite, this.d_colHeader[i]);
            for (int j = i + 1; j < this.d_colHeader.length; ++j) {
                HvacDuct hvacDuct2 = NodeLossDialog.findDuctByName(modelComposite, this.d_colHeader[j]);
                UnitDouble unitDouble = (UnitDouble)guiDefaultTableModel2.getValueAt(i - 1, j);
                UnitDouble unitDouble2 = (UnitDouble)guiDefaultTableModel2.getValueAt(j - 1, i);
                if (!NodeLossDialog.isLoss(unitDouble) && !NodeLossDialog.isLoss(unitDouble2)) continue;
                arrayList.add(new HvacDuctLoss(hvacNode, hvacDuct2, hvacDuct, NodeLossDialog.finalizeLoss(unitDouble), NodeLossDialog.finalizeLoss(unitDouble2)));
            }
        }
        return arrayList;
    }

    private static HvacDuct findDuctByName(ModelComposite modelComposite, String string) {
        return modelComposite.find(string, HvacDuct.class, true);
    }

    private static boolean isLoss(UnitDouble unitDouble) {
        return unitDouble != null && unitDouble.getValueNoUnit() != 0.0;
    }

    private static UnitDouble finalizeLoss(UnitDouble unitDouble) {
        return unitDouble == null ? new UnitDouble(0.0, Unit.ONE) : unitDouble;
    }

    private static class NoDiagEditsRenderer
    implements TableCellRenderer {
        private TableCellRenderer d_defaultRenderer;
        Color[] d_colors;

        public void setDefaultRenderer(TableCellRenderer tableCellRenderer) {
            this.d_defaultRenderer = tableCellRenderer;
        }

        public NoDiagEditsRenderer() {
            guiTextField guiTextField2 = new guiTextField();
            this.d_colors = new Color[4];
            this.d_colors[0] = guiTextField2.getForeground();
            this.d_colors[1] = guiTextField2.getBackground();
            guiTextField2.setEditable(false);
            this.d_colors[2] = guiTextField2.getForeground();
            this.d_colors[3] = guiTextField2.getBackground();
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = null;
            if (n + 1 != n2) {
                component = this.d_defaultRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
                component.setForeground(this.d_colors[0]);
                component.setBackground(this.d_colors[1]);
            } else {
                component = this.d_defaultRenderer.getTableCellRendererComponent(jTable, null, bl, false, n, n2);
                component.setForeground(this.d_colors[2]);
                component.setBackground(this.d_colors[3]);
            }
            return component;
        }
    }
}

