/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.vecmath.Point3d;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.APyroObject;
import pyrosim.domain.Composite;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.Property;
import pyrosim.domain.boundcond.surf.PredefSurf;
import pyrosim.domain.boundcond.surf.Surface;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.hvac.HvacComponent;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacDuctLoss;
import pyrosim.domain.hvac.HvacFilter;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.hvac.HvacUtil;
import pyrosim.geom.Geometry;
import pyrosim.gui.comboboxes.PyroComboBox;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.gui.geom.ModelObjectDialog;
import pyrosim.gui.geom.NodeLossDialog;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.ComponentGroup;
import thunderheadeng.gui.ComponentGroup2;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.MultiLineLabel;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.Events;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class NodeEditor
implements ModelObjectDialog.IEditor<HvacNode> {
    private final ModelObjectDialog d_parent;
    private final IGeomEditor d_geomEditor;
    private final PyroMod d_domain;
    private final guiTextField d_fyi;
    private final PyroComboBox<HvacFilter> d_filterCB;
    private final PyroComboBox<Vent> d_ventCB;
    private final guiLabel d_invalid;
    private final guiLabel d_minDucts2;
    private final guiLabel d_maxDucts10;
    private final guiLabel d_ductCount1;
    private final guiLabel d_minDucts1;
    private final guiLabel d_filterErr;
    private final MultiLineLabel d_connectedDuctLbl;
    private final guiRadioButton d_autoBtn;
    private final guiRadioButton d_ventBtn;
    private final guiRadioButton d_ambientBtn;
    private final guiRadioButton d_internalBtn;
    private final JButton d_lossBtn;
    private final ValueField<UnitDouble> d_lossIn;
    private final ValueField<UnitDouble> d_lossOut;
    private final ComponentGroup d_termLossGroup;
    private List<HvacNode> d_nodes;
    private List<HvacDuctLoss> d_losses;
    private NodeLossDialog d_nodeLossDlg;
    private static final HvacFilter FILTER_NONE = new HvacFilter(Intl.intl("<none>"));
    private final guiPanel d_dlgPanel = new guiPanel();
    private static final StandardProp<String> fyiProp = new StandardProp<String>(HvacComponent::getDesc, HvacComponent::setDesc);
    private static final StandardProp<HvacNode.NodeType> nodeTypeProp = new StandardProp<HvacNode.NodeType>(HvacNode::getNodeType, HvacNode::setNodeType);
    private static final StandardProp<Vent> ventProp = new StandardProp<Vent>(HvacNode::getVent, HvacNode::setVent);
    private static final GenericProp<HvacFilter> filterProp = new GenericProp("FILTER_ID");

    public NodeEditor(ModelObjectDialog modelObjectDialog, PyroMod pyroMod, IGeomEditor iGeomEditor) {
        this.d_parent = modelObjectDialog;
        this.d_domain = pyroMod;
        this.d_geomEditor = iGeomEditor;
        this.d_nodes = Collections.EMPTY_LIST;
        guiLabel guiLabel2 = new guiLabel(Intl.intl("FYI: "));
        this.d_fyi = new guiTextField();
        this.d_connectedDuctLbl = new MultiLineLabel("");
        this.d_connectedDuctLbl.setFont(this.d_connectedDuctLbl.getFont().deriveFont(2));
        this.d_autoBtn = new guiRadioButton(Intl.intl("Auto"));
        this.d_autoBtn.setToolTipText("<html>" + Intl.intl("This option selects <b>Ambient Endpoint</b> if exactly one duct is<br>connected or <b>Internal</b> if more are connected.") + "</html>");
        this.d_ambientBtn = new guiRadioButton(Intl.intl("Ambient Endpoint"));
        this.d_ambientBtn.setToolTipText("<html>" + Intl.intl("This option connects the node to the outside of the domain.<br>Only one duct may be connected to this node.") + "</html>");
        this.d_ventBtn = new guiRadioButton(Intl.intl("Vent Endpoint"));
        this.d_ventBtn.setToolTipText("<html>" + Intl.intl("This option connects the node to a vent on the interior of the domain.<br>Only one duct may be connected to this node.") + "</html>");
        this.d_internalBtn = new guiRadioButton(Intl.intl("Internal"));
        this.d_internalBtn.setToolTipText("<html>" + Intl.intl("This option makes the node a junction. At least two ducts must be<br>connected to the node.") + "</html>");
        new guiButtonGroup(this.d_autoBtn, this.d_ambientBtn, this.d_ventBtn, this.d_internalBtn);
        final Surface surface = pyroMod.getSurfaceMgr().get(PredefSurf.HVAC);
        assert (surface != null);
        this.d_ventCB = new PyroComboBox<Vent>((IPyroObject)pyroMod.getObstructions(), Vent.class){
            private static final long serialVersionUID = -3252193814719931186L;

            @Override
            public void update(Events events) {
                super.update(events);
                NodeEditor.this.d_ventBtn.setEnabled(this.getItemCount() > 0);
            }
        };
        this.d_ventCB.setFilter(new Predicate<Vent>(){

            @Override
            public boolean test(Vent vent) {
                return vent.getSurface() == surface;
            }
        });
        this.d_filterCB = new PyroComboBox<HvacFilter>((IPyroObject)pyroMod.getHvacList(), HvacFilter.class){
            private static final long serialVersionUID = 967290516795513307L;

            @Override
            protected Collection<?> getObjList() {
                Collection<?> collection = super.getObjList();
                ArrayList<HvacFilter> arrayList = new ArrayList<HvacFilter>(collection.size() + 1);
                arrayList.add(FILTER_NONE);
                arrayList.addAll(collection);
                return arrayList;
            }
        };
        this.d_lossBtn = new JButton(Intl.intl("Edit Duct Losses"));
        this.d_lossBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (NodeEditor.this.d_nodes.size() != 1) {
                    guiDialog.showInvalidEntryMessage(NodeEditor.this.d_dlgPanel, Intl.intl("Select only one node to edit losses."));
                    return;
                }
                if (NodeEditor.this.d_nodeLossDlg.doModal() == 1) {
                    NodeEditor.this.d_losses = NodeEditor.this.d_nodeLossDlg.getLosses(NodeEditor.this.d_domain.getObstructions(), (HvacNode)NodeEditor.this.d_nodes.get(0));
                    NodeEditor.this.d_dlgPanel.setModified(true);
                }
            }
        });
        this.d_lossIn = ValueFields.udFld(UnitSystem.getSource(85));
        this.d_lossOut = ValueFields.udFld(UnitSystem.getSource(85));
        Stream.of(this.d_lossIn, this.d_lossOut).forEach(valueField -> valueField.setNullAllowed(true));
        guiLabel guiLabel3 = new guiLabel(Intl.intl("In Loss"));
        guiLabel3.setToolTipText(Intl.intl("The loss for flow entering the HVAC system through a terminal node."));
        guiLabel guiLabel4 = new guiLabel(Intl.intl("Out Loss"));
        guiLabel4.setToolTipText(Intl.intl("The loss for flow exiting the HVAC system through a terminal node."));
        this.d_termLossGroup = new ComponentGroup2(new Component[]{this.d_lossIn, guiLabel3, this.d_lossOut, guiLabel4});
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    NodeEditor.this.updateTypeState();
                }
            }
        };
        this.d_internalBtn.addItemListener(itemListener);
        this.d_ambientBtn.addItemListener(itemListener);
        this.d_autoBtn.addItemListener(itemListener);
        this.d_ventBtn.addItemListener(itemListener);
        this.d_nodeLossDlg = null;
        this.d_invalid = NodeEditor.newErrorLbl(Intl.intl("Warning: Node is invalid."));
        this.d_minDucts2 = NodeEditor.newErrorLbl(Intl.intl("A minimum of two ducts must be connected to an interior node."));
        this.d_maxDucts10 = NodeEditor.newErrorLbl(Intl.intl("A maximum of ten ducts may be connected to an interior node."));
        this.d_ductCount1 = NodeEditor.newErrorLbl(Intl.intl("An endpoint node must be connected to exactly one duct."));
        this.d_filterErr = NodeEditor.newErrorLbl(Intl.intl("A maximum of two ducts may be connected to a node with a filter."));
        this.d_minDucts1 = NodeEditor.newErrorLbl(Intl.intl("A minimum of one duct must be connected to an auto node."));
        Observer observer = new Observer(){

            @Override
            public void update(Observable observable, Object object) {
                NodeEditor.this.checkValidNode();
            }
        };
        this.d_dlgPanel.addObserver(observer);
        guiPanel guiPanel2 = new guiPanel();
        GridBagHelper gridBagHelper = new GridBagHelper(guiPanel2);
        gridBagHelper.addRow(this.d_autoBtn);
        gridBagHelper.addRow(this.d_internalBtn);
        gridBagHelper.addRow(this.d_ambientBtn);
        gridBagHelper.addRow(this.d_ventBtn, this.d_ventCB, 0);
        gridBagHelper.finalizeRows();
        guiPanel guiPanel3 = new guiPanel();
        gridBagHelper = new GridBagHelper(guiPanel3);
        gridBagHelper.addRow(this.d_connectedDuctLbl, new double[]{1.0, 1.0}, new int[]{0, 1});
        gridBagHelper.addRow(this.d_lossBtn, 0);
        gridBagHelper.addRow(guiLabel3, this.d_lossIn, 0);
        gridBagHelper.addRow(guiLabel4, this.d_lossOut, 0);
        gridBagHelper.finalizeRows();
        GridBagHelper gridBagHelper2 = new GridBagHelper(this.d_dlgPanel, false);
        gridBagHelper2.addFilledRow(new JSeparator());
        gridBagHelper2.addRow(guiLabel2, this.d_fyi, 1.0, GridBagHelper.REMAINING);
        gridBagHelper2.addRow(Intl.intl("Filter:"), this.d_filterCB, 0);
        gridBagHelper2.addRow(Intl.intl("Node Type:"), 0);
        gridBagHelper2.addIdentRow(guiPanel2, 1.0, 0);
        gridBagHelper2.addRow(Intl.intl("Ducts:"), 0);
        gridBagHelper2.addIdentRow(guiPanel3, new double[]{1.0, 1.0}, new int[]{0, 1});
        gridBagHelper2.addFilledRow(this.d_invalid);
        gridBagHelper2.addFilledRow(this.d_minDucts2);
        gridBagHelper2.addFilledRow(this.d_maxDucts10);
        gridBagHelper2.addFilledRow(this.d_ductCount1);
        gridBagHelper2.addFilledRow(this.d_filterErr);
        gridBagHelper2.addFilledRow(this.d_minDucts1);
        gridBagHelper2.finalizeRows();
        this.updateTypeState();
        this.d_ventBtn.setEnabled(this.d_ventCB.getItemCount() > 0);
    }

    private static guiLabel newErrorLbl(String string) {
        guiLabel guiLabel2 = new guiLabel(string);
        guiLabel2.setForeground(Color.RED);
        guiLabel2.setVisible(false);
        return guiLabel2;
    }

    private static void addUngriddedRow(GridBagHelper gridBagHelper, Object ... objectArray) {
        FlowLayout flowLayout = new FlowLayout(0, gridBagHelper.d_colSpace, 0);
        guiPanel guiPanel2 = new guiPanel(flowLayout);
        for (Object object : objectArray) {
            if (object instanceof String) {
                object = new guiLabel((String)object);
            }
            if (!(object instanceof Component)) continue;
            guiPanel2.add((Component)object);
        }
        gridBagHelper.addFilledRow(guiPanel2);
    }

    @Override
    public String getDialogTitle() {
        return Intl.intl("HVAC Node Properties");
    }

    @Override
    public Class<HvacNode> getType() {
        return HvacNode.class;
    }

    @Override
    public void add(ModelObjectDialog modelObjectDialog, GridBagHelper gridBagHelper) {
        gridBagHelper.addFilledRow(this.d_dlgPanel);
    }

    @Override
    public List<Pair<String, guiPanel>> getExtraTabs() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean isControllable(HvacNode hvacNode) {
        return false;
    }

    private HvacNode.NodeType getSelectedNodeType() {
        if (this.d_autoBtn.isSelected()) {
            return HvacNode.NodeType.AUTO;
        }
        if (this.d_ambientBtn.isSelected()) {
            return HvacNode.NodeType.AMBIENT;
        }
        if (this.d_internalBtn.isSelected()) {
            return HvacNode.NodeType.INTERNAL;
        }
        if (this.d_ventBtn.isSelected()) {
            return HvacNode.NodeType.VENT;
        }
        return null;
    }

    private static boolean isTerminal(HvacNode.NodeType nodeType) {
        switch (nodeType) {
            case AMBIENT: 
            case AUTO: 
            case VENT: {
                return true;
            }
        }
        return false;
    }

    private static boolean isNonTerminal(HvacNode.NodeType nodeType) {
        switch (nodeType) {
            case AUTO: 
            case INTERNAL: {
                return true;
            }
        }
        return false;
    }

    private void updateLossVis() {
        this.d_termLossGroup.setVisible(this.getSelectedNodeType() != null ? NodeEditor.isTerminal(this.getSelectedNodeType()) : this.d_nodes.stream().anyMatch(hvacNode -> NodeEditor.isTerminal(hvacNode.getNodeType())));
        this.d_lossBtn.setVisible(this.getSelectedNodeType() != null ? NodeEditor.isNonTerminal(this.getSelectedNodeType()) : this.d_nodes.stream().anyMatch(hvacNode -> NodeEditor.isNonTerminal(hvacNode.getNodeType())));
        guiDialog guiDialog2 = (guiDialog)SwingUtilities.getAncestorOfClass(guiDialog.class, this.d_dlgPanel);
        if (guiDialog2 != null) {
            guiDialog2.pack();
        }
    }

    private static boolean requiresLocation(HvacNode.NodeType nodeType) {
        switch (nodeType) {
            case AMBIENT: 
            case AUTO: 
            case INTERNAL: {
                return true;
            }
        }
        return false;
    }

    private void updateCoords() {
        boolean bl = this.getSelectedNodeType() != null ? NodeEditor.requiresLocation(this.getSelectedNodeType()) : this.d_nodes.stream().anyMatch(hvacNode -> NodeEditor.requiresLocation(hvacNode.getNodeType()));
        this.d_parent.setGeomTabVis(bl);
    }

    private static boolean requiresVent(HvacNode.NodeType nodeType) {
        return nodeType == HvacNode.NodeType.VENT;
    }

    private void updateVent() {
        boolean bl = this.getSelectedNodeType() != null ? NodeEditor.requiresVent(this.getSelectedNodeType()) : this.d_nodes.stream().anyMatch(hvacNode -> NodeEditor.requiresVent(hvacNode.getNodeType()));
        this.d_ventCB.setEnabled(bl);
    }

    private void updateTypeState() {
        this.updateCoords();
        this.updateLossVis();
        this.updateVent();
    }

    @Override
    public void load(PyroMod pyroMod, Collection<? extends HvacNode> collection) {
        Object object;
        Object object2;
        Object object3;
        this.d_nodes = new ArrayList<HvacNode>(collection);
        Property property = Composite.getProp(fyiProp, collection);
        this.d_fyi.setText(property.orElse(Intl.intl("<multiple>")));
        Property property2 = Composite.getProp(filterProp, collection);
        if (property2.isUniform()) {
            object3 = property2.get() == null ? FILTER_NONE : (HvacFilter)property2.get();
            this.d_filterCB.setSelectedItem(object3);
        } else {
            this.d_filterCB.setSelectedItem(null);
        }
        object3 = Composite.getProp(nodeTypeProp, collection);
        if (((Property)object3).isUniform()) {
            switch ((HvacNode.NodeType)((Object)((Property)object3).get())) {
                case AUTO: {
                    this.d_autoBtn.setSelected(true);
                    break;
                }
                case AMBIENT: {
                    this.d_ambientBtn.setSelected(true);
                    break;
                }
                case INTERNAL: {
                    this.d_internalBtn.setSelected(true);
                    break;
                }
                case VENT: {
                    this.d_ventBtn.setSelected(true);
                }
            }
        } else {
            this.d_autoBtn.setSelected(false);
            this.d_ambientBtn.setSelected(false);
            this.d_internalBtn.setSelected(false);
            this.d_ventBtn.setSelected(false);
        }
        Property property3 = Composite.getProp(ventProp, theUtil.filter(collection, hvacNode -> NodeEditor.requiresVent(hvacNode.getNodeType())));
        this.d_ventCB.setSelectedItem(property3.orElse(null));
        if (collection.size() == 1) {
            object2 = collection.iterator().next();
            this.d_losses = new ArrayList<HvacDuctLoss>(HvacUtil.getDuctLosses(this.d_domain.getBridges(), (HvacNode)object2));
            object = new ArrayList<HvacDuct>(HvacUtil.getConnectedDucts(this.d_domain.getObstructions(), (HvacNode)object2));
            this.createNodeLossDlg(this.d_domain.getObstructions(), (List<HvacDuct>)object, this.d_losses);
        } else {
            this.d_losses = Collections.EMPTY_LIST;
        }
        object2 = theUtil.filter(collection, hvacNode -> NodeEditor.isTerminal(hvacNode.getNodeType()));
        object = new ValueField[]{this.d_lossIn, this.d_lossOut};
        for (int i = 0; i < 2; ++i) {
            Property<UnitDouble> property4 = Composite.getProp(new LossProp(i), (Collection<? extends IPyroObject>)object2);
            object[i].setValue(property4.orElse(null));
        }
        this.updateTypeState();
        this.d_dlgPanel.setModified(false);
    }

    @Override
    public boolean validateData(Component component, boolean bl, boolean bl2) {
        Predicate<HvacNode> predicate = hvacNode -> hvacNode.getNodeType() == HvacNode.NodeType.VENT;
        IFilteredCollection<HvacNode> iFilteredCollection = theUtil.filter(this.d_nodes, predicate.negate());
        if (this.d_ventBtn.isSelected() && !iFilteredCollection.isEmpty() && this.d_ventCB.getSelectedItem() == null) {
            if (bl) {
                guiDialog.showInvalidEntryMessage(this.d_dlgPanel, Intl.intl("A vent must be selected."));
            }
            if (bl2) {
                this.d_ventCB.requestFocus();
            }
            return false;
        }
        return true;
    }

    @Override
    public void save(PyroMod pyroMod, Collection<? extends HvacNode> collection) {
        Object object;
        Object object2;
        Object object3;
        if (this.d_fyi.isModified()) {
            object3 = this.d_fyi.getText();
            Composite.setProperty(fyiProp, object3, collection);
        }
        if ((object3 = (HvacFilter)this.d_filterCB.getSelectedItem()) != null) {
            if (object3 == FILTER_NONE) {
                object3 = null;
            }
            Composite.setProperty(filterProp, object3, collection);
        }
        HvacNode.NodeType nodeType = null;
        if (this.d_ambientBtn.isSelected()) {
            nodeType = HvacNode.NodeType.AMBIENT;
        } else if (this.d_internalBtn.isSelected()) {
            nodeType = HvacNode.NodeType.INTERNAL;
        } else if (this.d_autoBtn.isSelected()) {
            nodeType = HvacNode.NodeType.AUTO;
        } else if (this.d_ventBtn.isSelected()) {
            nodeType = HvacNode.NodeType.VENT;
        }
        if (nodeType != null) {
            if (nodeType != HvacNode.NodeType.VENT) {
                Composite.setProperty(nodeTypeProp, nodeType, collection);
                if (this.d_geomEditor != null) {
                    this.d_geomEditor.save(collection);
                }
            } else {
                object2 = (Vent)this.d_ventCB.getSelectedItem();
                Composite.setProp(ventProp, Property.ofNullable(object2), collection);
            }
        }
        object2 = theUtil.filter(collection, hvacNode -> NodeEditor.requiresVent(hvacNode.getNodeType()));
        if (nodeType == null) {
            object = (Vent)this.d_ventCB.getSelectedItem();
            Composite.setProp(ventProp, Property.ofNullable(object), (Collection<? extends IPyroObject>)object2);
        }
        object = theUtil.filter(collection, hvacNode -> NodeEditor.isTerminal(hvacNode.getNodeType()));
        ValueField[] valueFieldArray = new ValueField[]{this.d_lossIn, this.d_lossOut};
        for (int i = 0; i < 2; ++i) {
            UnitDouble unitDouble = (UnitDouble)valueFieldArray[i].getValue();
            Composite.setProp(new LossProp(i), Property.ofNullable(unitDouble), (Collection<? extends IPyroObject>)object);
        }
        if (this.d_nodes.size() == 1) {
            ArrayList<HvacDuctLoss> arrayList = new ArrayList<HvacDuctLoss>(HvacUtil.getDuctLosses(this.d_domain.getBridges(), this.d_nodes.get(0)));
            this.d_domain.getBridges().removeAll(arrayList);
            this.d_domain.getBridges().addAll(this.d_losses);
        }
    }

    private void createNodeLossDlg(ModelComposite modelComposite, List<HvacDuct> list, List<HvacDuctLoss> list2) {
        if (!list.isEmpty()) {
            String[] stringArray = new String[list.size() + 1];
            stringArray[0] = Intl.intl("*");
            Class[] classArray = new Class[list.size() + 1];
            classArray[0] = String.class;
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) == null) continue;
                stringArray[i + 1] = list.get(i).getName();
                classArray[i + 1] = UnitDouble.class;
            }
            this.d_nodeLossDlg = new NodeLossDialog(SwingUtilities.getWindowAncestor(this.d_dlgPanel), stringArray, classArray);
            this.d_nodeLossDlg.loadLosses(modelComposite, list2);
        } else {
            String[] stringArray = new String[]{Intl.intl("***")};
            Class[] classArray = new Class[]{String.class};
            this.d_nodeLossDlg = new NodeLossDialog(SwingUtilities.getWindowAncestor(this.d_dlgPanel), stringArray, classArray);
        }
    }

    private void checkValidNode() {
        Serializable serializable;
        Object object;
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>();
        if (this.d_nodes.size() == 1) {
            arrayList.add(this.d_connectedDuctLbl);
            object = this.d_nodes.get(0);
            serializable = this.d_domain.getObstructions();
            Collection<HvacDuct> collection = ((APyroObject)serializable).flatten(HvacDuct.class);
            StringBuilder stringBuilder = new StringBuilder(Intl.intl("Connected Ducts: "));
            int n = 0;
            for (HvacDuct hvacDuct : collection) {
                if (!hvacDuct.isNodeAttached((HvacNode)object)) continue;
                if (n > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(hvacDuct.getName());
                ++n;
            }
            if (n == 0) {
                stringBuilder.append("<none>");
            }
            this.d_connectedDuctLbl.setText(stringBuilder.toString());
            boolean bl = this.d_internalBtn.isSelected();
            boolean bl2 = this.d_ambientBtn.isSelected();
            boolean bl3 = this.d_ventBtn.isSelected();
            boolean bl4 = this.d_autoBtn.isSelected();
            guiLabel guiLabel2 = null;
            if (bl4) {
                if (n == 0) {
                    guiLabel2 = this.d_minDucts1;
                } else {
                    bl = n >= 2;
                    boolean bl5 = bl2 = n == 1;
                }
            }
            if (bl) {
                if (n > 2 && this.d_filterCB.getSelectedItem() != null && this.d_filterCB.getSelectedItem() != FILTER_NONE) {
                    guiLabel2 = this.d_filterErr;
                } else if (n < 2) {
                    guiLabel2 = this.d_minDucts2;
                } else if (n > 10) {
                    guiLabel2 = this.d_maxDucts10;
                }
            } else if ((bl2 || bl3) && n != 1) {
                guiLabel2 = this.d_ductCount1;
            }
            if (guiLabel2 != null) {
                arrayList.add(this.d_invalid);
                arrayList.add(guiLabel2);
            }
        }
        object = new boolean[]{false};
        Stream.of(this.d_invalid, this.d_ductCount1, this.d_minDucts2, this.d_maxDucts10, this.d_filterErr, this.d_minDucts1, this.d_connectedDuctLbl).forEach(arg_0 -> NodeEditor.lambda$checkValidNode$492(arrayList, (boolean[])object, arg_0));
        if (object[0] && (serializable = (guiDialog)SwingUtilities.getAncestorOfClass(guiDialog.class, this.d_dlgPanel)) != null) {
            ((Window)serializable).pack();
        }
    }

    private static /* synthetic */ void lambda$checkValidNode$492(List list, boolean[] blArray, JComponent jComponent) {
        boolean bl = list.contains(jComponent);
        if (bl != jComponent.isVisible()) {
            jComponent.setVisible(bl);
            blArray[0] = true;
        }
    }

    private static class StandardProp<T>
    extends Composite.AObjectProp<HvacNode, T> {
        private final Function<HvacNode, T> d_getter;
        private final BiConsumer<HvacNode, T> d_setter;

        public StandardProp(Function<HvacNode, T> function, BiConsumer<HvacNode, T> biConsumer) {
            super(HvacNode.class);
            this.d_setter = biConsumer;
            this.d_getter = function;
        }

        @Override
        public Object get(HvacNode hvacNode) {
            return this.d_getter.apply(hvacNode);
        }

        @Override
        public void set(HvacNode hvacNode, T t) {
            this.d_setter.accept(hvacNode, (HvacNode)t);
        }
    }

    private static class GenericProp<T>
    extends Composite.AObjectProp<HvacNode, T> {
        private final String d_propKey;

        public GenericProp(String string) {
            super(HvacNode.class);
            this.d_propKey = string;
        }

        @Override
        public Object get(HvacNode hvacNode) {
            return hvacNode.getProp(this.d_propKey);
        }

        @Override
        public void set(HvacNode hvacNode, T t) {
            hvacNode.setProp(this.d_propKey, t);
        }
    }

    private static class LossProp
    extends Composite.AObjectProp<HvacNode, UnitDouble> {
        private final int d_index;

        public LossProp(int n) {
            super(HvacNode.class);
            this.d_index = n;
        }

        @Override
        public Object get(HvacNode hvacNode) {
            return hvacNode.getTerminalLoss().get(this.d_index);
        }

        @Override
        public void set(HvacNode hvacNode, UnitDouble unitDouble) {
            ArrayList<UnitDouble> arrayList = new ArrayList<UnitDouble>(hvacNode.getTerminalLoss());
            arrayList.set(this.d_index, unitDouble);
            hvacNode.setTerminalLoss((UnitDouble)arrayList.get(0), (UnitDouble)arrayList.get(1));
        }
    }

    private static class LocProp
    extends Composite.AObjectProp<HvacNode, UnitDouble> {
        private final int d_coord;

        public LocProp(int n) {
            super(HvacNode.class);
            this.d_coord = n;
        }

        @Override
        public void set(HvacNode hvacNode, UnitDouble unitDouble) {
            UnitPoint3D unitPoint3D = (UnitPoint3D)hvacNode.getProp("XYZ");
            if (unitPoint3D == null) {
                unitPoint3D = new UnitPoint3D(new UnitDouble[0]);
            }
            UnitDouble[] unitDoubleArray = new UnitDouble[]{unitPoint3D.xu(), unitPoint3D.yu(), unitPoint3D.zu()};
            unitDoubleArray[this.d_coord] = unitDouble;
            hvacNode.setProp("XYZ", new UnitPoint3D(unitDoubleArray));
        }

        @Override
        public Object get(HvacNode hvacNode) {
            if (NodeEditor.requiresVent(hvacNode.getNodeType())) {
                Point3d point3d = hvacNode.getVent().getBounds().getCenter();
                switch (this.d_coord) {
                    case 0: {
                        return new UnitDouble(point3d.x, Geometry.LU);
                    }
                    case 1: {
                        return new UnitDouble(point3d.y, Geometry.LU);
                    }
                }
                return new UnitDouble(point3d.z, Geometry.LU);
            }
            UnitPoint3D unitPoint3D = (UnitPoint3D)hvacNode.getProp("XYZ");
            if (unitPoint3D == null) {
                return null;
            }
            switch (this.d_coord) {
                case 0: {
                    return unitPoint3D.xu();
                }
                case 1: {
                    return unitPoint3D.yu();
                }
            }
            return unitPoint3D.zu();
        }
    }
}

