/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Composite;
import pyrosim.domain.Hierarchy;
import pyrosim.domain.ICustomFDSPropsContainer;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.geom.GenericGeomSrc;
import pyrosim.domain.geom.IHole;
import pyrosim.domain.geom.IModelObj;
import pyrosim.domain.geom.IObstruction;
import pyrosim.domain.geom.InitRegion;
import pyrosim.domain.geom.ModelComposite;
import pyrosim.domain.geom.PartCloud;
import pyrosim.domain.geom.Vent;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.signals.AOneInPin;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.OneLogicInPin;
import pyrosim.domain.signals.Util;
import pyrosim.domain.tasks.AddAutoRenameTask;
import pyrosim.domain.tasks.ReorderObjectsTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.gui.CustomFDSPanel;
import pyrosim.gui.comboboxes.CompositeComboBox;
import pyrosim.gui.controls.ControlSelPnl;
import pyrosim.gui.controls.TextFldNameSource;
import pyrosim.gui.geom.AABoxGeomEditor;
import pyrosim.gui.geom.DefModelObjEditor;
import pyrosim.gui.geom.DuctEditor;
import pyrosim.gui.geom.GenericEditor;
import pyrosim.gui.geom.GeomGuiUtil;
import pyrosim.gui.geom.HoleEditor;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.gui.geom.InitEditor;
import pyrosim.gui.geom.ModelDialogsUtil;
import pyrosim.gui.geom.NodeEditor;
import pyrosim.gui.geom.ObstructionEditor;
import pyrosim.gui.geom.PartCloudEditor;
import pyrosim.gui.geom.VentEditor;
import pyrosim.treeview.TVEntryPoints;
import pyrosim.util.GeomUtil;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.CollectionMetrics;
import thunderheadeng.util.CompositeTask;
import thunderheadeng.util.ICloneRequired;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.IdentityHashSet;
import thunderheadeng.util.Pair;
import thunderheadeng.util.theUtil;

public class ModelObjectDialog
extends guiDialog {
    private static final long serialVersionUID = 1921931658608874407L;
    public static final String EDITOR_PROPS_TAB = Intl.intl("General");
    public static final String GEOMETRY_PROPS_TAB = Intl.intl("Geometry");
    public static final int ADD = 0;
    public static final int EDIT = 1;
    private final PyroMod d_mediator;
    private final Collection<? extends IPyroObject> d_objs;
    private final ModelComposite d_parent;
    private final JTabbedPane d_tabbedPane;
    private final guiTextField d_id;
    private final guiTextField d_desc;
    private final CompositeComboBox<IModelObj> d_group;
    private final ControlSelPnl d_controlPnl;
    private final guiMultiStateCheckBox d_cbSpecifyColor;
    private final ColorButton d_cbColor;
    private final IEditor d_objEditor;
    private final IGeomEditor d_geomEditor;
    private final AABoxGeomEditor d_boundsPanel;
    private final CustomFDSPanel d_customFDSPanel;
    private final guiPanel d_geomPanel;
    private int d_type;

    public ModelObjectDialog(JFrame jFrame, PyroMod pyroMod, Collection<? extends IPyroObject> collection, ModelComposite modelComposite, int n) {
        super((Window)jFrame, null, 9);
        Object object;
        this.d_objs = collection;
        this.d_parent = modelComposite;
        this.d_type = n;
        this.d_mediator = ((PyroSim)Application.getApp()).getMediator();
        this.d_id = new guiTextField();
        this.d_desc = new guiTextField();
        this.d_group = new CompositeComboBox<IModelObj>(this.d_mediator.getObstructions());
        this.d_cbSpecifyColor = new guiMultiStateCheckBox(Intl.intl("Specify Color"), false);
        this.d_cbColor = new ColorButton();
        LinkStatus.link((AbstractButton)this.d_cbSpecifyColor, this.d_cbColor);
        this.d_controlPnl = new ControlSelPnl(pyroMod.getControls());
        Collection<IModelObj> collection2 = Hierarchy.flatten(this.d_objs, IModelObj.class);
        this.d_controlPnl.setNameSrc(this.d_id, collection2);
        this.d_geomEditor = GeomGuiUtil.newEditor(collection2);
        this.d_objEditor = this.createObjEditor(this.d_mediator, collection, this.d_geomEditor);
        this.d_boundsPanel = new AABoxGeomEditor(false, true);
        this.d_boundsPanel.setEnabled(false);
        this.d_customFDSPanel = new CustomFDSPanel(6);
        guiPanel guiPanel2 = new guiPanel(new GridBagLayout());
        GridBagHelper gridBagHelper = new GridBagHelper(guiPanel2, false);
        gridBagHelper.addRow(Intl.intl("ID:"), this.d_id, 1.0, 0);
        gridBagHelper.addRow(Intl.intl("Description:"), this.d_desc, 1.0, 0);
        gridBagHelper.addRow(Intl.intl("Group:"), this.d_group, 0);
        if (this.d_objEditor != null) {
            this.d_objEditor.add(this, gridBagHelper);
        }
        guiPanel guiPanel3 = new guiPanel(new GridBagLayout());
        TitleSeparator titleSeparator = new TitleSeparator(Intl.intl("Bounding Box"));
        GridBagUtil.add(guiPanel3, titleSeparator, 0, 0, 1, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(guiPanel3, this.d_boundsPanel, 0, 1, 1, 1, 0, 12, 0, 0, 2, 1.0, 0.0, 17);
        guiPanel guiPanel4 = new guiPanel(new GridBagLayout());
        GridBagUtil.add(guiPanel4, guiPanel2, 0, 0, 2, 1, 0, 0, 12, 0, 2, 1.0, 0.0);
        GridBagUtil.add(guiPanel4, guiPanel3, 0, 1, 2, 1, 0, 0, 0, 0, 2, 1.0, 0.0);
        GridBagUtil.addGlue(guiPanel4);
        this.d_tabbedPane = new JTabbedPane();
        this.d_tabbedPane.add(Intl.intl("General"), ModelObjectDialog.createTab(guiPanel4));
        if (this.d_geomEditor != null) {
            this.d_geomPanel = new guiPanel(new GridBagLayout());
            object = new TitleSeparator(String.format(Intl.intl("%s Properties"), this.d_geomEditor.getGeomName()));
            GridBagUtil.add(this.d_geomPanel, (Component)object, 0, 0, 2, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
            GridBagUtil.add(this.d_geomPanel, this.d_geomEditor.getPanel(), 0, 1, 2, 1, 0, 12, 0, 0, 1, 1.0, 1.0, 17);
            this.d_tabbedPane.add(Intl.intl("Geometry"), ModelObjectDialog.createTab(this.d_geomPanel));
        } else {
            this.d_geomPanel = new guiPanel();
        }
        if (this.d_objEditor != null) {
            object = this.d_objEditor.getExtraTabs();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                Pair pair = (Pair)iterator.next();
                this.d_tabbedPane.add((String)pair.v1, ModelObjectDialog.createTab((guiPanel)pair.v2));
            }
        }
        object = this.getDialogPane();
        ((Container)object).add((Component)this.d_tabbedPane, "Center");
        this.setTitle(ModelObjectDialog.determineTitle(this.d_objEditor, collection));
        this.loadValues(this.d_objs);
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
                ModelObjectDialog.this.d_id.requestFocusInWindow();
            }

            @Override
            public void windowLostFocus(WindowEvent windowEvent) {
            }
        });
    }

    public ControlSelPnl.INameSource getNameSource() {
        return new TextFldNameSource(this.d_id);
    }

    public int getMode() {
        return this.d_type;
    }

    protected void removeExtraTab(String string) {
        if (this.d_tabbedPane == null) {
            return;
        }
        int n = this.d_tabbedPane.indexOfTab(string);
        if (n < 0) {
            return;
        }
        this.d_tabbedPane.removeTabAt(n);
    }

    protected void addExtraTab(String string, guiPanel guiPanel2) {
        int n = this.d_tabbedPane.indexOfTab(string);
        if (n >= 0) {
            return;
        }
        this.d_tabbedPane.addTab(string, ModelObjectDialog.createTab(guiPanel2));
    }

    public void setGeomTabVis(boolean bl) {
        if (this.d_geomEditor == null) {
            return;
        }
        if (bl) {
            this.addExtraTab(GEOMETRY_PROPS_TAB, this.d_geomPanel);
        } else {
            this.removeExtraTab(GEOMETRY_PROPS_TAB);
        }
    }

    public ControlSelPnl getControlPanel() {
        return this.d_controlPnl;
    }

    private IEditor createObjEditor(PyroMod pyroMod, Collection<? extends IPyroObject> collection, IGeomEditor iGeomEditor) {
        Collection<IModelObj> collection2 = Hierarchy.flatten(collection, IModelObj.class);
        CollectionMetrics<IModelObj> collectionMetrics = new CollectionMetrics<IModelObj>(collection2);
        int n2 = collectionMetrics.getNum(IHole.class);
        int n3 = collectionMetrics.getNum(IObstruction.class);
        int n4 = collectionMetrics.getNum(PartCloud.class);
        int n5 = collectionMetrics.getNum(Vent.class);
        int n6 = collectionMetrics.getNum(InitRegion.class);
        int n7 = collectionMetrics.getNum(GenericGeomSrc.class);
        int n8 = collectionMetrics.getNum(HvacNode.class);
        int n9 = collectionMetrics.getNum(HvacDuct.class);
        int n10 = collectionMetrics.getNum(FDSObject.class);
        boolean bl = true;
        boolean bl2 = n10 > 0;
        int n11 = (int)IntStream.of(n2, n3, n4, n5, n6, n7, n8, n9).filter(n -> n != 0).count();
        if (n11 == 0) {
            return new DefModelObjEditor<IModelObj>(IModelObj.class, Intl.intl("Group Properties"), false, false);
        }
        if (n11 > 1) {
            return new DefModelObjEditor<IModelObj>(IModelObj.class, Intl.intl("Multi-select Properties"), bl, bl2);
        }
        int n12 = collection2.size();
        if (ModelObjectDialog.isExclusive(n3, n12)) {
            return new ObstructionEditor(pyroMod, iGeomEditor);
        }
        if (ModelObjectDialog.isExclusive(n5, n12)) {
            return new VentEditor(this, pyroMod);
        }
        if (ModelObjectDialog.isExclusive(n2, n12)) {
            return new HoleEditor(pyroMod);
        }
        if (ModelObjectDialog.isExclusive(n4, n12)) {
            return new PartCloudEditor(this, pyroMod);
        }
        if (ModelObjectDialog.isExclusive(n6, n12)) {
            return new InitEditor(pyroMod);
        }
        if (ModelObjectDialog.isExclusive(n7, n12)) {
            return new GenericEditor();
        }
        if (ModelObjectDialog.isExclusive(n8, n12)) {
            return new NodeEditor(this, pyroMod, iGeomEditor);
        }
        if (ModelObjectDialog.isExclusive(n9, n12)) {
            return new DuctEditor(pyroMod, this.d_id);
        }
        return null;
    }

    private static boolean isExclusive(int n, int n2) {
        return n != 0 && n == n2;
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        Composite composite;
        if (!super.validateData(bl, bl2)) {
            return false;
        }
        Collection<IModelObj> collection = Hierarchy.flatten(this.d_objs, IModelObj.class);
        if (this.d_objEditor != null && !this.d_objEditor.validateData(this, bl, bl2)) {
            return false;
        }
        if (this.d_geomEditor != null && !this.d_geomEditor.validateData(collection, bl, bl2)) {
            return false;
        }
        if (this.d_type == 1 && (composite = (Composite)this.d_group.getSelectedItem()) != null) {
            IPyroObject iPyroObject = Hierarchy.getCommonParent(this.d_objs);
            boolean bl3 = TVEntryPoints.ep(composite).canDrop(this.d_mediator, composite, new IdentityHashSet<IPyroObject>(this.d_objs), iPyroObject);
            if (!bl3) {
                if (bl2) {
                    this.d_group.requestFocusInWindow();
                }
                if (bl) {
                    String string = String.format(Intl.intl("Cannot move selected objects to group, \"%s.\""), composite.getName());
                    ModelObjectDialog.showInvalidEntryMessage(this, string);
                }
                return false;
            }
        }
        try {
            ModelDialogsUtil.validateName(this.d_mediator, this.d_type != 1, this.d_objs, this.d_id);
        }
        catch (Exception exception) {
            if (bl) {
                ModelObjectDialog.showInvalidEntryMessage(this, exception.getLocalizedMessage());
            }
            return false;
        }
        return true;
    }

    protected int addColor(guiPanel guiPanel2, int n) {
        GridBagUtil.add(guiPanel2, this.d_cbSpecifyColor, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_cbColor, 1, n++, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        return n;
    }

    protected void addColor(GridBagHelper gridBagHelper) {
        gridBagHelper.addRow(this.d_cbSpecifyColor, this.d_cbColor);
    }

    protected int addControlInput(guiPanel guiPanel2, int n) {
        return this.d_controlPnl.add(guiPanel2, 0, n, 0, 0, 6, 0);
    }

    protected void addControlInput(GridBagHelper gridBagHelper) {
        this.d_controlPnl.add(gridBagHelper);
    }

    private static guiPanel createTab(guiPanel guiPanel2) {
        guiPanel guiPanel3 = guiPanel2;
        guiPanel3.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        return guiPanel3;
    }

    private static String determineTitle(IEditor iEditor, Collection<? extends IPyroObject> collection) {
        if (iEditor != null) {
            return iEditor.getDialogTitle();
        }
        return Intl.intl("Object Properties");
    }

    private void loadValues(Collection<? extends IPyroObject> collection) {
        if (this.d_type == 0 || this.sameParent(this.d_parent, collection)) {
            this.d_group.setSelectedComposite(this.d_parent);
        } else {
            this.d_group.setSelectedComposite(null);
        }
        this.d_group.setEnabled(true);
        Collection<IModelObj> collection2 = Hierarchy.flatten(collection, IModelObj.class);
        ModelDialogsUtil.loadName(collection, this.d_id);
        ModelDialogsUtil.loadString(collection2, this.d_desc, IModelObj.descProp);
        ModelDialogsUtil.loadColor(collection2, this.d_cbSpecifyColor, this.d_cbColor);
        AABox aABox = GeomUtil.getBounds(collection2);
        this.d_boundsPanel.load(new AABoxGeom(aABox));
        if (this.d_geomEditor != null) {
            this.d_geomEditor.load(collection2);
        }
        if (this.d_objEditor != null) {
            this.d_objEditor.load(this.d_mediator, collection2);
        }
        this.d_controlPnl.load(this.getEventPins(collection2));
        IFilteredCollection<ICustomFDSPropsContainer> iFilteredCollection = theUtil.filter(collection2, ICustomFDSPropsContainer.class);
        if (iFilteredCollection.isEmpty()) {
            this.d_tabbedPane.remove(this.d_boundsPanel);
        } else {
            this.d_tabbedPane.addTab(Intl.intl("Advanced"), this.d_customFDSPanel);
            this.d_customFDSPanel.load(iFilteredCollection);
        }
        this.setModified(false);
    }

    public void saveValues(Collection<? extends IPyroObject> collection) {
        final Collection<IModelObj> collection2 = Hierarchy.flatten(collection, IModelObj.class);
        final Collection<? extends IPyroObject> collection3 = collection;
        AOneTimeTask aOneTimeTask = new AOneTimeTask(){

            @Override
            public void run() {
                ModelDialogsUtil.saveName(ModelObjectDialog.this.d_mediator, ModelObjectDialog.this.d_type == 0, collection3, ModelObjectDialog.this.d_id);
                ModelDialogsUtil.saveString(collection2, ModelObjectDialog.this.d_desc, IModelObj.descProp);
                ModelDialogsUtil.saveColor(ModelObjectDialog.this.d_mediator, collection2, ModelObjectDialog.this.d_cbSpecifyColor, ModelObjectDialog.this.d_cbColor);
                Pair pair = ModelObjectDialog.this.filterControllableObjs(collection2);
                if (ModelObjectDialog.this.d_controlPnl.save(ModelObjectDialog.this.getEventPins((Collection)pair.v1))) {
                    for (ICloneRequired iCloneRequired : collection2) {
                        iCloneRequired.changedEvt(new Object[0]);
                    }
                }
                for (ICloneRequired iCloneRequired : ModelObjectDialog.this.getEventPins((Collection)pair.v2)) {
                    ((AOneInPin)iCloneRequired).disconnectAll();
                }
                for (ICloneRequired iCloneRequired : (Collection)pair.v2) {
                    iCloneRequired.changedEvt(new Object[0]);
                }
                if (ModelObjectDialog.this.d_geomEditor != null && ModelObjectDialog.this.d_tabbedPane.indexOfTab(GEOMETRY_PROPS_TAB) >= 0) {
                    ModelObjectDialog.this.d_geomEditor.save(collection2);
                    ModelDialogsUtil.bakeTransforms(ModelObjectDialog.this.d_mediator, collection2);
                }
                if (ModelObjectDialog.this.d_objEditor != null) {
                    ModelObjectDialog.this.d_objEditor.save(ModelObjectDialog.this.d_mediator, collection2);
                }
                ModelObjectDialog.this.d_customFDSPanel.save(theUtil.filter(collection2, ICustomFDSPropsContainer.class));
            }
        };
        Composite composite = (Composite)this.d_group.getSelectedItem();
        if (this.d_type == 0) {
            aOneTimeTask.run();
            IModelObj iModelObj = collection2.iterator().next();
            AddAutoRenameTask addAutoRenameTask = new AddAutoRenameTask(composite, new IPyroObject[]{iModelObj});
            SelectTask selectTask = new SelectTask(this.d_mediator, iModelObj);
            selectTask.addTask(addAutoRenameTask);
            this.d_mediator.getTaskManager().exec(selectTask, Intl.intl("Add Object"));
        } else if (this.d_type == 1) {
            CompositeTask<PyroMod> compositeTask = new CompositeTask<PyroMod>(this.d_mediator);
            compositeTask.addTask(aOneTimeTask);
            if (composite != null) {
                ArrayList<IPyroObject> arrayList = new ArrayList<IPyroObject>();
                for (IPyroObject iPyroObject : collection3) {
                    if (iPyroObject.getParent() == composite) continue;
                    arrayList.add(iPyroObject);
                }
                if (!arrayList.isEmpty()) {
                    compositeTask.addTask(new ReorderObjectsTask((IPyroObject)composite, composite.getMembers().size(), arrayList));
                }
            }
            this.d_mediator.getTaskManager().exec(compositeTask, Intl.intl("Edit Obstructions"));
        }
    }

    private boolean sameParent(Composite<? extends IPyroObject> composite, Collection<? extends IPyroObject> collection) {
        int n = 0;
        for (IPyroObject iPyroObject : collection) {
            IPyroObject iPyroObject2 = iPyroObject.getParent();
            if (Objects.equals(iPyroObject2, composite)) {
                ++n;
                continue;
            }
            return false;
        }
        return n == collection.size();
    }

    private Pair<Collection<IModelObj>, Collection<IModelObj>> filterControllableObjs(Collection<? extends IModelObj> collection) {
        Predicate<IModelObj> predicate = new Predicate<IModelObj>(){

            @Override
            public boolean test(IModelObj iModelObj) {
                return ModelObjectDialog.this.d_objEditor.getType().isInstance(iModelObj) && ModelObjectDialog.this.d_objEditor.isControllable(iModelObj);
            }
        };
        return new Pair<Collection<IModelObj>, Collection<IModelObj>>(theUtil.filter(collection, predicate), theUtil.filter(collection, predicate.negate()));
    }

    private Collection<OneLogicInPin> getEventPins(Collection<? extends IModelObj> collection) {
        return theUtil.filter(Util.getInputPins(theUtil.filter(collection, ISignalSink.class).iterator()), OneLogicInPin.class);
    }

    public static interface IEditor<T extends IModelObj> {
        public String getDialogTitle();

        public Class<T> getType();

        public void add(ModelObjectDialog var1, GridBagHelper var2);

        public List<Pair<String, guiPanel>> getExtraTabs();

        public boolean isControllable(T var1);

        public void load(PyroMod var1, Collection<? extends T> var2);

        public void save(PyroMod var1, Collection<? extends T> var2);

        public boolean validateData(Component var1, boolean var2, boolean var3);
    }
}

