/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.Composite;
import pyrosim.domain.GeomUtil;
import pyrosim.domain.INamed;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.geom.FDSObject;
import pyrosim.domain.geom.GenericGeomSrc;
import pyrosim.domain.geom.IModelObj;
import pyrosim.util.Util;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.colorscheme.ColorButton;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.util.IFilteredCollection;
import thunderheadeng.util.theUtil;

public class ModelDialogsUtil {
    public static final Composite.IObjectProp colorProp = new Composite.AObjectProp<IModelObj, Color[]>(IModelObj.class){

        @Override
        public void set(IModelObj iModelObj, Color[] colorArray) {
            if (iModelObj instanceof FDSObject) {
                FDSObject.colorProp.set(iModelObj, colorArray);
            } else if (iModelObj instanceof GenericGeomSrc) {
                GenericGeomSrc.colorProp.set(iModelObj, colorArray);
            }
        }

        @Override
        public Object get(IModelObj iModelObj) {
            if (iModelObj instanceof FDSObject) {
                return FDSObject.colorProp.get(iModelObj);
            }
            if (iModelObj instanceof GenericGeomSrc) {
                return GenericGeomSrc.colorProp.get(iModelObj);
            }
            return Composite.NOT_SUPPORTED;
        }

        @Override
        public boolean equal(Color[] colorArray, Color[] colorArray2) {
            return Arrays.equals(colorArray, colorArray2);
        }
    };

    public static void loadName(Collection<? extends IPyroObject> collection, guiTextField guiTextField2) {
        if (collection.size() == 1) {
            guiTextField2.setText(Util.getName(collection.iterator().next()));
        } else {
            guiTextField2.setText("<" + collection.size() + " Objects Selected>");
        }
    }

    public static void saveName(PyroMod pyroMod, boolean bl, Collection<? extends IPyroObject> collection, guiTextField guiTextField2) {
        if (!bl && !guiTextField2.isModified()) {
            return;
        }
        IFilteredCollection<INamed> iFilteredCollection = theUtil.filter(collection, INamed.class);
        if (iFilteredCollection.isEmpty()) {
            return;
        }
        String string = guiTextField2.getText();
        List<String> list = pyroMod.getNames().generateValidNames(iFilteredCollection, string, !bl);
        int n = 0;
        for (INamed iNamed : iFilteredCollection) {
            iNamed.setName(list.get(n++));
        }
    }

    public static void validateName(PyroMod pyroMod, boolean bl, Collection<? extends IPyroObject> collection, guiTextField guiTextField2) throws Exception {
        IFilteredCollection<INamed> iFilteredCollection = theUtil.filter(collection, INamed.class);
        if (iFilteredCollection.size() == 1 && (bl || guiTextField2.isModified())) {
            String string = guiTextField2.getText();
            INamed iNamed = (INamed)iFilteredCollection.iterator().next();
            if (!bl && string.equals(iNamed.getName())) {
                return;
            }
            if (string.isEmpty()) {
                throw new Exception(Intl.intl("Name must not be empty"));
            }
            if (pyroMod.getNames(iNamed).isRegistered(string)) {
                throw new Exception(Intl.intl("Name is already in use. Choose a different name."));
            }
        }
    }

    public static void loadString(Collection<? extends IModelObj> collection, guiTextField guiTextField2, Composite.IObjectProp<IModelObj, String> iObjectProp) {
        Object object = Composite.getProperty(iObjectProp, collection);
        if (object == Composite.NON_UNIFORM) {
            guiTextField2.setValue(Intl.intl("<multiple>"));
        } else if (object instanceof String) {
            guiTextField2.setValue((String)object);
        }
    }

    public static void saveString(Collection<? extends IModelObj> collection, guiTextField guiTextField2, Composite.IObjectProp<IModelObj, String> iObjectProp) {
        if (guiTextField2.isModified()) {
            Composite.setProperty(iObjectProp, guiTextField2.getValue().trim(), collection);
        }
    }

    public static <ObjT extends IModelObj> void loadBoolean(Collection<? extends ObjT> collection, guiMultiStateCheckBox guiMultiStateCheckBox2, Composite.IObjectProp<ObjT, Boolean> iObjectProp) {
        Object object = Composite.getProperty(iObjectProp, collection);
        if (object == Composite.NON_UNIFORM) {
            guiMultiStateCheckBox2.setState(2);
        } else if (object instanceof Boolean) {
            guiMultiStateCheckBox2.setSelected((Boolean)object);
        }
    }

    public static <ObjT extends IModelObj> void saveBoolean(PyroMod pyroMod, Collection<? extends ObjT> collection, guiMultiStateCheckBox guiMultiStateCheckBox2, Composite.IObjectProp<ObjT, Boolean> iObjectProp) {
        if (guiMultiStateCheckBox2.getState() != 2) {
            Composite.setProperty(iObjectProp, guiMultiStateCheckBox2.isSelected(), collection);
        }
    }

    public static <ObjT extends IModelObj> void bakeTransforms(PyroMod pyroMod, Collection<? extends ObjT> collection) {
        for (IModelObj iModelObj : collection) {
            IGeomNode iGeomNode = iModelObj.getGeom();
            iGeomNode = iGeomNode.bakeIfRecommended();
            iModelObj.setGeom(iGeomNode);
        }
    }

    public static void loadColor(Collection<? extends IModelObj> collection, guiMultiStateCheckBox guiMultiStateCheckBox2, ColorButton colorButton) {
        Object object = Composite.getProperty(colorProp, collection);
        if (object == Composite.NON_UNIFORM) {
            guiMultiStateCheckBox2.setState(2);
        } else if (object != Composite.NOT_SUPPORTED) {
            boolean bl;
            Color[] colorArray = (Color[])object;
            boolean bl2 = bl = colorArray != null ? GeomUtil.isUniform(colorArray) : true;
            if (bl) {
                guiMultiStateCheckBox2.setSelected(colorArray[0] != null);
                if (colorArray[0] != null) {
                    colorButton.setColor(colorArray[0]);
                }
            } else {
                guiMultiStateCheckBox2.setState(2);
            }
        }
    }

    public static void saveColor(PyroMod pyroMod, Collection<? extends IModelObj> collection, guiMultiStateCheckBox guiMultiStateCheckBox2, ColorButton colorButton) {
        if (guiMultiStateCheckBox2.getState() != 2) {
            Color color = guiMultiStateCheckBox2.isSelected() ? colorButton.getColor() : null;
            Composite.setProperty(colorProp, new Color[]{color}, collection);
        }
    }

    private static void setDFValue(ValueField<Double> valueField, double d, boolean bl) {
        if (bl) {
            valueField.setValue(d);
        } else {
            valueField.setText("");
        }
    }

    public static <T extends IModelObj> void loadDoubles(Collection<? extends T> collection, Field<double[], T> field, ValueField<Double> ... valueFieldArray) {
        if (collection.isEmpty()) {
            return;
        }
        Iterator<T> iterator = collection.iterator();
        IModelObj iModelObj = (IModelObj)iterator.next();
        double[] dArray = new double[valueFieldArray.length];
        double[] dArray2 = field.getValue(iModelObj);
        assert (dArray2.length == valueFieldArray.length);
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = dArray2[i];
        }
        boolean[] blArray = new boolean[dArray.length];
        Arrays.fill(blArray, true);
        while (iterator.hasNext()) {
            IModelObj iModelObj2 = (IModelObj)iterator.next();
            double[] dArray3 = field.getValue(iModelObj2);
            assert (dArray3.length == dArray.length);
            for (int i = 0; i < dArray.length; ++i) {
                if (!blArray[i] || dArray3[i] == dArray[i]) continue;
                blArray[i] = false;
            }
        }
        for (int i = 0; i < valueFieldArray.length; ++i) {
            ModelDialogsUtil.setDFValue(valueFieldArray[i], dArray[i], blArray[i]);
        }
    }

    public static <T extends IModelObj> void saveDoubles(PyroMod pyroMod, Collection<? extends T> collection, Field<double[], T> field, ValueField<Double> ... valueFieldArray) {
        pyroMod.pauseUpdates();
        for (IModelObj iModelObj : collection) {
            double[] dArray = field.getValue(iModelObj);
            assert (dArray.length == valueFieldArray.length);
            for (int i = 0; i < dArray.length; ++i) {
                if (valueFieldArray[i].isEmpty()) continue;
                dArray[i] = (Double)valueFieldArray[i].getValue();
            }
            field.setValue(iModelObj, dArray);
        }
        pyroMod.resumeUpdates();
    }

    public static <T extends IModelObj> void loadDouble(Collection<? extends T> collection, Field<Double, T> field, ValueField<Double> valueField) {
        if (collection.isEmpty()) {
            return;
        }
        Iterator<T> iterator = collection.iterator();
        Double d = field.getValue((IModelObj)iterator.next());
        while (iterator.hasNext()) {
            IModelObj iModelObj = (IModelObj)iterator.next();
            Double d2 = field.getValue(iModelObj);
            if (d.equals(d2)) continue;
            ModelDialogsUtil.setDFValue(valueField, d, false);
            return;
        }
        ModelDialogsUtil.setDFValue(valueField, d, true);
    }

    public static <T extends IModelObj> void saveDouble(PyroMod pyroMod, Collection<? extends T> collection, Field<Double, T> field, ValueField<Double> valueField) {
        if (valueField.isEmpty()) {
            return;
        }
        pyroMod.pauseUpdates();
        for (IModelObj iModelObj : collection) {
            field.setValue((T)iModelObj, (Double)valueField.getValue());
        }
        pyroMod.resumeUpdates();
    }

    public static interface Field<DataType, ObjType extends IModelObj> {
        public DataType getValue(ObjType var1);

        public void setValue(ObjType var1, DataType var2);
    }
}

