/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.GridBagLayout;
import java.util.Collection;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.geom.Geometry;
import pyrosim.gui.geom.GeomGuiUtil;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.gui.geom.Point3DPanel;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.objs.LineSeg;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitLineSeg3D;
import thunderheadeng.units.UnitPoint3D;

public class LineSegEditor
extends guiPanel
implements IGeomEditor<LineSeg> {
    private static final long serialVersionUID = -3108590421712295087L;
    private UnitSystem d_currentUS = ((PyroSim)Application.getApp()).getUnitSystem();
    private Point3DPanel d_p1Panel;
    private Point3DPanel d_p2Panel;

    public LineSegEditor() {
        this.setLayout(new GridBagLayout());
        this.d_p1Panel = new Point3DPanel(Intl.intl("End Point 1"));
        this.d_p2Panel = new Point3DPanel(Intl.intl("End Point 2"));
        this.d_p1Panel.addToPanel(this, 0, 0);
        this.d_p2Panel.addToPanel(this, 0, 1);
        GridBagUtil.addGlue(this);
        this.load(new UnitLineSeg3D(0.0, 0.0, 0.0, 0.0, 0.0, 3.0, SI.METER));
    }

    @Override
    public String getGeomName() {
        return Intl.intl("Line");
    }

    @Override
    public int getNumFaces() {
        return 0;
    }

    @Override
    public String[] getFaceNames() {
        return null;
    }

    @Override
    public int[] getFaceOrder(IGeomNode iGeomNode) {
        return null;
    }

    @Override
    public guiPanel getPanel() {
        return this;
    }

    @Override
    public void load(Collection<? extends IPyroGeomSrc> collection) {
        UnitDouble[] unitDoubleArray = GeomGuiUtil.getDataVals(collection, new DataProp(), 6, Geometry.LU);
        this.d_p1Panel.setX(unitDoubleArray[0]);
        this.d_p1Panel.setY(unitDoubleArray[1]);
        this.d_p1Panel.setZ(unitDoubleArray[2]);
        this.d_p2Panel.setX(unitDoubleArray[3]);
        this.d_p2Panel.setY(unitDoubleArray[4]);
        this.d_p2Panel.setZ(unitDoubleArray[5]);
    }

    @Override
    public void save(Collection<? extends IPyroGeomSrc> collection) {
        UnitDouble[] unitDoubleArray = new UnitDouble[]{this.d_p1Panel.x(), this.d_p1Panel.y(), this.d_p1Panel.z(), this.d_p2Panel.x(), this.d_p2Panel.y(), this.d_p2Panel.z()};
        GeomGuiUtil.setDataVals(collection, new DataProp(), Geometry.LU, unitDoubleArray);
    }

    @Override
    public boolean validateData(Collection<? extends IPyroGeomSrc> collection, boolean bl, boolean bl2) {
        return true;
    }

    public void load(UnitLineSeg3D unitLineSeg3D) {
        this.d_p1Panel.load(unitLineSeg3D.getP1());
        this.d_p2Panel.load(unitLineSeg3D.getP2());
    }

    public UnitLineSeg3D getBeamLoc() {
        UnitPoint3D unitPoint3D = this.d_p1Panel.save();
        UnitPoint3D unitPoint3D2 = this.d_p2Panel.save();
        return new UnitLineSeg3D(unitPoint3D, unitPoint3D2);
    }

    private static class DataProp
    extends GeomGuiUtil.AGeomProp<LineSeg> {
        private DataProp() {
        }

        @Override
        protected LineSeg constructGeom(LineSeg lineSeg, double[] dArray) {
            return new LineSeg(new Point3d(dArray[0], dArray[1], dArray[2]), new Point3d(dArray[3], dArray[4], dArray[5]));
        }

        @Override
        protected double[] saveData(LineSeg lineSeg) {
            return new double[]{lineSeg.p1.x, lineSeg.p1.y, lineSeg.p1.z, lineSeg.p2.x, lineSeg.p2.y, lineSeg.p2.z};
        }
    }
}

