/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.Composite;
import pyrosim.domain.ExSpec;
import pyrosim.domain.ExSpecList;
import pyrosim.domain.SimParams;
import pyrosim.domain.geom.InitRegion;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.geom.ModelObjectDialog;
import pyrosim.unitsystem.UnitSystem;
import pyrosim.util.NamedSorter;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiMultiStateCheckBox;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Pair;
import thunderheadeng.util.SortCache;

public class InitEditor
implements ModelObjectDialog.IEditor<InitRegion> {
    private static final String MASS_FRAC_TITLE = Intl.intl("Mass Fraction");
    private static final String VOL_FRAC_TITLE = Intl.intl("Volume Fraction");
    private final PyroMod d_domain;
    private final guiMultiStateCheckBox d_tempCB;
    private final ValueField<UnitDouble> d_tempFld;
    private final guiMultiStateCheckBox d_densityCB;
    private final ValueField<UnitDouble> d_densityFld;
    private final guiRadioButton d_massFracRB;
    private final guiRadioButton d_volFracRB;
    private final guiButtonGroup d_specFracGroup;
    private final guiTable d_specTbl;
    private final SortCache<ExSpec> d_specs;

    public InitEditor(PyroMod pyroMod) {
        this.d_domain = pyroMod;
        this.d_tempCB = new guiMultiStateCheckBox(Intl.intl("Temperature:"));
        this.d_tempFld = ValueFields.udFld(UnitSystem.getSource(1));
        this.d_tempFld.setNullAllowed(true);
        this.d_tempCB.addActionListener(actionEvent -> this.d_tempFld.requestFocusInWindow());
        LinkStatus.link((AbstractButton)this.d_tempCB, this.d_tempFld);
        this.d_densityCB = new guiMultiStateCheckBox(Intl.intl("Density:"));
        this.d_densityFld = ValueFields.udFld(UnitSystem.getSource(4));
        this.d_densityCB.addActionListener(actionEvent -> this.d_densityFld.requestFocusInWindow());
        this.d_densityFld.setNullAllowed(true);
        LinkStatus.link((AbstractButton)this.d_densityCB, this.d_densityFld);
        this.d_specs = this.sortSpecs(pyroMod);
        this.d_specTbl = InitEditor.prepareSpecTbl(this.d_specs);
        this.d_massFracRB = new guiRadioButton(Intl.intl("Species as Mass Fraction"));
        this.d_volFracRB = new guiRadioButton(Intl.intl("Species as Volume Fraction"));
        this.d_specFracGroup = new guiButtonGroup(this.d_massFracRB, this.d_volFracRB);
        ItemListener itemListener = itemEvent -> {
            String string = "";
            UnitSystem unitSystem = PyroSim.getApp().getUnitSystem();
            if (this.d_massFracRB.isSelected()) {
                string = MASS_FRAC_TITLE + " (" + unitSystem.getMassFractionUnit().toString() + ")";
            }
            if (this.d_volFracRB.isSelected()) {
                string = VOL_FRAC_TITLE + " (" + unitSystem.getMassFractionUnit().toString() + ")";
            }
            this.d_specTbl.getColumnModel().getColumn(1).setHeaderValue(string);
            this.d_specTbl.setEnabled(true);
            this.d_specTbl.updateUI();
        };
        this.d_massFracRB.setSelected(true);
        this.d_massFracRB.addItemListener(itemListener);
        this.d_volFracRB.addItemListener(itemListener);
    }

    @Override
    public boolean isControllable(InitRegion initRegion) {
        return initRegion.isControllable();
    }

    private SortCache<ExSpec> sortSpecs(PyroMod pyroMod) {
        ExSpecList exSpecList = pyroMod.getExSpecList();
        return new SortCache<ExSpec>(exSpecList.flatten(), new NamedSorter());
    }

    private static guiTable prepareSpecTbl(SortCache<ExSpec> sortCache) {
        UnitSystem unitSystem = PyroSim.getApp().getUnitSystem();
        guiTable guiTable2 = guiTableUtil.fixedColumnTable(new String[]{Intl.intl("Species"), String.format(Intl.intl("Mass Fraction (%s)"), unitSystem.getMassFractionUnit())}, new Class[]{String.class, Double.class}, sortCache.size(), sortCache.size(), 0);
        for (int i = 0; i < sortCache.size(); ++i) {
            guiTable2.setValueAt(sortCache.get(i).getName(), i, 0);
        }
        guiTable2.setColumnEditable(0, false);
        return guiTable2;
    }

    @Override
    public String getDialogTitle() {
        return Intl.intl("Initial Region Properties");
    }

    @Override
    public Class<InitRegion> getType() {
        return InitRegion.class;
    }

    @Override
    public List<Pair<String, guiPanel>> getExtraTabs() {
        return Collections.EMPTY_LIST;
    }

    @Override
    public void add(ModelObjectDialog modelObjectDialog, GridBagHelper gridBagHelper) {
        this.add(gridBagHelper);
    }

    public void add(GridBagHelper gridBagHelper) {
        TitleSeparator titleSeparator = new TitleSeparator(Intl.intl("Initial Environment Properties"));
        JScrollPane jScrollPane = new JScrollPane(this.d_specTbl);
        int n = this.d_specTbl.autoSizeColumns();
        jScrollPane.setPreferredSize(new Dimension(n, 100));
        gridBagHelper.addFilledRow(titleSeparator);
        gridBagHelper.indent();
        gridBagHelper.addRow(this.d_tempCB, this.d_tempFld);
        gridBagHelper.addRow(this.d_densityCB, this.d_densityFld);
        gridBagHelper.addRow(this.d_massFracRB);
        gridBagHelper.addRow(this.d_volFracRB);
        gridBagHelper.addFilledRow(jScrollPane);
    }

    @Override
    public boolean validateData(Component component, boolean bl, boolean bl2) {
        for (int i = 0; i < this.d_specs.size(); ++i) {
            guiLabel guiLabel2;
            int n;
            Double d;
            ExSpec exSpec = this.d_specs.get(i);
            if (!ExSpecList.Predefined.AIR.spec.equals(exSpec) || (d = (Double)this.d_specTbl.getValueAt(i, 1)) == null || d == 0.0 || (n = JOptionPane.showConfirmDialog(component, guiLabel2 = new guiLabel(PyroGuiUtil.encodeToHtmlLabel(Intl.intl("AIR is usually the background species and should be set to 0. It will\nautomatically account for any unspecified mass fraction. If you have\ndefined a custom background species other than AIR, click OK to ignore\nthis warning."))), Intl.intl("Warning"), 2, 2)) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void load(PyroMod pyroMod, Collection<? extends InitRegion> collection) {
        SimParams.Environment environment = pyroMod.getSimParams().getEnvironment();
        InitEditor.loadCB(this.d_tempCB, this.d_tempFld, environment.getAmbTemp(), InitRegion.tempProp, collection);
        InitEditor.loadCB(this.d_densityCB, this.d_densityFld, null, InitRegion.densityProp, collection);
        this.loadExSpec(InitRegion.specTypeProp, collection);
    }

    private static void loadCB(guiMultiStateCheckBox guiMultiStateCheckBox2, ValueField<UnitDouble> valueField, UnitDouble unitDouble, Composite.IObjectProp<InitRegion, UnitDouble> iObjectProp, Collection<? extends InitRegion> collection) {
        Object object = Composite.getProperty(iObjectProp, collection);
        if (object == Composite.NON_UNIFORM) {
            guiMultiStateCheckBox2.setState(2);
            valueField.setValue(null);
        } else if (object == null) {
            guiMultiStateCheckBox2.setSelected(false);
            valueField.setValue(unitDouble);
        } else {
            guiMultiStateCheckBox2.setSelected(true);
            valueField.setValue((UnitDouble)object);
        }
    }

    private void loadExSpec(Composite.IObjectProp<InitRegion, InitRegion.SpecFractionType> iObjectProp, Collection<? extends InitRegion> collection) {
        Object object = Composite.getProperty(iObjectProp, collection);
        Unit unit = null;
        if (object == Composite.NON_UNIFORM) {
            this.d_specFracGroup.clearSelection();
            this.d_specTbl.setEnabled(false);
            return;
        }
        if (object.equals((Object)InitRegion.SpecFractionType.MASS_FRACTION)) {
            this.d_massFracRB.setSelected(true);
            unit = PyroSim.getApp().getUnitSystem().getMassFractionUnit();
        } else if (object.equals((Object)InitRegion.SpecFractionType.VOLUME_FRACTION)) {
            this.d_volFracRB.setSelected(true);
            unit = PyroSim.getApp().getUnitSystem().getVolumeFractionUnit();
        }
        if (unit != null) {
            InitRegion.SpecFracProp specFracProp = new InitRegion.SpecFracProp();
            for (int i = 0; i < this.d_specs.size(); ++i) {
                ExSpec exSpec;
                specFracProp.currSpec = exSpec = this.d_specs.get(i);
                Object object2 = Composite.getProperty(specFracProp, collection);
                object2 = object2 == Composite.NON_UNIFORM ? null : Double.valueOf(((UnitDouble)object2).getValue(unit));
                this.d_specTbl.setValueAt(object2, i, 1);
            }
        }
    }

    @Override
    public void save(PyroMod pyroMod, Collection<? extends InitRegion> collection) {
        InitEditor.saveCB(this.d_tempCB, this.d_tempFld, InitRegion.tempProp, collection);
        InitEditor.saveCB(this.d_densityCB, this.d_densityFld, InitRegion.densityProp, collection);
        this.saveExSpec(InitRegion.specTypeProp, collection);
    }

    private static void saveCB(guiMultiStateCheckBox guiMultiStateCheckBox2, ValueField<UnitDouble> valueField, Composite.IObjectProp<InitRegion, UnitDouble> iObjectProp, Collection<? extends InitRegion> collection) {
        if (guiMultiStateCheckBox2.getState() == 2) {
            return;
        }
        if (!guiMultiStateCheckBox2.isSelected()) {
            Composite.setProperty(iObjectProp, null, collection);
        } else if (valueField.getValue() != null) {
            Composite.setProperty(iObjectProp, valueField.getValue(), collection);
        }
    }

    private void saveExSpec(Composite.IObjectProp<InitRegion, InitRegion.SpecFractionType> iObjectProp, Collection<? extends InitRegion> collection) {
        Unit unit = null;
        InitRegion.SpecFractionType specFractionType = null;
        if (!this.d_massFracRB.isSelected() && !this.d_volFracRB.isSelected()) {
            return;
        }
        if (this.d_massFracRB.isSelected()) {
            unit = PyroSim.getApp().getUnitSystem().getMassFractionUnit();
            specFractionType = InitRegion.SpecFractionType.MASS_FRACTION;
        } else if (this.d_volFracRB.isSelected()) {
            unit = PyroSim.getApp().getUnitSystem().getVolumeFractionUnit();
            specFractionType = InitRegion.SpecFractionType.VOLUME_FRACTION;
        }
        if (unit != null && specFractionType != null) {
            Composite.setProperty(iObjectProp, specFractionType, collection);
            InitRegion.SpecFracProp specFracProp = new InitRegion.SpecFracProp();
            for (int i = 0; i < this.d_specs.size(); ++i) {
                ExSpec exSpec;
                specFracProp.currSpec = exSpec = this.d_specs.get(i);
                Double d = (Double)this.d_specTbl.getValueAt(i, 1);
                if (d == null) continue;
                UnitDouble unitDouble = new UnitDouble(d, unit);
                Composite.setProperty(specFracProp, unitDouble, collection);
            }
        }
    }
}

