/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.geom.Vent;
import pyrosim.geom.Geometry;
import pyrosim.gui.geom.AABoxGeomEditor;
import pyrosim.gui.geom.AARectangleEditor;
import pyrosim.gui.geom.ExtrudedPolyEditor;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.gui.geom.PointGeomEditor;
import pyrosim.gui.geom.PolygonEditor;
import pyrosim.gui.geom.TransformEditor;
import pyrosim.gui.geom.VentGeomEditor;
import pyrosim.gui.geom.WallGeomEditor;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.ExtrudedPoly;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.WallGeom;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Global;
import thunderheadeng.util.Pair;
import thunderheadeng.util.Predicates;
import thunderheadeng.util.PropertyUtil;

public class GeomGuiUtil {
    private static final List<Pair<Predicate<IGeomNode>, IEditorSupplier>> EDITOR_FACTORY = new ArrayList<Pair<Predicate<IGeomNode>, IEditorSupplier>>();

    private static <T extends IGeom> void addEditor(Class<T> clazz, IEditorSupplier iEditorSupplier) {
        GeomGuiUtil.addEditor(clazz, Predicates.alwaysTrue(), iEditorSupplier);
    }

    private static <T extends IGeom> void addEditor(Class<T> clazz, Predicate<T> predicate, IEditorSupplier iEditorSupplier) {
        GeomGuiUtil.addEditor((IGeomNode iGeomNode) -> clazz.isInstance(iGeomNode.getLocalGeom()) && iGeomNode.getChildren().isEmpty() && predicate.test(iGeomNode.getLocalGeom()), iEditorSupplier);
    }

    private static <T extends IGeom> void addEditor(Predicate<IGeomNode> predicate, IEditorSupplier iEditorSupplier) {
        EDITOR_FACTORY.add(new Pair<Predicate<IGeomNode>, IEditorSupplier>(predicate, iEditorSupplier));
    }

    public static IGeomEditor newEditor(Collection<? extends IPyroGeomSrc> collection) {
        if (collection.isEmpty()) {
            return null;
        }
        ArrayList<IGeomNode> arrayList = new ArrayList<IGeomNode>(collection.size());
        for (IPyroGeomSrc object : collection) {
            arrayList.add(object.getGeom());
        }
        Object object = null;
        for (Pair<Predicate<IGeomNode>, IEditorSupplier> pair : EDITOR_FACTORY) {
            if (!arrayList.stream().allMatch((Predicate)pair.v1)) continue;
            object = (IGeomEditor)((IEditorSupplier)pair.v2).apply(collection);
            break;
        }
        boolean bl = TransformEditor.isNeeded(collection);
        if (object != null && bl) {
            return new XformedGeomNodeEditor((IGeomEditor)object);
        }
        if (object != null) {
            return object;
        }
        if (bl) {
            return new TransformEditor();
        }
        return null;
    }

    public static <T extends IGeom> double[] getValueRange(final AGeomProp<T> aGeomProp, int n, Collection<? extends IPyroGeomSrc> collection) {
        aGeomProp.setIndex(n);
        final double[] dArray = new double[]{Double.MAX_VALUE, -1.7976931348623157E308};
        PropertyUtil.getProperty(new PropertyUtil.AProp<IPyroGeomSrc, Double>(IPyroGeomSrc.class){

            @Override
            public Object get(IPyroGeomSrc iPyroGeomSrc) {
                double d = (Double)aGeomProp.get(iPyroGeomSrc);
                if (d < dArray[0]) {
                    dArray[0] = d;
                }
                if (d > dArray[1]) {
                    dArray[1] = d;
                }
                return d;
            }

            @Override
            public void set(IPyroGeomSrc iPyroGeomSrc, Double d) {
            }
        }, collection);
        return dArray;
    }

    public static <T extends IGeom> boolean validateMinMax(Component component, ValueField<UnitDouble> valueField, ValueField<UnitDouble> valueField2, String string, String string2, boolean bl, AGeomProp<T> aGeomProp, int n, int n2, Collection<? extends IPyroGeomSrc> collection, boolean bl2, boolean bl3) {
        UnitDouble unitDouble;
        UnitDouble unitDouble2;
        if (valueField.isEmpty() && valueField2.isEmpty()) {
            return true;
        }
        if (valueField.isEmpty() || valueField2.isEmpty()) {
            double[] dArray;
            if (!valueField.isEmpty()) {
                dArray = GeomGuiUtil.getValueRange(aGeomProp, n2, collection);
                unitDouble2 = (UnitDouble)valueField.getValue();
                unitDouble = new UnitDouble(dArray[0], Geometry.LU);
                string2 = Global.format(unitDouble);
            } else {
                dArray = GeomGuiUtil.getValueRange(aGeomProp, n, collection);
                unitDouble2 = new UnitDouble(dArray[1], Geometry.LU);
                unitDouble = (UnitDouble)valueField2.getValue();
                string = Global.format(unitDouble2);
            }
        } else {
            unitDouble2 = (UnitDouble)valueField.getValue();
            unitDouble = (UnitDouble)valueField2.getValue();
        }
        boolean bl4 = GeomGuiUtil.validateMinMax(component, unitDouble2, unitDouble, string, string2, bl, bl2, bl3);
        if (!bl4 && bl3) {
            valueField.requestFocus();
        }
        return bl4;
    }

    public static <T extends IGeom> boolean validateMinMax(Component component, UnitDouble unitDouble, UnitDouble unitDouble2, String string, String string2, boolean bl, boolean bl2, boolean bl3) {
        int n = unitDouble.compareTo(unitDouble2);
        if (bl && n > 0) {
            if (bl2) {
                guiDialog.showInvalidEntryMessage(component, String.format(Intl.intl("%1$s must be less than or equal to %2$s."), string, string2));
            }
            return false;
        }
        if (!bl && n >= 0) {
            if (bl2) {
                guiDialog.showInvalidEntryMessage(component, String.format(Intl.intl("%1$s must be less than %2$s."), string, string2));
            }
            return false;
        }
        return true;
    }

    public static <T extends IGeom> UnitDouble[] getDataVals(Collection<? extends IPyroGeomSrc> collection, AGeomProp<T> aGeomProp, int n, Unit unit) {
        UnitDouble[] unitDoubleArray = new UnitDouble[n];
        for (int i = 0; i < n; ++i) {
            aGeomProp.setIndex(i);
            Object object = PropertyUtil.getProperty(aGeomProp, collection);
            unitDoubleArray[i] = !(object instanceof Double) ? null : new UnitDouble((Double)object, unit);
        }
        return unitDoubleArray;
    }

    public static <T extends IGeom> void setDataVals(Collection<? extends IPyroGeomSrc> collection, AGeomProp<T> aGeomProp, Unit unit, UnitDouble ... unitDoubleArray) {
        for (int i = 0; i < unitDoubleArray.length; ++i) {
            UnitDouble unitDouble = unitDoubleArray[i];
            if (unitDouble == null) continue;
            aGeomProp.setIndex(i);
            PropertyUtil.setProperty(aGeomProp, unitDouble.getValue(unit), collection);
        }
    }

    public static <T extends IGeom> Double[] getDoubleDataVals(Collection<? extends IPyroGeomSrc> collection, AGeomProp<T> aGeomProp, int n) {
        return GeomGuiUtil.getDoubleDataVals(collection, aGeomProp, n, Unit.ONE, Unit.ONE);
    }

    public static <T extends IGeom> Double[] getDoubleDataVals(Collection<? extends IPyroGeomSrc> collection, AGeomProp<T> aGeomProp, int n, Unit unit, Unit unit2) {
        Double[] doubleArray = new Double[n];
        for (int i = 0; i < n; ++i) {
            aGeomProp.setIndex(i);
            Object object = PropertyUtil.getProperty(aGeomProp, collection);
            doubleArray[i] = !(object instanceof Double) ? null : Double.valueOf(UnitDouble.convert((Double)object, unit, unit2));
        }
        return doubleArray;
    }

    public static <T extends IGeom> void setDoubleDataVals(Collection<? extends IPyroGeomSrc> collection, AGeomProp<T> aGeomProp, Double ... doubleArray) {
        GeomGuiUtil.setDoubleDataVals(collection, aGeomProp, Unit.ONE, Unit.ONE, doubleArray);
    }

    public static <T extends IGeom> void setDoubleDataVals(Collection<? extends IPyroGeomSrc> collection, AGeomProp<T> aGeomProp, Unit unit, Unit unit2, Double ... doubleArray) {
        for (int i = 0; i < doubleArray.length; ++i) {
            Double d = doubleArray[i];
            if (d == null) continue;
            aGeomProp.setIndex(i);
            PropertyUtil.setProperty(aGeomProp, UnitDouble.convert(d, unit, unit2), collection);
        }
    }

    static {
        GeomGuiUtil.addEditor(Point.class, collection -> new PointGeomEditor());
        GeomGuiUtil.addEditor(AABoxGeom.class, collection -> new AABoxGeomEditor(true, true));
        GeomGuiUtil.addEditor(WallGeom.class, collection -> new WallGeomEditor());
        GeomGuiUtil.addEditor(Vent.VentGeom.class, collection -> new VentGeomEditor());
        GeomGuiUtil.addEditor(AARectangle.class, collection -> new AARectangleEditor(true));
        GeomGuiUtil.addEditor(IPolygon.class, iPolygon -> iPolygon.getNumLoops() == 1, collection -> new PolygonEditor());
        GeomGuiUtil.addEditor(ExtrudedPoly.class, collection -> new ExtrudedPolyEditor());
    }

    private static class XformedGeomNodeEditor
    extends guiPanel
    implements IGeomEditor {
        private static final long serialVersionUID = -6235819727843229411L;
        public final TransformEditor d_xformEditor = new TransformEditor();
        public final IGeomEditor d_baseEditor;

        public XformedGeomNodeEditor(IGeomEditor iGeomEditor) {
            this.d_baseEditor = iGeomEditor;
            GridBagHelper gridBagHelper = new GridBagHelper(this);
            gridBagHelper.addFilledRow(new TitleSeparator(Intl.intl("Transformation")));
            gridBagHelper.addIdentRow(this.d_xformEditor.getPanel(), 1.0, 0);
            gridBagHelper.addFilledRow(new TitleSeparator(String.format(Intl.intl("%s Properties"), this.d_baseEditor.getGeomName())));
            gridBagHelper.addIdentRow(this.d_baseEditor.getPanel(), 1.0, 0);
            gridBagHelper.finalizeRows();
        }

        @Override
        public String getGeomName() {
            return this.d_baseEditor.getGeomName();
        }

        @Override
        public guiPanel getPanel() {
            return this;
        }

        public void load(Collection collection) {
            this.d_xformEditor.load(collection);
            this.d_baseEditor.load(collection);
        }

        public void save(Collection collection) {
            this.d_xformEditor.save(collection);
            this.d_baseEditor.save(collection);
        }

        public boolean validateData(Collection collection, boolean bl, boolean bl2) {
            return this.d_xformEditor.validateData(bl, bl2) && this.d_baseEditor.validateData(collection, bl, bl2);
        }

        @Override
        public int getNumFaces() {
            return this.d_baseEditor.getNumFaces();
        }

        @Override
        public String[] getFaceNames() {
            return this.d_baseEditor.getFaceNames();
        }

        @Override
        public int[] getFaceOrder(IGeomNode iGeomNode) {
            return this.d_baseEditor.getFaceOrder(iGeomNode);
        }
    }

    public static abstract class AGeomProp<T extends IGeom>
    extends PropertyUtil.AProp<IPyroGeomSrc, Double> {
        private int d_dataIx;

        public AGeomProp() {
            this(0);
        }

        public AGeomProp(int n) {
            super(IPyroGeomSrc.class);
            this.d_dataIx = n;
        }

        public void setIndex(int n) {
            this.d_dataIx = n;
        }

        protected abstract double[] saveData(T var1);

        protected abstract T constructGeom(T var1, double[] var2);

        @Override
        public Object get(IPyroGeomSrc iPyroGeomSrc) {
            IGeomNode iGeomNode = iPyroGeomSrc.getGeom();
            double[] dArray = this.saveData(iGeomNode.getLocalGeom());
            return dArray[this.d_dataIx];
        }

        @Override
        public void set(IPyroGeomSrc iPyroGeomSrc, Double d) {
            IGeomNode iGeomNode = iPyroGeomSrc.getGeom();
            double[] dArray = this.saveData(iGeomNode.getLocalGeom());
            dArray[this.d_dataIx] = d;
            IGeom iGeom = this.constructGeom(iGeomNode.getLocalGeom(), dArray);
            iPyroGeomSrc.setGeom(iGeomNode.applyLocalGeom(iGeom));
        }
    }

    private static interface IEditorSupplier
    extends Function<Collection<? extends IPyroGeomSrc>, IGeomEditor<? extends IGeom>> {
    }
}

