/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.GridBagLayout;
import java.util.Collection;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import pyrosim.Intl;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.devices.FreePointGeom;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.geom.Geometry;
import pyrosim.gui.geom.GeomGuiUtil;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.gui.geom.Point3DPanel;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.objs.Point;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.PropertyUtil;

public class FreePointGeomEditor
extends guiPanel
implements IGeomEditor<FreePointGeom> {
    private static final long serialVersionUID = 7556093351826105101L;
    private Point3DPanel d_locPanel;
    private ValueField<UnitDouble> d_rotation;
    private ValueField<Double> d_xOrien;
    private ValueField<Double> d_yOrien;
    private ValueField<Double> d_zOrien;

    public FreePointGeomEditor() {
        this.setLayout(new GridBagLayout());
        int n = 0;
        guiLabel guiLabel2 = new guiLabel(Intl.intl("Orientation"));
        guiLabel guiLabel3 = new guiLabel(Intl.intl("Rotation") + ":");
        this.d_rotation = ValueFields.udFld(UnitSystem.getSource(29));
        this.d_locPanel = new Point3DPanel(Intl.intl("Location"));
        guiLabel guiLabel4 = new guiLabel(Intl.intl("X:"));
        guiLabel guiLabel5 = new guiLabel(Intl.intl("Y:"));
        guiLabel guiLabel6 = new guiLabel(Intl.intl("Z:"));
        this.d_xOrien = ValueFields.doubleFld();
        this.d_yOrien = ValueFields.doubleFld();
        this.d_zOrien = ValueFields.doubleFld();
        this.d_locPanel.addToPanel(this, 0, n++);
        GridBagUtil.add(this, guiLabel2, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, guiLabel4, 1, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_xOrien, 2, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, guiLabel5, 3, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_yOrien, 4, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, guiLabel6, 5, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_zOrien, 6, n++, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, guiLabel3, 0, n, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_rotation, 2, n, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
        this.load(new FreePointLoc());
    }

    @Override
    public boolean validateData(Collection<? extends IPyroGeomSrc> collection, boolean bl, boolean bl2) {
        return true;
    }

    @Override
    public guiPanel getPanel() {
        return this;
    }

    @Override
    public String getGeomName() {
        return Intl.intl("Location");
    }

    @Override
    public int getNumFaces() {
        return 0;
    }

    @Override
    public String[] getFaceNames() {
        return null;
    }

    @Override
    public int[] getFaceOrder(IGeomNode iGeomNode) {
        return null;
    }

    @Override
    public void load(Collection<? extends IPyroGeomSrc> collection) {
        UnitDouble[] unitDoubleArray = GeomGuiUtil.getDataVals(collection, new LocProp(), 3, Geometry.LU);
        Double[] doubleArray = GeomGuiUtil.getDoubleDataVals(collection, new OrientProp(), 3);
        Object object = PropertyUtil.getProperty(new RotProp(), collection);
        if (!(object instanceof UnitDouble)) {
            object = null;
        }
        this.d_locPanel.setX(unitDoubleArray[0]);
        this.d_locPanel.setY(unitDoubleArray[1]);
        this.d_locPanel.setZ(unitDoubleArray[2]);
        this.d_xOrien.setValue(doubleArray[0]);
        this.d_yOrien.setValue(doubleArray[1]);
        this.d_zOrien.setValue(doubleArray[2]);
        this.d_rotation.setValue((UnitDouble)object);
    }

    @Override
    public void save(Collection<? extends IPyroGeomSrc> collection) {
        UnitDouble[] unitDoubleArray = new UnitDouble[]{this.d_locPanel.x(), this.d_locPanel.y(), this.d_locPanel.z()};
        Double[] doubleArray = new Double[]{(Double)this.d_xOrien.getValue(), (Double)this.d_yOrien.getValue(), (Double)this.d_zOrien.getValue()};
        UnitDouble unitDouble = (UnitDouble)this.d_rotation.getValue();
        GeomGuiUtil.setDataVals(collection, new LocProp(), Geometry.LU, unitDoubleArray);
        GeomGuiUtil.setDoubleDataVals(collection, new OrientProp(), doubleArray);
        PropertyUtil.setProperty(new RotProp(), unitDouble, collection);
    }

    public void load(FreePointLoc freePointLoc) {
        assert (freePointLoc.d_geom instanceof Point);
        this.d_locPanel.load(new UnitPoint3D(((Point)freePointLoc.d_geom).loc, Geometry.LU));
        this.d_xOrien.setValue(freePointLoc.d_orientation.x);
        this.d_yOrien.setValue(freePointLoc.d_orientation.y);
        this.d_zOrien.setValue(freePointLoc.d_orientation.z);
        this.d_rotation.setValue(freePointLoc.d_rotation);
    }

    public FreePointLoc getFreePointLoc() {
        UnitPoint3D unitPoint3D = this.d_locPanel.save();
        Vector3d vector3d = new Vector3d((Double)this.d_xOrien.getValue(), (Double)this.d_yOrien.getValue(), (Double)this.d_zOrien.getValue());
        return new FreePointLoc(new Point(unitPoint3D.getPoint3dValue(Geometry.LU)), vector3d, (UnitDouble)this.d_rotation.getValue());
    }

    private static class RotProp
    extends PropertyUtil.AProp<IPyroGeomSrc, UnitDouble> {
        public RotProp() {
            super(IPyroGeomSrc.class);
        }

        @Override
        public Object get(IPyroGeomSrc iPyroGeomSrc) {
            return ((FreePointGeom)iPyroGeomSrc.getGeom().getLocalGeom()).loc.d_rotation;
        }

        @Override
        public void set(IPyroGeomSrc iPyroGeomSrc, UnitDouble unitDouble) {
            FreePointGeom freePointGeom = (FreePointGeom)iPyroGeomSrc.getGeom().getLocalGeom();
            FreePointLoc freePointLoc = new FreePointLoc(freePointGeom.loc.d_geom, freePointGeom.loc.d_orientation, unitDouble);
            iPyroGeomSrc.setGeom(GeomNodeUtil.newNode(new FreePointGeom(freePointLoc)));
        }
    }

    private static class OrientProp
    extends GeomGuiUtil.AGeomProp<FreePointGeom> {
        private OrientProp() {
        }

        @Override
        protected FreePointGeom constructGeom(FreePointGeom freePointGeom, double[] dArray) {
            FreePointLoc freePointLoc = new FreePointLoc(freePointGeom.loc.d_geom, new Vector3d(dArray[0], dArray[1], dArray[2]), freePointGeom.loc.d_rotation);
            return new FreePointGeom(freePointLoc);
        }

        @Override
        protected double[] saveData(FreePointGeom freePointGeom) {
            FreePointLoc freePointLoc = freePointGeom.loc;
            double[] dArray = new double[3];
            freePointLoc.d_orientation.get(dArray);
            return dArray;
        }
    }

    private static class LocProp
    extends GeomGuiUtil.AGeomProp<FreePointGeom> {
        private LocProp() {
        }

        @Override
        protected FreePointGeom constructGeom(FreePointGeom freePointGeom, double[] dArray) {
            FreePointLoc freePointLoc = new FreePointLoc(new Point(new Point3d(dArray[0], dArray[1], dArray[2])), freePointGeom.loc.d_orientation, freePointGeom.loc.d_rotation);
            return new FreePointGeom(freePointLoc);
        }

        @Override
        protected double[] saveData(FreePointGeom freePointGeom) {
            FreePointLoc freePointLoc = freePointGeom.loc;
            assert (freePointLoc.d_geom instanceof Point);
            Point3d point3d = ((Point)freePointGeom.loc.d_geom).loc;
            return new double[]{point3d.x, point3d.y, point3d.z};
        }
    }
}

