/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.GridBagLayout;
import java.util.Collection;
import javax.swing.AbstractButton;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.geom.Geometry;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.gui.geom.Point3DPanel;
import pyrosim.gui.geom.PolygonEditor;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.Util3D;
import thunderheadeng.geometry.objs.ExtrudedPoly;
import thunderheadeng.geometry.objs.IPolygon;
import thunderheadeng.geometry.objs.PolyUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.PropertyUtil;

public class ExtrudedPolyEditor
extends guiPanel
implements IGeomEditor<ExtrudedPoly> {
    private static final long serialVersionUID = 8020246006014903489L;
    private final NormalPanel d_normalPnl;
    private final PolygonEditor d_polyEditor;
    private final PropertyUtil.IProp<IPyroGeomSrc, Vector3d> extrusionProp = new PropertyUtil.AProp<IPyroGeomSrc, Vector3d>(IPyroGeomSrc.class){

        @Override
        public Object get(IPyroGeomSrc iPyroGeomSrc) {
            return ((ExtrudedPoly)iPyroGeomSrc.getGeom().getLocalGeom()).extrusion;
        }

        @Override
        public void set(IPyroGeomSrc iPyroGeomSrc, Vector3d vector3d) {
            ExtrudedPoly extrudedPoly = (ExtrudedPoly)iPyroGeomSrc.getGeom().getLocalGeom();
            iPyroGeomSrc.setGeom(iPyroGeomSrc.getGeom().applyLocalGeom(new ExtrudedPoly(extrudedPoly.poly, vector3d)));
        }
    };
    private final PropertyUtil.IProp<IPyroGeomSrc, IPolygon> polyExtractorProp = new PropertyUtil.AProp<IPyroGeomSrc, IPolygon>(IPyroGeomSrc.class){

        @Override
        public Object get(IPyroGeomSrc iPyroGeomSrc) {
            return ((ExtrudedPoly)iPyroGeomSrc.getGeom().getLocalGeom()).poly;
        }

        @Override
        public void set(IPyroGeomSrc iPyroGeomSrc, IPolygon iPolygon) {
            ExtrudedPoly extrudedPoly = (ExtrudedPoly)iPyroGeomSrc.getGeom().getLocalGeom();
            iPyroGeomSrc.setGeom(iPyroGeomSrc.getGeom().applyLocalGeom(new ExtrudedPoly(iPolygon, extrudedPoly.extrusion)));
        }

        @Override
        public boolean equal(IPolygon iPolygon, IPolygon iPolygon2) {
            return PolyUtil.polysEqual(iPolygon, iPolygon2);
        }
    };

    public ExtrudedPolyEditor() {
        super(new GridBagLayout());
        this.d_normalPnl = new NormalPanel();
        this.d_polyEditor = new PolygonEditor();
        TitleSeparator titleSeparator = new TitleSeparator(Intl.intl("Base Polygon"));
        int n = 0;
        GridBagUtil.add(this, this.d_normalPnl, 0, n, 1, 1, 0, 0, 0, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, titleSeparator, 0, ++n, 1, 1, 6, 0, 0, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, this.d_polyEditor, 0, ++n, 1, 1, 6, 12, 0, 0, 1, 1.0, 1.0, 17);
    }

    @Override
    public String[] getFaceNames() {
        int n = this.getNumFaces();
        if (n < 1) {
            return new String[0];
        }
        assert (n >= 2);
        String[] stringArray = new String[this.getNumFaces()];
        stringArray[0] = String.format(Intl.intl("Face %d"), 1);
        stringArray[1] = String.format(Intl.intl("Face %d"), 2);
        for (int i = 2; i < stringArray.length; ++i) {
            stringArray[i] = String.format(Intl.intl("Side %d"), i - 1);
        }
        return stringArray;
    }

    @Override
    public int getNumFaces() {
        int n = this.d_polyEditor.getNumSides();
        if (n == 0) {
            return -1;
        }
        return n + 2;
    }

    @Override
    public int[] getFaceOrder(IGeomNode iGeomNode) {
        return null;
    }

    @Override
    public String getGeomName() {
        return Intl.intl("Slab");
    }

    @Override
    public guiPanel getPanel() {
        return this;
    }

    @Override
    public void load(Collection<? extends IPyroGeomSrc> collection) {
        Object object;
        Object object2 = PropertyUtil.getProperty(this.polyExtractorProp, collection);
        if (!(object2 instanceof IPolygon)) {
            object2 = null;
        }
        if (!((object = PropertyUtil.getProperty(this.extrusionProp, collection)) instanceof Vector3d)) {
            object = null;
        }
        this.d_normalPnl.load((IPolygon)object2, (Vector3d)object);
        this.d_polyEditor.load((IPolygon)object2);
    }

    @Override
    public void save(Collection<? extends IPyroGeomSrc> collection) {
        IPolygon iPolygon = this.d_polyEditor.save();
        if (iPolygon == null) {
            for (IPyroGeomSrc iPyroGeomSrc : collection) {
                iPolygon = ((ExtrudedPoly)iPyroGeomSrc.getGeom().getLocalGeom()).poly;
                Vector3d vector3d = this.d_normalPnl.save(iPolygon);
                if (vector3d == null) continue;
                PropertyUtil.setProperty(this.extrusionProp, vector3d, collection);
            }
        } else {
            Vector3d vector3d = this.d_normalPnl.save(iPolygon);
            if (iPolygon != null) {
                PropertyUtil.setProperty(this.polyExtractorProp, iPolygon, collection);
            }
            if (vector3d != null) {
                PropertyUtil.setProperty(this.extrusionProp, vector3d, collection);
            }
        }
    }

    @Override
    public boolean validateData(Collection<? extends IPyroGeomSrc> collection, boolean bl, boolean bl2) {
        return this.d_polyEditor.validateData(collection, bl, bl2);
    }

    private static class NormalPanel
    extends guiPanel {
        private static final long serialVersionUID = -3707401587607321934L;
        private final guiRadioButton d_normalRB = new guiRadioButton(Intl.intl("Normal to Polygon"));
        private final ValueField<UnitDouble> d_distFld;
        private final guiRadioButton d_dirRB = new guiRadioButton(Intl.intl("Custom Direction") + ":");
        private final Point3DPanel d_dirPnl;

        public NormalPanel() {
            super(new GridBagLayout());
            new guiButtonGroup(this.d_normalRB, this.d_dirRB);
            this.d_distFld = ValueFields.udFld(0.2, (Unit)SI.METER, UnitSystem.getSource(0));
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Distance"));
            this.d_dirPnl = new Point3DPanel(null, true);
            LinkStatus.link((AbstractButton)this.d_normalRB, guiLabel2, this.d_distFld);
            LinkStatus.link((AbstractButton)this.d_dirRB, this.d_dirPnl);
            TitleSeparator titleSeparator = new TitleSeparator(Intl.intl("Extrusion Path"));
            int n = 0;
            GridBagUtil.add(this, titleSeparator, 0, n, 10, 1, 0, 0, 0, 0, 2, 1.0, 0.0, 17);
            GridBagUtil.add(this, this.d_normalRB, 0, ++n, 1, 1, 6, 12, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel2, 1, n, 1, 1, 6, 6, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_distFld, 2, n, 1, 1, 6, 6, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_dirRB, 0, ++n, 1, 1, 6, 12, 0, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_dirPnl, 1, n, 5, 1, 6, 6, 0, 0, 0, 0.0, 0.0, 17);
        }

        public void load(IPolygon iPolygon, Vector3d vector3d) {
            if (vector3d == null || iPolygon == null) {
                this.d_normalRB.setSelected(false);
                this.d_dirRB.setSelected(false);
                return;
            }
            Vector3d vector3d2 = iPolygon.getNormal(true);
            Vector3d vector3d3 = Util3D.normalize(vector3d);
            if (vector3d3.epsilonEquals(vector3d2, 1.0E-6) || Util3D.negate(vector3d3).epsilonEquals(vector3d2, 1.0E-6)) {
                this.d_normalRB.setSelected(true);
                double d = vector3d.length();
                if (!vector3d3.epsilonEquals(vector3d2, 1.0E-6)) {
                    d = -d;
                }
                this.d_distFld.setValue(UnitDouble.from(d, Geometry.LU, PyroSim.getApp().getUnitSystem().getLengthUnit()));
            } else {
                this.d_dirRB.setSelected(true);
                this.d_dirPnl.load(new UnitPoint3D(vector3d, Geometry.LU));
            }
        }

        public Vector3d save(IPolygon iPolygon) {
            if (!this.d_normalRB.isSelected() && !this.d_dirRB.isSelected()) {
                return null;
            }
            if (this.d_dirRB.isSelected()) {
                return this.d_dirPnl.save().getVector3dValue(Geometry.LU);
            }
            if (iPolygon == null) {
                return null;
            }
            Vector3d vector3d = new Vector3d(iPolygon.getNormal(true));
            vector3d.scale(((UnitDouble)this.d_distFld.getValue()).getValue(Geometry.LU));
            return vector3d;
        }
    }
}

