/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.Composite;
import pyrosim.domain.Grid;
import pyrosim.domain.geom.EvacProps;
import pyrosim.domain.geom.FDSObject;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;

public class EvacPanel
extends guiPanel {
    private static final long serialVersionUID = 2541253062723710927L;
    private static final List<Integer> evacuationOpts = Arrays.asList(0, 2, 1);
    private static final Object MULTIPLE = new Object();
    private guiComboBox d_cbEvacuation;
    private guiComboBox d_cbMeshId;
    public static final Composite.IObjectProp evacPropEvacuation = new Composite.AObjectProp<FDSObject, Integer>(FDSObject.class){

        @Override
        public void set(FDSObject fDSObject, Integer n) {
            throw new UnsupportedOperationException(Intl.intl("Use the direct setter to avoid cluttering the EvacProps pool."));
        }

        public Integer get(FDSObject fDSObject) {
            return fDSObject.getEvac().evacuation;
        }
    };
    public static final Composite.IObjectProp evacPropMeshId = new Composite.AObjectProp<FDSObject, Grid>(FDSObject.class){

        @Override
        public void set(FDSObject fDSObject, Grid grid) {
            throw new UnsupportedOperationException(Intl.intl("Use the direct setter to avoid cluttering the EvacProps pool."));
        }

        public Grid get(FDSObject fDSObject) {
            return fDSObject.getEvac().mesh;
        }
    };

    public EvacPanel() {
        guiLabel guiLabel2 = new guiLabel(Intl.intl("Use In:"));
        guiLabel2.setToolTipText("EVACUATION");
        this.d_cbEvacuation = new guiComboBox();
        this.d_cbEvacuation.setRenderer(new CbRendererEvacuation());
        guiLabel guiLabel3 = new guiLabel("Mesh:");
        guiLabel3.setToolTipText("MESH_ID");
        this.d_cbMeshId = new guiComboBox();
        this.d_cbMeshId.setRenderer(new CbRendererMeshId());
        this.setLayout(new GridBagLayout());
        int n = 0;
        GridBagUtil.add(this, guiLabel2, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_cbEvacuation, 1, n, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, guiLabel3, 0, ++n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_cbMeshId, 1, n, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.addGlue(this);
    }

    public void load(PyroMod pyroMod, Collection<? extends FDSObject> collection) {
        Vector<Integer> vector = new Vector<Integer>(evacuationOpts);
        Vector vector2 = new Vector(pyroMod.getGridManager().flatten());
        vector2.add(0, null);
        Object object = Composite.getProperty(evacPropEvacuation, collection);
        Object object2 = Composite.getProperty(evacPropMeshId, collection);
        this.cbInit(this.d_cbEvacuation, vector, object);
        this.cbInit(this.d_cbMeshId, vector2, object2);
    }

    private void cbInit(guiComboBox guiComboBox2, Vector vector, Object object) {
        if (object == Composite.NON_UNIFORM) {
            vector.add(0, MULTIPLE);
            object = MULTIPLE;
        }
        guiComboBox2.setModel(new DefaultComboBoxModel(vector));
        guiComboBox2.setSelectedItem(object);
    }

    public void save(PyroMod pyroMod, Collection<? extends FDSObject> collection) {
        Object t = this.d_cbEvacuation.getSelectedItem();
        Object t2 = this.d_cbMeshId.getSelectedItem();
        if (t != MULTIPLE || t2 != MULTIPLE) {
            if (t != MULTIPLE && t2 != MULTIPLE) {
                EvacProps evacProps = EvacProps.get((Integer)t, (Grid)t2);
                Composite.setProperty(FDSObject.evacProp, evacProps, collection);
            } else {
                for (FDSObject fDSObject : collection) {
                    Integer n = t == MULTIPLE ? Integer.valueOf(fDSObject.getEvac().evacuation) : (Integer)t;
                    Grid grid = t2 == MULTIPLE ? fDSObject.getEvac().mesh : (Grid)t2;
                    EvacProps evacProps = EvacProps.get(n, grid);
                    fDSObject.setEvac(evacProps);
                }
            }
        }
    }

    private class CbRendererEvacuation
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 5860300054815079712L;

        private CbRendererEvacuation() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object == MULTIPLE) {
                this.setText(Intl.intl("<multiple>"));
            } else {
                switch (Integer.valueOf((Integer)object)) {
                    case 0: {
                        this.setText(Intl.intl("Default"));
                        break;
                    }
                    case 2: {
                        this.setText(Intl.intl("Evac Only"));
                        break;
                    }
                    case 1: {
                        this.setText(Intl.intl("Fire Only"));
                    }
                }
            }
            return this;
        }
    }

    private class CbRendererMeshId
    extends DefaultListCellRenderer {
        private static final long serialVersionUID = 8666832609776817309L;

        private CbRendererMeshId() {
        }

        @Override
        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            if (object == MULTIPLE) {
                this.setText(Intl.intl("<multiple>"));
            } else if (object != null) {
                this.setText(((Grid)object).getName());
            } else {
                this.setText(Intl.intl("Default"));
            }
            return this;
        }
    }
}

