/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.Composite;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.Property;
import pyrosim.domain.TimeBasedValue;
import pyrosim.domain.TimeFunction;
import pyrosim.domain.controls.ControlBridge;
import pyrosim.domain.hvac.HvacAircoil;
import pyrosim.domain.hvac.HvacComponent;
import pyrosim.domain.hvac.HvacDuct;
import pyrosim.domain.hvac.HvacDuctLoss;
import pyrosim.domain.hvac.HvacFan;
import pyrosim.domain.hvac.HvacNode;
import pyrosim.domain.hvac.HvacUtil;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.TimeFunctionEditor;
import pyrosim.gui.comboboxes.PyroComboBox;
import pyrosim.gui.controls.ControlSelPnl;
import pyrosim.gui.geom.ModelObjectDialog;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiButtonGroup;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitDoubleVR;
import thunderheadeng.util.Pair;

public class DuctEditor
implements ModelObjectDialog.IEditor<HvacDuct> {
    private final PyroMod d_domain;
    private final guiTextField d_nameFld;
    private final guiTextField d_fyi;
    private final ValueField<UnitDouble> d_areaFld;
    private final ValueField<UnitDouble> d_perimeterFld;
    private final ValueField<UnitDouble> d_diaFld;
    private final guiRadioButton d_autoLenRB;
    private final guiRadioButton d_fixedLenRB;
    private final ValueField<UnitDouble> d_lengthFld;
    private final guiRadioButton d_circularBtn;
    private final guiRadioButton d_nonCircularBtn;
    private final guiComboBox<HvacNode> d_fromNodeCB;
    private final guiComboBox<HvacNode> d_toNodeCB;
    private final guiLabel d_flare1;
    private final guiLabel d_flare2;
    private final guiPanel d_flowPnl;
    private final ValueField<UnitDouble> d_forwardLossFld;
    private final ValueField<UnitDouble> d_reverseLossFld;
    private final guiComboBox<HvacDuct.FrictionType> d_roughnessTypeCB;
    private final ValueField<UnitDouble> d_roughFld;
    private final guiComboBox<IFlowDevcEditor> d_flowDevcEditorCB;
    private guiPanel d_dlgPanel;
    private Collection<? extends HvacDuct> d_ducts = Collections.EMPTY_LIST;
    private static final Composite.IObjectProp<HvacDuct, UnitDouble> volflowProp = new Composite.AObjectProp<HvacDuct, UnitDouble>(HvacDuct.class){

        @Override
        public Object get(HvacDuct hvacDuct) {
            return ((UnitDouble)hvacDuct.getVolflow().val).abs();
        }

        @Override
        public void set(HvacDuct hvacDuct, UnitDouble unitDouble) {
            hvacDuct.setVolflow(new TimeBasedValue<UnitDouble>(unitDouble, hvacDuct.getVolflow().func));
        }
    };
    private static final Composite.IObjectProp<HvacDuct, TimeFunction> volflowRampProp = new Composite.AObjectProp<HvacDuct, TimeFunction>(HvacDuct.class){

        @Override
        public Object get(HvacDuct hvacDuct) {
            return hvacDuct.getVolflow().func;
        }

        @Override
        public void set(HvacDuct hvacDuct, TimeFunction timeFunction) {
            hvacDuct.setVolflow(new TimeBasedValue<UnitDouble>((UnitDouble)hvacDuct.getVolflow().val, timeFunction));
        }
    };
    private static final StandardProp<String> fyiProp = new StandardProp<String>(HvacComponent::getDesc, HvacComponent::setDesc);
    private static final GenericProp<UnitDouble> lossProp = new GenericProp("LOSS");
    private static final GenericProp<UnitDouble> lengthProp = new GenericProp("LENGTH");
    private static final GenericProp<HvacDuct.Shape> shapeProp = new GenericProp("opt_shape");
    private static final GenericProp<UnitDouble> areaProp = new GenericProp("AREA");
    private static final GenericProp<UnitDouble> diamProp = new GenericProp("DIAMETER");
    private static final GenericProp<UnitDouble> perimProp = new GenericProp("PERIMETER");
    private static final GenericProp<UnitDouble> roughnessProp = new GenericProp("ROUGHNESS");
    private static final GenericProp<HvacDuct.FrictionType> roughTypeProp = new GenericProp("opt_friction_type");
    private static final GenericProp<HvacDuct.AirflowObj> airflowProp = new GenericProp("opt_none_damper_fan");
    private static final ReverseVolFlowProp revVolFlowProp = new ReverseVolFlowProp();
    private static final GenericProp<Boolean> revProp = new GenericProp("REVERSE");
    private static GenericProp<HvacAircoil> aircoilProp = new GenericProp("AIRCOIL_ID");
    private static final GenericProp<HvacFan> fanProp = new GenericProp("FAN_ID");
    private static final Composite.IObjectProp<HvacDuct, ControlBridge> ctrlProp = ControlSelPnl.getControlProp(HvacDuct.class);

    public DuctEditor(PyroMod pyroMod, guiTextField guiTextField2) {
        this.d_dlgPanel = new guiPanel(){
            private static final long serialVersionUID = 9115036219863490523L;

            @Override
            public boolean validateData(boolean bl, boolean bl2) {
                if (!super.validateData(bl, bl2)) {
                    return false;
                }
                return DuctEditor.this.validateData(DuctEditor.this.d_dlgPanel, bl, bl2);
            }
        };
        this.d_domain = pyroMod;
        this.d_nameFld = guiTextField2;
        this.d_fyi = new guiTextField();
        this.d_fyi.setToolTipText(Intl.intl("FYI"));
        this.d_roughnessTypeCB = new guiComboBox<HvacDuct.FrictionType>(HvacDuct.FrictionType.values());
        this.d_roughnessTypeCB.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 1L;

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object instanceof HvacDuct.FrictionType) {
                    this.setText(((HvacDuct.FrictionType)((Object)object)).displayName);
                }
                return this;
            }
        });
        this.d_roughFld = ValueFields.udFld(UnitSystem.getSource(0));
        this.d_roughFld.setNullAllowed(true);
        this.d_roughnessTypeCB.addItemListener(itemEvent -> {
            HvacDuct.FrictionType frictionType = this.d_roughnessTypeCB.getSelectedItem();
            boolean bl = frictionType != null && frictionType.equals((Object)HvacDuct.FrictionType.EXPLICIT);
            this.d_roughFld.setEnabled(bl);
            this.d_roughFld.setVisible(bl);
            if (this.d_roughFld.getParent() != null) {
                this.d_roughFld.getParent().validate();
            }
        });
        this.d_roughnessTypeCB.setSelectedItem((Object)HvacDuct.FrictionType.EXPLICIT);
        this.d_circularBtn = new guiRadioButton(Intl.intl("Circular"));
        this.d_nonCircularBtn = new guiRadioButton(Intl.intl("Non-circular"));
        new guiButtonGroup(this.d_circularBtn, this.d_nonCircularBtn);
        guiLabel guiLabel2 = new guiLabel(Intl.intl("Area:"));
        this.d_areaFld = ValueFields.udFld(UnitSystem.getSource(79));
        guiLabel guiLabel3 = new guiLabel(Intl.intl("Diameter:"));
        this.d_diaFld = ValueFields.udFld(UnitSystem.getSource(0));
        guiLabel guiLabel4 = new guiLabel(Intl.intl("Perimeter:"));
        this.d_perimeterFld = ValueFields.udFld(UnitSystem.getSource(0));
        LinkStatus.link((AbstractButton)this.d_nonCircularBtn, guiLabel2, this.d_areaFld, guiLabel4, this.d_perimeterFld);
        LinkStatus.link((AbstractButton)this.d_circularBtn, guiLabel3, this.d_diaFld);
        Stream.of(this.d_areaFld, this.d_diaFld, this.d_perimeterFld).forEach(valueField -> valueField.setNullAllowed(true));
        this.d_autoLenRB = new guiRadioButton(Intl.intl("Automatic"));
        this.d_autoLenRB.setToolTipText(Intl.intl("Length is calculated as the distance between the connected nodes."));
        this.d_fixedLenRB = new guiRadioButton(Intl.intl("Fixed:"));
        this.d_lengthFld = ValueFields.udFld(UnitSystem.getSource(0));
        this.d_lengthFld.setNullAllowed(true);
        LinkStatus.link((AbstractButton)this.d_fixedLenRB, this.d_lengthFld);
        new guiButtonGroup(this.d_autoLenRB, this.d_fixedLenRB);
        this.d_fromNodeCB = new PyroComboBox<HvacNode>(pyroMod.getObstructions(), HvacNode.class);
        this.d_flare1 = new guiLabel(PyroGuiUtil.loadPyroSimIcon("bad.png"));
        this.d_flare1.setToolTipText(Intl.intl("Node must be unique."));
        this.d_toNodeCB = new PyroComboBox<HvacNode>(pyroMod.getObstructions(), HvacNode.class);
        this.d_flare2 = new guiLabel(PyroGuiUtil.loadPyroSimIcon("bad.png"));
        this.d_flare2.setToolTipText(Intl.intl("Node must be unique."));
        ItemListener itemListener = itemEvent -> this.updateValidationFlares();
        this.d_fromNodeCB.addItemListener(itemListener);
        this.d_toNodeCB.addItemListener(itemListener);
        ItemListener itemListener2 = itemEvent -> {
            if (itemEvent.getStateChange() != 1) {
                return;
            }
            if (!this.d_dlgPanel.validateData(false, false)) {
                return;
            }
            this.updateAutoLbl();
        };
        this.d_fromNodeCB.addItemListener(itemListener2);
        this.d_toNodeCB.addItemListener(itemListener2);
        this.d_forwardLossFld = ValueFields.udFld(UnitSystem.getSource(28));
        this.d_reverseLossFld = ValueFields.udFld(UnitSystem.getSource(28));
        Stream.of(this.d_forwardLossFld, this.d_reverseLossFld).forEach(valueField -> valueField.setNullAllowed(true));
        final CardLayout cardLayout = new CardLayout();
        List<guiPanel> list = Arrays.asList(new NoDevcPnl(), new DamperPnl(pyroMod), new BasicFanPnl(pyroMod), new AircoilPnl(pyroMod), new FanPnl(pyroMod));
        final guiPanel guiPanel2 = new guiPanel(cardLayout);
        for (IFlowDevcEditor object2 : list) {
            guiPanel2.add((Component)object2.getPanel(), object2.toString());
        }
        this.d_flowDevcEditorCB = new guiComboBox();
        this.d_flowDevcEditorCB.setModel(new DefaultComboBoxModel(new Vector<guiPanel>(list)){
            private static final long serialVersionUID = -3777719222507922189L;

            @Override
            public void setSelectedItem(Object object) {
                IFlowDevcEditor iFlowDevcEditor;
                if (object instanceof IFlowDevcEditor && !(iFlowDevcEditor = (IFlowDevcEditor)object).getPanel().isEnabled()) {
                    return;
                }
                super.setSelectedItem(object);
            }
        });
        this.d_flowDevcEditorCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() != 1) {
                    return;
                }
                IFlowDevcEditor iFlowDevcEditor = (IFlowDevcEditor)itemEvent.getItem();
                cardLayout.show(guiPanel2, iFlowDevcEditor.toString());
            }
        });
        this.d_flowDevcEditorCB.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 3922086684266902999L;

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                IFlowDevcEditor iFlowDevcEditor = (IFlowDevcEditor)object;
                if (iFlowDevcEditor != null) {
                    this.setEnabled(iFlowDevcEditor.getPanel().isEnabled());
                }
                return this;
            }
        });
        GridBagHelper gridBagHelper = new GridBagHelper(this.d_dlgPanel, false);
        gridBagHelper.addFilledRow(new TitleSeparator(Intl.intl("Length")));
        gridBagHelper.addIdentRow(this.d_autoLenRB, 0);
        gridBagHelper.addIdentRow(this.d_fixedLenRB, this.d_lengthFld, 0);
        gridBagHelper.addFilledRow(new TitleSeparator(Intl.intl("Shape")));
        gridBagHelper.indent();
        gridBagHelper.addRow(this.d_circularBtn, 0);
        gridBagHelper.addIdentRow(guiLabel3, this.d_diaFld, 0);
        gridBagHelper.addRow(this.d_nonCircularBtn, 0);
        gridBagHelper.addIdentRow(guiLabel2, this.d_areaFld, 0);
        gridBagHelper.addIdentRow(guiLabel4, this.d_perimeterFld, 0);
        gridBagHelper.finalizeRows();
        guiLabel guiLabel5 = PyroGuiUtil.label(Intl.intl("Foward Loss:"), Intl.intl("The flow loss from Node 1 to Node 2."));
        guiLabel guiLabel6 = PyroGuiUtil.label(Intl.intl("Reverse Loss:"), Intl.intl("The flow loss from Node 2 to Node 1."));
        this.d_flowPnl = new guiPanel();
        GridBagHelper gridBagHelper2 = new GridBagHelper(this.d_flowPnl, true);
        gridBagHelper2.addRow(guiLabel5, this.d_forwardLossFld, 0);
        gridBagHelper2.addRow(guiLabel6, this.d_reverseLossFld, 0);
        gridBagHelper2.addRow(Intl.intl("Roughness:"), this.d_roughnessTypeCB, this.d_roughFld, 0);
        gridBagHelper2.addRow(Intl.intl("Flow Device:"), this.d_flowDevcEditorCB, 0);
        gridBagHelper2.addIdentRow(guiPanel2, new int[]{0, 0}, new double[]{1.0, 1.0});
        gridBagHelper2.finalizeRows();
    }

    @Override
    public boolean validateData(Component component, boolean bl, boolean bl2) {
        return true;
    }

    private void updateAutoLbl() {
        HvacNode hvacNode = this.d_fromNodeCB.getSelectedItem();
        HvacNode hvacNode2 = this.d_toNodeCB.getSelectedItem();
        if (hvacNode != null && hvacNode2 != null) {
            UnitDouble unitDouble = HvacDuct.getDistance(hvacNode, hvacNode2);
            String string = String.format(Intl.intl("Automatic (%s)"), PyroGuiUtil.format(unitDouble, 0));
            this.d_autoLenRB.setText(string);
        } else {
            this.d_autoLenRB.setText(Intl.intl("Automatic"));
        }
    }

    @Override
    public void add(ModelObjectDialog modelObjectDialog, GridBagHelper gridBagHelper) {
        gridBagHelper.addRow(Intl.intl("FYI:"), this.d_fyi, 1.0, 0);
        gridBagHelper.addRow(Intl.intl("Node 1:"), this.d_fromNodeCB, this.d_flare1);
        gridBagHelper.addRow(Intl.intl("Node 2:"), this.d_toNodeCB, this.d_flare2);
        gridBagHelper.addFilledRow(this.d_dlgPanel);
    }

    @Override
    public String getDialogTitle() {
        return Intl.intl("HVAC Duct Properties");
    }

    @Override
    public Class<HvacDuct> getType() {
        return HvacDuct.class;
    }

    @Override
    public List<Pair<String, guiPanel>> getExtraTabs() {
        return Arrays.asList(new Pair<String, guiPanel>(Intl.intl("Flow Model"), this.d_flowPnl));
    }

    @Override
    public boolean isControllable(HvacDuct hvacDuct) {
        return true;
    }

    private void updateValidationFlares() {
        boolean bl;
        boolean bl2 = bl = this.d_fromNodeCB.getSelectedItem() != null && this.d_fromNodeCB.getSelectedItem() == this.d_toNodeCB.getSelectedItem();
        if (this.d_ducts.size() == 1) {
            this.d_flare1.setVisible(this.d_fromNodeCB.getSelectedItem() == null || bl);
            this.d_flare2.setVisible(this.d_toNodeCB.getSelectedItem() == null || bl);
        } else {
            this.d_flare1.setVisible(bl);
            this.d_flare2.setVisible(bl);
        }
    }

    private static guiComboBox<Boolean> newDirCB() {
        guiComboBox<Boolean> guiComboBox2 = new guiComboBox<Boolean>((T[])new Boolean[]{false, true});
        DefaultListCellRenderer defaultListCellRenderer = new DefaultListCellRenderer(){
            private static final long serialVersionUID = -8808010086343633670L;

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object != null) {
                    Boolean bl3 = (Boolean)object;
                    String string = bl3 != false ? Intl.intl("Node 2 to Node 1") : Intl.intl("Node 1 to Node 2");
                    this.setText(string);
                }
                return this;
            }
        };
        guiComboBox2.setRenderer(defaultListCellRenderer);
        return guiComboBox2;
    }

    @Override
    public void load(PyroMod pyroMod, Collection<? extends HvacDuct> collection) {
        IFlowDevcEditor iFlowDevcEditor;
        int n;
        Property property;
        Composite.IObjectProp[] iObjectPropArray;
        Property<HvacNode> property2;
        Object object;
        for (int i = 0; i < this.d_flowDevcEditorCB.getItemCount(); ++i) {
            object = this.d_flowDevcEditorCB.getItemAt(i);
            object.updateEnabled(this.d_domain);
        }
        IFlowDevcEditor iFlowDevcEditor2 = this.d_flowDevcEditorCB.getSelectedItem();
        if (iFlowDevcEditor2 != null && !iFlowDevcEditor2.getPanel().isEnabled()) {
            this.d_flowDevcEditorCB.setSelectedIndex(0);
        }
        object = Composite.getProp(fyiProp, collection);
        this.d_fyi.setText(((Property)object).orElse(Intl.intl("<multiple>")));
        guiComboBox[] guiComboBoxArray = new guiComboBox[]{this.d_fromNodeCB, this.d_toNodeCB};
        for (int i = 0; i < guiComboBoxArray.length; ++i) {
            property2 = Composite.getProp(new NodeProp(i), collection);
            guiComboBoxArray[i].setSelectedItem(property2.orElse(null));
        }
        Property property3 = Composite.getProp(lengthProp, collection);
        if (!property3.isUniform()) {
            this.d_fixedLenRB.setSelected(false);
            this.d_autoLenRB.setSelected(false);
        } else if (property3.get() == null) {
            this.d_autoLenRB.setSelected(true);
            this.d_lengthFld.setValue(new UnitDouble(1.0, SI.METER));
        } else {
            this.d_fixedLenRB.setSelected(true);
            this.d_lengthFld.setValue(property3.get());
        }
        property2 = Composite.getProp(shapeProp, collection);
        if (property2.isUniform()) {
            switch ((HvacDuct.Shape)((Object)property2.get())) {
                case CIRCULAR: {
                    this.d_circularBtn.setSelected(true);
                    break;
                }
                case NON_CIRCULAR: {
                    this.d_nonCircularBtn.setSelected(true);
                }
            }
        } else {
            this.d_circularBtn.setSelected(false);
            this.d_nonCircularBtn.setSelected(false);
        }
        ValueField[] valueFieldArray = new ValueField[]{this.d_areaFld, this.d_diaFld, this.d_perimeterFld};
        GenericProp[] genericPropArray = new GenericProp[]{areaProp, diamProp, perimProp};
        for (int i = 0; i < valueFieldArray.length; ++i) {
            iObjectPropArray = Composite.getProp(genericPropArray[i], collection);
            valueFieldArray[i].setValue(iObjectPropArray.orElse(null));
        }
        ValueField[] valueFieldArray2 = new ValueField[]{this.d_forwardLossFld, this.d_reverseLossFld, this.d_roughFld};
        iObjectPropArray = new Composite.IObjectProp[]{new LossProp(0), new LossProp(1), roughnessProp};
        for (int i = 0; i < valueFieldArray2.length; ++i) {
            property = Composite.getProp(iObjectPropArray[i], collection);
            valueFieldArray2[i].setValue(property.orElse(null));
        }
        Property property4 = Composite.getProp(roughTypeProp, collection);
        this.d_roughnessTypeCB.setSelectedItem(property4.orElse(null));
        property = Composite.getProp(airflowProp, collection);
        int n2 = -1;
        if (property.isUniform()) {
            for (n = 0; n < this.d_flowDevcEditorCB.getItemCount(); ++n) {
                iFlowDevcEditor = this.d_flowDevcEditorCB.getItemAt(n);
                HvacDuct.AirflowObj airflowObj = iFlowDevcEditor.getDevcType();
                if (airflowObj != property.get()) continue;
                n2 = n;
                break;
            }
        }
        this.d_flowDevcEditorCB.setSelectedIndex(n2);
        for (n = 0; n < this.d_flowDevcEditorCB.getItemCount(); ++n) {
            iFlowDevcEditor = this.d_flowDevcEditorCB.getItemAt(n);
            iFlowDevcEditor.load(collection, this.d_nameFld);
        }
        this.updateAutoLbl();
        this.d_dlgPanel.setModified(false);
    }

    @Override
    public void save(PyroMod pyroMod, Collection<? extends HvacDuct> collection) {
        Cloneable cloneable;
        HashSet<Composite.IObjectProp> hashSet;
        if (this.d_fyi.isModified()) {
            Composite.setProperty(fyiProp, this.d_fyi.getText(), collection);
        }
        if (this.d_autoLenRB.isSelected()) {
            Composite.setProperty(lengthProp, null, collection);
        } else if (this.d_fixedLenRB.isSelected()) {
            Composite.setProp(lengthProp, Property.ofNullable(this.d_lengthFld.getValue()), collection);
        }
        if (this.d_circularBtn.isSelected()) {
            Composite.setProperty(shapeProp, HvacDuct.Shape.CIRCULAR, collection);
            Composite.setProp(diamProp, Property.ofNullable(this.d_diaFld.getValue()), collection);
        } else if (this.d_nonCircularBtn.isSelected()) {
            Composite.setProperty(shapeProp, HvacDuct.Shape.NON_CIRCULAR, collection);
            Composite.setProp(areaProp, Property.ofNullable(this.d_areaFld.getValue()), collection);
            Composite.setProp(perimProp, Property.ofNullable(this.d_perimeterFld.getValue()), collection);
        }
        Composite.setProp(new LossProp(0), Property.ofNullable(this.d_forwardLossFld.getValue()), collection);
        Composite.setProp(new LossProp(1), Property.ofNullable(this.d_reverseLossFld.getValue()), collection);
        Composite.setProp(roughnessProp, Property.ofNullable(this.d_roughFld.getValue()), collection);
        Composite.setProp(roughTypeProp, Property.ofNullable(this.d_roughnessTypeCB.getSelectedItem()), collection);
        IFlowDevcEditor iFlowDevcEditor = this.d_flowDevcEditorCB.getSelectedItem();
        if (iFlowDevcEditor != null) {
            hashSet = new HashSet();
            for (int i = 0; i < this.d_flowDevcEditorCB.getItemCount(); ++i) {
                this.d_flowDevcEditorCB.getItemAt(i).getProps(hashSet);
            }
            cloneable = new HashSet();
            iFlowDevcEditor.getProps((Set<Composite.IObjectProp>)((Object)cloneable));
            hashSet.removeAll((Collection<?>)((Object)cloneable));
            for (int i = 0; i < this.d_flowDevcEditorCB.getItemCount(); ++i) {
                if (this.d_flowDevcEditorCB.getItemAt(i) == iFlowDevcEditor) continue;
                this.d_flowDevcEditorCB.getItemAt(i).resetProps(hashSet, collection);
            }
            Composite.setProperty(airflowProp, iFlowDevcEditor.getDevcType(), collection);
            iFlowDevcEditor.save(collection);
        }
        hashSet = this.d_fromNodeCB.getSelectedItem();
        cloneable = this.d_toNodeCB.getSelectedItem();
        ArrayList<HvacDuctLoss> arrayList = new ArrayList<HvacDuctLoss>();
        for (HvacDuct hvacDuct : collection) {
            List list = (List)hvacDuct.getProp("NODE_ID");
            HvacNode hvacNode = (HvacNode)list.get(0);
            HvacNode hvacNode2 = (HvacNode)list.get(1);
            List<HvacNode> list2 = Arrays.asList(hashSet != null ? hashSet : hvacNode, cloneable != null ? cloneable : hvacNode2);
            assert (hashSet == null || this.d_domain.getObstructions().containsDeep((IPyroObject)((Object)hashSet)));
            assert (cloneable == null || this.d_domain.getObstructions().containsDeep((IPyroObject)cloneable));
            if (hvacNode != null && !list2.contains(hvacNode)) {
                arrayList.addAll(HvacUtil.getDuctLosses(this.d_domain.getBridges(), hvacNode, hvacDuct));
            }
            if (hvacNode2 != null && !list2.contains(hvacNode2)) {
                arrayList.addAll(HvacUtil.getDuctLosses(this.d_domain.getBridges(), hvacNode2, hvacDuct));
            }
            hvacDuct.setProp("NODE_ID", list2);
        }
        this.d_domain.getBridges().removeAll(arrayList);
    }

    private static boolean error(boolean bl, boolean bl2, Component component, Supplier<String> supplier) {
        if (bl) {
            guiDialog.showInvalidEntryMessage(SwingUtilities.getWindowAncestor(component), supplier.get());
        }
        if (bl2) {
            component.requestFocus();
        }
        return false;
    }

    private static class BasicFanPnl
    extends guiPanel
    implements IFlowDevcEditor {
        private static final long serialVersionUID = -1347270971426334846L;
        private final ValueField<UnitDouble> d_volFlowFld;
        private final TimeFunctionEditor d_ramp;
        private final guiComboBox<Boolean> d_dirCB;
        private Collection<? extends HvacDuct> d_ducts = Collections.EMPTY_LIST;

        public BasicFanPnl(PyroMod pyroMod) {
            this.d_volFlowFld = ValueFields.udFld(UnitSystem.getSource(24), UnitDoubleVR.above(SIUS.newud(0.0, 24), true));
            this.d_volFlowFld.setNullAllowed(true);
            this.d_ramp = new TimeFunctionEditor(Intl.intl("Ramp up time"), 29);
            this.d_dirCB = DuctEditor.newDirCB();
            GridBagHelper gridBagHelper = new GridBagHelper(this);
            gridBagHelper.addRow(Intl.intl("Volume Flow:"), this.d_volFlowFld, 2);
            gridBagHelper.addRow(this.d_ramp.getLabel(), this.d_ramp.getCombo(), 1.0, this.d_ramp.getEditor());
            gridBagHelper.addRow(Intl.intl("Flow Direction:"), this.d_dirCB, 0);
            gridBagHelper.finalizeRows();
        }

        @Override
        public HvacDuct.AirflowObj getDevcType() {
            return HvacDuct.AirflowObj.VOLFLOW;
        }

        @Override
        public String toString() {
            return Intl.intl("Basic Fan");
        }

        @Override
        public guiPanel getPanel() {
            return this;
        }

        @Override
        public void updateEnabled(PyroMod pyroMod) {
        }

        @Override
        public void getProps(Set<Composite.IObjectProp> set) {
            set.add(volflowProp);
            set.add(volflowRampProp);
            set.add(revVolFlowProp);
        }

        @Override
        public void resetProps(Set<Composite.IObjectProp> set, Collection<? extends HvacDuct> collection) {
            if (set.contains(volflowProp)) {
                Composite.setProperty(volflowProp, SIUS.newud(0.0, 24), collection);
            }
            if (set.contains(volflowRampProp)) {
                Composite.setProperty(volflowRampProp, TimeFunction.newDefault(), collection);
            }
            if (set.contains(revVolFlowProp)) {
                Composite.setProperty(revVolFlowProp, Boolean.FALSE, collection);
            }
        }

        @Override
        public void load(Collection<? extends HvacDuct> collection, JTextField jTextField) {
            this.d_ducts = collection;
            Property property = Composite.getProp(volflowProp, collection);
            this.d_volFlowFld.setValue(property.orElse(null));
            Property property2 = Composite.getProp(volflowRampProp, collection);
            this.d_ramp.loadFunction(property2.orElse(null));
            Property<Boolean> property3 = Composite.getProp(revVolFlowProp, collection);
            this.d_dirCB.setSelectedItem(property3.orElse(null));
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            if (!super.validateData(bl, bl2) || !this.d_ramp.validateData(bl, bl2)) {
                return false;
            }
            if (this.d_ducts.stream().anyMatch(hvacDuct -> hvacDuct.getProp("opt_none_damper_fan") != this.getDevcType())) {
                if (this.d_volFlowFld.getValue() == null) {
                    return DuctEditor.error(bl, bl2, this.d_volFlowFld, () -> Intl.intl("Volume Flow must not be empty."));
                }
                if (this.d_dirCB.getSelectedItem() == null) {
                    return DuctEditor.error(bl, bl2, this.d_dirCB, () -> Intl.intl("A Flow Direction must be chosen."));
                }
                if (this.d_ramp.saveFunction() == null) {
                    return DuctEditor.error(bl, bl2, this.d_ramp.getCombo(), () -> Intl.intl("A ramp-up time must be chosen."));
                }
            }
            return true;
        }

        @Override
        public void save(Collection<? extends HvacDuct> collection) {
            UnitDouble unitDouble = (UnitDouble)this.d_volFlowFld.getValue();
            Composite.setProp(volflowProp, Property.ofNullable(unitDouble), collection);
            TimeFunction<?> timeFunction = this.d_ramp.saveFunction();
            Composite.setProp(volflowRampProp, Property.ofNullable(timeFunction), collection);
            Boolean bl = this.d_dirCB.getSelectedItem();
            Composite.setProp(revVolFlowProp, Property.ofNullable(bl), collection);
        }
    }

    private static class AircoilPnl
    extends guiPanel
    implements IFlowDevcEditor {
        private static final long serialVersionUID = -9020985968423659050L;
        private final guiComboBox<HvacAircoil> d_aircoilCB;
        private final ControlSelPnl d_controlPnl;
        private Collection<? extends HvacDuct> d_ducts = Collections.EMPTY_LIST;

        public AircoilPnl(PyroMod pyroMod) {
            this.d_aircoilCB = new PyroComboBox<HvacAircoil>(pyroMod.getHvacList(), HvacAircoil.class);
            this.d_controlPnl = new ControlSelPnl(pyroMod.getControls());
            GridBagHelper gridBagHelper = new GridBagHelper(this);
            gridBagHelper.addRow(Intl.intl("Aircoil:"), this.d_aircoilCB, 0);
            this.d_controlPnl.add(gridBagHelper);
            gridBagHelper.finalizeRows();
        }

        @Override
        public HvacDuct.AirflowObj getDevcType() {
            return HvacDuct.AirflowObj.AIRCOIL;
        }

        @Override
        public String toString() {
            return Intl.intl("Aircoil");
        }

        @Override
        public guiPanel getPanel() {
            return this;
        }

        @Override
        public void updateEnabled(PyroMod pyroMod) {
            this.setEnabled(this.d_aircoilCB.getItemCount() > 0);
            if (this.d_aircoilCB.getSelectedIndex() < 0 && this.d_aircoilCB.getItemCount() > 0) {
                this.d_aircoilCB.setSelectedIndex(0);
            }
        }

        @Override
        public void getProps(Set<Composite.IObjectProp> set) {
            set.add(aircoilProp);
            set.add(ctrlProp);
        }

        @Override
        public void resetProps(Set<Composite.IObjectProp> set, Collection<? extends HvacDuct> collection) {
            if (set.contains(aircoilProp)) {
                Composite.setProperty(aircoilProp, null, collection);
            }
            if (set.contains(ctrlProp)) {
                Composite.setProperty(ctrlProp, null, collection);
            }
        }

        @Override
        public void load(Collection<? extends HvacDuct> collection, JTextField jTextField) {
            this.d_ducts = collection;
            Property property = Composite.getProp(aircoilProp, collection);
            this.d_aircoilCB.setSelectedItem(property.orElse(null));
            this.d_controlPnl.setNameSrc(jTextField, collection);
            this.d_controlPnl.load(Composite.getProp(ctrlProp, collection));
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            if (!super.validateData(bl, bl2)) {
                return false;
            }
            if (this.d_ducts.stream().anyMatch(hvacDuct -> hvacDuct.getProp("opt_none_damper_fan") != this.getDevcType())) {
                if (this.d_aircoilCB.getSelectedItem() == null) {
                    return DuctEditor.error(bl, bl2, this.d_aircoilCB, () -> Intl.intl("An aircoil must be chosen."));
                }
                if (!this.d_controlPnl.save().isUniform()) {
                    return DuctEditor.error(bl, bl2, this.d_controlPnl.getComboBox(), () -> Intl.intl("Activation must be specified."));
                }
            }
            return true;
        }

        @Override
        public void save(Collection<? extends HvacDuct> collection) {
            HvacAircoil hvacAircoil = this.d_aircoilCB.getSelectedItem();
            Composite.setProp(aircoilProp, Property.ofNullable(hvacAircoil), collection);
            Composite.setProp(ctrlProp, this.d_controlPnl.save(), collection);
        }
    }

    private static class FanPnl
    extends guiPanel
    implements IFlowDevcEditor {
        private static final long serialVersionUID = 6320057201436867513L;
        private final guiComboBox<HvacFan> d_fanCB;
        private final guiComboBox<Boolean> d_dirCB;
        private final ControlSelPnl d_controlPnl;
        private Collection<? extends HvacDuct> d_ducts = Collections.EMPTY_LIST;

        public FanPnl(PyroMod pyroMod) {
            this.d_fanCB = new PyroComboBox<HvacFan>(pyroMod.getHvacList(), HvacFan.class);
            this.d_dirCB = DuctEditor.newDirCB();
            this.d_controlPnl = new ControlSelPnl(pyroMod.getControls());
            GridBagHelper gridBagHelper = new GridBagHelper(this);
            gridBagHelper.addRow(Intl.intl("Fan:"), this.d_fanCB, 0);
            gridBagHelper.addRow(Intl.intl("Flow Direction:"), this.d_dirCB, 0);
            this.d_controlPnl.add(gridBagHelper);
            gridBagHelper.finalizeRows();
        }

        @Override
        public HvacDuct.AirflowObj getDevcType() {
            return HvacDuct.AirflowObj.FAN;
        }

        @Override
        public String toString() {
            return Intl.intl("Fan");
        }

        @Override
        public guiPanel getPanel() {
            return this;
        }

        @Override
        public void updateEnabled(PyroMod pyroMod) {
            this.setEnabled(this.d_fanCB.getItemCount() > 0);
            if (this.d_fanCB.getSelectedIndex() < 0 && this.d_fanCB.getItemCount() > 0) {
                this.d_fanCB.setSelectedIndex(0);
            }
        }

        @Override
        public void getProps(Set<Composite.IObjectProp> set) {
            set.add(fanProp);
            set.add(revProp);
            set.add(ctrlProp);
        }

        @Override
        public void resetProps(Set<Composite.IObjectProp> set, Collection<? extends HvacDuct> collection) {
            if (set.contains(fanProp)) {
                Composite.setProperty(fanProp, null, collection);
            }
            if (set.contains(revProp)) {
                Composite.setProperty(revProp, Boolean.FALSE, collection);
            }
            if (set.contains(ctrlProp)) {
                Composite.setProperty(ctrlProp, null, collection);
            }
        }

        @Override
        public void load(Collection<? extends HvacDuct> collection, JTextField jTextField) {
            this.d_ducts = collection;
            Property property = Composite.getProp(fanProp, collection);
            this.d_fanCB.setSelectedItem(property.orElse(null));
            Property property2 = Composite.getProp(revProp, collection);
            this.d_dirCB.setSelectedItem(property2.orElse(null));
            this.d_controlPnl.setNameSrc(jTextField, collection);
            Property<ControlBridge> property3 = Composite.getProp(ctrlProp, collection);
            this.d_controlPnl.load(property3);
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            if (!super.validateData(bl, bl2)) {
                return false;
            }
            if (this.d_ducts.stream().anyMatch(hvacDuct -> hvacDuct.getProp("opt_none_damper_fan") != this.getDevcType())) {
                if (this.d_fanCB.getSelectedItem() == null) {
                    return DuctEditor.error(bl, bl2, this.d_fanCB, () -> Intl.intl("A fan must be chosen."));
                }
                if (this.d_dirCB.getSelectedItem() == null) {
                    return DuctEditor.error(bl, bl2, this.d_dirCB, () -> Intl.intl("A Flow Direction must be chosen."));
                }
                if (!this.d_controlPnl.save().isUniform()) {
                    return DuctEditor.error(bl, bl2, this.d_controlPnl.getComboBox(), () -> Intl.intl("Activation must be specified."));
                }
            }
            return true;
        }

        @Override
        public void save(Collection<? extends HvacDuct> collection) {
            HvacFan hvacFan = this.d_fanCB.getSelectedItem();
            Composite.setProp(fanProp, Property.ofNullable(hvacFan), collection);
            Boolean bl = this.d_dirCB.getSelectedItem();
            Composite.setProp(revProp, Property.ofNullable(bl), collection);
            Composite.setProp(ctrlProp, this.d_controlPnl.save(), collection);
        }
    }

    private static class DamperPnl
    extends guiPanel
    implements IFlowDevcEditor {
        private static final long serialVersionUID = 4536444679561931622L;
        private final ControlSelPnl d_controlPnl;
        private Collection<? extends HvacDuct> d_ducts = Collections.EMPTY_LIST;

        public DamperPnl(PyroMod pyroMod) {
            this.d_controlPnl = new ControlSelPnl(pyroMod.getControls());
            GridBagHelper gridBagHelper = new GridBagHelper(this);
            this.d_controlPnl.add(gridBagHelper);
            gridBagHelper.finalizeRows();
        }

        @Override
        public HvacDuct.AirflowObj getDevcType() {
            return HvacDuct.AirflowObj.DAMPER;
        }

        @Override
        public String toString() {
            return Intl.intl("Damper");
        }

        @Override
        public guiPanel getPanel() {
            return this;
        }

        @Override
        public void updateEnabled(PyroMod pyroMod) {
        }

        @Override
        public void getProps(Set<Composite.IObjectProp> set) {
            set.add(ctrlProp);
        }

        @Override
        public void resetProps(Set<Composite.IObjectProp> set, Collection<? extends HvacDuct> collection) {
            if (set.contains(ctrlProp)) {
                Composite.setProperty(ctrlProp, null, collection);
            }
        }

        @Override
        public void load(Collection<? extends HvacDuct> collection, JTextField jTextField) {
            this.d_ducts = collection;
            this.d_controlPnl.setNameSrc(jTextField, collection);
            this.d_controlPnl.load(Composite.getProp(ctrlProp, collection));
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            if (!super.validateData(bl, bl2)) {
                return false;
            }
            if (this.d_ducts.stream().anyMatch(hvacDuct -> hvacDuct.getProp("opt_none_damper_fan") != this.getDevcType()) && !this.d_controlPnl.save().isUniform()) {
                return DuctEditor.error(bl, bl2, this.d_controlPnl.getComboBox(), () -> Intl.intl("Activation must be specified."));
            }
            return true;
        }

        @Override
        public void save(Collection<? extends HvacDuct> collection) {
            Composite.setProp(ctrlProp, this.d_controlPnl.save(), collection);
        }
    }

    private static class NoDevcPnl
    extends guiPanel
    implements IFlowDevcEditor {
        private static final long serialVersionUID = 7170816517958924562L;

        private NoDevcPnl() {
        }

        @Override
        public HvacDuct.AirflowObj getDevcType() {
            return HvacDuct.AirflowObj.NONE;
        }

        @Override
        public String toString() {
            return Intl.intl("<none>");
        }

        @Override
        public guiPanel getPanel() {
            return this;
        }

        @Override
        public void updateEnabled(PyroMod pyroMod) {
        }

        @Override
        public void getProps(Set<Composite.IObjectProp> set) {
        }

        @Override
        public void resetProps(Set<Composite.IObjectProp> set, Collection<? extends HvacDuct> collection) {
        }

        @Override
        public void load(Collection<? extends HvacDuct> collection, JTextField jTextField) {
        }

        @Override
        public void save(Collection<? extends HvacDuct> collection) {
        }
    }

    private static interface IFlowDevcEditor {
        public HvacDuct.AirflowObj getDevcType();

        public void load(Collection<? extends HvacDuct> var1, JTextField var2);

        public void save(Collection<? extends HvacDuct> var1);

        public String toString();

        public guiPanel getPanel();

        public void updateEnabled(PyroMod var1);

        public void getProps(Set<Composite.IObjectProp> var1);

        public void resetProps(Set<Composite.IObjectProp> var1, Collection<? extends HvacDuct> var2);
    }

    private static class NodeProp
    extends ListProp<HvacNode> {
        public NodeProp(int n) {
            super("NODE_ID", n);
        }
    }

    private static class LossProp
    extends ListProp<UnitDouble> {
        public LossProp(int n) {
            super("LOSS", n);
        }
    }

    private static class ListProp<T>
    extends Composite.AObjectProp<HvacDuct, T> {
        private final String d_key;
        private final int d_index;

        public ListProp(String string, int n) {
            super(HvacDuct.class);
            this.d_key = string;
            this.d_index = n;
        }

        @Override
        public Object get(HvacDuct hvacDuct) {
            List list = (List)hvacDuct.getProp(this.d_key);
            return list.get(this.d_index);
        }

        @Override
        public void set(HvacDuct hvacDuct, T t) {
            ArrayList<T> arrayList = new ArrayList<T>((List)hvacDuct.getProp(this.d_key));
            arrayList.set(this.d_index, t);
            hvacDuct.setProp(this.d_key, arrayList);
        }
    }

    private static class StandardProp<T>
    extends Composite.AObjectProp<HvacDuct, T> {
        private final Function<HvacDuct, T> d_getter;
        private final BiConsumer<HvacDuct, T> d_setter;

        public StandardProp(Function<HvacDuct, T> function, BiConsumer<HvacDuct, T> biConsumer) {
            super(HvacDuct.class);
            this.d_setter = biConsumer;
            this.d_getter = function;
        }

        @Override
        public Object get(HvacDuct hvacDuct) {
            return this.d_getter.apply(hvacDuct);
        }

        @Override
        public void set(HvacDuct hvacDuct, T t) {
            this.d_setter.accept(hvacDuct, (HvacDuct)t);
        }
    }

    private static class GenericProp<T>
    extends Composite.AObjectProp<HvacDuct, T> {
        private final String d_propKey;

        public GenericProp(String string) {
            super(HvacDuct.class);
            this.d_propKey = string;
        }

        @Override
        public Object get(HvacDuct hvacDuct) {
            return hvacDuct.getProp(this.d_propKey);
        }

        @Override
        public void set(HvacDuct hvacDuct, T t) {
            hvacDuct.setProp(this.d_propKey, t);
        }
    }

    private static class ReverseVolFlowProp
    extends Composite.AObjectProp<HvacDuct, Boolean> {
        private static final UnitDouble ZERO = SIUS.newud(0.0, 24);

        public ReverseVolFlowProp() {
            super(HvacDuct.class);
        }

        @Override
        public void set(HvacDuct hvacDuct, Boolean bl) {
            if (bl.booleanValue()) {
                TimeBasedValue<UnitDouble> timeBasedValue = hvacDuct.getVolflow();
                timeBasedValue = new TimeBasedValue<UnitDouble>(((UnitDouble)timeBasedValue.val).negate(), timeBasedValue.func);
                hvacDuct.setVolflow(timeBasedValue);
            }
        }

        @Override
        public Object get(HvacDuct hvacDuct) {
            return ((UnitDouble)hvacDuct.getVolflow().val).lt(ZERO, 0.0);
        }
    }
}

