/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.GridBagLayout;
import java.util.Collection;
import javax.vecmath.Vector3d;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.domain.devices.AttachedPointGeom;
import pyrosim.domain.geom.AttachedPointLoc;
import pyrosim.geom.Geometry;
import pyrosim.gui.geom.GeomGuiUtil;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.gui.geom.Point3DPanel;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.objs.node.GeomNodeUtil;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;
import thunderheadeng.util.PropertyUtil;

public class AttachedPointGeomEditor
extends guiPanel
implements IGeomEditor<AttachedPointGeom> {
    private static final long serialVersionUID = -7397906603675436194L;
    private Point3DPanel d_locPanel;
    private ValueField<UnitDouble> d_rotation;
    private ValueField<Double> d_xOrien;
    private ValueField<Double> d_yOrien;
    private ValueField<Double> d_zOrien;

    public AttachedPointGeomEditor() {
        this.setLayout(new GridBagLayout());
        int n = 0;
        guiLabel guiLabel2 = new guiLabel(Intl.intl("Normal of Solid"));
        guiLabel guiLabel3 = new guiLabel(Intl.intl("Rotation") + ":");
        this.d_rotation = ValueFields.udFld(UnitSystem.getSource(29));
        this.d_locPanel = new Point3DPanel(Intl.intl("Location"));
        guiLabel guiLabel4 = new guiLabel(Intl.intl("X") + ":");
        guiLabel guiLabel5 = new guiLabel(Intl.intl("Y") + ":");
        guiLabel guiLabel6 = new guiLabel(Intl.intl("Z") + ":");
        this.d_xOrien = ValueFields.doubleFld();
        this.d_yOrien = ValueFields.doubleFld();
        this.d_zOrien = ValueFields.doubleFld();
        this.d_locPanel.addToPanel(this, 0, n++);
        GridBagUtil.add(this, guiLabel2, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, guiLabel4, 1, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_xOrien, 2, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, guiLabel5, 3, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_yOrien, 4, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, guiLabel6, 5, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_zOrien, 6, n++, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, guiLabel3, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_rotation, 2, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        this.load(new AttachedPointLoc());
    }

    @Override
    public String getGeomName() {
        return Intl.intl("Location");
    }

    @Override
    public guiPanel getPanel() {
        return this;
    }

    @Override
    public int getNumFaces() {
        return 0;
    }

    @Override
    public String[] getFaceNames() {
        return null;
    }

    @Override
    public int[] getFaceOrder(IGeomNode iGeomNode) {
        return null;
    }

    @Override
    public void load(Collection<? extends IPyroGeomSrc> collection) {
        UnitDouble[] unitDoubleArray = GeomGuiUtil.getDataVals(collection, new LocProp(), 3, Geometry.LU);
        Double[] doubleArray = GeomGuiUtil.getDoubleDataVals(collection, new OrientProp(), 3);
        Object object = PropertyUtil.getProperty(new RotProp(), collection);
        if (!(object instanceof UnitDouble)) {
            object = null;
        }
        this.d_locPanel.setX(unitDoubleArray[0]);
        this.d_locPanel.setY(unitDoubleArray[1]);
        this.d_locPanel.setZ(unitDoubleArray[2]);
        this.d_xOrien.setValue(doubleArray[0]);
        this.d_yOrien.setValue(doubleArray[1]);
        this.d_zOrien.setValue(doubleArray[2]);
        this.d_rotation.setValue((UnitDouble)object);
    }

    @Override
    public void save(Collection<? extends IPyroGeomSrc> collection) {
        UnitDouble[] unitDoubleArray = new UnitDouble[]{this.d_locPanel.x(), this.d_locPanel.y(), this.d_locPanel.z()};
        Double[] doubleArray = new Double[]{(Double)this.d_xOrien.getValue(), (Double)this.d_yOrien.getValue(), (Double)this.d_zOrien.getValue()};
        UnitDouble unitDouble = (UnitDouble)this.d_rotation.getValue();
        GeomGuiUtil.setDataVals(collection, new LocProp(), Geometry.LU, unitDoubleArray);
        GeomGuiUtil.setDoubleDataVals(collection, new OrientProp(), doubleArray);
        PropertyUtil.setProperty(new RotProp(), unitDouble, collection);
    }

    @Override
    public boolean validateData(Collection<? extends IPyroGeomSrc> collection, boolean bl, boolean bl2) {
        return true;
    }

    public void load(AttachedPointLoc attachedPointLoc) {
        this.d_locPanel.load(attachedPointLoc.d_location);
        this.d_xOrien.setValue(attachedPointLoc.d_faceNormal.x);
        this.d_yOrien.setValue(attachedPointLoc.d_faceNormal.y);
        this.d_zOrien.setValue(attachedPointLoc.d_faceNormal.z);
        this.d_rotation.setValue(attachedPointLoc.d_rotation);
    }

    public AttachedPointLoc getAttachedPointLoc() {
        UnitPoint3D unitPoint3D = this.d_locPanel.save();
        Vector3d vector3d = new Vector3d((Double)this.d_xOrien.getValue(), (Double)this.d_yOrien.getValue(), (Double)this.d_zOrien.getValue());
        return new AttachedPointLoc(unitPoint3D, vector3d, (UnitDouble)this.d_rotation.getValue());
    }

    private static class RotProp
    extends PropertyUtil.AProp<IPyroGeomSrc, UnitDouble> {
        public RotProp() {
            super(IPyroGeomSrc.class);
        }

        @Override
        public Object get(IPyroGeomSrc iPyroGeomSrc) {
            return ((AttachedPointGeom)iPyroGeomSrc.getGeom().getLocalGeom()).loc.d_rotation;
        }

        @Override
        public void set(IPyroGeomSrc iPyroGeomSrc, UnitDouble unitDouble) {
            AttachedPointGeom attachedPointGeom = (AttachedPointGeom)iPyroGeomSrc.getGeom().getLocalGeom();
            AttachedPointLoc attachedPointLoc = new AttachedPointLoc(attachedPointGeom.loc.d_location, attachedPointGeom.loc.d_faceNormal, unitDouble);
            iPyroGeomSrc.setGeom(GeomNodeUtil.newNode(new AttachedPointGeom(attachedPointLoc)));
        }
    }

    private static class OrientProp
    extends GeomGuiUtil.AGeomProp<AttachedPointGeom> {
        private OrientProp() {
        }

        @Override
        protected AttachedPointGeom constructGeom(AttachedPointGeom attachedPointGeom, double[] dArray) {
            AttachedPointLoc attachedPointLoc = new AttachedPointLoc(attachedPointGeom.loc.d_location, new Vector3d(dArray[0], dArray[1], dArray[2]), attachedPointGeom.loc.d_rotation);
            return new AttachedPointGeom(attachedPointLoc);
        }

        @Override
        protected double[] saveData(AttachedPointGeom attachedPointGeom) {
            AttachedPointLoc attachedPointLoc = attachedPointGeom.loc;
            double[] dArray = new double[3];
            attachedPointLoc.d_faceNormal.get(dArray);
            return dArray;
        }
    }

    private static class LocProp
    extends GeomGuiUtil.AGeomProp<AttachedPointGeom> {
        private LocProp() {
        }

        @Override
        protected AttachedPointGeom constructGeom(AttachedPointGeom attachedPointGeom, double[] dArray) {
            AttachedPointLoc attachedPointLoc = new AttachedPointLoc(new UnitPoint3D(dArray[0], dArray[1], dArray[2], Geometry.LU), attachedPointGeom.loc.d_faceNormal, attachedPointGeom.loc.d_rotation);
            return new AttachedPointGeom(attachedPointLoc);
        }

        @Override
        protected double[] saveData(AttachedPointGeom attachedPointGeom) {
            Unit unit = Geometry.LU;
            AttachedPointLoc attachedPointLoc = attachedPointGeom.loc;
            return new double[]{attachedPointLoc.d_location.x(unit), attachedPointLoc.d_location.y(unit), attachedPointLoc.d_location.z(unit)};
        }
    }
}

