/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.geom.Geometry;
import pyrosim.gui.geom.AABoxGeomEditor;
import pyrosim.gui.geom.GeomGuiUtil;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.AABox;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitAABox;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class AARectangleEditor
extends guiPanel
implements IGeomEditor<AARectangle> {
    private static final long serialVersionUID = -196090020161127760L;
    public static final String FACE_NAME = Intl.intl("Face");
    public static final int X_PLANE = 0;
    public static final int Y_PLANE = 1;
    public static final int Z_PLANE = 2;
    public static final int NO_PLANE = 3;
    private guiComboBox<String> d_planeCombo;
    private ValueField<UnitDouble> d_planeLoc;
    private AABoxGeomEditor d_boxGeomEditor;
    private final GeomGuiUtil.AGeomProp rectProp = new GeomGuiUtil.AGeomProp<AARectangle>(){

        @Override
        protected double[] saveData(AARectangle aARectangle) {
            return new double[]{aARectangle.d_plane, aARectangle.d_planeVal, aARectangle.d_minx, aARectangle.d_miny, aARectangle.d_maxx, aARectangle.d_maxy};
        }

        @Override
        protected AARectangle constructGeom(AARectangle aARectangle, double[] dArray) {
            return new AARectangle((byte)dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5], aARectangle.flipped);
        }
    };

    public AARectangleEditor(boolean bl) {
        this.setLayout(new GridBagLayout());
        this.d_boxGeomEditor = new AABoxGeomEditor(bl, true);
        guiLabel guiLabel2 = new guiLabel(Intl.intl("Plane"));
        this.d_planeCombo = new guiComboBox<Object>((T[])new Object[]{" X ", " Y ", " Z "});
        this.d_planeCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int n = AARectangleEditor.this.d_planeCombo.getSelectedIndex();
                if (n == 0) {
                    AARectangleEditor.this.selectPlane(0);
                } else if (n == 1) {
                    AARectangleEditor.this.selectPlane(1);
                } else if (n == 2) {
                    AARectangleEditor.this.selectPlane(2);
                } else {
                    AARectangleEditor.this.selectPlane(3);
                }
            }
        });
        guiLabel guiLabel3 = new guiLabel("=");
        this.d_planeLoc = AARectangleEditor.newField(bl, 0.0, SI.METER);
        guiPanel guiPanel2 = new guiPanel(new GridBagLayout());
        GridBagUtil.add(guiPanel2, guiLabel2, 0, 0, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_planeCombo, 1, 0, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, guiLabel3, 2, 0, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_planeLoc, 3, 0, 1, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, guiPanel2, 0, 0, 6, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        TitleSeparator titleSeparator = new TitleSeparator(Intl.intl("Bounds"));
        guiPanel guiPanel3 = this.d_boxGeomEditor.getPanel();
        GridBagUtil.add(this, titleSeparator, 0, 1, 6, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, guiPanel3, 0, 2, 6, 1, 0, 12, 0, 0, 2, 1.0, 0.0, 17);
        GridBagUtil.addGlue(this);
        this.selectPlane(0);
    }

    private static ValueField<UnitDouble> newField(boolean bl, double d, Unit unit) {
        ValueField<UnitDouble> valueField = ValueFields.udFld(new UnitDouble(d, unit), UnitSystem.getSource(0));
        valueField.setColumns(8);
        valueField.setNullAllowed(bl);
        return valueField;
    }

    @Override
    public String getGeomName() {
        return Intl.intl("Rectangle");
    }

    @Override
    public guiPanel getPanel() {
        return this;
    }

    @Override
    public String[] getFaceNames() {
        return new String[]{FACE_NAME};
    }

    @Override
    public int getNumFaces() {
        return 1;
    }

    @Override
    public int[] getFaceOrder(IGeomNode iGeomNode) {
        return null;
    }

    public guiComboBox<String> getPlaneCB() {
        return this.d_planeCombo;
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        if (bl) {
            this.selectPlane(this.d_planeCombo.getSelectedIndex());
        }
    }

    public void selectPlane(int n) {
        int n2;
        ValueField[] valueFieldArray = this.d_boxGeomEditor.getMinFields();
        ValueField[] valueFieldArray2 = this.d_boxGeomEditor.getMaxFields();
        for (n2 = 0; n2 < valueFieldArray.length; ++n2) {
            valueFieldArray[n2].setEnabled(false);
        }
        for (n2 = 0; n2 < valueFieldArray2.length; ++n2) {
            valueFieldArray2[n2].setEnabled(false);
        }
        switch (n) {
            case 0: {
                valueFieldArray[1].setEnabled(true);
                valueFieldArray2[1].setEnabled(true);
                valueFieldArray[2].setEnabled(true);
                valueFieldArray2[2].setEnabled(true);
                break;
            }
            case 1: {
                valueFieldArray[0].setEnabled(true);
                valueFieldArray2[0].setEnabled(true);
                valueFieldArray[2].setEnabled(true);
                valueFieldArray2[2].setEnabled(true);
                break;
            }
            case 2: {
                valueFieldArray[0].setEnabled(true);
                valueFieldArray2[0].setEnabled(true);
                valueFieldArray[1].setEnabled(true);
                valueFieldArray2[1].setEnabled(true);
            }
        }
        this.revalidate();
    }

    @Override
    public boolean validateData(Collection<? extends IPyroGeomSrc> collection, boolean bl, boolean bl2) {
        if (!super.validateData(bl, bl2)) {
            return false;
        }
        int n = this.d_planeCombo.getSelectedIndex();
        boolean bl3 = n == 1 || n == 2;
        boolean bl4 = n == 0 || n == 2;
        boolean bl5 = n == 0 || n == 1;
        ValueField[] valueFieldArray = this.d_boxGeomEditor.getMinFields();
        ValueField[] valueFieldArray2 = this.d_boxGeomEditor.getMaxFields();
        if (bl3 && !GeomGuiUtil.validateMinMax(this.getParent(), valueFieldArray[0], valueFieldArray2[0], Intl.intl("Min X"), Intl.intl("Max X"), false, this.rectProp, 2, 4, collection, bl, bl2)) {
            return false;
        }
        if (bl4) {
            int n2;
            int n3 = n2 = n == 0 ? 2 : 3;
            if (!GeomGuiUtil.validateMinMax(this.getParent(), valueFieldArray[1], valueFieldArray2[1], Intl.intl("Min Y"), Intl.intl("Max Y"), false, this.rectProp, n2, n2 + 2, collection, bl, bl2)) {
                return false;
            }
        }
        return !bl5 || GeomGuiUtil.validateMinMax(this.getParent(), valueFieldArray[2], valueFieldArray2[2], Intl.intl("Min Z"), Intl.intl("Max Z"), false, this.rectProp, 3, 5, collection, bl, bl2);
    }

    @Override
    public void load(Collection<? extends IPyroGeomSrc> collection) {
        UnitDouble[] unitDoubleArray = GeomGuiUtil.getDataVals(collection, this.rectProp, 6, Geometry.LU);
        if (unitDoubleArray[0] == null) {
            this.d_planeCombo.setSelectedItem(null);
            this.d_planeLoc.setValue(null);
            this.d_boxGeomEditor.load((AABoxGeom)null);
        } else {
            byte by = (byte)unitDoubleArray[0].getValueNoUnit();
            this.d_planeLoc.setValue(unitDoubleArray[1]);
            ValueField[] valueFieldArray = this.d_boxGeomEditor.getMinFields();
            ValueField[] valueFieldArray2 = this.d_boxGeomEditor.getMaxFields();
            switch (by) {
                case 0: {
                    this.d_planeCombo.setSelectedIndex(0);
                    this.selectPlane(0);
                    valueFieldArray[1].setValue(unitDoubleArray[2]);
                    valueFieldArray[2].setValue(unitDoubleArray[3]);
                    valueFieldArray2[1].setValue(unitDoubleArray[4]);
                    valueFieldArray2[2].setValue(unitDoubleArray[5]);
                    break;
                }
                case 1: {
                    this.d_planeCombo.setSelectedIndex(1);
                    this.selectPlane(1);
                    valueFieldArray[0].setValue(unitDoubleArray[2]);
                    valueFieldArray[2].setValue(unitDoubleArray[3]);
                    valueFieldArray2[0].setValue(unitDoubleArray[4]);
                    valueFieldArray2[2].setValue(unitDoubleArray[5]);
                    break;
                }
                case 2: {
                    this.d_planeCombo.setSelectedIndex(2);
                    this.selectPlane(2);
                    valueFieldArray[0].setValue(unitDoubleArray[2]);
                    valueFieldArray[1].setValue(unitDoubleArray[3]);
                    valueFieldArray2[0].setValue(unitDoubleArray[4]);
                    valueFieldArray2[1].setValue(unitDoubleArray[5]);
                }
            }
        }
    }

    @Override
    public void save(Collection<? extends IPyroGeomSrc> collection) {
        ValueField valueField;
        ValueField valueField2;
        ValueField valueField3;
        ValueField valueField4;
        String string = this.d_planeCombo.getSelectedItem();
        if (string == null) {
            return;
        }
        ValueField[] valueFieldArray = this.d_boxGeomEditor.getMinFields();
        ValueField[] valueFieldArray2 = this.d_boxGeomEditor.getMaxFields();
        int n = this.d_planeCombo.getSelectedIndex();
        switch (n) {
            case 0: {
                n = 0;
                valueField4 = valueFieldArray[1];
                valueField3 = valueFieldArray[2];
                valueField2 = valueFieldArray2[1];
                valueField = valueFieldArray2[2];
                break;
            }
            case 1: {
                n = 1;
                valueField4 = valueFieldArray[0];
                valueField3 = valueFieldArray[2];
                valueField2 = valueFieldArray2[0];
                valueField = valueFieldArray2[2];
                break;
            }
            case 2: {
                n = 2;
                valueField4 = valueFieldArray[0];
                valueField3 = valueFieldArray[1];
                valueField2 = valueFieldArray2[0];
                valueField = valueFieldArray2[1];
                break;
            }
            default: {
                assert (false);
                valueField = null;
                valueField2 = null;
                valueField3 = null;
                valueField4 = null;
            }
        }
        GeomGuiUtil.setDataVals(collection, this.rectProp, Geometry.LU, new UnitDouble(n, Geometry.LU), (UnitDouble)this.d_planeLoc.getValue(), (UnitDouble)valueField4.getValue(), (UnitDouble)valueField3.getValue(), (UnitDouble)valueField2.getValue(), (UnitDouble)valueField.getValue());
    }

    public void load(AARectangle aARectangle) {
        this.d_planeLoc.setValue(new UnitDouble(aARectangle.d_planeVal, Geometry.LU));
        AABoxGeom aABoxGeom = new AABoxGeom(aARectangle.getBoundingBox(new AABox()));
        this.d_boxGeomEditor.load(aABoxGeom);
        if (aARectangle.d_plane == 0) {
            this.d_planeCombo.setSelectedIndex(0);
        } else if (aARectangle.d_plane == 1) {
            this.d_planeCombo.setSelectedIndex(1);
        } else {
            this.d_planeCombo.setSelectedIndex(2);
        }
    }

    public AARectangle saveData() {
        int n = this.d_planeCombo.getSelectedIndex();
        boolean bl = n == 1 || n == 2;
        boolean bl2 = n == 0 || n == 2;
        boolean bl3 = n == 0 || n == 1;
        AABoxGeom aABoxGeom = this.d_boxGeomEditor.save();
        Point3d point3d = aABoxGeom.min;
        Point3d point3d2 = aABoxGeom.max;
        double d = ((UnitDouble)this.d_planeLoc.getValue()).getValue(Geometry.LU);
        if (bl && bl2) {
            return new AARectangle(2, d, point3d.x, point3d.y, point3d2.x, point3d2.y, false);
        }
        if (bl2 && bl3) {
            return new AARectangle(0, d, point3d.y, point3d.z, point3d2.y, point3d2.z, false);
        }
        return new AARectangle(1, d, point3d.x, point3d.z, point3d2.x, point3d2.z, false);
    }

    public UnitAABox getBoundingBox() {
        ValueField[] valueFieldArray = this.d_boxGeomEditor.getMinFields();
        if (valueFieldArray == null) {
            return null;
        }
        ValueField[] valueFieldArray2 = this.d_boxGeomEditor.getMaxFields();
        if (valueFieldArray2 == null) {
            return null;
        }
        int n = this.d_planeCombo.getSelectedIndex();
        if (n < 0 || 2 < n) {
            return null;
        }
        UnitDouble unitDouble = (UnitDouble)this.d_planeLoc.getValue();
        if (unitDouble == null) {
            return null;
        }
        try {
            switch (n) {
                case 0: {
                    return new UnitAABox(new UnitPoint3D(unitDouble, (UnitDouble)valueFieldArray[1].getValue(), (UnitDouble)valueFieldArray[2].getValue()), new UnitPoint3D(unitDouble, (UnitDouble)valueFieldArray2[1].getValue(), (UnitDouble)valueFieldArray2[2].getValue()));
                }
                case 1: {
                    return new UnitAABox(new UnitPoint3D((UnitDouble)valueFieldArray[0].getValue(), unitDouble, (UnitDouble)valueFieldArray[2].getValue()), new UnitPoint3D((UnitDouble)valueFieldArray2[0].getValue(), unitDouble, (UnitDouble)valueFieldArray2[2].getValue()));
                }
                case 2: {
                    return new UnitAABox(new UnitPoint3D((UnitDouble)valueFieldArray[0].getValue(), (UnitDouble)valueFieldArray[1].getValue(), unitDouble), new UnitPoint3D((UnitDouble)valueFieldArray2[0].getValue(), (UnitDouble)valueFieldArray2[1].getValue(), unitDouble));
                }
            }
            return null;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }
}

