/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.geom;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.GridBagLayout;
import java.util.Collection;
import javax.vecmath.Point3d;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.domain.IPyroGeomSrc;
import pyrosim.geom.Geometry;
import pyrosim.gui.geom.GeomGuiUtil;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.objs.AABoxGeom;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.geometry.objs.node.IGeomNode;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.units.UnitPoint3D;

public class AABoxGeomEditor
extends guiPanel
implements IGeomEditor<AABoxGeom> {
    private static final long serialVersionUID = 7480869622284435689L;
    public static final String[] FACE_NAMES = new String[6];
    private final ValueField<UnitDouble> d_minX;
    private final ValueField<UnitDouble> d_minY;
    private final ValueField<UnitDouble> d_minZ;
    private final ValueField<UnitDouble> d_maxX;
    private final ValueField<UnitDouble> d_maxY;
    private final ValueField<UnitDouble> d_maxZ;
    private final boolean d_equalAllowed;

    public AABoxGeomEditor(boolean bl, boolean bl2) {
        this.setLayout(new GridBagLayout());
        this.d_equalAllowed = bl2;
        guiLabel guiLabel2 = new guiLabel(Intl.intl("Min X") + ":");
        guiLabel guiLabel3 = new guiLabel(Intl.intl("Min Y") + ":");
        guiLabel guiLabel4 = new guiLabel(Intl.intl("Min Z") + ":");
        guiLabel guiLabel5 = new guiLabel(Intl.intl("Max X") + ":");
        guiLabel guiLabel6 = new guiLabel(Intl.intl("Max Y") + ":");
        guiLabel guiLabel7 = new guiLabel(Intl.intl("Max Z") + ":");
        this.d_minX = AABoxGeomEditor.newValueField(bl, 0.0, SI.METER);
        this.d_minY = AABoxGeomEditor.newValueField(bl, 0.0, SI.METER);
        this.d_minZ = AABoxGeomEditor.newValueField(bl, 0.0, SI.METER);
        this.d_maxX = AABoxGeomEditor.newValueField(bl, 1.0, SI.METER);
        this.d_maxY = AABoxGeomEditor.newValueField(bl, 1.0, SI.METER);
        this.d_maxZ = AABoxGeomEditor.newValueField(bl, 1.0, SI.METER);
        GridBagUtil.add(this, guiLabel2, 0, 0, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_minX, 1, 0, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, guiLabel3, 2, 0, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_minY, 3, 0, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, guiLabel4, 4, 0, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_minZ, 5, 0, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, guiLabel5, 0, 1, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_maxX, 1, 1, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, guiLabel6, 2, 1, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_maxY, 3, 1, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, guiLabel7, 4, 1, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_maxZ, 5, 1, 1, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 17);
        GridBagUtil.addGlue(this);
        this.setFocusTraversalPolicy(new BoxTraversalPolicy());
        this.setFocusTraversalPolicyProvider(true);
    }

    @Override
    public String[] getFaceNames() {
        return FACE_NAMES;
    }

    @Override
    public int getNumFaces() {
        return 6;
    }

    @Override
    public int[] getFaceOrder(IGeomNode iGeomNode) {
        IGeom iGeom = iGeomNode.getLocalGeom();
        if (!(iGeom instanceof AABoxGeom)) {
            return null;
        }
        AABoxGeom aABoxGeom = (AABoxGeom)iGeom;
        return aABoxGeom.isNaturallyOrdered() ? null : aABoxGeom.getNameToIndexFaceOrder();
    }

    public ValueField[] getMinFields() {
        return new ValueField[]{this.d_minX, this.d_minY, this.d_minZ};
    }

    public ValueField[] getMaxFields() {
        return new ValueField[]{this.d_maxX, this.d_maxY, this.d_maxZ};
    }

    private static ValueField newValueField(boolean bl, double d, Unit unit) {
        ValueField<UnitDouble> valueField = ValueFields.udFld(d, unit, UnitSystem.getSource(0));
        valueField.setColumns(8);
        valueField.setNullAllowed(true);
        return valueField;
    }

    @Override
    public String getGeomName() {
        return Intl.intl("Box");
    }

    @Override
    public guiPanel getPanel() {
        return this;
    }

    @Override
    public void load(Collection<? extends IPyroGeomSrc> collection) {
        UnitDouble[] unitDoubleArray = GeomGuiUtil.getDataVals(collection, new AABoxProp(), 6, Geometry.LU);
        this.d_minX.setValue(unitDoubleArray[0]);
        this.d_minY.setValue(unitDoubleArray[1]);
        this.d_minZ.setValue(unitDoubleArray[2]);
        this.d_maxX.setValue(unitDoubleArray[3]);
        this.d_maxY.setValue(unitDoubleArray[4]);
        this.d_maxZ.setValue(unitDoubleArray[5]);
    }

    @Override
    public void save(Collection<? extends IPyroGeomSrc> collection) {
        UnitDouble[] unitDoubleArray = new UnitDouble[]{(UnitDouble)this.d_minX.getValue(), (UnitDouble)this.d_minY.getValue(), (UnitDouble)this.d_minZ.getValue(), (UnitDouble)this.d_maxX.getValue(), (UnitDouble)this.d_maxY.getValue(), (UnitDouble)this.d_maxZ.getValue()};
        GeomGuiUtil.setDataVals(collection, new AABoxProp(), Geometry.LU, unitDoubleArray);
    }

    public void load(AABoxGeom aABoxGeom) {
        if (aABoxGeom == null) {
            this.d_minX.setValue(null);
            this.d_minY.setValue(null);
            this.d_minZ.setValue(null);
            this.d_maxX.setValue(null);
            this.d_maxY.setValue(null);
            this.d_maxZ.setValue(null);
            return;
        }
        Unit unit = Geometry.LU;
        this.d_minX.setValue(new UnitDouble(aABoxGeom.min.x, unit));
        this.d_minY.setValue(new UnitDouble(aABoxGeom.min.y, unit));
        this.d_minZ.setValue(new UnitDouble(aABoxGeom.min.z, unit));
        this.d_maxX.setValue(new UnitDouble(aABoxGeom.max.x, unit));
        this.d_maxY.setValue(new UnitDouble(aABoxGeom.max.y, unit));
        this.d_maxZ.setValue(new UnitDouble(aABoxGeom.max.z, unit));
    }

    public AABoxGeom save() {
        if (this.d_minX.isEmpty() || this.d_minY.isEmpty() || this.d_minZ.isEmpty() || this.d_maxX.isEmpty() || this.d_maxY.isEmpty() || this.d_maxZ.isEmpty()) {
            return null;
        }
        UnitPoint3D unitPoint3D = new UnitPoint3D((UnitDouble)this.d_minX.getValue(), (UnitDouble)this.d_minY.getValue(), (UnitDouble)this.d_minZ.getValue());
        UnitPoint3D unitPoint3D2 = new UnitPoint3D((UnitDouble)this.d_maxX.getValue(), (UnitDouble)this.d_maxY.getValue(), (UnitDouble)this.d_maxZ.getValue());
        return new AABoxGeom(unitPoint3D.getPoint3dValue(Geometry.LU), unitPoint3D2.getPoint3dValue(Geometry.LU), 0);
    }

    @Override
    public boolean validateData(Collection<? extends IPyroGeomSrc> collection, boolean bl, boolean bl2) {
        if (!this.validate(collection, this.d_minX, this.d_maxX, 0, 3, Intl.intl("X"), bl, bl2)) {
            return false;
        }
        if (!this.validate(collection, this.d_minY, this.d_maxY, 1, 4, Intl.intl("Y"), bl, bl2)) {
            return false;
        }
        return this.validate(collection, this.d_minZ, this.d_maxZ, 2, 5, Intl.intl("Z"), bl, bl2);
    }

    private boolean validate(Collection<? extends IPyroGeomSrc> collection, ValueField valueField, ValueField valueField2, int n, int n2, String string, boolean bl, boolean bl2) {
        String string2 = String.format(Intl.intl("Min %s"), string);
        String string3 = String.format(Intl.intl("Max %s"), string);
        return GeomGuiUtil.validateMinMax(this.getParent(), valueField, valueField2, string2, string3, this.d_equalAllowed, new AABoxProp(), n, n2, collection, bl, bl2);
    }

    static {
        AABoxGeomEditor.FACE_NAMES[0] = Intl.intl("Min X");
        AABoxGeomEditor.FACE_NAMES[1] = Intl.intl("Max X");
        AABoxGeomEditor.FACE_NAMES[2] = Intl.intl("Min Y");
        AABoxGeomEditor.FACE_NAMES[3] = Intl.intl("Max Y");
        AABoxGeomEditor.FACE_NAMES[4] = Intl.intl("Min Z");
        AABoxGeomEditor.FACE_NAMES[5] = Intl.intl("Max Z");
    }

    private class BoxTraversalPolicy
    extends FocusTraversalPolicy {
        private BoxTraversalPolicy() {
        }

        @Override
        public Component getComponentAfter(Container container, Component component) {
            if (component.equals(AABoxGeomEditor.this.d_minX)) {
                return AABoxGeomEditor.this.d_maxX;
            }
            if (component.equals(AABoxGeomEditor.this.d_maxX)) {
                if (AABoxGeomEditor.this.d_minY.isEnabled()) {
                    return AABoxGeomEditor.this.d_minY;
                }
                return AABoxGeomEditor.this.d_minZ;
            }
            if (component.equals(AABoxGeomEditor.this.d_minY)) {
                return AABoxGeomEditor.this.d_maxY;
            }
            if (component.equals(AABoxGeomEditor.this.d_maxY)) {
                if (AABoxGeomEditor.this.d_minZ.isEnabled()) {
                    return AABoxGeomEditor.this.d_minZ;
                }
                return null;
            }
            if (component.equals(AABoxGeomEditor.this.d_minZ)) {
                return AABoxGeomEditor.this.d_maxZ;
            }
            if (component.equals(AABoxGeomEditor.this.d_maxZ)) {
                return null;
            }
            return AABoxGeomEditor.this.d_minX.isEnabled() ? AABoxGeomEditor.this.d_minX : AABoxGeomEditor.this.d_minY;
        }

        @Override
        public Component getComponentBefore(Container container, Component component) {
            if (component.equals(AABoxGeomEditor.this.d_minX)) {
                return null;
            }
            if (component.equals(AABoxGeomEditor.this.d_maxX)) {
                return AABoxGeomEditor.this.d_minX;
            }
            if (component.equals(AABoxGeomEditor.this.d_minY)) {
                if (AABoxGeomEditor.this.d_maxX.isEnabled()) {
                    return AABoxGeomEditor.this.d_maxX;
                }
                return null;
            }
            if (component.equals(AABoxGeomEditor.this.d_maxY)) {
                return AABoxGeomEditor.this.d_minY;
            }
            if (component.equals(AABoxGeomEditor.this.d_minZ)) {
                if (AABoxGeomEditor.this.d_maxY.isEnabled()) {
                    return AABoxGeomEditor.this.d_maxY;
                }
                return AABoxGeomEditor.this.d_maxX;
            }
            if (component.equals(AABoxGeomEditor.this.d_maxZ)) {
                return AABoxGeomEditor.this.d_minZ;
            }
            return AABoxGeomEditor.this.d_minX.isEnabled() ? AABoxGeomEditor.this.d_minX : AABoxGeomEditor.this.d_minY;
        }

        @Override
        public Component getDefaultComponent(Container container) {
            return this.getFirstComponent(container);
        }

        @Override
        public Component getFirstComponent(Container container) {
            if (AABoxGeomEditor.this.d_minX.isEnabled()) {
                return AABoxGeomEditor.this.d_minX;
            }
            return AABoxGeomEditor.this.d_minY;
        }

        @Override
        public Component getLastComponent(Container container) {
            if (AABoxGeomEditor.this.d_maxZ.isEnabled()) {
                return AABoxGeomEditor.this.d_maxZ;
            }
            return AABoxGeomEditor.this.d_maxY;
        }
    }

    private static class AABoxProp
    extends GeomGuiUtil.AGeomProp<AABoxGeom> {
        @Override
        protected AABoxGeom constructGeom(AABoxGeom aABoxGeom, double[] dArray) {
            return new AABoxGeom(new Point3d(dArray[0], dArray[1], dArray[2]), new Point3d(dArray[3], dArray[4], dArray[5]), aABoxGeom.swizzle);
        }

        @Override
        protected double[] saveData(AABoxGeom aABoxGeom) {
            return new double[]{aABoxGeom.min.x, aABoxGeom.min.y, aABoxGeom.min.z, aABoxGeom.max.x, aABoxGeom.max.y, aABoxGeom.max.z};
        }
    }
}

