/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.fds;

import java.awt.Dimension;
import java.awt.Window;
import java.io.File;
import java.sql.Date;
import java.text.DateFormat;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import pyrosim.Intl;
import pyrosim.PyroPrefs;
import pyrosim.domain.ResultsArchive;
import pyrosim.io.IOUtil;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiFileChooser;
import thunderheadeng.gui.guiTFWithButton;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.util.TypedProp;

public class RestoreResultsDlg
extends guiDialog {
    private static final long serialVersionUID = 1209299358363477267L;
    public static final TypedProp<Boolean> PREF_RETAIN = new TypedProp<Boolean>((Object)"RestoreResultsDlg.retainArchive", true);
    private final guiCheckBox d_retainArchiveCB;
    private final guiTable d_recordTbl = guiTableUtil.fixedColumnTable(new String[]{Intl.intl("FDS Results"), Intl.intl("Date Created")}, new Class[]{RecordVal.class, RecordVal.class}, 0, 0, 6);
    private final guiTFWithButton d_dstChooser;
    private final guiFileChooser d_dstDirChooser;

    public RestoreResultsDlg(Window window) {
        super(window, Intl.intl("Restore Archived Results"), 9);
        this.d_recordTbl.setRowSelectionAllowed(true);
        this.d_recordTbl.setColumnSelectionAllowed(false);
        this.d_recordTbl.setColumnEditable(0, false);
        this.d_recordTbl.setColumnEditable(1, false);
        this.d_recordTbl.setPreferredScrollableViewportSize(new Dimension(300, 200));
        this.d_recordTbl.setSelectionMode(0);
        this.d_recordTbl.setSortColumn(1);
        this.d_recordTbl.setSortOrder(2);
        JScrollPane jScrollPane = new JScrollPane(this.d_recordTbl);
        this.d_retainArchiveCB = new guiCheckBox(Intl.intl("Retain selected archive."), true);
        this.d_dstChooser = new guiTFWithButton();
        this.d_dstDirChooser = new guiFileChooser();
        this.d_dstDirChooser.setAcceptAllFileFilterUsed(false);
        this.d_dstDirChooser.setFileSelectionMode(1);
        guiTFWithButton.BrowseFileCmd browseFileCmd = new guiTFWithButton.BrowseFileCmd(this.d_dstChooser.getTextField(), this.d_dstDirChooser);
        this.d_dstChooser.setButtonCommand(browseFileCmd);
        GridBagHelper gridBagHelper = new GridBagHelper(this.getDialogPane());
        gridBagHelper.addRow(Intl.intl("Destination directory:"), this.d_dstChooser, 1.0, 0);
        gridBagHelper.addRow(this.d_retainArchiveCB, 0);
        gridBagHelper.addFilledRow(new TitleSeparator(Intl.intl("Available Archives (choose one)")));
        gridBagHelper.addIdentRow(jScrollPane, new double[]{1.0, 1.0}, new int[]{0, 0});
        gridBagHelper.finalizeRows();
        this.setResizable(true);
    }

    @Override
    public int doModal() {
        this.loadPrefs();
        int n = super.doModal();
        if (n == 1) {
            this.savePrefs();
        }
        return n;
    }

    private void loadPrefs() {
        this.d_retainArchiveCB.setSelected(PyroPrefs.getBoolean(PREF_RETAIN));
    }

    private void savePrefs() {
        PyroPrefs.set(PREF_RETAIN, this.d_retainArchiveCB.isSelected(), true);
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        String string;
        int n;
        if (!super.validateData(bl, bl2)) {
            return false;
        }
        if (this.d_dstChooser.getTextField().getText().trim().isEmpty()) {
            String string2 = Intl.intl("You must specify a destination directory for the restored results.");
            return this.invalidateFld(bl, bl2, this.d_dstChooser.getTextField(), string2);
        }
        int n2 = this.d_recordTbl.getSelectedRow();
        if (n2 == -1) {
            if (bl) {
                RestoreResultsDlg.showInvalidEntryMessage(this, Intl.intl("Select an archive from the table to restore."));
            }
            return false;
        }
        File file = this.getDestinationDir();
        return !file.isDirectory() || IOUtil.listFiles(file).size() <= 0 || !bl || (n = JOptionPane.showConfirmDialog(this, string = Intl.intl("All existing files in the destination directory will be deleted.\nWould you like to continue?"), Intl.intl("Delete Existing Files?"), 0)) == 0;
    }

    public void setDefaultDestination(File file) {
        this.d_dstChooser.getTextField().setText(file.getAbsolutePath());
    }

    public File getDestinationDir() {
        return new File(this.d_dstChooser.getTextField().getText().trim());
    }

    public void load(List<ResultsArchive.Record> list) {
        guiDefaultTableModel guiDefaultTableModel2 = (guiDefaultTableModel)this.d_recordTbl.getModel();
        guiDefaultTableModel2.setRowCount(list.size());
        for (int i = 0; i < list.size(); ++i) {
            ResultsArchive.Record record = list.get(i);
            guiDefaultTableModel2.setValueAt(new RecordVal(record, RecordVal.Type.NAME), i, 0);
            guiDefaultTableModel2.setValueAt(new RecordVal(record, RecordVal.Type.DATE), i, 1);
        }
        this.d_recordTbl.autoSizeColumns(true);
        if (list.size() > 0) {
            this.d_recordTbl.setRowSelectionInterval(0, 0);
            this.d_recordTbl.setColumnSelectionInterval(0, 1);
        }
    }

    public boolean getRetainArchive() {
        return this.d_retainArchiveCB.isSelected();
    }

    public ResultsArchive.Record getSelectedRecord() {
        RecordVal recordVal = (RecordVal)this.d_recordTbl.getValueAt(this.d_recordTbl.getSelectedRow(), 0);
        return recordVal.record;
    }

    private static class RecordVal
    implements Comparable<RecordVal> {
        public final Type field;
        public final ResultsArchive.Record record;

        public RecordVal(ResultsArchive.Record record, Type type) {
            this.field = type;
            this.record = record;
        }

        @Override
        public int compareTo(RecordVal recordVal) {
            switch (this.field) {
                case DATE: {
                    return Long.signum(this.record.dateCreated - recordVal.record.dateCreated);
                }
                case NAME: {
                    return this.record.name.compareToIgnoreCase(recordVal.record.name);
                }
            }
            return 0;
        }

        public String toString() {
            switch (this.field) {
                case DATE: {
                    Date date = new Date(this.record.dateCreated);
                    return DateFormat.getDateTimeInstance(3, 3).format(date);
                }
                case NAME: {
                    return this.record.name;
                }
            }
            return super.toString();
        }

        public static enum Type {
            DATE,
            NAME;

        }
    }
}

