/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.fds;

import java.awt.Window;
import pyrosim.Intl;
import pyrosim.PyroPrefs;
import pyrosim.domain.ResultsArchive;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.util.TypedProp;

public class ArchiveResultsDlg
extends guiDialog {
    private static final long serialVersionUID = -3281200301754176316L;
    public static final TypedProp<Boolean> PREF_RETAIN = new TypedProp<Boolean>((Object)"ArchiveResultsDlg.retainResults", true);
    public static final TypedProp<Integer> PREF_METHOD = new TypedProp<Integer>((Object)"ArchiveResultsDlg.method", 0);
    public static final TypedProp<Integer> PREF_COMPRESSION = new TypedProp<Integer>((Object)"ArchiveResultsDlg.compression", 10);
    private final guiTextField d_nameFld = new guiTextField();
    private final guiCheckBox d_retainOldCB;
    private final guiCheckBox d_compressCB;

    public ArchiveResultsDlg(Window window) {
        super(window, Intl.intl("Archive FDS Results"), 9);
        this.d_nameFld.setColumns(30);
        this.d_retainOldCB = new guiCheckBox(Intl.intl("Retain current results"), true);
        this.d_compressCB = new guiCheckBox(Intl.intl("Compress to a ZIP file"), true);
        GridBagHelper gridBagHelper = new GridBagHelper(this.getDialogPane());
        gridBagHelper.addRow(Intl.intl("Archive name:"), this.d_nameFld, 1.0, 0);
        gridBagHelper.addRow(this.d_retainOldCB, 0);
        gridBagHelper.addRow(this.d_compressCB, 0);
        gridBagHelper.finalizeRows();
    }

    @Override
    public int doModal() {
        this.loadPrefs();
        int n = super.doModal();
        if (n == 1) {
            this.savePrefs();
        }
        return n;
    }

    private void loadPrefs() {
        this.d_retainOldCB.setSelected(PyroPrefs.getBoolean(PREF_RETAIN));
        int n = PyroPrefs.getInt(PREF_METHOD);
        this.d_compressCB.setSelected(n != 0);
    }

    private void savePrefs() {
        PyroPrefs.set(PREF_RETAIN, this.d_retainOldCB.isSelected(), false);
        PyroPrefs.set(PREF_METHOD, this.d_compressCB.isSelected() ? 2 : 0, true);
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        if (!super.validateData(bl, bl2)) {
            return false;
        }
        if (this.d_nameFld.getText().trim().isEmpty()) {
            return this.invalidateFld(bl, bl2, this.d_nameFld, Intl.intl("You must specify an archive name."));
        }
        return true;
    }

    @Override
    public void setName(String string) {
        this.d_nameFld.setText(string);
    }

    @Override
    public String getName() {
        return this.d_nameFld.getText();
    }

    public ResultsArchive.IMethod getMethod() {
        return this.d_compressCB.isSelected() ? ResultsArchive.COMPRESSED : ResultsArchive.DIRECTORY;
    }

    public Object getOptions() {
        int n = PyroPrefs.getInt(PREF_COMPRESSION) - 1;
        if (n < 0 || n > 9) {
            n = 9;
        }
        return this.d_compressCB.isSelected() ? new ResultsArchive.CompressedOptions(n) : null;
    }

    public boolean getRetainCurrentResults() {
        return this.d_retainOldCB.isSelected();
    }
}

