/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JTabbedPane;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.domain.devices.detectors.SprinklerLinkModelMgr;
import pyrosim.gui.CustomFDSPanel;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiConstUnitDoubleField;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AOneTimeTask;

public class SprinklerLinkModelPanel
extends guiPanel
implements IEditor<SprinklerLinkModel> {
    private static final long serialVersionUID = -3162190571986760271L;
    private final SprinklerLinkModelMgr d_sprinklerLMMgr;
    private final guiDialog d_parent;
    private final UnitSystem d_currentUS;
    private final guiCheckBox d_initTempCB;
    private final ValueField<UnitDouble> d_initTemp;
    private final ValueField<UnitDouble> d_activTemp;
    private final guiConstUnitDoubleField d_respTimeInd;
    private final guiConstUnitDoubleField d_cFactor;
    private final CustomFDSPanel d_customPnl;
    private final guiTextField d_name;
    private final guiTextField d_fyi;

    public SprinklerLinkModelPanel(guiDialog guiDialog2) {
        PyroSim pyroSim = PyroSim.getApp();
        PyroMod pyroMod = pyroSim.getMediator();
        this.d_sprinklerLMMgr = pyroMod.getSprinklerLinkModels();
        this.d_currentUS = pyroSim.getUnitSystem();
        this.d_parent = guiDialog2;
        this.d_name = new guiTextField();
        this.d_name.setEditable(false);
        this.d_fyi = new guiTextField();
        this.d_customPnl = new CustomFDSPanel(6);
        this.d_initTempCB = new guiCheckBox(Intl.intl("Initial Temperature") + ":");
        this.d_initTemp = ValueFields.udFld(UnitSystem.getSource(1));
        this.d_activTemp = ValueFields.udFld(UnitSystem.getSource(1));
        this.d_respTimeInd = new guiConstUnitDoubleField(UnitSystem.getSource(3).getUnit());
        this.d_cFactor = new guiConstUnitDoubleField(UnitSystem.getSource(60).getUnit());
        guiLabel guiLabel2 = new guiLabel(Intl.intl("Activation Temperature") + ":");
        guiLabel guiLabel3 = new guiLabel(Intl.intl("Response Time Index") + ":");
        guiLabel guiLabel4 = new guiLabel(Intl.intl("C Factor") + ":");
        guiLabel guiLabel5 = new guiLabel(this.d_respTimeInd.getUnit().toString());
        guiLabel guiLabel6 = new guiLabel(this.d_cFactor.getUnit().toString());
        guiPanel guiPanel2 = new guiPanel(new GridBagLayout());
        int n = 0;
        GridBagUtil.add(guiPanel2, new guiLabel(Intl.intl("Sprinkler Link Model ID") + ":"), 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_name, 1, n++, 3, 1, 0, 0, 6, 1, 2, 1.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, new guiLabel(Intl.intl("Description") + ":"), 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_fyi, 1, n++, 3, 1, 0, 0, 6, 1, 2, 1.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_initTempCB, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_initTemp, 1, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, guiLabel2, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_activTemp, 1, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, guiLabel3, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_respTimeInd, 1, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, guiLabel5, 2, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, guiLabel4, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_cFactor, 1, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, guiLabel6, 2, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.addGlue(guiPanel2);
        LinkStatus.link((AbstractButton)this.d_initTempCB, this.d_initTemp);
        guiPanel2.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(Intl.intl("Properties"), guiPanel2);
        jTabbedPane.addTab(Intl.intl("Advanced"), this.d_customPnl);
        this.add((Component)jTabbedPane, "Center");
        this.init(new SprinklerLinkModel(""));
        this.setEnabled(false);
        this.setModified(false);
    }

    @Override
    public SprinklerLinkModel commit(final SprinklerLinkModel sprinklerLinkModel) {
        AOneTimeTask aOneTimeTask = new AOneTimeTask(){

            @Override
            public void run() {
                SprinklerLinkModelPanel.this.save(sprinklerLinkModel);
            }
        };
        PyroSim.getApp().getMediator().getTaskManager().exec(aOneTimeTask, Intl.intl("Edit Sprinkler Link Model"));
        this.setModified(false);
        return sprinklerLinkModel;
    }

    @Override
    public SprinklerLinkModel preview(SprinklerLinkModel sprinklerLinkModel) {
        this.save(sprinklerLinkModel);
        return sprinklerLinkModel;
    }

    private void save(SprinklerLinkModel sprinklerLinkModel) {
        sprinklerLinkModel.setFYI(this.d_fyi.getText());
        UnitDouble unitDouble = null;
        if (this.d_initTempCB.isSelected()) {
            unitDouble = (UnitDouble)this.d_initTemp.getValue();
        }
        sprinklerLinkModel.setCFactor((UnitDouble)this.d_cFactor.getValue());
        sprinklerLinkModel.setActivationTemp((UnitDouble)this.d_activTemp.getValue());
        sprinklerLinkModel.setRti((UnitDouble)this.d_respTimeInd.getValue());
        sprinklerLinkModel.setInitialTemp(unitDouble);
        this.d_customPnl.save(sprinklerLinkModel);
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    @Override
    public void init(SprinklerLinkModel sprinklerLinkModel) {
        this.setEnabled(sprinklerLinkModel != null);
        if (sprinklerLinkModel != null) {
            this.d_name.setText(sprinklerLinkModel.getName());
            this.d_fyi.setText(sprinklerLinkModel.getFYI());
            if (sprinklerLinkModel.getInitialTemp() != null) {
                this.d_initTempCB.setSelected(true);
                this.d_initTemp.setValue(sprinklerLinkModel.getInitialTemp());
            } else {
                this.d_initTempCB.setSelected(false);
                this.d_initTemp.setValue(new UnitDouble(20.0, SI.CELSIUS));
            }
            this.d_activTemp.setValue(sprinklerLinkModel.getActivationTemp());
            this.d_respTimeInd.setValue(sprinklerLinkModel.getRti());
            this.d_cFactor.setValue(sprinklerLinkModel.getCFactor());
            this.d_customPnl.load(sprinklerLinkModel);
        }
        this.setModified(false);
    }
}

