/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.event.ListSelectionEvent;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.domain.devices.detectors.SprinklerLinkModelMgr;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.gui.ManagerDlg;
import pyrosim.gui.RenameAction;
import pyrosim.gui.devices.NewSprinklerLinkModelDlg;
import pyrosim.gui.devices.SprinklerLinkModelPanel;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiAction;

public class SprinklerLinkModelManagerDlg
extends ManagerDlg {
    private static final long serialVersionUID = -9183950827654889044L;
    private final Action[] d_actions;
    private final IEditor d_editor;
    private SprinklerLinkModelMgr d_sprinklerMgr;
    private JFrame d_owner;

    public SprinklerLinkModelManagerDlg(JFrame jFrame) {
        super(jFrame, Intl.intl("Sprinkler Link Models"), true);
        this.d_owner = jFrame;
        this.d_actions = new Action[]{new NewAction(), new ManagerDlg.LibraryAction(SprinklerLinkModel.class), new RenameAction(this, Intl.intl("sprinkler link model")), new ManagerDlg.DeleteAction()};
        this.d_editor = new SprinklerLinkModelPanel(this);
        this.setPreviewTypes("PROP", "RAMP");
    }

    private void updateActions() {
        int n = this.getList().getSelectedIx();
        this.d_actions[0].setEnabled(this.d_sprinklerMgr != null);
        this.d_actions[2].setEnabled(this.d_sprinklerMgr != null && n > -1);
        this.d_actions[3].setEnabled(this.d_sprinklerMgr != null && n > -1);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        super.valueChanged(listSelectionEvent);
        this.updateActions();
    }

    public void init(SprinklerLinkModelMgr sprinklerLinkModelMgr, SprinklerLinkModel sprinklerLinkModel) {
        this.d_sprinklerMgr = sprinklerLinkModelMgr;
        ((RenameAction)this.d_actions[2]).init(sprinklerLinkModelMgr);
        super.init(this.d_sprinklerMgr, this.d_editor, this.d_actions, sprinklerLinkModel);
        this.updateActions();
    }

    private class NewAction
    extends guiAction {
        private static final long serialVersionUID = 9154714627772565686L;

        public NewAction() {
            super(Intl.intl("New") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!SprinklerLinkModelManagerDlg.this.preSave()) {
                return;
            }
            PyroMod pyroMod = (PyroMod)SprinklerLinkModelManagerDlg.this.d_sprinklerMgr.getDomain();
            NewSprinklerLinkModelDlg newSprinklerLinkModelDlg = new NewSprinklerLinkModelDlg(pyroMod);
            if (newSprinklerLinkModelDlg.doModal() == 1) {
                SprinklerLinkModel sprinklerLinkModel = new SprinklerLinkModel(newSprinklerLinkModelDlg.getSprinklerLinkName());
                AddTask addTask = new AddTask((IPyroObject)SprinklerLinkModelManagerDlg.this.d_sprinklerMgr, new IPyroObject[]{sprinklerLinkModel});
                SelectTask selectTask = new SelectTask(pyroMod, sprinklerLinkModel);
                selectTask.addTask(addTask);
                pyroMod.getTaskManager().exec(selectTask, Intl.intl("New Sprinkler Link Model"));
                SprinklerLinkModelManagerDlg.this.getList().updateModelView(SprinklerLinkModelManagerDlg.this.d_sprinklerMgr);
                SprinklerLinkModelManagerDlg.this.getList().select(sprinklerLinkModel);
                SprinklerLinkModelManagerDlg.this.d_editor.getEditorPanel().setModified(false);
                SprinklerLinkModelManagerDlg.this.updateActions();
            }
        }
    }
}

