/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.devices.detectors.SprinklerLink;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.comboboxes.SprinklerLinkModelComboBox;
import pyrosim.gui.devices.ADevcEditor;
import pyrosim.gui.geom.FreePointGeomEditor;
import pyrosim.gui.geom.IGeomEditor;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;

public class SprinklerLinkEditor
extends ADevcEditor<SprinklerLink> {
    private final SprinklerLinkDataPanel d_dataPanel;

    public SprinklerLinkEditor(PyroMod pyroMod) {
        this.d_dataPanel = new SprinklerLinkDataPanel(pyroMod);
    }

    @Override
    public String getDesc() {
        return Intl.intl("Sprinkler Link");
    }

    @Override
    public String getDefName() {
        return Intl.intl("SLINK");
    }

    @Override
    public IGeomEditor<? extends IGeom> createGeomEditor() {
        return new FreePointGeomEditor();
    }

    @Override
    public guiPanel getDataPanel() {
        return this.d_dataPanel;
    }

    @Override
    public boolean validateData(Component component, SprinklerLink sprinklerLink, boolean bl, boolean bl2) {
        return true;
    }

    @Override
    public SprinklerLink create() {
        return new SprinklerLink("", this.d_dataPanel.getSprinklerLinkModel(), new FreePointLoc());
    }

    @Override
    public void load(SprinklerLink sprinklerLink) {
        this.d_dataPanel.setSprinklerLinkModel(sprinklerLink.getModel());
    }

    @Override
    public void save(SprinklerLink sprinklerLink) {
        sprinklerLink.setModel(this.d_dataPanel.getSprinklerLinkModel());
    }

    public static class SprinklerLinkDataPanel
    extends guiPanel {
        private static final long serialVersionUID = 7485619082615631763L;
        private final guiComboBox<SprinklerLinkModel> d_typeCombo;

        public SprinklerLinkDataPanel(PyroMod pyroMod) {
            this.setLayout(new GridBagLayout());
            this.d_typeCombo = new SprinklerLinkModelComboBox(pyroMod.getSprinklerLinkModels());
            this.d_typeCombo.setMinimumSize(this.d_typeCombo.getPreferredSize());
            JButton jButton = new JButton(Intl.intl("Edit") + "...");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Actions.editSprinklerLinkModels((SprinklerLinkModel)d_typeCombo.getSelectedItem());
                    if (d_typeCombo.getSelectedItem() == null && d_typeCombo.getItemCount() > 0) {
                        d_typeCombo.setSelectedIndex(0);
                    }
                }
            });
            GridBagHelper gridBagHelper = new GridBagHelper(this);
            gridBagHelper.addRow(Intl.intl("Type:"), this.d_typeCombo, jButton, 0);
            gridBagHelper.finalizeRows();
        }

        public SprinklerLinkModel getSprinklerLinkModel() {
            return this.d_typeCombo.getSelectedItem();
        }

        public void setSprinklerLinkModel(SprinklerLinkModel sprinklerLinkModel) {
            this.d_typeCombo.setSelectedItem(sprinklerLinkModel);
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            if (!super.validateData(bl, bl2)) {
                return false;
            }
            if (this.d_typeCombo.getSelectedItem() == null) {
                if (bl) {
                    guiDialog.showInvalidEntryMessage(this, Intl.intl("Please choose a type."));
                }
                if (bl2) {
                    this.d_typeCombo.requestFocus();
                }
                return false;
            }
            return true;
        }
    }
}

