/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.devices.detectors.SprinklerLinkModel;
import pyrosim.domain.devices.sprayers.DryPipe;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.devices.sprayers.Sprinkler;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.comboboxes.DryPipeComboBox;
import pyrosim.gui.comboboxes.QuantityComboBox;
import pyrosim.gui.comboboxes.SprayModelComboBox;
import pyrosim.gui.comboboxes.SprinklerLinkModelComboBox;
import pyrosim.gui.devices.ADevcEditor;
import pyrosim.gui.geom.FreePointGeomEditor;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.units.IUnitSrc;
import thunderheadeng.units.UnitDouble;

public class SprinklerEditor
extends ADevcEditor<Sprinkler> {
    private final SprinklerDataPanel d_sprinklerDataPanel;

    public SprinklerEditor(PyroMod pyroMod) {
        this.d_sprinklerDataPanel = new SprinklerDataPanel(pyroMod);
    }

    @Override
    public String getDesc() {
        return Intl.intl("Sprinkler");
    }

    @Override
    public String getDefName() {
        return Intl.intl("SPRK");
    }

    @Override
    public IGeomEditor<? extends IGeom> createGeomEditor() {
        return new FreePointGeomEditor();
    }

    @Override
    public guiPanel getDataPanel() {
        return this.d_sprinklerDataPanel;
    }

    @Override
    public boolean validateData(Component component, Sprinkler sprinkler, boolean bl, boolean bl2) {
        return true;
    }

    @Override
    public Set<String> getFDSPreviewTypes() {
        HashSet<String> hashSet = new HashSet<String>(super.getFDSPreviewTypes());
        hashSet.add("PROP");
        hashSet.add("CTRL");
        return hashSet;
    }

    @Override
    public Sprinkler create() {
        return new Sprinkler("", this.d_sprinklerDataPanel.getSprayModel(), this.d_sprinklerDataPanel.getLinkModel(), new FreePointLoc());
    }

    @Override
    public void load(Sprinkler sprinkler) {
        this.d_sprinklerDataPanel.setSprayModel(sprinkler.getSprayModel());
        this.d_sprinklerDataPanel.setLinkModel(sprinkler.getLinkModel());
        this.d_sprinklerDataPanel.setPipe(sprinkler.getDryPipe());
    }

    @Override
    public void save(Sprinkler sprinkler) {
        UnitSystem unitSystem = PyroSim.getApp().getUnitSystem();
        Sprinkler.LinkModel linkModel = this.d_sprinklerDataPanel.getLinkModel();
        sprinkler.setLinkModel(linkModel, unitSystem.getUnit(linkModel.getOutputQuantity().get().unitType));
        sprinkler.setSprayModel(this.d_sprinklerDataPanel.getSprayModel());
        sprinkler.setDryPipe(this.d_sprinklerDataPanel.getPipe());
    }

    public static class SprinklerDataPanel
    extends guiPanel {
        private static final long serialVersionUID = -555686495219689805L;
        private UnitSystem d_currentUS = ((PyroSim)Application.getApp()).getUnitSystem();
        private final LinkModelPanel d_linkModPnl;
        private final SprayModelComboBox d_sprayCombo;
        private final guiComboBox<DryPipe> d_dryPipeCombo;

        public SprinklerDataPanel(final PyroMod pyroMod) {
            this.setLayout(new GridBagLayout());
            int n = 0;
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Spray Model") + ":");
            this.d_sprayCombo = new SprayModelComboBox(pyroMod.getSprayModels());
            JButton jButton = new JButton(Intl.intl("Edit") + "...");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Actions.editSprayModel((SprayModel)d_sprayCombo.getSelectedItem());
                    if (d_sprayCombo.getSelectedItem() == null && d_sprayCombo.getItemCount() > 0) {
                        this.selectDefault(pyroMod);
                    }
                }
            });
            this.selectDefault(pyroMod);
            guiLabel guiLabel3 = new guiLabel(Intl.intl("Dry Pipe:"));
            this.d_dryPipeCombo = new DryPipeComboBox(pyroMod.getDevices());
            JButton jButton2 = new JButton(Intl.intl("New..."));
            jButton2.addActionListener(Actions.NEW_DRY_PIPE_ACTION);
            TitleSeparator titleSeparator = new TitleSeparator(Intl.intl("Activator"));
            this.d_linkModPnl = new LinkModelPanel(pyroMod);
            GridBagUtil.add(this, guiLabel2, 0, ++n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_sprayCombo, 1, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, jButton, 2, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel3, 0, ++n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_dryPipeCombo, 1, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, jButton2, 2, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, titleSeparator, 0, ++n, 3, 1, 0, 0, 6, 0, 2, 1.0, 0.0, 17);
            GridBagUtil.add(this, this.d_linkModPnl, 0, ++n, 3, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
        }

        private void selectDefault(PyroMod pyroMod) {
            SprayModel sprayModel = pyroMod.getSprayModels().getDefaultWaterSpray(pyroMod.getPartList());
            if (sprayModel != null) {
                this.d_sprayCombo.setSelectedItem(sprayModel);
            } else {
                this.d_sprayCombo.selectFirstOfType(Particle.Type.LIQUID);
            }
        }

        public SprayModel getSprayModel() {
            return (SprayModel)this.d_sprayCombo.getSelectedItem();
        }

        public void setSprayModel(SprayModel sprayModel) {
            this.d_sprayCombo.setSelectedItem(sprayModel);
        }

        public DryPipe getPipe() {
            return this.d_dryPipeCombo.getSelectedItem();
        }

        public void setPipe(DryPipe dryPipe) {
            this.d_dryPipeCombo.setSelectedItem(dryPipe);
        }

        public Sprinkler.LinkModel getLinkModel() {
            return this.d_linkModPnl.save();
        }

        public void setLinkModel(Sprinkler.LinkModel linkModel) {
            this.d_linkModPnl.load(linkModel);
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            if (!super.validateData(bl, bl2)) {
                return false;
            }
            if (this.d_sprayCombo.getSelectedItem() == null) {
                if (bl) {
                    guiDialog.showInvalidEntryMessage(this, Intl.intl("Please choose a spray model."));
                }
                if (bl2) {
                    this.d_sprayCombo.requestFocus();
                }
                return false;
            }
            return true;
        }
    }

    public static class LinkModelPanel
    extends guiPanel {
        private static final long serialVersionUID = 1109286038572904723L;
        private final guiRadioButton d_tradRB;
        private final guiComboBox<SprinklerLinkModel> d_linkCombo;
        private final guiRadioButton d_quantRB;
        private final guiComboBox<IQuantity> d_msrCombo;
        private final ValueField<UnitDouble> d_setpointFld;
        private final guiCheckBox d_triggerOnceCB = new guiCheckBox(Intl.intl("Trigger Only Once"));
        private final guiCheckBox d_initOnCB = new guiCheckBox(Intl.intl("Initially Activated"));

        public LinkModelPanel(PyroMod pyroMod) {
            super(new GridBagLayout());
            this.d_tradRB = new guiRadioButton(Intl.intl("Temperature Link:"));
            this.d_linkCombo = new SprinklerLinkModelComboBox(pyroMod.getSprinklerLinkModels());
            JButton jButton = new JButton(Intl.intl("Edit..."));
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Actions.editSprinklerLinkModels((SprinklerLinkModel)d_linkCombo.getSelectedItem());
                    if (d_linkCombo.getSelectedItem() == null && d_linkCombo.getItemCount() > 0) {
                        d_linkCombo.setSelectedIndex(0);
                    }
                }
            });
            LinkStatus.link((AbstractButton)this.d_tradRB, this.d_linkCombo, jButton);
            this.d_quantRB = new guiRadioButton(Intl.intl("Quantity:"));
            Predicate<Quantity> predicate = Sprinkler.QuantityModel.getQuantityFilter();
            this.d_msrCombo = new QuantityComboBox(predicate);
            this.d_setpointFld = ValueFields.udFld(UnitSystem.getSource(28));
            this.d_msrCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        IQuantity iQuantity = (IQuantity)d_msrCombo.getSelectedItem();
                        IUnitSrc iUnitSrc = UnitSystem.getSource(iQuantity.get().unitType);
                        ValueFields.setUnitSource(d_setpointFld, iUnitSrc);
                    }
                }
            });
            LinkStatus.link((AbstractButton)this.d_quantRB, this.d_msrCombo, this.d_setpointFld);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.d_tradRB);
            buttonGroup.add(this.d_quantRB);
            GridBagHelper gridBagHelper = new GridBagHelper(this);
            gridBagHelper.addRow(this.d_tradRB, this.d_linkCombo, 1.0, jButton, 0);
            gridBagHelper.addRow(this.d_quantRB, this.d_msrCombo, 1.0, this.d_setpointFld, 0);
            gridBagHelper.addRow(this.d_triggerOnceCB, 0);
            gridBagHelper.addRow(this.d_initOnCB, 0);
            gridBagHelper.finalizeRows();
            this.d_tradRB.setSelected(true);
            this.d_msrCombo.setSelectedItem(Quantity.TEMPERATURE.create());
            this.d_setpointFld.setValue(new UnitDouble(74.0, SI.CELSIUS));
            this.d_triggerOnceCB.setSelected(true);
        }

        public void load(Sprinkler.LinkModel linkModel) {
            if (linkModel instanceof Sprinkler.TraditionalModel) {
                this.d_tradRB.setSelected(true);
                this.d_linkCombo.setSelectedItem(((Sprinkler.TraditionalModel)linkModel).d_link);
            } else {
                Sprinkler.QuantityModel quantityModel = (Sprinkler.QuantityModel)linkModel;
                this.d_quantRB.setSelected(true);
                this.d_msrCombo.setSelectedItem(quantityModel.d_quantity);
                this.d_setpointFld.setValue(quantityModel.d_setPoint);
            }
            this.d_initOnCB.setSelected(linkModel.d_initState);
            this.d_triggerOnceCB.setSelected(linkModel.d_latch);
        }

        public Sprinkler.LinkModel save() {
            boolean bl = this.d_initOnCB.isSelected();
            boolean bl2 = this.d_triggerOnceCB.isSelected();
            if (this.d_tradRB.isSelected()) {
                return new Sprinkler.TraditionalModel(this.d_linkCombo.getSelectedItem(), bl, bl2);
            }
            return new Sprinkler.QuantityModel(this.d_msrCombo.getSelectedItem(), (UnitDouble)this.d_setpointFld.getValue(), bl, bl2);
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            if (!super.validateData(bl, bl2)) {
                return false;
            }
            if (this.d_tradRB.isSelected() && this.d_linkCombo.getSelectedItem() == null) {
                if (bl) {
                    guiDialog.showInvalidEntryMessage(this, Intl.intl("Please choose a link model."));
                }
                if (bl2) {
                    this.d_linkCombo.requestFocus();
                }
                return false;
            }
            return true;
        }
    }
}

