/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.table.TableModel;
import org.jscience.physics.units.NonSI;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.devices.sprayers.SprayModelMgr;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.ramp.IRampInput;
import pyrosim.domain.ramp.Ramp;
import pyrosim.gui.CustomFDSPanel;
import pyrosim.gui.RampFuncDlg;
import pyrosim.gui.TimeFunctionEditor;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.comboboxes.ParticleComboBox;
import pyrosim.legacy_2012_1.thunderheadeng.gui.guiButtonGroup;
import pyrosim.unitsystem.SIUS;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiRadioButton;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.gui.table.ResizableTableModel;
import thunderheadeng.gui.table.guiDefaultTableModel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.gui.table.guiTableUtil;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AOneTimeTask;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.Global;
import thunderheadeng.util.IntVR;
import thunderheadeng.util.theUtil;

public class SprayModelPanel
extends guiPanel
implements IEditor<SprayModel> {
    private static final long serialVersionUID = 2985983426945539248L;
    private final UnitSystem d_currentUS = ((PyroSim)Application.getApp()).getUnitSystem();
    private final SprayModelMgr d_sprayMgr;
    private final guiTextField d_sprayID;
    private final guiTextField d_fyi;
    private final ParticleComboBox d_particleCombo;
    private final FlowRatePanel d_flowRatePanel;
    private final JetStreamPanel d_jetPanel;
    private final MiscPanel d_miscPanel;
    private final CustomFDSPanel d_customPanel;
    private final guiDialog d_parent;
    private final JTabbedPane d_tabs;

    public SprayModelPanel(guiDialog guiDialog2) {
        PyroSim pyroSim = PyroSim.getApp();
        PyroMod pyroMod = pyroSim.getMediator();
        this.d_sprayMgr = pyroMod.getSprayModels();
        this.d_parent = guiDialog2;
        guiLabel guiLabel2 = new guiLabel(Intl.intl("Ejected Particle") + ":");
        this.d_sprayID = new guiTextField();
        this.d_sprayID.setEditable(false);
        guiLabel guiLabel3 = new guiLabel(Intl.intl("Description:"));
        this.d_fyi = new guiTextField();
        this.d_particleCombo = new ParticleComboBox(PyroSim.getApp().getMediator().getPartList());
        this.d_particleCombo.setFilter(SprayModel.getParticleFilter());
        JButton jButton = new JButton(Intl.intl("Edit Particles") + "...");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Actions.editParticles((Particle)SprayModelPanel.this.d_particleCombo.getSelectedItem());
                if (SprayModelPanel.this.d_particleCombo.getSelectedItem() == null && SprayModelPanel.this.d_particleCombo.getItemCount() > 0) {
                    SprayModelPanel.this.d_particleCombo.setSelectedIndex(0);
                }
            }
        });
        this.d_customPanel = new CustomFDSPanel(6);
        this.setLayout(new GridBagLayout());
        int n = 0;
        GridBagUtil.add(this, new guiLabel(Intl.intl("Spray Model ID") + ":"), 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_sprayID, 1, n++, 3, 1, 0, 0, 6, 1, 2, 1.0, 0.0, 17);
        GridBagUtil.add(this, guiLabel3, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_fyi, 1, n++, 3, 1, 0, 0, 6, 1, 2, 1.0, 0.0, 17);
        this.d_flowRatePanel = new FlowRatePanel();
        this.d_jetPanel = new JetStreamPanel();
        this.d_miscPanel = new MiscPanel();
        GridBagUtil.add(this, guiLabel2, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(this, this.d_particleCombo, 1, n, 1, 1, 0, 0, 6, 12, 2, 0.0, 0.0, 17);
        GridBagUtil.add(this, jButton, 2, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        this.d_tabs = new JTabbedPane();
        this.d_tabs.addTab(Intl.intl("Flow Rate"), this.d_flowRatePanel);
        this.d_tabs.addTab(Intl.intl("Jet Streams"), this.d_jetPanel);
        this.d_tabs.addTab(Intl.intl("Misc"), this.d_miscPanel);
        this.d_tabs.addTab(Intl.intl("Advanced"), this.d_customPanel);
        GridBagUtil.add(this, this.d_tabs, 0, n++, 3, 1, 0, 0, 0, 0, 2, 1.0, 0.0, 17);
        this.loadSpray(new SprayModel("", null));
        this.setEnabled(false);
        this.setModified(false);
    }

    @Override
    public SprayModel preview(SprayModel sprayModel) {
        this.saveSprayModel(sprayModel);
        return sprayModel;
    }

    @Override
    public SprayModel commit(final SprayModel sprayModel) {
        AOneTimeTask aOneTimeTask = new AOneTimeTask(){

            @Override
            public void run() {
                SprayModelPanel.this.saveSprayModel(sprayModel);
            }
        };
        PyroSim.getApp().getMediator().getTaskManager().exec(aOneTimeTask, Intl.intl("Edit Spray Model"));
        this.setModified(false);
        return sprayModel;
    }

    private void saveSprayModel(SprayModel sprayModel) {
        sprayModel.setFYI(this.d_fyi.getText());
        sprayModel.setParticle((Particle)this.d_particleCombo.getSelectedItem());
        sprayModel.setFlowRate(this.d_flowRatePanel.save());
        sprayModel.setDropsPerSecond(this.d_miscPanel.getDropsPerSec());
        sprayModel.setJets(this.d_jetPanel.saveJets());
        sprayModel.setSprayOffset(this.d_jetPanel.saveOffset());
        this.d_customPanel.save(sprayModel);
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    @Override
    public void init(SprayModel sprayModel) {
        this.setEnabled(sprayModel != null);
        if (sprayModel != null) {
            this.loadSpray(sprayModel);
            this.d_sprayID.setText(sprayModel.getName());
        }
        this.setModified(false);
    }

    public void loadSpray(SprayModel sprayModel) {
        this.d_fyi.setText(sprayModel.getFYI());
        this.d_flowRatePanel.load(sprayModel.getFlowRate());
        this.d_jetPanel.load(sprayModel.getSprayOffset(), sprayModel.getJets());
        this.d_miscPanel.setDropsPerSec(sprayModel.getDropsPerSecond());
        if (sprayModel.getParticle() != null) {
            this.d_particleCombo.setSelectedItem(sprayModel.getParticle());
        }
        this.d_customPanel.load(sprayModel);
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        if (!super.validateData(bl, bl2)) {
            return false;
        }
        if (this.d_particleCombo.getSelectedItem() == null) {
            if (bl) {
                guiDialog.showInvalidEntryMessage(this.d_parent, Intl.intl("An ejected particle is required."));
            }
            if (bl2) {
                this.d_particleCombo.requestFocus();
            }
            return false;
        }
        if (((Particle)this.d_particleCombo.getSelectedItem()).isType(Particle.Type.TRACER)) {
            if (bl) {
                guiDialog.showInvalidEntryMessage(this.d_parent, Intl.intl("The ejected particle cannot be massless."));
            }
            if (bl2) {
                this.d_particleCombo.requestFocus();
            }
            return false;
        }
        return true;
    }

    public class MiscPanel
    extends guiPanel {
        private static final long serialVersionUID = -7925071800912542524L;
        private ValueField<Integer> d_fldDropsPerSec;

        public MiscPanel() {
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Droplets Per Second:"));
            this.d_fldDropsPerSec = ValueFields.intFld(1, IntVR.above(0, false));
            String string = Intl.intl("DROPLETS_PER_SECOND does not affect flow rate.");
            guiLabel2.setToolTipText(string);
            this.d_fldDropsPerSec.setToolTipText(string);
            this.setLayout(new GridBagLayout());
            GridBagHelper gridBagHelper = new GridBagHelper(this);
            gridBagHelper.addRow(guiLabel2, this.d_fldDropsPerSec);
            gridBagHelper.finalizeRows();
            this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        }

        public int getDropsPerSec() {
            return (Integer)this.d_fldDropsPerSec.getValue();
        }

        public void setDropsPerSec(int n) {
            this.d_fldDropsPerSec.setValue(n);
        }
    }

    public class FlowRatePanel
    extends guiPanel {
        private static final long serialVersionUID = 4448634972603632940L;
        private final guiRadioButton d_specifyRB;
        private final guiRadioButton d_calculateRB;
        private final guiRadioButton d_varyingRB;
        private final ValueField<UnitDouble> d_pressure;
        private final ValueField<UnitDouble> d_kFactor;
        private final ValueField<UnitDouble> d_flowRate;
        private final JButton d_pressureRampBtn;
        private final guiCheckBox d_varyPressureCB;
        private final ValueField<UnitDouble> d_varyPressure;
        private final guiCheckBox d_varyKFactorCB;
        private final ValueField<UnitDouble> d_varyKFactor;
        private final guiCheckBox d_varyFlowrateCB;
        private final ValueField<UnitDouble> d_varyFlowRate;
        private final guiLabel d_varyCountLbl;
        private Ramp d_currPressureRamp;
        private final guiLabel d_flowCalcLab;
        private final TimeFunctionEditor d_rampTimeEditor;

        public FlowRatePanel() {
            this.setLayout(new GridBagLayout());
            int n = 0;
            SprayModel.ExplicitFlowRate explicitFlowRate = new SprayModel.ExplicitFlowRate();
            SprayModel.PressurizedFlowRate pressurizedFlowRate = new SprayModel.PressurizedFlowRate();
            this.d_specifyRB = new guiRadioButton(Intl.intl("Specify") + ":");
            this.d_calculateRB = new guiRadioButton(Intl.intl("Calculate"));
            this.d_varyingRB = new guiRadioButton(Intl.intl("Varies with the number of active sprinklers tied to ejected particle"));
            this.d_flowCalcLab = new guiLabel(String.format(Intl.intl("<html> (Flow Rate (K&#8730p) = %g)</html>"), 0.0));
            this.d_flowRate = ValueFields.udFld(UnitSystem.getSource(30));
            this.d_pressure = ValueFields.udFld(DoubleVR.above(0.0, true), SIUS.unit(12), UnitSystem.getSource(12));
            this.d_kFactor = ValueFields.udFld(UnitSystem.getSource(58));
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Operating Pressure (p)") + ":");
            guiLabel guiLabel3 = new guiLabel(Intl.intl("K Factor (K)") + ":");
            this.d_pressureRampBtn = new JButton(Intl.intl("Edit Pressure Ramp..."));
            this.d_varyFlowrateCB = new guiCheckBox(Intl.intl("Flow Rate") + ":");
            this.d_varyFlowRate = ValueFields.udFld(explicitFlowRate.d_rate.getValue(SIUS.unit(30)), SIUS.unit(30), UnitSystem.getSource(30));
            this.d_varyPressureCB = new guiCheckBox(guiLabel2.getText());
            this.d_varyPressure = ValueFields.udFld(pressurizedFlowRate.d_opPressure.getValue(SIUS.unit(12)), DoubleVR.above(0.0, true), SIUS.unit(12), UnitSystem.getSource(12));
            this.d_varyKFactorCB = new guiCheckBox(guiLabel3.getText());
            this.d_varyKFactor = ValueFields.udFld(pressurizedFlowRate.d_kFactor.getValue(SIUS.unit(58)), SIUS.unit(58), UnitSystem.getSource(58));
            this.d_varyCountLbl = new guiLabel();
            GridBagUtil.add(this, this.d_specifyRB, 0, n, 2, 1, 12, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_flowRate, 2, n++, 1, 1, 12, 0, 6, 0, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_calculateRB, 0, n, 1, 1, 0, 12, 6, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_flowCalcLab, 1, n++, 3, 1, 0, 0, 6, 0, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel2, 0, n, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_pressure, 2, n++, 1, 1, 0, 0, 6, 0, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel3, 0, n, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_kFactor, 2, n++, 1, 1, 0, 0, 6, 0, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_varyingRB, 0, n++, 9, 1, 0, 12, 6, 0, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_pressureRampBtn, 0, n++, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_varyFlowrateCB, 0, n, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_varyFlowRate, 2, n++, 1, 1, 0, 0, 6, 0, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_varyPressureCB, 0, n, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_varyPressure, 2, n++, 1, 1, 0, 0, 6, 0, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_varyKFactorCB, 0, n, 2, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_varyKFactor, 2, n++, 1, 1, 0, 0, 6, 0, 2, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_varyCountLbl, 0, n++, 2, 1, 0, 30, 6, 0, 2, 0.0, 0.0, 17);
            this.d_rampTimeEditor = this.newTimeFuncEditor();
            this.d_rampTimeEditor.addToPanel(this, 0, n++, 0, 12, 12, 12);
            GridBagUtil.addGlue(this);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.d_specifyRB);
            buttonGroup.add(this.d_calculateRB);
            buttonGroup.add(this.d_varyingRB);
            LinkStatus.link((AbstractButton)this.d_specifyRB, this.d_flowRate);
            LinkStatus.link((AbstractButton)this.d_calculateRB, guiLabel2, this.d_pressure, guiLabel3, this.d_kFactor);
            LinkStatus.link2((AbstractButton)this.d_varyingRB, this.d_pressureRampBtn, this.d_varyFlowrateCB, this.d_varyFlowRate, this.d_varyKFactorCB, this.d_varyKFactor, this.d_varyPressureCB, this.d_varyPressure, this.d_varyCountLbl);
            LinkStatus.link((AbstractButton)this.d_varyFlowrateCB, this.d_varyFlowRate);
            LinkStatus.link((AbstractButton)this.d_varyKFactorCB, this.d_varyKFactor);
            LinkStatus.link((AbstractButton)this.d_varyPressureCB, this.d_varyPressure);
            PropertyChangeListener propertyChangeListener = propertyChangeEvent -> {
                try {
                    UnitDouble unitDouble = (UnitDouble)this.d_pressure.getValue();
                    UnitDouble unitDouble2 = (UnitDouble)this.d_kFactor.getValue();
                    UnitDouble unitDouble3 = unitDouble2.multiply(unitDouble.sqrt());
                    this.d_flowCalcLab.setText(String.format(Intl.intl("<html> (Flow Rate (K&#8730p) = %s)</html>"), Global.format(unitDouble3.convert(UnitSystem.getSource(30).getUnit()))));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    this.d_flowCalcLab.setText(Intl.intl("<html> (Flow Rate (K&#8730p) = ?)</html>"));
                }
            };
            this.d_pressure.addValueChangeListener(propertyChangeListener);
            this.d_kFactor.addValueChangeListener(propertyChangeListener);
            ItemListener itemListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    FlowRatePanel.this.updateVaryCountLbl();
                }
            };
            this.d_varyFlowrateCB.addItemListener(itemListener);
            this.d_varyKFactorCB.addItemListener(itemListener);
            this.d_varyPressureCB.addItemListener(itemListener);
            this.d_pressureRampBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Ramp ramp;
                    IRampInput iRampInput = SprayModel.VaryingFlowRate.DEF_RAMP_INPUT;
                    if (FlowRatePanel.this.d_currPressureRamp != null) {
                        iRampInput = FlowRatePanel.this.d_currPressureRamp.getDefaultInput();
                    }
                    RampFuncDlg rampFuncDlg = new RampFuncDlg(iRampInput, 12, Intl.intl("Pipe Pressure"), null);
                    if (FlowRatePanel.this.d_currPressureRamp != null) {
                        rampFuncDlg.loadData(FlowRatePanel.this.d_currPressureRamp);
                    }
                    if (rampFuncDlg.doModal() == 1 && !theUtil.equal(ramp = rampFuncDlg.getRamp(), FlowRatePanel.this.d_currPressureRamp)) {
                        FlowRatePanel.this.d_currPressureRamp = rampFuncDlg.getRamp();
                        FlowRatePanel.this.setModified(true);
                    }
                }
            });
            this.load(explicitFlowRate);
        }

        private int countSelectedVaryingProps() {
            int n = 0;
            if (this.d_varyFlowrateCB.isSelected()) {
                ++n;
            }
            if (this.d_varyKFactorCB.isSelected()) {
                ++n;
            }
            if (this.d_varyPressureCB.isSelected()) {
                ++n;
            }
            return n;
        }

        private void updateVaryCountLbl() {
            int n = this.countSelectedVaryingProps();
            String string = String.format(Intl.intl("%d/2 properties chosen."), n);
            this.d_varyCountLbl.setText(string);
            Color color = n >= 2 ? Color.BLUE : Color.RED;
            this.d_varyCountLbl.setForeground(color);
        }

        public void load(SprayModel.FlowRate flowRate) {
            this.d_currPressureRamp = null;
            this.d_rampTimeEditor.loadFunction(flowRate.d_ramp);
            if (flowRate instanceof SprayModel.ExplicitFlowRate) {
                SprayModel.ExplicitFlowRate explicitFlowRate = (SprayModel.ExplicitFlowRate)flowRate;
                this.d_specifyRB.setSelected(true);
                this.d_flowRate.setValue(explicitFlowRate.d_rate);
                this.d_pressure.setValue(new SprayModel.PressurizedFlowRate().d_opPressure);
                this.d_kFactor.setValue(new SprayModel.PressurizedFlowRate().d_kFactor);
            } else if (flowRate instanceof SprayModel.PressurizedFlowRate) {
                SprayModel.PressurizedFlowRate pressurizedFlowRate = (SprayModel.PressurizedFlowRate)flowRate;
                this.d_calculateRB.setSelected(true);
                this.d_pressure.setValue(pressurizedFlowRate.d_opPressure);
                this.d_kFactor.setValue(pressurizedFlowRate.d_kFactor);
                this.d_flowRate.setValue(new SprayModel.ExplicitFlowRate().d_rate);
            } else if (flowRate instanceof SprayModel.VaryingFlowRate) {
                SprayModel.VaryingFlowRate varyingFlowRate = (SprayModel.VaryingFlowRate)flowRate;
                this.d_varyingRB.setSelected(true);
                this.loadVaryVal(this.d_varyFlowrateCB, this.d_varyFlowRate, varyingFlowRate.d_rate);
                this.loadVaryVal(this.d_varyKFactorCB, this.d_varyKFactor, varyingFlowRate.d_kFactor);
                this.loadVaryVal(this.d_varyPressureCB, this.d_varyPressure, varyingFlowRate.d_opPressure);
                this.d_currPressureRamp = varyingFlowRate.d_pressureRamp;
            }
            this.updateVaryCountLbl();
        }

        private void loadVaryVal(guiCheckBox guiCheckBox2, ValueField<UnitDouble> valueField, UnitDouble unitDouble) {
            guiCheckBox2.setSelected(unitDouble != null);
            if (unitDouble != null) {
                valueField.setValue(unitDouble);
            }
        }

        public SprayModel.FlowRate save() {
            if (this.d_specifyRB.isSelected()) {
                return new SprayModel.ExplicitFlowRate((UnitDouble)this.d_flowRate.getValue(), this.d_rampTimeEditor.saveFunction());
            }
            if (this.d_calculateRB.isSelected()) {
                return new SprayModel.PressurizedFlowRate((UnitDouble)this.d_pressure.getValue(), (UnitDouble)this.d_kFactor.getValue(), this.d_rampTimeEditor.saveFunction());
            }
            assert (this.d_currPressureRamp != null);
            return new SprayModel.VaryingFlowRate(this.d_currPressureRamp, this.saveVaryVal(this.d_varyPressureCB, this.d_varyPressure), this.saveVaryVal(this.d_varyKFactorCB, this.d_varyKFactor), this.saveVaryVal(this.d_varyFlowrateCB, this.d_varyFlowRate), this.d_rampTimeEditor.saveFunction());
        }

        private UnitDouble saveVaryVal(guiCheckBox guiCheckBox2, ValueField<UnitDouble> valueField) {
            return guiCheckBox2.isSelected() ? (UnitDouble)valueField.getValue() : null;
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            if (!super.validateData(bl, bl2)) {
                return false;
            }
            if (!this.d_rampTimeEditor.validateData(bl, bl2)) {
                return false;
            }
            if (this.d_varyingRB.isSelected()) {
                if (this.countSelectedVaryingProps() < 2) {
                    if (bl) {
                        this.error(Intl.intl("You must specify at least two of the flow rate parameters."));
                    }
                    if (bl2) {
                        if (!this.d_varyFlowrateCB.isSelected()) {
                            this.d_varyFlowrateCB.requestFocus();
                        } else if (!this.d_varyPressureCB.isSelected()) {
                            this.d_varyPressureCB.requestFocus();
                        } else {
                            this.d_varyKFactorCB.requestFocus();
                        }
                    }
                    return false;
                }
                if (this.d_currPressureRamp == null) {
                    if (bl) {
                        this.error(Intl.intl("You must specify the pipe pressure ramp."));
                    }
                    if (bl2) {
                        this.d_pressureRampBtn.requestFocus();
                    }
                    return false;
                }
            }
            return true;
        }

        private void error(String string) {
            JOptionPane.showMessageDialog(this, string, Intl.intl("Pipe Pressure Error"), 0);
        }

        private TimeFunctionEditor newTimeFuncEditor() {
            return this.newTimeFuncEditor(Intl.intl("Ramp-Up Time"));
        }

        private TimeFunctionEditor newTimeFuncEditor(String string) {
            int n = 29;
            return new TimeFunctionEditor(string, n);
        }
    }

    public class JetStreamPanel
    extends guiPanel {
        private static final long serialVersionUID = -7944685939417325175L;
        private final CardLayout d_cards;
        private final guiPanel d_cardPanel;
        private final ConicalPanel d_conicalPanel;
        private final EllipticalPanel d_ellipticalPanel;
        private final TablePanel d_tablePanel;
        private final guiComboBox d_jetTypeCombo;
        public final String CONICAL_SPRAY = Intl.intl("Conical");
        public final String ELLIPTICAL_SPRAY = Intl.intl("Elliptical");
        public final String TABLE_SPRAY = Intl.intl("Spray Table");
        private ValueField<UnitDouble> d_offset;
        private String d_selected;

        public JetStreamPanel() {
            this.setLayout(new GridBagLayout());
            this.d_cards = new CardLayout();
            this.d_cardPanel = new guiPanel(this.d_cards);
            this.d_conicalPanel = new ConicalPanel();
            this.d_ellipticalPanel = new EllipticalPanel();
            this.d_tablePanel = new TablePanel();
            this.d_jetTypeCombo = new guiComboBox<Object>((T[])new Object[]{this.CONICAL_SPRAY, this.ELLIPTICAL_SPRAY, this.TABLE_SPRAY});
            this.d_jetTypeCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    if (JetStreamPanel.this.d_jetTypeCombo.getSelectedItem().equals(JetStreamPanel.this.CONICAL_SPRAY)) {
                        JetStreamPanel.this.d_cards.show(JetStreamPanel.this.d_cardPanel, (String)JetStreamPanel.this.d_jetTypeCombo.getSelectedItem());
                        if (JetStreamPanel.this.d_selected.equals(JetStreamPanel.this.ELLIPTICAL_SPRAY)) {
                            JetStreamPanel.this.d_conicalPanel.loadData(JetStreamPanel.this.d_ellipticalPanel.getJet());
                        }
                    } else if (JetStreamPanel.this.d_jetTypeCombo.getSelectedItem().equals(JetStreamPanel.this.ELLIPTICAL_SPRAY)) {
                        JetStreamPanel.this.d_cards.show(JetStreamPanel.this.d_cardPanel, (String)JetStreamPanel.this.d_jetTypeCombo.getSelectedItem());
                        if (JetStreamPanel.this.d_selected.equals(JetStreamPanel.this.CONICAL_SPRAY)) {
                            JetStreamPanel.this.d_ellipticalPanel.loadData(JetStreamPanel.this.d_conicalPanel.getJet(), false);
                        }
                    } else if (JetStreamPanel.this.d_jetTypeCombo.getSelectedItem().equals(JetStreamPanel.this.TABLE_SPRAY)) {
                        JetStreamPanel.this.d_cards.show(JetStreamPanel.this.d_cardPanel, (String)JetStreamPanel.this.d_jetTypeCombo.getSelectedItem());
                    }
                    JetStreamPanel.this.d_selected = (String)JetStreamPanel.this.d_jetTypeCombo.getSelectedItem();
                }
            });
            this.d_selected = this.CONICAL_SPRAY;
            this.d_cardPanel.add(this.CONICAL_SPRAY, this.d_conicalPanel);
            this.d_cardPanel.add(this.ELLIPTICAL_SPRAY, this.d_ellipticalPanel);
            this.d_cardPanel.add(this.TABLE_SPRAY, this.d_tablePanel);
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Jet Stream Type:"));
            this.d_offset = ValueFields.udFld(UnitSystem.getSource(0));
            guiLabel guiLabel3 = new guiLabel(Intl.intl("Jet Stream Offset:"));
            int n = 0;
            GridBagUtil.add(this, guiLabel3, 0, n, 1, 1, 12, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_offset, 1, n++, 1, 1, 12, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel2, 0, n, 1, 1, 0, 12, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_jetTypeCombo, 1, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_cardPanel, 0, n++, 3, 1, 0, 30, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
        }

        public void load(UnitDouble unitDouble, List<SprayModel.Jet> list) {
            this.d_offset.setValue(unitDouble);
            if (list.size() > 1) {
                this.d_tablePanel.loadData(list);
                this.d_jetTypeCombo.setSelectedItem(this.TABLE_SPRAY);
            } else if (list.size() > 0) {
                SprayModel.Jet jet = list.get(0);
                if (jet.isConicalSpray()) {
                    this.d_jetTypeCombo.setSelectedItem(this.CONICAL_SPRAY);
                    this.d_conicalPanel.loadData(jet);
                    this.d_ellipticalPanel.loadData(new SprayModel.Jet(), true);
                } else {
                    this.d_jetTypeCombo.setSelectedItem(this.ELLIPTICAL_SPRAY);
                    this.d_ellipticalPanel.loadData(jet, true);
                    this.d_conicalPanel.loadData(new SprayModel.Jet());
                }
            }
        }

        public List<SprayModel.Jet> saveJets() {
            if (this.d_jetTypeCombo.getSelectedItem().equals(this.CONICAL_SPRAY)) {
                return Arrays.asList(this.d_conicalPanel.getJet());
            }
            if (this.d_jetTypeCombo.getSelectedItem().equals(this.ELLIPTICAL_SPRAY)) {
                return Arrays.asList(this.d_ellipticalPanel.getJet());
            }
            return this.d_tablePanel.getJets();
        }

        public UnitDouble saveOffset() {
            return (UnitDouble)this.d_offset.getValue();
        }

        private class TablePanel
        extends guiPanel {
            private static final long serialVersionUID = -1020186893007446253L;
            private final guiTable d_table;

            public TablePanel() {
                this.setLayout(new GridBagLayout());
                this.d_table = new guiTable((TableModel)new MultipleJetStreamTable(), 24);
                this.d_table.setNullValuesAllowed(false);
                this.d_table.getColumnModel().getColumn(1).setCellEditor(new guiTable.UnitDoubleEditor(SprayModelPanel.this.d_currentUS.getVelocityUnit()));
                this.d_table.getColumnModel().getColumn(2).setCellEditor(new guiTable.UnitDoubleEditor(NonSI.DEGREE_ANGLE));
                this.d_table.getColumnModel().getColumn(3).setCellEditor(new guiTable.UnitDoubleEditor(NonSI.DEGREE_ANGLE));
                this.d_table.getColumnModel().getColumn(4).setCellEditor(new guiTable.UnitDoubleEditor(NonSI.DEGREE_ANGLE));
                this.d_table.getColumnModel().getColumn(5).setCellEditor(new guiTable.UnitDoubleEditor(NonSI.DEGREE_ANGLE));
                this.d_table.getColumnModel().getColumn(2).setPreferredWidth(25);
                this.d_table.getColumnModel().getColumn(3).setPreferredWidth(25);
                this.d_table.getColumnModel().getColumn(4).setPreferredWidth(25);
                this.d_table.getColumnModel().getColumn(5).setPreferredWidth(25);
                this.d_table.autoSizeColumns();
                guiTableEditor guiTableEditor2 = new guiTableEditor(this.d_table, 0);
                Dimension dimension = guiTableEditor2.getPreferredSize();
                dimension.height = 90;
                dimension.width += 15;
                guiTableEditor2.setPreferredSize(dimension);
                GridBagUtil.add(this, guiTableEditor2, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0.0, 0.0, 17);
                GridBagUtil.addGlue(this);
            }

            @Override
            public boolean validateData(boolean bl, boolean bl2) {
                if (!super.validateData(bl, bl2)) {
                    return false;
                }
                TableModel tableModel = this.d_table.getModel();
                if (tableModel.getRowCount() == 0) {
                    if (bl) {
                        String string = Intl.intl("At least one jet must be entered.");
                        guiDialog.showInvalidEntryMessage(SprayModelPanel.this.d_parent, string);
                    }
                    if (bl2) {
                        this.d_table.requestFocus();
                    }
                    return false;
                }
                if (this.fracBad(tableModel)) {
                    if (bl) {
                        String string = Intl.intl("Flow fraction must be > 0 and <= 1.");
                        guiDialog.showInvalidEntryMessage(SprayModelPanel.this.d_parent, string);
                    }
                    if (bl2) {
                        this.d_table.requestFocus();
                    }
                    return false;
                }
                if (this.fracSumBad(tableModel)) {
                    if (bl) {
                        String string = Intl.intl("Fractions must add up to 1 or less.");
                        guiDialog.showInvalidEntryMessage(SprayModelPanel.this.d_parent, string);
                    }
                    if (bl2) {
                        this.d_table.requestFocus();
                    }
                    return false;
                }
                return true;
            }

            public void loadData(List<SprayModel.Jet> list) {
                this.d_table.selectAll();
                this.d_table.removeSelectedRows();
                this.d_table.clearSelection();
                ResizableTableModel resizableTableModel = (ResizableTableModel)this.d_table.getModel();
                int n = 0;
                for (SprayModel.Jet jet : list) {
                    Object[] objectArray = new Object[]{jet.d_flowFrac, jet.d_velocity, jet.d_lat1, jet.d_lat2, jet.d_long1, jet.d_long2};
                    resizableTableModel.insertRow(n, objectArray);
                    ++n;
                }
            }

            public List<SprayModel.Jet> getJets() {
                return ((MultipleJetStreamTable)this.d_table.getModel()).getJets();
            }

            private boolean fracBad(TableModel tableModel) {
                int n = tableModel.getRowCount();
                for (int i = 0; i < n; ++i) {
                    double d = guiTableUtil.getDouble(tableModel, i, 0);
                    if (!(d <= 0.0) && !(d > 1.0)) continue;
                    return true;
                }
                return false;
            }

            private boolean fracSumBad(TableModel tableModel) {
                int n = tableModel.getRowCount();
                double d = 0.0;
                for (int i = 0; i < n; ++i) {
                    d += guiTableUtil.getDouble(tableModel, i, 0);
                }
                return d > 1.0;
            }

            private class MultipleJetStreamTable
            extends guiDefaultTableModel {
                private static final long serialVersionUID = 6093437583977032163L;

                private MultipleJetStreamTable() {
                }

                @Override
                public String getColumnName(int n) {
                    switch (n) {
                        case 0: {
                            return Intl.intl("Flow Fraction");
                        }
                        case 1: {
                            return String.format(Intl.intl("Velocity (%s)"), SprayModelPanel.this.d_currentUS.getVelocityUnit());
                        }
                        case 2: {
                            return String.format(Intl.intl("Lat1 (%s)"), NonSI.DEGREE_ANGLE.toString());
                        }
                        case 3: {
                            return String.format(Intl.intl("Lat2 (%s)"), NonSI.DEGREE_ANGLE.toString());
                        }
                        case 4: {
                            return String.format(Intl.intl("Long1 (%s)"), NonSI.DEGREE_ANGLE.toString());
                        }
                        case 5: {
                            return String.format(Intl.intl("Long2 (%s)"), NonSI.DEGREE_ANGLE.toString());
                        }
                    }
                    return null;
                }

                @Override
                public Class getColumnClass(int n) {
                    switch (n) {
                        case 0: {
                            return Double.class;
                        }
                        case 1: {
                            return UnitDouble.class;
                        }
                        case 2: {
                            return UnitDouble.class;
                        }
                        case 3: {
                            return UnitDouble.class;
                        }
                        case 4: {
                            return UnitDouble.class;
                        }
                        case 5: {
                            return UnitDouble.class;
                        }
                    }
                    assert (false);
                    return null;
                }

                @Override
                public int getColumnCount() {
                    return 6;
                }

                public List<SprayModel.Jet> getJets() {
                    int n = this.getRowCount();
                    ArrayList<SprayModel.Jet> arrayList = new ArrayList<SprayModel.Jet>(n);
                    for (int i = 0; i < n; ++i) {
                        arrayList.add(new SprayModel.Jet((UnitDouble)this.getValueAt(i, 1), null, (Double)this.getValueAt(i, 0), (UnitDouble)this.getValueAt(i, 4), (UnitDouble)this.getValueAt(i, 5), (UnitDouble)this.getValueAt(i, 2), (UnitDouble)this.getValueAt(i, 3)));
                    }
                    return arrayList;
                }
            }
        }

        private class EllipticalPanel
        extends guiPanel {
            private static final long serialVersionUID = 3295190240877198895L;
            public ValueField<UnitDouble> d_velocity;
            public ValueField<UnitDouble> d_orificeDiam;
            public ValueField<UnitDouble> d_latAngle1;
            public ValueField<UnitDouble> d_latAngle2;
            public guiRadioButton d_orificeRB;
            public guiRadioButton d_velocityRB;
            public final ValueField<UnitDouble> d_longAngle1;
            public final ValueField<UnitDouble> d_longAngle2;

            public EllipticalPanel() {
                this.setLayout(new GridBagLayout());
                this.d_orificeRB = new guiRadioButton(Intl.intl("Orifice Diameter:"));
                this.d_velocityRB = new guiRadioButton(Intl.intl("Velocity:"));
                this.d_orificeDiam = ValueFields.udFld(UnitSystem.getSource(0));
                this.d_velocity = ValueFields.udFld(UnitSystem.getSource(8));
                LinkStatus.link2((AbstractButton)this.d_orificeRB, this.d_orificeDiam);
                LinkStatus.link2((AbstractButton)this.d_velocityRB, this.d_velocity);
                new guiButtonGroup(this.d_orificeRB, this.d_velocityRB);
                guiLabel guiLabel2 = new guiLabel(Intl.intl("Latitude Angle 1:"));
                guiLabel guiLabel3 = new guiLabel(Intl.intl("Latitude Angle 2:"));
                this.d_latAngle1 = ValueFields.udFld(UnitSystem.getSource(29));
                this.d_latAngle2 = ValueFields.udFld(UnitSystem.getSource(29));
                guiLabel guiLabel4 = new guiLabel(Intl.intl("Longitude Angle 1:"));
                guiLabel guiLabel5 = new guiLabel(Intl.intl("Longitude Angle 2:"));
                this.d_longAngle1 = ValueFields.udFld(UnitSystem.getSource(29));
                this.d_longAngle2 = ValueFields.udFld(UnitSystem.getSource(29));
                this.d_longAngle1.setValue(new UnitDouble(0.0, NonSI.DEGREE_ANGLE));
                this.d_longAngle2.setValue(new UnitDouble(360.0, NonSI.DEGREE_ANGLE));
                GridBagHelper gridBagHelper = new GridBagHelper(this);
                gridBagHelper.addRow(this.d_velocityRB, this.d_velocity);
                gridBagHelper.addRow(this.d_orificeRB, this.d_orificeDiam);
                gridBagHelper.addRow(guiLabel2, this.d_latAngle1, guiLabel3, this.d_latAngle2);
                gridBagHelper.addRow(guiLabel4, this.d_longAngle1, guiLabel5, this.d_longAngle2);
                gridBagHelper.finalizeRows();
            }

            public void loadData(SprayModel.Jet jet, boolean bl) {
                this.d_latAngle1.setValue(jet.d_lat1);
                this.d_latAngle2.setValue(jet.d_lat2);
                if (bl) {
                    this.d_longAngle1.setValue(jet.d_long1 != null ? jet.d_long1 : new UnitDouble(0.0, NonSI.DEGREE_ANGLE));
                    this.d_longAngle2.setValue(jet.d_long2 != null ? jet.d_long2 : new UnitDouble(360.0, NonSI.DEGREE_ANGLE));
                } else {
                    if (jet.d_long1 != null) {
                        this.d_longAngle1.setValue(jet.d_long1);
                    }
                    if (jet.d_long2 != null) {
                        this.d_longAngle2.setValue(jet.d_long2);
                    }
                }
                if (jet.d_velocity != null) {
                    this.d_velocityRB.setSelected(true);
                    this.d_velocity.setValue(jet.d_velocity);
                } else {
                    assert (jet.d_orificeDiam != null);
                    this.d_orificeRB.setSelected(true);
                    this.d_orificeDiam.setValue(jet.d_orificeDiam);
                }
            }

            public SprayModel.Jet getJet() {
                return new SprayModel.Jet(this.d_velocityRB.isSelected() ? (UnitDouble)this.d_velocity.getValue() : null, this.d_orificeRB.isSelected() ? (UnitDouble)this.d_orificeDiam.getValue() : null, 1.0, (UnitDouble)this.d_longAngle1.getValue(), (UnitDouble)this.d_longAngle2.getValue(), (UnitDouble)this.d_latAngle1.getValue(), (UnitDouble)this.d_latAngle2.getValue());
            }
        }

        private class ConicalPanel
        extends guiPanel {
            private static final long serialVersionUID = 5206652111545452785L;
            public ValueField<UnitDouble> d_velocity;
            public ValueField<UnitDouble> d_orificeDiam;
            public ValueField<UnitDouble> d_latAngle1;
            public ValueField<UnitDouble> d_latAngle2;
            public guiRadioButton d_orificeRB;
            public guiRadioButton d_velocityRb;

            public ConicalPanel() {
                this.setLayout(new GridBagLayout());
                this.d_orificeRB = new guiRadioButton(Intl.intl("Orifice Diameter:"));
                this.d_velocityRb = new guiRadioButton(Intl.intl("Velocity:"));
                this.d_orificeDiam = ValueFields.udFld(UnitSystem.getSource(0));
                this.d_velocity = ValueFields.udFld(UnitSystem.getSource(8));
                LinkStatus.link2((AbstractButton)this.d_orificeRB, this.d_orificeDiam);
                LinkStatus.link2((AbstractButton)this.d_velocityRb, this.d_velocity);
                new guiButtonGroup(this.d_orificeRB, this.d_velocityRb);
                guiLabel guiLabel2 = new guiLabel(Intl.intl("Latitude Angle 1:"));
                guiLabel guiLabel3 = new guiLabel(Intl.intl("Latitude Angle 2:"));
                this.d_latAngle1 = ValueFields.udFld(UnitSystem.getSource(29));
                this.d_latAngle2 = ValueFields.udFld(UnitSystem.getSource(29));
                GridBagHelper gridBagHelper = new GridBagHelper(this);
                gridBagHelper.addRow(this.d_velocityRb, this.d_velocity);
                gridBagHelper.addRow(this.d_orificeRB, this.d_orificeDiam);
                gridBagHelper.addRow(guiLabel2, this.d_latAngle1, guiLabel3, this.d_latAngle2);
                gridBagHelper.finalizeRows();
            }

            public void loadData(SprayModel.Jet jet) {
                this.d_latAngle1.setValue(jet.d_lat1);
                this.d_latAngle2.setValue(jet.d_lat2);
                if (jet.d_velocity != null) {
                    this.d_velocityRb.setSelected(true);
                    this.d_velocity.setValue(jet.d_velocity);
                } else {
                    assert (jet.d_orificeDiam != null);
                    this.d_orificeRB.setSelected(true);
                    this.d_orificeDiam.setValue(jet.d_orificeDiam);
                }
            }

            public SprayModel.Jet getJet() {
                return new SprayModel.Jet(this.d_velocityRb.isSelected() ? (UnitDouble)this.d_velocity.getValue() : null, this.d_orificeRB.isSelected() ? (UnitDouble)this.d_orificeDiam.getValue() : null, 1.0, (UnitDouble)this.d_latAngle1.getValue(), (UnitDouble)this.d_latAngle2.getValue());
            }
        }
    }
}

