/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.event.ActionEvent;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.JFrame;
import javax.swing.event.ListSelectionEvent;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.ExSpec;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.NamedPyroObject;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.devices.sprayers.SprayModelMgr;
import pyrosim.domain.particle.Output;
import pyrosim.domain.particle.Particle;
import pyrosim.domain.tasks.AddTask;
import pyrosim.domain.tasks.SelectTask;
import pyrosim.gui.ManagerDlg;
import pyrosim.gui.RenameAction;
import pyrosim.gui.devices.NewSprayModelDlg;
import pyrosim.gui.devices.SprayModelPanel;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiAction;

public class SprayModelManagerDlg
extends ManagerDlg {
    private static final long serialVersionUID = 1403854967012767479L;
    private final Action[] d_actions;
    private final IEditor d_editor;
    private SprayModelMgr d_sprayMgr;
    private JFrame d_owner;

    public SprayModelManagerDlg(JFrame jFrame) {
        super(jFrame, Intl.intl("Spray Models"), true);
        this.d_owner = jFrame;
        this.d_actions = new Action[]{new NewAction(), new ManagerDlg.LibraryAction(SprayModel.class), new RenameAction(this, Intl.intl("spray model")), new ManagerDlg.DeleteAction()};
        this.d_editor = new SprayModelPanel(this);
        this.setPreviewTypes("PROP", "RAMP");
    }

    private void updateActions() {
        int n = this.getList().getSelectedIx();
        this.d_actions[0].setEnabled(this.d_sprayMgr != null);
        this.d_actions[2].setEnabled(this.d_sprayMgr != null && n > -1);
        this.d_actions[3].setEnabled(this.d_sprayMgr != null && n > -1);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        super.valueChanged(listSelectionEvent);
        this.updateActions();
    }

    public void init(SprayModelMgr sprayModelMgr, SprayModel sprayModel) {
        this.d_sprayMgr = sprayModelMgr;
        ((RenameAction)this.d_actions[2]).init(sprayModelMgr);
        super.init(this.d_sprayMgr, this.d_editor, this.d_actions, sprayModel);
        this.updateActions();
    }

    private class NewAction
    extends guiAction {
        private static final long serialVersionUID = 4182152059864970394L;

        public NewAction() {
            super(Intl.intl("New") + "...");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!SprayModelManagerDlg.this.preSave()) {
                return;
            }
            NewSprayModelDlg newSprayModelDlg = new NewSprayModelDlg(SprayModelManagerDlg.this.d_sprayMgr);
            PyroMod pyroMod = (PyroMod)SprayModelManagerDlg.this.d_sprayMgr.getDomain();
            if (newSprayModelDlg.doModal() == 1) {
                SelectTask selectTask;
                AddTask addTask;
                NamedPyroObject namedPyroObject;
                String string = newSprayModelDlg.getSprayModelName();
                Particle particle = null;
                Collection<Particle> collection = pyroMod.getPartList().flatten(SprayModel.getParticleFilter());
                if (collection.isEmpty()) {
                    particle = new Particle(Intl.intl("Water_PART"), Particle.Type.LIQUID, new Output(10), null);
                    namedPyroObject = pyroMod.getExSpecList().get("WATER VAPOR");
                    particle.setSpecies((ExSpec)namedPyroObject);
                    addTask = new AddTask((IPyroObject)pyroMod.getPartList(), new IPyroObject[]{particle});
                    selectTask = new SelectTask(pyroMod, particle);
                    selectTask.addTask(addTask);
                    pyroMod.getTaskManager().exec(selectTask, Intl.intl("New Particle"));
                } else {
                    particle = collection.iterator().next();
                }
                namedPyroObject = new SprayModel(string, particle);
                addTask = new AddTask((IPyroObject)SprayModelManagerDlg.this.d_sprayMgr, new IPyroObject[]{namedPyroObject});
                selectTask = new SelectTask(pyroMod, namedPyroObject);
                selectTask.addTask(addTask);
                pyroMod.getTaskManager().exec(selectTask, Intl.intl("New Spray Model"));
                SprayModelManagerDlg.this.getList().updateModelView(SprayModelManagerDlg.this.d_sprayMgr);
                SprayModelManagerDlg.this.getList().select(namedPyroObject);
                SprayModelManagerDlg.this.d_editor.getEditorPanel().setModified(false);
                SprayModelManagerDlg.this.updateActions();
            }
        }
    }
}

