/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.jscience.physics.units.SI;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.devices.DeviceManager;
import pyrosim.domain.devices.measurers.AMeasuringDevc;
import pyrosim.domain.devices.measurers.GaugeHeatFluxMeasurer;
import pyrosim.domain.devices.measurers.InnerTempMeasurer;
import pyrosim.domain.devices.measurers.PressureCoeffMeasurer;
import pyrosim.domain.devices.measurers.SolidDensityMeasurer;
import pyrosim.domain.devices.measurers.SolidPointMeasurer;
import pyrosim.domain.geom.AttachedPointLoc;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.ObjectQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.comboboxes.QuantityComboBox;
import pyrosim.gui.devices.ADevcEditor;
import pyrosim.gui.devices.AlarmInfoPanel;
import pyrosim.gui.devices.IDevcEditor;
import pyrosim.gui.devices.MsrDeviceEditorUtil;
import pyrosim.gui.geom.AttachedPointGeomEditor;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.DoubleVR;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Sets;

public class SolidPointDeviceEditor
extends ADevcEditor<SolidPointMeasurer> {
    private final SolidPointDeviceDataPanel d_dataPanel;

    public SolidPointDeviceEditor(PyroMod pyroMod, IDevcEditor.Mode mode) {
        this.d_dataPanel = new SolidPointDeviceDataPanel(pyroMod, mode);
    }

    @Override
    public String getDesc() {
        return Intl.intl("Solid-phase Device");
    }

    @Override
    public String getDefName() {
        return Intl.intl("SOLID");
    }

    @Override
    public IGeomEditor<? extends IGeom> createGeomEditor() {
        return new AttachedPointGeomEditor();
    }

    @Override
    public AlarmInfoPanel createAlarmPanel() {
        final AlarmInfoPanel alarmInfoPanel = new AlarmInfoPanel((IQuantity)this.d_dataPanel.d_measCombo.getSelectedItem());
        this.d_dataPanel.d_measCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                alarmInfoPanel.setCurrentMsr((IQuantity)SolidPointDeviceEditor.this.d_dataPanel.d_measCombo.getSelectedItem());
            }
        });
        return alarmInfoPanel;
    }

    @Override
    public Collection<String> getCustomTypes() {
        HashSet<String> hashSet = new HashSet<String>();
        SolidPointMeasurer.getCustomFDSTypes((IQuantity)this.d_dataPanel.d_measCombo.getSelectedItem(), hashSet);
        return hashSet;
    }

    @Override
    public Set<String> getFDSPreviewTypes() {
        return Sets.fromArrayHS("PROP", "DEVC");
    }

    @Override
    public SolidPointMeasurer create() {
        return this.d_dataPanel.create();
    }

    @Override
    public void load(SolidPointMeasurer solidPointMeasurer) {
        this.d_dataPanel.load(solidPointMeasurer);
    }

    @Override
    public void save(SolidPointMeasurer solidPointMeasurer) {
        this.d_dataPanel.save(solidPointMeasurer);
    }

    @Override
    public guiPanel getDataPanel() {
        return this.d_dataPanel;
    }

    @Override
    public boolean validateData(Component component, SolidPointMeasurer solidPointMeasurer, boolean bl, boolean bl2) {
        return MsrDeviceEditorUtil.validateData(component, solidPointMeasurer, (IQuantity)this.d_dataPanel.d_measCombo.getSelectedItem(), bl, bl2);
    }

    public class SolidPointDeviceDataPanel
    extends guiPanel {
        private static final long serialVersionUID = 1726105864786556448L;
        private final IDevcEditor.Mode d_mode;
        private final DeviceManager d_mgr;
        private final QuantityComboBox d_measCombo;
        private final GuageHeatFluxProps d_heatFluxPanel;
        private final PressureCoeffProps d_pressCoeffPanel;
        private final DepthProps d_surfDepthPanel;
        private guiPanel d_cardPanel;
        private CardLayout d_cardLayout;
        private static final String SURFACE_DEPTH = "SURFACE_DEPTH";

        public SolidPointDeviceDataPanel(PyroMod pyroMod, IDevcEditor.Mode mode) {
            this.d_mgr = pyroMod.getDevices();
            this.d_mode = mode;
            this.setLayout(new GridBagLayout());
            this.d_measCombo = new QuantityComboBox(SolidPointMeasurer.getOutputType(), SolidPointMeasurer.getQuantityType());
            this.d_measCombo.setMinimumSize(this.d_measCombo.getPreferredSize());
            this.d_cardLayout = new CardLayout();
            this.d_cardPanel = new guiPanel(this.d_cardLayout);
            this.d_heatFluxPanel = new GuageHeatFluxProps();
            this.d_pressCoeffPanel = new PressureCoeffProps();
            this.d_surfDepthPanel = new DepthProps(new UnitDouble(0.0, SI.METER));
            this.d_cardPanel.add((Component)this.d_heatFluxPanel, Quantity.GAUGE_HEAT_FLUX.create().getDescription());
            this.d_cardPanel.add((Component)this.d_pressCoeffPanel, Quantity.PRESSURE_COEFFICIENT.create().getDescription());
            this.d_cardPanel.add((Component)this.d_surfDepthPanel, SURFACE_DEPTH);
            this.d_measCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    SolidPointDeviceDataPanel.this.updateCardSelect();
                }
            });
            GridBagHelper gridBagHelper = new GridBagHelper(this);
            gridBagHelper.addRow(Intl.intl("Quantity:"), this.d_measCombo, 0);
            gridBagHelper.addRow(this.d_cardPanel, 0, 1.0);
            gridBagHelper.finalizeRows();
            this.d_cardPanel.setVisible(false);
            this.updateCardSelect();
        }

        private void updateCardSelect() {
            IQuantity iQuantity = (IQuantity)this.d_measCombo.getSelectedItem();
            if (iQuantity.get().equals((Object)Quantity.GAUGE_HEAT_FLUX) || iQuantity.get().equals((Object)Quantity.PRESSURE_COEFFICIENT)) {
                this.d_cardLayout.show(this.d_cardPanel, iQuantity.getDescription());
                this.d_cardPanel.setVisible(true);
            } else if (iQuantity.get().equals((Object)Quantity.INSIDE_WALL_TEMPERATURE) || iQuantity.get().equals((Object)Quantity.MATL_SOLID_DENSITY)) {
                this.d_cardLayout.show(this.d_cardPanel, SURFACE_DEPTH);
                this.d_cardPanel.setVisible(true);
            } else {
                this.d_cardPanel.setVisible(false);
            }
            PyroGuiUtil.pack(this);
        }

        public void load(SolidPointMeasurer solidPointMeasurer) {
            boolean bl = this.d_mode == IDevcEditor.Mode.CREATE;
            Predicate<Quantity> predicate = this.d_measCombo.getFilter();
            if (solidPointMeasurer instanceof GaugeHeatFluxMeasurer) {
                this.d_heatFluxPanel.setTemp(((GaugeHeatFluxMeasurer)solidPointMeasurer).getGaugeTemperature());
                this.d_heatFluxPanel.setEmiss(((GaugeHeatFluxMeasurer)solidPointMeasurer).getGaugeEmissivity());
                this.d_measCombo.setEnabled(bl);
            } else if (solidPointMeasurer instanceof PressureCoeffMeasurer) {
                this.d_pressCoeffPanel.setVel(((PressureCoeffMeasurer)solidPointMeasurer).getCharacteristicVel());
                this.d_measCombo.setEnabled(bl);
            } else if (solidPointMeasurer instanceof InnerTempMeasurer) {
                this.d_surfDepthPanel.setDepth(((InnerTempMeasurer)solidPointMeasurer).getDepth());
                this.d_measCombo.setEnabled(bl);
            } else if (solidPointMeasurer instanceof SolidDensityMeasurer) {
                this.d_surfDepthPanel.setDepth(((SolidDensityMeasurer)solidPointMeasurer).getDepth());
                if (this.d_mode == IDevcEditor.Mode.EDIT) {
                    predicate = predicate.and(SolidDensityMeasurer.getQuantityFilter());
                }
            } else if (this.d_mode == IDevcEditor.Mode.EDIT) {
                EnumSet<Quantity> enumSet = EnumSet.of(Quantity.GAUGE_HEAT_FLUX, Quantity.PRESSURE_COEFFICIENT, Quantity.INSIDE_WALL_TEMPERATURE);
                predicate = predicate.and(Filters.reject(enumSet));
                predicate = predicate.and(SolidDensityMeasurer.getQuantityFilter().negate());
                this.d_measCombo.setEnabled(true);
            }
            this.d_measCombo.setSelectedItem(solidPointMeasurer.getQuantity());
            this.d_measCombo.setFilter(predicate);
            this.updateCardSelect();
        }

        public SolidPointMeasurer create() {
            IQuantity iQuantity = (IQuantity)this.d_measCombo.getSelectedItem();
            if (iQuantity.get().equals((Object)Quantity.GAUGE_HEAT_FLUX)) {
                return new GaugeHeatFluxMeasurer("", this.d_heatFluxPanel.getTemp(), this.d_heatFluxPanel.getEmiss(), new AttachedPointLoc());
            }
            if (iQuantity.get().equals((Object)Quantity.PRESSURE_COEFFICIENT)) {
                return new PressureCoeffMeasurer("", this.d_pressCoeffPanel.getVel(), new AttachedPointLoc());
            }
            if (iQuantity.get().equals((Object)Quantity.INSIDE_WALL_TEMPERATURE)) {
                return new InnerTempMeasurer("", this.d_surfDepthPanel.getDepth(), new AttachedPointLoc());
            }
            if (iQuantity.get().equals((Object)Quantity.MATL_SOLID_DENSITY)) {
                return new SolidDensityMeasurer("", (ObjectQuantity)iQuantity, this.d_surfDepthPanel.getDepth(), new AttachedPointLoc());
            }
            return new SolidPointMeasurer("", (IQuantity)this.d_measCombo.getSelectedItem(), new AttachedPointLoc());
        }

        public void save(SolidPointMeasurer solidPointMeasurer) {
            if (solidPointMeasurer instanceof GaugeHeatFluxMeasurer) {
                ((GaugeHeatFluxMeasurer)solidPointMeasurer).setGaugeTemperature(this.d_heatFluxPanel.getTemp());
                ((GaugeHeatFluxMeasurer)solidPointMeasurer).setGaugeEmissivity(this.d_heatFluxPanel.getEmiss());
            } else if (solidPointMeasurer instanceof PressureCoeffMeasurer) {
                ((PressureCoeffMeasurer)solidPointMeasurer).setCharacteristicVel(this.d_pressCoeffPanel.getVel());
            } else if (solidPointMeasurer instanceof InnerTempMeasurer) {
                ((InnerTempMeasurer)solidPointMeasurer).setDepth(this.d_surfDepthPanel.getDepth());
            } else if (solidPointMeasurer instanceof SolidDensityMeasurer) {
                SolidDensityMeasurer solidDensityMeasurer = (SolidDensityMeasurer)solidPointMeasurer;
                this.updateMsr(solidDensityMeasurer);
                solidDensityMeasurer.setDepth(this.d_surfDepthPanel.getDepth());
            } else {
                this.updateMsr(solidPointMeasurer);
            }
        }

        private void updateMsr(AMeasuringDevc aMeasuringDevc) {
            IQuantity iQuantity = (IQuantity)this.d_measCombo.getSelectedItem();
            UnitSystem unitSystem = PyroSim.getApp().getUnitSystem();
            Unit unit = unitSystem.getUnit(iQuantity.get().unitType);
            aMeasuringDevc.setQuantity(iQuantity, unit);
        }
    }

    public static class DepthProps
    extends guiPanel {
        private static final long serialVersionUID = -2411132089444480219L;
        private final UnitSystem d_currentUS = ((PyroSim)Application.getApp()).getUnitSystem();
        private ValueField<UnitDouble> d_depth;

        public DepthProps(UnitDouble unitDouble) {
            this.setLayout(new GridBagLayout());
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Surface Depth") + ":");
            this.d_depth = ValueFields.udFld(unitDouble, UnitSystem.getSource(0));
            GridBagUtil.add(this, guiLabel2, 0, 0, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_depth, 1, 0, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
        }

        public UnitDouble getDepth() {
            return (UnitDouble)this.d_depth.getValue();
        }

        public void setDepth(UnitDouble unitDouble) {
            this.d_depth.setValue(unitDouble);
        }
    }

    public static class PressureCoeffProps
    extends guiPanel {
        private static final long serialVersionUID = 9038362831755486092L;
        private final UnitSystem d_currentUS = ((PyroSim)Application.getApp()).getUnitSystem();
        private ValueField<UnitDouble> d_vel;

        public PressureCoeffProps() {
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Characteristic Velocity") + ":");
            this.d_vel = ValueFields.udFld(new PressureCoeffMeasurer("", null).getCharacteristicVel(), UnitSystem.getSource(8));
            this.setLayout(new GridBagLayout());
            GridBagUtil.add(this, guiLabel2, 0, 0, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_vel, 1, 0, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
        }

        public UnitDouble getVel() {
            return (UnitDouble)this.d_vel.getValue();
        }

        public void setVel(UnitDouble unitDouble) {
            this.d_vel.setValue(unitDouble);
        }
    }

    public static class GuageHeatFluxProps
    extends guiPanel {
        private static final long serialVersionUID = -6098232058307237925L;
        private final UnitSystem d_currentUS = ((PyroSim)Application.getApp()).getUnitSystem();
        private ValueField<UnitDouble> d_temp;
        private ValueField<Double> d_emiss;

        public GuageHeatFluxProps() {
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Gauge Temperature") + ":");
            this.d_temp = ValueFields.udFld(UnitSystem.getSource(1));
            this.d_temp.setNullAllowed(true);
            ValueFields.getFormat(this.d_temp).alias(null, "TMPA");
            this.d_temp.setValue(null);
            guiLabel guiLabel3 = new guiLabel(Intl.intl("Gauge Emissivity") + ":");
            this.d_emiss = ValueFields.doubleFld(0.9, DoubleVR.between(0.0, 1.0, false, true));
            this.setLayout(new GridBagLayout());
            GridBagUtil.add(this, guiLabel2, 0, 0, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_temp, 1, 0, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, guiLabel3, 0, 1, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_emiss, 1, 1, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
        }

        public UnitDouble getTemp() {
            return (UnitDouble)this.d_temp.getValue();
        }

        public void setTemp(UnitDouble unitDouble) {
            this.d_temp.setValue(unitDouble);
        }

        public Double getEmiss() {
            return (Double)this.d_emiss.getValue();
        }

        public void setEmiss(Double d) {
            this.d_emiss.setValue(d);
        }
    }
}

