/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroTaskManager;
import pyrosim.domain.IPyroObject;
import pyrosim.domain.boundcond.mat.Material;
import pyrosim.domain.devices.detectors.SmokeLinkModel;
import pyrosim.domain.devices.detectors.SmokeLinkModelMgr;
import pyrosim.domain.tasks.AddTask;
import pyrosim.gui.ManagerDlg;
import pyrosim.gui.RenameAction;
import pyrosim.gui.devices.SmokeLinkModelEditor;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.guiAction;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.util.TaskManager;

public class SmokeLinkModelMgrDlg
extends ManagerDlg<SmokeLinkModel, SmokeLinkModelMgr> {
    private static final long serialVersionUID = 7783165884539434554L;
    private final IEditor d_editor;
    private final Action[] d_actions = new Action[]{new NewAction(), new ManagerDlg.LibraryAction(SmokeLinkModel.class), new RenameAction<SmokeLinkModel, SmokeLinkModelMgr>(this, Intl.intl("smoke link model")), new ManagerDlg.DeleteAction()};
    private SmokeLinkModelMgr d_mgr;

    public SmokeLinkModelMgrDlg(JFrame jFrame) {
        super(jFrame, Intl.intl("Smoke Detector Models"), true);
        this.d_editor = new SmokeLinkModelEditor();
        this.setPreviewTypes("PROP", "RAMP");
        this.updateActions();
    }

    public void updateActions() {
        this.d_actions[0].setEnabled(this.d_mgr != null);
        this.d_actions[2].setEnabled(this.d_mgr != null && this.getList().getSelectedIx() > -1);
        this.d_actions[3].setEnabled(this.d_mgr != null && this.getList().getSelectedIx() > -1);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        super.valueChanged(listSelectionEvent);
        this.updateActions();
    }

    public void init(SmokeLinkModelMgr smokeLinkModelMgr, SmokeLinkModel smokeLinkModel) {
        this.d_mgr = smokeLinkModelMgr;
        ((RenameAction)this.d_actions[2]).init(smokeLinkModelMgr);
        super.init(this.d_mgr, this.d_editor, this.d_actions, smokeLinkModel);
        this.updateActions();
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        return super.validateData(bl, bl2) && ((SmokeLinkModelEditor)this.d_editor).validateData(bl, bl2);
    }

    private class NewSMDlg
    extends guiDialog {
        private static final long serialVersionUID = 911240332962425729L;
        SmokeLinkModelEditor d_editor;
        private guiTextField d_name;

        public NewSMDlg(SmokeLinkModelEditor smokeLinkModelEditor) {
            super((Window)Application.getApp().getActiveFrame(), Intl.intl("New Model"), 9);
            this.d_editor = null;
            this.d_name = null;
            this.d_editor = smokeLinkModelEditor;
            this.d_name = new guiTextField(this.generateUniqueName());
            guiPanel guiPanel2 = this.getDialogPane();
            guiPanel2.setLayout(new GridBagLayout());
            GridBagUtil.add(guiPanel2, new guiLabel(Intl.intl("Model Name") + ":"), 0, 0, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(guiPanel2, this.d_name, 1, 0, 1, 1, 0, 0, 6, 0);
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            if (!super.validateData(bl, bl2)) {
                return false;
            }
            String string = this.d_name.getText();
            if (((PyroMod)SmokeLinkModelMgrDlg.this.d_mgr.getDomain()).getNames(SmokeLinkModel.class).isRegistered(string)) {
                String string2 = Intl.intl("Model name already in use.") + "\n" + Intl.intl("Each model must have a unique name.");
                this.showMessageBox(string2);
                this.requestFocusHack();
                return false;
            }
            if (this.d_name.getText().length() < 1) {
                String string3 = Intl.intl("You must name the model.");
                this.showMessageBox(string3);
                this.requestFocusHack();
                return false;
            }
            return true;
        }

        @Override
        public int doModal() {
            return super.doModal();
        }

        @Override
        public String getName() {
            return this.d_name.getValue();
        }

        private String generateUniqueName() {
            return ((PyroMod)SmokeLinkModelMgrDlg.this.d_mgr.getDomain()).getNames(SmokeLinkModel.class).generateName();
        }

        private boolean nameInUse(String string) {
            return ((PyroMod)SmokeLinkModelMgrDlg.this.d_mgr.getDomain()).getNames(SmokeLinkModel.class).isRegistered(string);
        }

        protected class typeCBRenderer
        extends DefaultListCellRenderer {
            private static final long serialVersionUID = -819899512786758561L;
            private Font d_normalFont = new Font("Sans Serif", 1, 11);

            protected typeCBRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                Material material = (Material)object;
                if (material == null) {
                    return this;
                }
                String string = ((Material)object).getName();
                this.setText(string);
                this.setFont(this.d_normalFont);
                return this;
            }
        }
    }

    private class NewAction
    extends guiAction {
        private static final long serialVersionUID = -6300672709508653071L;

        public NewAction() {
            super(Intl.intl("New"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (!SmokeLinkModelMgrDlg.this.preSave()) {
                return;
            }
            NewSMDlg newSMDlg = new NewSMDlg((SmokeLinkModelEditor)SmokeLinkModelMgrDlg.this.d_editor);
            PyroMod pyroMod = (PyroMod)SmokeLinkModelMgrDlg.this.d_mgr.getDomain();
            if (newSMDlg.doModal() == 1) {
                SmokeLinkModel smokeLinkModel = new SmokeLinkModel(newSMDlg.getName());
                PyroTaskManager pyroTaskManager = pyroMod.getTaskManager();
                ((TaskManager)pyroTaskManager).exec(new AddTask((IPyroObject)SmokeLinkModelMgrDlg.this.d_mgr, new IPyroObject[]{smokeLinkModel}), Intl.intl("New Smoke Detector Link Model"));
                SmokeLinkModelMgrDlg.this.getList().updateModelView(SmokeLinkModelMgrDlg.this.d_mgr);
                SmokeLinkModelMgrDlg.this.getList().select(smokeLinkModel);
                SmokeLinkModelMgrDlg.this.updateActions();
            }
        }
    }
}

