/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.JTabbedPane;
import pyrosim.Intl;
import pyrosim.PyroSim;
import pyrosim.domain.ExSpec;
import pyrosim.domain.devices.detectors.SmokeLinkModel;
import pyrosim.gui.CustomFDSPanel;
import pyrosim.gui.comboboxes.ExSpecComboBox;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AOneTimeTask;

public class SmokeLinkModelEditor
implements IEditor<SmokeLinkModel> {
    private final guiPanel d_edPanel;
    private final guiTextField d_fyi;
    private final ValueField<UnitDouble> d_ot;
    private final ExSpecComboBox d_smokeSpecies;
    private final guiComboBox<String> d_cb;
    private final ValueField<UnitDouble> d_hlen;
    private final ValueField<Double> d_cAlphaC;
    private final ValueField<Double> d_cBetaC;
    private final ValueField<Double> d_cAlphaE;
    private final ValueField<Double> d_cBetaE;
    private final CustomFDSPanel d_customPanel;
    private static final String HESKESTAD = Intl.intl("Heskestad Model");
    private static final String CLEARY = Intl.intl("Cleary Model");

    private static UnitSystem getUnits() {
        return PyroSim.getApp().getUnitSystem();
    }

    public SmokeLinkModelEditor() {
        guiPanel guiPanel2 = new guiPanel(new GridBagLayout());
        guiLabel guiLabel2 = new guiLabel(Intl.intl("Description:"));
        this.d_fyi = new guiTextField();
        this.d_customPanel = new CustomFDSPanel(6);
        this.d_ot = ValueFields.udFld(UnitSystem.getSource(31));
        int n = 1;
        GridBagUtil.add(guiPanel2, guiLabel2, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_fyi, 1, n, 5, 1, 0, 0, 6, 6, 2, 1.0, 0.0, 17);
        guiLabel guiLabel3 = new guiLabel(Intl.intl("Obscuration Threshold") + ":");
        GridBagUtil.add(guiPanel2, guiLabel3, 0, ++n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_ot, 1, n, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        guiLabel guiLabel4 = new guiLabel(Intl.intl("Smoke Species:"));
        this.d_smokeSpecies = new ExSpecComboBox(PyroSim.getApp().getMediator().getExSpecList(), null, Intl.intl("Default"));
        GridBagUtil.add(guiPanel2, guiLabel4, 0, ++n, 1, 1, 0, 0, 6, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_smokeSpecies, 1, n, 2, 1, 0, 0, 6, 0, 0, 1.0, 0.0, 17);
        ++n;
        guiLabel guiLabel5 = new guiLabel(Intl.intl("Detector Specification") + ":");
        String[] stringArray = new String[]{HESKESTAD, CLEARY};
        this.d_cb = new guiComboBox<String>((T[])stringArray);
        final CardLayout cardLayout = new CardLayout(0, 0);
        final guiPanel guiPanel3 = new guiPanel(cardLayout);
        guiPanel guiPanel4 = new guiPanel(new GridBagLayout());
        guiPanel guiPanel5 = new guiPanel(new GridBagLayout());
        guiPanel3.add((Component)guiPanel4, HESKESTAD);
        guiPanel3.add((Component)guiPanel5, CLEARY);
        cardLayout.addLayoutComponent(guiPanel4, HESKESTAD);
        cardLayout.addLayoutComponent(guiPanel5, CLEARY);
        GridBagUtil.add(guiPanel2, guiLabel5, 0, n, 1, 1, 0, 0, 12, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_cb, 1, n, 2, 1, 0, 0, 12, 6, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, guiPanel3, 0, ++n, 3, 1, 0, 30, 0, 0, 1, 1.0, 1.0, 18);
        this.d_cb.addActionListener(new ActionListener(){
            private Object last = SmokeLinkModelEditor.access$000();

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object t = SmokeLinkModelEditor.this.d_cb.getSelectedItem();
                if (t != this.last) {
                    cardLayout.show(guiPanel3, ((String)SmokeLinkModelEditor.this.d_cb.getSelectedItem()).toString());
                    SmokeLinkModelEditor.this.d_edPanel.setModified(true);
                    this.last = t;
                }
            }
        });
        this.d_hlen = ValueFields.udFld(UnitSystem.getSource(0));
        guiLabel guiLabel6 = new guiLabel(Intl.intl("Characteristic Length") + ":");
        GridBagUtil.add(guiPanel4, guiLabel6, 0, 0, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel4, this.d_hlen, 1, 0, 1, 1, 0, 0, 0, 6, 0, 0.0, 0.0, 13);
        GridBagUtil.addGlue(guiPanel4);
        this.d_cAlphaC = ValueFields.doubleFld();
        this.d_cBetaC = ValueFields.doubleFld();
        this.d_cAlphaE = ValueFields.doubleFld();
        this.d_cBetaE = ValueFields.doubleFld();
        guiLabel guiLabel7 = new guiLabel("Alpha C:");
        guiLabel guiLabel8 = new guiLabel("Beta C:");
        guiLabel guiLabel9 = new guiLabel("Alpha E:");
        guiLabel guiLabel10 = new guiLabel("Beta E:");
        GridBagUtil.add(guiPanel5, guiLabel7, 0, 0, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel5, this.d_cAlphaC, 1, 0, 1, 1, 0, 0, 6, 30, 2, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel5, guiLabel8, 0, 1, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel5, this.d_cBetaC, 1, 1, 1, 1, 0, 0, 0, 30, 2, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel5, guiLabel9, 2, 0, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel5, this.d_cAlphaE, 3, 0, 1, 1, 0, 0, 6, 0, 2, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel5, guiLabel10, 2, 1, 1, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel5, this.d_cBetaE, 3, 1, 1, 1, 0, 0, 0, 0, 2, 0.0, 0.0, 17);
        GridBagUtil.addGlue(guiPanel5);
        guiPanel2.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(Intl.intl("Properties"), guiPanel2);
        jTabbedPane.addTab(Intl.intl("Advanced"), this.d_customPanel);
        this.d_edPanel = new guiPanel(new BorderLayout());
        this.d_edPanel.add((Component)jTabbedPane, "Center");
        this.init(null);
    }

    @Override
    public void addObserver(Observer observer) {
        this.d_edPanel.addObserver(observer);
    }

    @Override
    public void removeObserver(Observer observer) {
        this.d_edPanel.removeObserver(observer);
    }

    @Override
    public void init(SmokeLinkModel smokeLinkModel) {
        this.d_edPanel.setEnabled(smokeLinkModel != null);
        if (smokeLinkModel != null) {
            this.d_fyi.setText(smokeLinkModel.getFYI());
            this.initSpec(new SmokeLinkModel.Cleary());
            this.initSpec(new SmokeLinkModel.Heskestad());
            this.d_ot.setValue(smokeLinkModel.getActivationObscuration());
            this.initSpec(smokeLinkModel.getSpec());
            this.d_smokeSpecies.setSelectedItem(smokeLinkModel.getSmokeSpecies());
            this.d_customPanel.load(smokeLinkModel);
        }
        this.d_edPanel.setModified(false);
    }

    private void initSpec(SmokeLinkModel.ISpec iSpec) {
        if (iSpec instanceof SmokeLinkModel.Heskestad) {
            SmokeLinkModel.Heskestad heskestad = (SmokeLinkModel.Heskestad)iSpec;
            this.d_cb.setSelectedItem(HESKESTAD);
            this.d_hlen.setValue(heskestad.d_length);
        } else if (iSpec instanceof SmokeLinkModel.Cleary) {
            SmokeLinkModel.Cleary cleary = (SmokeLinkModel.Cleary)iSpec;
            this.d_cb.setSelectedItem(CLEARY);
            this.d_cAlphaC.setValue(cleary.d_cAlpha);
            this.d_cBetaC.setValue(cleary.d_cBeta);
            this.d_cAlphaE.setValue(cleary.d_eAlpha);
            this.d_cBetaE.setValue(cleary.d_eBeta);
        }
    }

    @Override
    public boolean isModified() {
        return this.d_edPanel.isModified();
    }

    @Override
    public SmokeLinkModel commit(final SmokeLinkModel smokeLinkModel) {
        assert (smokeLinkModel != null);
        assert (this.isModified());
        AOneTimeTask aOneTimeTask = new AOneTimeTask(){

            @Override
            public void run() {
                SmokeLinkModelEditor.this.save(smokeLinkModel);
            }
        };
        PyroSim.getApp().getMediator().getTaskManager().exec(aOneTimeTask, Intl.intl("Edit Smoke Detector Model"));
        this.d_edPanel.setModified(false);
        return smokeLinkModel;
    }

    public boolean validateData(boolean bl, boolean bl2) {
        return this.d_edPanel.validateData(bl, bl2);
    }

    @Override
    public guiPanel getEditorPanel() {
        return this.d_edPanel;
    }

    @Override
    public SmokeLinkModel preview(SmokeLinkModel smokeLinkModel) {
        this.save(smokeLinkModel);
        return smokeLinkModel;
    }

    private void save(SmokeLinkModel smokeLinkModel) {
        smokeLinkModel.setFYI(this.d_fyi.getText());
        UnitDouble unitDouble = (UnitDouble)this.d_ot.getValue();
        smokeLinkModel.setActivationObscuration(unitDouble);
        ExSpec exSpec = this.d_smokeSpecies.getSelectedItem();
        smokeLinkModel.setSmokeSpecies(exSpec);
        if (this.d_cb.getSelectedItem() == HESKESTAD) {
            smokeLinkModel.setSpec(new SmokeLinkModel.Heskestad((UnitDouble)this.d_hlen.getValue()));
        } else if (this.d_cb.getSelectedItem() == CLEARY) {
            smokeLinkModel.setSpec(new SmokeLinkModel.Cleary((Double)this.d_cAlphaC.getValue(), (Double)this.d_cBetaC.getValue(), (Double)this.d_cAlphaE.getValue(), (Double)this.d_cBetaE.getValue()));
        }
        this.d_customPanel.save(smokeLinkModel);
    }

    static /* synthetic */ String access$000() {
        return HESKESTAD;
    }
}

