/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.devices.detectors.SmokeDetector;
import pyrosim.domain.devices.detectors.SmokeLinkModel;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.comboboxes.SmokeLinkModelComboBox;
import pyrosim.gui.devices.ADevcEditor;
import pyrosim.gui.geom.FreePointGeomEditor;
import pyrosim.gui.geom.IGeomEditor;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;

public class SmokeDetectorEditor
extends ADevcEditor<SmokeDetector> {
    private final SmokeDetectorDataPanel d_dataPanel;

    public SmokeDetectorEditor(PyroMod pyroMod) {
        this.d_dataPanel = new SmokeDetectorDataPanel(pyroMod);
    }

    @Override
    public String getDesc() {
        return Intl.intl("Smoke Detector");
    }

    @Override
    public String getDefName() {
        return Intl.intl("SD");
    }

    @Override
    public IGeomEditor<? extends IGeom> createGeomEditor() {
        return new FreePointGeomEditor();
    }

    @Override
    public guiPanel getDataPanel() {
        return this.d_dataPanel;
    }

    @Override
    public boolean validateData(Component component, SmokeDetector smokeDetector, boolean bl, boolean bl2) {
        return true;
    }

    @Override
    public SmokeDetector create() {
        return new SmokeDetector("", this.d_dataPanel.getSmokeLinkModel());
    }

    @Override
    public void load(SmokeDetector smokeDetector) {
        this.d_dataPanel.setSmokeLinkModel(smokeDetector.getModel());
    }

    @Override
    public void save(SmokeDetector smokeDetector) {
        smokeDetector.setModel(this.d_dataPanel.getSmokeLinkModel());
    }

    public static class SmokeDetectorDataPanel
    extends guiPanel {
        private static final long serialVersionUID = 1165057042647528613L;
        private final guiComboBox<SmokeLinkModel> d_modelCombo;

        public SmokeDetectorDataPanel(PyroMod pyroMod) {
            this.setLayout(new GridBagLayout());
            this.d_modelCombo = new SmokeLinkModelComboBox(pyroMod.getSmokeLinkModels());
            this.d_modelCombo.setMinimumSize(this.d_modelCombo.getPreferredSize());
            this.setSmokeLinkModel(pyroMod.getSmokeLinkModels().getDefaultModel());
            JButton jButton = new JButton(Intl.intl("Edit") + "...");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Actions.editSmokeLinkModels((SmokeLinkModel)d_modelCombo.getSelectedItem());
                    if (d_modelCombo.getSelectedItem() == null && d_modelCombo.getItemCount() > 0) {
                        d_modelCombo.setSelectedIndex(0);
                    }
                }
            });
            GridBagHelper gridBagHelper = new GridBagHelper(this);
            gridBagHelper.addRow(Intl.intl("Model:"), this.d_modelCombo, jButton, 0);
            gridBagHelper.finalizeRows();
        }

        public SmokeLinkModel getSmokeLinkModel() {
            return this.d_modelCombo.getSelectedItem();
        }

        public void setSmokeLinkModel(SmokeLinkModel smokeLinkModel) {
            this.d_modelCombo.setSelectedItem(smokeLinkModel);
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            if (!super.validateData(bl, bl2)) {
                return false;
            }
            if (this.d_modelCombo.getSelectedItem() == null) {
                if (bl) {
                    guiDialog.showInvalidEntryMessage(this, Intl.intl("Please choose a model."));
                }
                if (bl2) {
                    this.d_modelCombo.requestFocus();
                }
                return false;
            }
            return true;
        }
    }
}

