/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.devices.sprayers.Nozzle;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.particle.Particle;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.comboboxes.SprayModelComboBox;
import pyrosim.gui.devices.ADevcEditor;
import pyrosim.gui.geom.FreePointGeomEditor;
import pyrosim.gui.geom.IGeomEditor;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;

public class NozzleEditor
extends ADevcEditor<Nozzle> {
    private final NozzleDataPanel d_dataPanel;

    public NozzleEditor(PyroMod pyroMod) {
        this.d_dataPanel = new NozzleDataPanel(pyroMod);
    }

    @Override
    public String getDesc() {
        return Intl.intl("Nozzle");
    }

    @Override
    public String getDefName() {
        return Intl.intl("NOZZLE");
    }

    @Override
    public IGeomEditor<? extends IGeom> createGeomEditor() {
        return new FreePointGeomEditor();
    }

    @Override
    public guiPanel getDataPanel() {
        return this.d_dataPanel;
    }

    @Override
    public boolean validateData(Component component, Nozzle nozzle, boolean bl, boolean bl2) {
        return true;
    }

    @Override
    public Nozzle create() {
        return new Nozzle("", this.d_dataPanel.getSprayModel());
    }

    @Override
    public void load(Nozzle nozzle) {
        this.d_dataPanel.setSprayModel(nozzle);
    }

    @Override
    public void save(Nozzle nozzle) {
        nozzle.setSprayModel(this.d_dataPanel.getSprayModel());
    }

    public class NozzleDataPanel
    extends guiPanel {
        private static final long serialVersionUID = -4506442033051845947L;
        private final SprayModelComboBox d_sprayCombo;

        public NozzleDataPanel(PyroMod pyroMod) {
            this.setLayout(new GridBagLayout());
            this.d_sprayCombo = new SprayModelComboBox(pyroMod.getSprayModels());
            this.d_sprayCombo.setMinimumSize(this.d_sprayCombo.getPreferredSize());
            JButton jButton = new JButton(Intl.intl("Edit") + "...");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Actions.editSprayModel((SprayModel)NozzleDataPanel.this.d_sprayCombo.getSelectedItem());
                    if (NozzleDataPanel.this.d_sprayCombo.getSelectedItem() == null && NozzleDataPanel.this.d_sprayCombo.getItemCount() > 0) {
                        NozzleDataPanel.this.d_sprayCombo.selectFirstOfType(Particle.Type.LIQUID);
                    }
                }
            });
            this.d_sprayCombo.selectFirstOfType(Particle.Type.LIQUID);
            GridBagHelper gridBagHelper = new GridBagHelper(this);
            gridBagHelper.addRow(Intl.intl("Spray Type:"), this.d_sprayCombo, jButton);
            gridBagHelper.finalizeRows();
        }

        public SprayModel getSprayModel() {
            return (SprayModel)this.d_sprayCombo.getSelectedItem();
        }

        public void setSprayModel(Nozzle nozzle) {
            this.d_sprayCombo.setSelectedItem(nozzle.getSprayModel());
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            if (!super.validateData(bl, bl2)) {
                return false;
            }
            if (this.d_sprayCombo.getSelectedItem() == null) {
                if (bl) {
                    guiDialog.showInvalidEntryMessage(this, Intl.intl("Please choose a spray type."));
                }
                if (bl2) {
                    this.d_sprayCombo.requestFocus();
                }
                return false;
            }
            return true;
        }
    }
}

