/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.GridLayout;
import java.awt.Window;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.devices.sprayers.SprayModel;
import pyrosim.domain.devices.sprayers.SprayModelMgr;
import thunderheadeng.gui.Application;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;

public class NewSprayModelDlg
extends guiDialog {
    private static final long serialVersionUID = 3552622551662834449L;
    private final guiTextField d_name;
    private final SprayModelMgr d_sprayModels;

    public NewSprayModelDlg(SprayModelMgr sprayModelMgr) {
        super((Window)Application.getApp().getActiveFrame(), Intl.intl("New Spray Model"), 9);
        this.d_sprayModels = sprayModelMgr;
        this.d_name = new guiTextField(((PyroMod)sprayModelMgr.getDomain()).getNames(SprayModel.class).generateName());
        guiLabel guiLabel2 = new guiLabel(Intl.intl("Spray Model Name") + ":   ");
        guiPanel guiPanel2 = this.getDialogPane();
        guiPanel2.setLayout(new GridLayout(1, 2));
        guiPanel2.add(guiLabel2);
        guiPanel2.add(this.d_name);
    }

    public String getSprayModelName() {
        return this.d_name.getValue();
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        if (!super.validateData(bl, bl2)) {
            return false;
        }
        if (this.d_name.getText().length() < 1) {
            NewSprayModelDlg.showInvalidEntryMessage(this, Intl.intl("Please enter a name."));
            this.d_name.requestFocus();
            return false;
        }
        if (((PyroMod)this.d_sprayModels.getDomain()).getNames(SprayModel.class).isRegistered(this.d_name.getText())) {
            NewSprayModelDlg.showInvalidEntryMessage(this, String.format(Intl.intl("There is already a spray model named %s.\nPlease choose another name."), this.d_name.getText()));
            this.d_name.requestFocus();
            return false;
        }
        return true;
    }
}

