/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import javax.swing.SwingUtilities;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.devices.IDevice;
import pyrosim.gui.IGridBagAdder;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;

public class NamePnl
extends guiPanel
implements IGridBagAdder {
    private static final long serialVersionUID = 7595994933846914872L;
    private final PyroMod d_pyMod;
    private String d_loadedName;
    private final guiTextField d_nameFld;

    public NamePnl(PyroMod pyroMod, String string) {
        this.d_pyMod = pyroMod;
        this.d_nameFld = new guiTextField(pyroMod.getNames(IDevice.class).generateValidName(string));
        GridBagHelper gridBagHelper = new GridBagHelper(this);
        this.add(gridBagHelper);
        gridBagHelper.finalizeRows();
    }

    @Override
    public void add(GridBagHelper gridBagHelper) {
        gridBagHelper.addRow(Intl.intl("Name:"), this.d_nameFld, 0, 1.0);
    }

    public guiTextField getNameField() {
        return this.d_nameFld;
    }

    protected void setDefaultName(String string) {
        this.d_nameFld.setText(this.d_pyMod.getNames(IDevice.class).generateValidName(string));
    }

    public void load(String string) {
        this.d_nameFld.setText(string);
        this.d_loadedName = string;
    }

    public String save() {
        return this.d_nameFld.getText();
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        if (!super.validateData(bl, bl2)) {
            return false;
        }
        if (this.d_nameFld.getText().equals(this.d_loadedName)) {
            return true;
        }
        String string = this.d_nameFld.getText().trim();
        if (string.length() < 1) {
            if (bl) {
                guiDialog.showInvalidEntryMessage(SwingUtilities.getWindowAncestor(this.d_nameFld), Intl.intl("Please enter a name."));
            }
            if (bl2) {
                this.d_nameFld.requestFocus();
            }
            return false;
        }
        if (this.d_pyMod.getNames(IDevice.class).isRegistered(string)) {
            if (bl) {
                guiDialog.showInvalidEntryMessage(SwingUtilities.getWindowAncestor(this.d_nameFld), String.format(Intl.intl("There is already a device named %s.\nPlease enter another name."), string));
            }
            if (bl2) {
                this.d_nameFld.requestFocus();
            }
            return false;
        }
        return true;
    }
}

