/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import pyrosim.Intl;
import pyrosim.domain.devices.measurers.LayerMeasurer;
import pyrosim.domain.devices.measurers.MeasureOutInfo;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.devices.ADevcEditor;
import pyrosim.gui.devices.AlarmInfoPanel;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.gui.geom.LineSegEditor;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiPanel;

public class LayerMsrEditor
extends ADevcEditor<LayerMeasurer> {
    private final LayerInfoDataPanel d_dataPanel = new LayerInfoDataPanel();

    public LayerMsrEditor() {
        this.load(new LayerMeasurer(Intl.intl("LAYER")));
    }

    @Override
    public String getDesc() {
        return Intl.intl("Layer Zoning Device");
    }

    @Override
    public String getDefName() {
        return Intl.intl("LAYER");
    }

    @Override
    public IGeomEditor<? extends IGeom> createGeomEditor() {
        return new LineSegEditor();
    }

    @Override
    public AlarmInfoPanel createAlarmPanel() {
        return null;
    }

    @Override
    public guiPanel getDataPanel() {
        return this.d_dataPanel;
    }

    @Override
    public boolean validateData(Component component, LayerMeasurer layerMeasurer, boolean bl, boolean bl2) {
        return true;
    }

    @Override
    public LayerMeasurer create() {
        return new LayerMeasurer("");
    }

    @Override
    public void load(LayerMeasurer layerMeasurer) {
        this.d_dataPanel.d_heightInfo.load(layerMeasurer.getHeightInfo());
        this.d_dataPanel.d_lowerTempInfo.load(layerMeasurer.getLowerTempInfo());
        this.d_dataPanel.d_upperTempInfo.load(layerMeasurer.getUpperTempInfo());
    }

    @Override
    public void save(LayerMeasurer layerMeasurer) {
        layerMeasurer.setMeasures(this.d_dataPanel.d_heightInfo.d_enabled.isSelected(), this.d_dataPanel.d_lowerTempInfo.d_enabled.isSelected(), this.d_dataPanel.d_upperTempInfo.d_enabled.isSelected());
        layerMeasurer.getHeightInfo().setAlarmInfo(this.d_dataPanel.d_heightInfo.d_alarmPanel.save());
        layerMeasurer.getLowerTempInfo().setAlarmInfo(this.d_dataPanel.d_lowerTempInfo.d_alarmPanel.save());
        layerMeasurer.getUpperTempInfo().setAlarmInfo(this.d_dataPanel.d_upperTempInfo.d_alarmPanel.save());
    }

    public class LayerInfoDataPanel
    extends guiPanel {
        private static final long serialVersionUID = -7337015475435543635L;
        private final OutputInfo d_heightInfo;
        private final OutputInfo d_lowerTempInfo;
        private final OutputInfo d_upperTempInfo;

        public LayerInfoDataPanel() {
            this.setLayout(new GridBagLayout());
            this.d_heightInfo = new OutputInfo(Intl.intl("Measure Layer Height"), Quantity.LAYER_HEIGHT.create());
            this.d_upperTempInfo = new OutputInfo(Intl.intl("Measure Upper Temperature"), Quantity.UPPER_TEMPERATURE.create());
            this.d_lowerTempInfo = new OutputInfo(Intl.intl("Measure Lower Temperature"), Quantity.LOWER_TEMPERATURE.create());
            GridBagUtil.add(this, this.d_heightInfo, 0, 1, 2, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_upperTempInfo, 0, 2, 2, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.add(this, this.d_lowerTempInfo, 0, 3, 2, 1, 0, 0, 0, 12, 0, 0.0, 0.0, 17);
            GridBagUtil.addGlue(this);
        }

        private class OutputInfo
        extends guiPanel {
            private static final long serialVersionUID = 3381193455926002286L;
            private final guiCheckBox d_enabled;
            private final AlarmInfoPanel d_alarmPanel;
            private final IQuantity d_msr;

            public OutputInfo(String string, IQuantity iQuantity) {
                super(new GridBagLayout());
                this.d_msr = iQuantity;
                this.d_enabled = new guiCheckBox(string);
                this.d_alarmPanel = new AlarmInfoPanel(iQuantity, 1);
                this.d_alarmPanel.setVisible(false);
                this.d_enabled.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent itemEvent) {
                        OutputInfo.this.d_alarmPanel.setVisible(OutputInfo.this.d_enabled.isSelected());
                        PyroGuiUtil.pack(OutputInfo.this);
                    }
                });
                LinkStatus.link((AbstractButton)this.d_enabled, this.d_alarmPanel);
                GridBagUtil.add(this, this.d_enabled, 0, 1, 1, 1, 0, 0, 6, 0, 0, 0.0, 0.0, 17);
                GridBagUtil.add(this, this.d_alarmPanel, 0, 2, 1, 1, 0, 18, 0, 0, 0, 0.0, 0.0, 17);
                GridBagUtil.addGlue(this);
            }

            private void load(MeasureOutInfo measureOutInfo) {
                this.d_enabled.setSelected(measureOutInfo.isEnabled());
                if (measureOutInfo.isEnabled()) {
                    this.d_alarmPanel.load(this.d_msr, measureOutInfo.getAlarmInfo());
                }
            }
        }
    }
}

