/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.Component;
import java.awt.GridBagLayout;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.devices.hvac.DuctDevice;
import pyrosim.domain.devices.hvac.HvacDevice;
import pyrosim.domain.devices.hvac.NodeDevice;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.domain.quantity.QuantityUtil;
import pyrosim.gui.comboboxes.QuantityComboBox;
import pyrosim.gui.devices.ADevcEditor;
import pyrosim.gui.devices.IDevcEditor;
import pyrosim.gui.geom.IGeomEditor;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;

public class HvacDevcEditor
extends ADevcEditor<HvacDevice> {
    public static final int DUCT = 0;
    public static final int NODE = 1;
    private final String d_desc;
    private final String d_defName;
    private final HvacDevcDataPanel d_dataPanel;
    private final IDevcEditor.Mode d_mode;
    private int d_type;

    public HvacDevcEditor(PyroMod pyroMod, IDevcEditor.Mode mode, int n) {
        this(pyroMod, Intl.intl("HVAC Device"), Intl.intl("HVAC"), mode, n);
    }

    public HvacDevcEditor(PyroMod pyroMod, String string, String string2, IDevcEditor.Mode mode, int n) {
        this.d_desc = string;
        this.d_defName = string2;
        this.d_type = n;
        this.d_mode = mode;
        this.d_dataPanel = new HvacDevcDataPanel(pyroMod);
    }

    @Override
    public HvacDevice create() {
        IQuantity iQuantity = (IQuantity)this.d_dataPanel.d_measCombo.getSelectedItem();
        if (this.d_type == 0) {
            return new DuctDevice("", iQuantity);
        }
        if (this.d_type == 1) {
            return new NodeDevice("", iQuantity);
        }
        return null;
    }

    @Override
    public void save(HvacDevice hvacDevice) {
        if (hvacDevice == null) {
            this.create();
        } else {
            this.d_dataPanel.save(hvacDevice);
        }
    }

    @Override
    public void load(HvacDevice hvacDevice) {
        this.d_dataPanel.load(hvacDevice);
    }

    @Override
    public String getDesc() {
        return this.d_desc;
    }

    @Override
    public String getDefName() {
        return this.d_defName;
    }

    @Override
    public guiPanel getDataPanel() {
        return this.d_dataPanel;
    }

    @Override
    public IGeomEditor createGeomEditor() {
        return null;
    }

    @Override
    public boolean validateData(Component component, HvacDevice hvacDevice, boolean bl, boolean bl2) {
        return this.d_dataPanel.validateData(false, false);
    }

    private class HvacDevcDataPanel
    extends guiPanel {
        private static final long serialVersionUID = 5620527752378853409L;
        QuantityComboBox d_measCombo;
        PyroMod d_pyMod;

        public HvacDevcDataPanel(PyroMod pyroMod) {
            this.d_pyMod = pyroMod;
            this.setLayout(new GridBagLayout());
            guiLabel guiLabel2 = new guiLabel(Intl.intl("Quantity: "));
            this.d_measCombo = new QuantityComboBox();
            this.updateDlg();
            GridBagUtil.add(this, guiLabel2, 0, 1, 1, 1, 15, 0, 0, 0);
            GridBagUtil.add(this, this.d_measCombo, 1, 1, 1, 1, 11, 0, 0, 0);
        }

        private void updateDlg() {
            QuantityUtil.TypeFilter typeFilter = null;
            typeFilter = HvacDevcEditor.this.d_type == 0 ? new QuantityUtil.TypeFilter(0, QuantityType.HVAC_DUCT) : new QuantityUtil.TypeFilter(0, QuantityType.HVAC_NODE);
            this.d_measCombo.setFilter(typeFilter);
        }

        public void load(HvacDevice hvacDevice) {
            if (hvacDevice instanceof DuctDevice && HvacDevcEditor.this.d_type != 0) {
                HvacDevcEditor.this.d_type = 0;
                this.updateDlg();
            }
            if (hvacDevice instanceof NodeDevice && HvacDevcEditor.this.d_type != 1) {
                HvacDevcEditor.this.d_type = 1;
                this.updateDlg();
            }
            if (hvacDevice != null && hvacDevice.getQuantity() != null) {
                this.d_measCombo.setSelectedItem(hvacDevice.getQuantity());
            }
        }

        public void save(HvacDevice hvacDevice) {
            IQuantity iQuantity = (IQuantity)this.d_measCombo.getSelectedItem();
            hvacDevice.setQuantity(iQuantity);
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            if (!super.validateData(bl, bl2)) {
                return false;
            }
            return this.d_measCombo.getSelectedItem() != null;
        }
    }
}

