/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JTabbedPane;
import org.jscience.physics.units.SI;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.devices.detectors.HeatLinkModel;
import pyrosim.domain.devices.detectors.HeatLinkModelMgr;
import pyrosim.gui.CustomFDSPanel;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.gui.GridBagUtil;
import thunderheadeng.gui.IEditor;
import thunderheadeng.gui.LinkStatus;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiCheckBox;
import thunderheadeng.gui.guiConstUnitDoubleField;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.guiTextField;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.AOneTimeTask;

public class HeatLinkModelPanel
extends guiPanel
implements IEditor<HeatLinkModel> {
    private static final long serialVersionUID = -4639877275088909555L;
    private final HeatLinkModelMgr d_heatLMMgr;
    private final guiDialog d_parent;
    private final UnitSystem d_currentUS;
    private final guiCheckBox d_initTempCB;
    private final ValueField<UnitDouble> d_initTemp;
    private final ValueField<UnitDouble> d_activTemp;
    private final guiConstUnitDoubleField d_respTimeInd;
    private final guiTextField d_name;
    private final guiTextField d_fyi;
    private final CustomFDSPanel d_customPnl = new CustomFDSPanel(6);

    public HeatLinkModelPanel(guiDialog guiDialog2) {
        PyroSim pyroSim = PyroSim.getApp();
        PyroMod pyroMod = pyroSim.getMediator();
        this.d_heatLMMgr = pyroMod.getHeatLinkModels();
        this.d_currentUS = pyroSim.getUnitSystem();
        this.d_parent = guiDialog2;
        this.d_name = new guiTextField();
        this.d_name.setEditable(false);
        this.d_fyi = new guiTextField();
        this.setLayout(new GridBagLayout());
        this.d_initTempCB = new guiCheckBox(Intl.intl("Initial Temperature") + ":");
        this.d_initTemp = ValueFields.udFld(UnitSystem.getSource(1));
        this.d_activTemp = ValueFields.udFld(UnitSystem.getSource(1));
        this.d_respTimeInd = new guiConstUnitDoubleField(UnitSystem.getSource(3).getUnit());
        guiLabel guiLabel2 = new guiLabel(Intl.intl("Activation Temperature") + ":");
        guiLabel guiLabel3 = new guiLabel(Intl.intl("Response Time Index") + ":");
        guiLabel guiLabel4 = new guiLabel(this.d_respTimeInd.getUnit().toString());
        guiPanel guiPanel2 = new guiPanel(new GridBagLayout());
        int n = 0;
        GridBagUtil.add(guiPanel2, new guiLabel(Intl.intl("Heat Detector Model ID") + ":"), 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_name, 1, n++, 3, 1, 0, 0, 6, 1, 2, 1.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, new guiLabel(Intl.intl("Description") + ":"), 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_fyi, 1, n++, 3, 1, 0, 0, 6, 1, 2, 1.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_initTempCB, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_initTemp, 1, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, guiLabel2, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_activTemp, 1, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, guiLabel3, 0, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, this.d_respTimeInd, 1, n, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.add(guiPanel2, guiLabel4, 2, n++, 1, 1, 0, 0, 6, 12, 0, 0.0, 0.0, 17);
        GridBagUtil.addGlue(guiPanel2);
        LinkStatus.link((AbstractButton)this.d_initTempCB, this.d_initTemp);
        guiPanel2.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.addTab(Intl.intl("Properties"), guiPanel2);
        jTabbedPane.addTab(Intl.intl("Advanced"), this.d_customPnl);
        this.setLayout(new BorderLayout());
        this.add((Component)jTabbedPane, "Center");
        this.init(new HeatLinkModel(""));
        this.setEnabled(false);
        this.setModified(false);
    }

    @Override
    public HeatLinkModel commit(final HeatLinkModel heatLinkModel) {
        AOneTimeTask aOneTimeTask = new AOneTimeTask(){

            @Override
            public void run() {
                HeatLinkModelPanel.this.save(heatLinkModel);
            }
        };
        PyroSim.getApp().getMediator().getTaskManager().exec(aOneTimeTask, Intl.intl("Edit Heat Detector Model"));
        this.setModified(false);
        return heatLinkModel;
    }

    private void save(HeatLinkModel heatLinkModel) {
        heatLinkModel.setFYI(this.d_fyi.getText());
        UnitDouble unitDouble = null;
        if (this.d_initTempCB.isSelected()) {
            unitDouble = (UnitDouble)this.d_initTemp.getValue();
        }
        heatLinkModel.setActivationTemp((UnitDouble)this.d_activTemp.getValue());
        heatLinkModel.setRti((UnitDouble)this.d_respTimeInd.getValue());
        heatLinkModel.setInitialTemp(unitDouble);
        this.d_customPnl.save(heatLinkModel);
    }

    @Override
    public guiPanel getEditorPanel() {
        return this;
    }

    @Override
    public void init(HeatLinkModel heatLinkModel) {
        this.setEnabled(heatLinkModel != null);
        if (heatLinkModel != null) {
            this.d_name.setText(heatLinkModel.getName());
            this.d_fyi.setText(heatLinkModel.getFYI());
            if (heatLinkModel.getInitialTemp() != null) {
                this.d_initTempCB.setSelected(true);
                this.d_initTemp.setValue(heatLinkModel.getInitialTemp());
            } else {
                this.d_initTempCB.setSelected(false);
                this.d_initTemp.setValue(new UnitDouble(20.0, SI.CELSIUS));
            }
            this.d_activTemp.setValue(heatLinkModel.getActivationTemp());
            this.d_respTimeInd.setValue(heatLinkModel.getRti());
            this.d_customPnl.load(heatLinkModel);
        }
        this.setModified(false);
    }

    @Override
    public HeatLinkModel preview(HeatLinkModel heatLinkModel) {
        this.save(heatLinkModel);
        return heatLinkModel;
    }
}

