/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.devices.detectors.HeatDetector;
import pyrosim.domain.devices.detectors.HeatLinkModel;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.gui.actions.Actions;
import pyrosim.gui.comboboxes.HeatLinkModelComboBox;
import pyrosim.gui.devices.ADevcEditor;
import pyrosim.gui.geom.FreePointGeomEditor;
import pyrosim.gui.geom.IGeomEditor;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;

public class HeatDetectorEditor
extends ADevcEditor<HeatDetector> {
    private final HeatDetectorDataPanel d_dataPanel;

    public HeatDetectorEditor(PyroMod pyroMod) {
        this.d_dataPanel = new HeatDetectorDataPanel(pyroMod);
    }

    @Override
    public String getDesc() {
        return Intl.intl("Heat Detector");
    }

    @Override
    public String getDefName() {
        return Intl.intl("HD");
    }

    @Override
    public void load(HeatDetector heatDetector) {
        this.d_dataPanel.setHeatLinkModel(heatDetector.getModel());
    }

    @Override
    public HeatDetector create() {
        return new HeatDetector("", this.d_dataPanel.getHeatLinkModel(), new FreePointLoc());
    }

    @Override
    public void save(HeatDetector heatDetector) {
        heatDetector.setModel(this.d_dataPanel.getHeatLinkModel());
    }

    @Override
    public IGeomEditor<? extends IGeom> createGeomEditor() {
        return new FreePointGeomEditor();
    }

    @Override
    public guiPanel getDataPanel() {
        return this.d_dataPanel;
    }

    @Override
    public boolean validateData(Component component, HeatDetector heatDetector, boolean bl, boolean bl2) {
        return true;
    }

    public static class HeatDetectorDataPanel
    extends guiPanel {
        private static final long serialVersionUID = -5913785177024606267L;
        private final guiComboBox<HeatLinkModel> d_linkCombo;

        public HeatDetectorDataPanel(PyroMod pyroMod) {
            this.setLayout(new GridBagLayout());
            this.d_linkCombo = new HeatLinkModelComboBox(pyroMod.getHeatLinkModels());
            this.d_linkCombo.setMinimumSize(this.d_linkCombo.getPreferredSize());
            JButton jButton = new JButton(Intl.intl("Edit") + "...");
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    Actions.editHeatLinkModels((HeatLinkModel)d_linkCombo.getSelectedItem());
                    if (d_linkCombo.getSelectedItem() == null && d_linkCombo.getItemCount() > 0) {
                        d_linkCombo.setSelectedIndex(0);
                    }
                }
            });
            GridBagHelper gridBagHelper = new GridBagHelper(this);
            gridBagHelper.addRow(Intl.intl("Link:"), this.d_linkCombo, jButton, 0);
            gridBagHelper.finalizeRows();
        }

        public HeatLinkModel getHeatLinkModel() {
            return this.d_linkCombo.getSelectedItem();
        }

        public void setHeatLinkModel(HeatLinkModel heatLinkModel) {
            this.d_linkCombo.setSelectedItem(heatLinkModel);
        }

        @Override
        public boolean validateData(boolean bl, boolean bl2) {
            if (!super.validateData(bl, bl2)) {
                return false;
            }
            if (this.d_linkCombo.getSelectedItem() == null) {
                if (bl) {
                    guiDialog.showInvalidEntryMessage(this, Intl.intl("Please choose a link."));
                }
                if (bl2) {
                    this.d_linkCombo.requestFocus();
                }
                return false;
            }
            return true;
        }
    }
}

