/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.devices.DeviceManager;
import pyrosim.domain.devices.measurers.GasPointMeasurer;
import pyrosim.domain.devices.measurers.Thermocouple;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.Quantity;
import pyrosim.gui.PyroGuiUtil;
import pyrosim.gui.comboboxes.QuantityComboBox;
import pyrosim.gui.devices.ADevcEditor;
import pyrosim.gui.devices.AlarmInfoPanel;
import pyrosim.gui.devices.IDevcEditor;
import pyrosim.gui.devices.MsrDeviceEditorUtil;
import pyrosim.gui.geom.FreePointGeomEditor;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.Filters;
import thunderheadeng.util.Sets;

public class GasPointDevcEditor
extends ADevcEditor<GasPointMeasurer> {
    private final String d_desc;
    private final String d_defName;
    private final GasPointDeviceDataPanel d_dataPanel;
    private final IQuantity d_fixedMsr;

    public GasPointDevcEditor(PyroMod pyroMod, IDevcEditor.Mode mode) {
        this(pyroMod, Intl.intl("Gas-phase Device"), Intl.intl("GAS"), null, mode);
    }

    public GasPointDevcEditor(PyroMod pyroMod, String string, String string2, IQuantity iQuantity, IDevcEditor.Mode mode) {
        this.d_desc = string;
        this.d_defName = string2;
        this.d_dataPanel = new GasPointDeviceDataPanel(pyroMod, iQuantity, mode);
        this.d_fixedMsr = iQuantity;
    }

    @Override
    public String getDefName() {
        return this.d_defName;
    }

    @Override
    public String getDesc() {
        return this.d_desc;
    }

    @Override
    public Collection<String> getCustomTypes() {
        HashSet<String> hashSet = new HashSet<String>();
        GasPointMeasurer.getCustomFDSTypes((IQuantity)this.d_dataPanel.d_measCombo.getSelectedItem(), hashSet);
        return hashSet;
    }

    @Override
    public Set<String> getFDSPreviewTypes() {
        return Sets.fromArrayHS("PROP", "DEVC");
    }

    @Override
    public AlarmInfoPanel createAlarmPanel() {
        final AlarmInfoPanel alarmInfoPanel = new AlarmInfoPanel((IQuantity)this.d_dataPanel.d_measCombo.getSelectedItem());
        this.d_dataPanel.d_measCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    alarmInfoPanel.setCurrentMsr((IQuantity)GasPointDevcEditor.this.d_dataPanel.d_measCombo.getSelectedItem());
                }
            }
        });
        if (this.d_fixedMsr != null) {
            alarmInfoPanel.setCurrentMsr(this.d_fixedMsr);
        }
        return alarmInfoPanel;
    }

    @Override
    public IGeomEditor<? extends IGeom> createGeomEditor() {
        return new FreePointGeomEditor();
    }

    @Override
    public void load(GasPointMeasurer gasPointMeasurer) {
        this.d_dataPanel.load(gasPointMeasurer);
    }

    @Override
    public GasPointMeasurer create() {
        return this.d_dataPanel.create("");
    }

    @Override
    public void save(GasPointMeasurer gasPointMeasurer) {
        this.d_dataPanel.save(gasPointMeasurer);
    }

    @Override
    public boolean validateData(Component component, GasPointMeasurer gasPointMeasurer, boolean bl, boolean bl2) {
        return MsrDeviceEditorUtil.validateData(component, gasPointMeasurer, (IQuantity)this.d_dataPanel.d_measCombo.getSelectedItem(), bl, bl2);
    }

    @Override
    public guiPanel getDataPanel() {
        return this.d_dataPanel;
    }

    public static class GasPointDeviceDataPanel
    extends guiPanel {
        private static final long serialVersionUID = 3844599879929888196L;
        private final IDevcEditor.Mode d_mode;
        private final DeviceManager d_mgr;
        private final QuantityComboBox d_measCombo;
        private final ThermocoupleProps d_thermocouplePanel;

        public GasPointDeviceDataPanel(PyroMod pyroMod, IQuantity iQuantity, IDevcEditor.Mode mode) {
            this.d_mgr = pyroMod.getDevices();
            this.d_mode = mode;
            this.setLayout(new GridBagLayout());
            this.d_measCombo = new QuantityComboBox(GasPointMeasurer.getOutputType(), GasPointMeasurer.getQuantityType());
            this.d_measCombo.setMinimumSize(this.d_measCombo.getPreferredSize());
            this.d_thermocouplePanel = new ThermocoupleProps();
            this.d_measCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    this.updateCardSelect();
                }
            });
            if (iQuantity != null) {
                this.d_measCombo.setSelectedItem(iQuantity);
            }
            if (mode == IDevcEditor.Mode.EDIT) {
                this.d_measCombo.setEnabled(false);
            }
            GridBagHelper gridBagHelper = new GridBagHelper(this);
            gridBagHelper.addRow(Intl.intl("Quantity:"), this.d_measCombo, 0);
            gridBagHelper.addRow(this.d_thermocouplePanel, 0, 1.0);
            gridBagHelper.finalizeRows();
            this.updateCardSelect();
        }

        private void updateCardSelect() {
            this.d_thermocouplePanel.setVisible(((IQuantity)this.d_measCombo.getSelectedItem()).get().equals((Object)Quantity.THERMOCOUPLE));
            PyroGuiUtil.pack(this);
        }

        public void load(GasPointMeasurer gasPointMeasurer) {
            this.d_measCombo.setSelectedItem(gasPointMeasurer.getQuantity());
            if (gasPointMeasurer instanceof Thermocouple) {
                Thermocouple thermocouple = (Thermocouple)gasPointMeasurer;
                this.d_thermocouplePanel.load(thermocouple);
                if (this.d_mode == IDevcEditor.Mode.EDIT) {
                    this.d_measCombo.setEnabled(false);
                }
            } else {
                if (this.d_mode == IDevcEditor.Mode.EDIT) {
                    Predicate<Quantity> predicate = Filters.reject(Quantity.THERMOCOUPLE);
                    Predicate<Quantity> predicate2 = predicate.and(this.d_measCombo.getFilter());
                    this.d_measCombo.setFilter(predicate2);
                }
                this.d_measCombo.setEnabled(true);
            }
        }

        public GasPointMeasurer create(String string) {
            if (((IQuantity)this.d_measCombo.getSelectedItem()).get().equals((Object)Quantity.THERMOCOUPLE)) {
                return new Thermocouple(string, new FreePointLoc());
            }
            return new GasPointMeasurer(string, (IQuantity)this.d_measCombo.getSelectedItem(), new FreePointLoc());
        }

        public void save(GasPointMeasurer gasPointMeasurer) {
            if (gasPointMeasurer instanceof Thermocouple) {
                assert (((IQuantity)this.d_measCombo.getSelectedItem()).get().equals((Object)Quantity.THERMOCOUPLE));
                Thermocouple thermocouple = (Thermocouple)gasPointMeasurer;
                this.d_thermocouplePanel.save(thermocouple);
            } else {
                IQuantity iQuantity = (IQuantity)this.d_measCombo.getSelectedItem();
                UnitSystem unitSystem = PyroSim.getApp().getUnitSystem();
                Unit unit = unitSystem.getUnit(iQuantity.get().unitType);
                gasPointMeasurer.setQuantity(iQuantity, unit);
            }
        }
    }

    private static class ThermocoupleProps
    extends guiPanel {
        private static final long serialVersionUID = 904712893678455207L;
        private ValueField<UnitDouble> d_beadDiam = ValueFields.udFld(UnitSystem.getSource(9));
        private ValueField<Double> d_emissivity = ValueFields.doubleFld();
        private ValueField<UnitDouble> d_beadDensity = ValueFields.udFld(UnitSystem.getSource(4));
        private ValueField<UnitDouble> d_beadSpecHeat = ValueFields.udFld(UnitSystem.getSource(11));

        public ThermocoupleProps() {
            GridBagHelper gridBagHelper = new GridBagHelper(this);
            gridBagHelper.addRow(Intl.intl("Bead Diameter") + ":", this.d_beadDiam);
            gridBagHelper.addRow(Intl.intl("Emissivity") + ":", this.d_emissivity);
            gridBagHelper.addRow(Intl.intl("Bead Density:"), this.d_beadDensity);
            gridBagHelper.addRow(Intl.intl("Bead Specific Heat:"), this.d_beadSpecHeat);
            gridBagHelper.finalizeRows();
            this.load(new Thermocouple("", null));
        }

        public void load(Thermocouple thermocouple) {
            this.d_beadDiam.setValue(thermocouple.getBeadDiameter());
            this.d_emissivity.setValue(thermocouple.getEmissivity());
            this.d_beadDensity.setValue(thermocouple.getBeadDensity());
            this.d_beadSpecHeat.setValue(thermocouple.getBeadSpecHeat());
        }

        public void save(Thermocouple thermocouple) {
            thermocouple.setBeadDiameter((UnitDouble)this.d_beadDiam.getValue());
            thermocouple.setEmissivity((Double)this.d_emissivity.getValue());
            thermocouple.setBeadDensity((UnitDouble)this.d_beadDensity.getValue());
            thermocouple.setBeadSpecHeat((UnitDouble)this.d_beadSpecHeat.getValue());
        }
    }
}

