/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.devices.measurers.FlowMeasurer;
import pyrosim.domain.quantity.IQuantity;
import pyrosim.domain.quantity.QuantityType;
import pyrosim.gui.MappedListCellRenderer;
import pyrosim.gui.comboboxes.QuantityComboBox;
import pyrosim.gui.devices.ADevcEditor;
import pyrosim.gui.devices.AlarmInfoPanel;
import pyrosim.gui.devices.MsrDeviceEditorUtil;
import pyrosim.gui.geom.AARectangleEditor;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.unitsystem.UnitSystem;
import thunderheadeng.geometry.objs.AARectangle;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.guiComboBox;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;

public class FlowMeasurerEditor
extends ADevcEditor<FlowMeasurer> {
    private final FlowMeasurerDataPanel d_dataPanel;

    public FlowMeasurerEditor(PyroMod pyroMod) {
        this.d_dataPanel = new FlowMeasurerDataPanel(pyroMod);
    }

    @Override
    public String getDesc() {
        return Intl.intl("Flow Measuring Device");
    }

    @Override
    public String getDefName() {
        return Intl.intl("FLOW");
    }

    @Override
    public AlarmInfoPanel createAlarmPanel() {
        final AlarmInfoPanel alarmInfoPanel = new AlarmInfoPanel((IQuantity)this.d_dataPanel.d_measCombo.getSelectedItem());
        this.d_dataPanel.d_measCombo.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                alarmInfoPanel.setCurrentMsr((IQuantity)FlowMeasurerEditor.this.d_dataPanel.d_measCombo.getSelectedItem());
            }
        });
        return alarmInfoPanel;
    }

    @Override
    public IGeomEditor<? extends IGeom> createGeomEditor() {
        return new AARectangleEditor(false);
    }

    @Override
    public FlowMeasurer create() {
        FlowMeasurer flowMeasurer = new FlowMeasurer("", this.d_dataPanel.getQuantity(), new AARectangle(), this.d_dataPanel.getFlowDir());
        this.save(flowMeasurer);
        return flowMeasurer;
    }

    @Override
    public void load(FlowMeasurer flowMeasurer) {
        this.d_dataPanel.load(flowMeasurer);
    }

    @Override
    public void save(FlowMeasurer flowMeasurer) {
        this.d_dataPanel.save(flowMeasurer);
    }

    @Override
    public boolean validateData(Component component, FlowMeasurer flowMeasurer, boolean bl, boolean bl2) {
        return MsrDeviceEditorUtil.validateData(component, flowMeasurer, this.d_dataPanel.getQuantity(), bl, bl2);
    }

    @Override
    public guiPanel getDataPanel() {
        return this.d_dataPanel;
    }

    public static class FlowMeasurerDataPanel
    extends guiPanel {
        private static final long serialVersionUID = -5706326457562312359L;
        private final PyroMod d_domain;
        private final guiComboBox<IQuantity> d_measCombo;
        private final guiComboBox<Integer> d_directionCombo;
        private final String d_bothID = Intl.intl("Both");
        private final String d_negID = Intl.intl("Negative");
        private final String d_posID = Intl.intl("Positive");

        public FlowMeasurerDataPanel(PyroMod pyroMod) {
            this.setLayout(new GridBagLayout());
            this.d_domain = pyroMod;
            this.d_measCombo = new QuantityComboBox(FlowMeasurer.getOutputType(), FlowMeasurer.getQuantityTypes());
            this.d_measCombo.setMinimumSize(this.d_measCombo.getPreferredSize());
            guiLabel guiLabel2 = new guiLabel("Flow Direction:");
            this.d_directionCombo = new guiComboBox<Integer>((T[])new Integer[]{0, 1, 2});
            this.d_directionCombo.setRenderer(new MappedListCellRenderer<Integer>(n -> {
                if (n == null) {
                    return "";
                }
                switch (n) {
                    case 0: {
                        return Intl.intl("Positive");
                    }
                    case 1: {
                        return Intl.intl("Negative");
                    }
                }
                return this.d_measCombo.getSelectedItem().get().quantityType == QuantityType.GAS ? Intl.intl("Both") : Intl.intl("Auto");
            }));
            this.d_directionCombo.setMinimumSize(this.d_directionCombo.getPreferredSize());
            this.d_directionCombo.setSelectedItem(2);
            this.d_measCombo.addItemListener(itemEvent -> {
                if (itemEvent.getStateChange() == 1) {
                    IQuantity iQuantity = this.d_measCombo.getSelectedItem();
                    if (iQuantity.get().quantityType == QuantityType.GAS) {
                        guiLabel2.setText(Intl.intl("Flow Direction:"));
                    } else {
                        guiLabel2.setText(Intl.intl("Wall Normal:"));
                    }
                    this.d_directionCombo.invalidate();
                }
            });
            GridBagHelper gridBagHelper = new GridBagHelper(this);
            gridBagHelper.addRow(Intl.intl("Quantity:"), this.d_measCombo, 0);
            gridBagHelper.addRow(guiLabel2, this.d_directionCombo, 0);
            gridBagHelper.finalizeRows();
        }

        public void load(FlowMeasurer flowMeasurer) {
            this.d_measCombo.setSelectedItem(flowMeasurer.getQuantity());
            this.d_measCombo.setEnabled(true);
            this.d_directionCombo.setSelectedItem(flowMeasurer.getFlowDir());
        }

        public void save(FlowMeasurer flowMeasurer) {
            IQuantity iQuantity = this.d_measCombo.getSelectedItem();
            UnitSystem unitSystem = PyroSim.getApp().getUnitSystem();
            Unit unit = unitSystem.getUnit(iQuantity.get().unitType);
            flowMeasurer.setQuantity(iQuantity, unit);
            flowMeasurer.setFlowDir(this.d_directionCombo.getSelectedItem());
        }

        public IQuantity getQuantity() {
            return this.d_measCombo.getSelectedItem();
        }

        public int getFlowDir() {
            return this.d_directionCombo.getSelectedItem();
        }
    }
}

