/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JSeparator;
import pyrosim.PyroMod;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.IFreezable;
import pyrosim.domain.devices.detectors.IDetector;
import pyrosim.domain.devices.measurers.IMeasurer;
import pyrosim.domain.signals.ISignalSink;
import pyrosim.domain.signals.OneLogicInPin;
import pyrosim.gui.IGridBagAdder;
import pyrosim.gui.controls.ControlSelPnl;
import pyrosim.gui.devices.AlarmInfoPanel;
import pyrosim.gui.devices.IDevcEditor;
import pyrosim.gui.devices.NamePnl;
import pyrosim.gui.devices.TripFlagsPanel;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.gui.guiListBuilder;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.Validateable;
import thunderheadeng.gui.guiPanel;

public class DevicePnl<T extends IDevice>
extends guiPanel {
    private static final long serialVersionUID = 1967996334902404556L;
    public static final int OPT_NAME = 1;
    public static final int OPT_GEOM = 2;
    public static final int OPT_ALL = 3;
    private final PyroMod d_pyMod;
    private final Class<T> d_type;
    private final IDevcEditor<T> d_editor;
    private final NamePnl d_namePnl;
    private final IGeomEditor<? extends IGeom> d_geomEditor;
    private final AlarmInfoPanel d_alarmPanel;
    private final TripFlagsPanel d_tripFlagsPanel;
    private final ControlSelPnl d_eventPanel;
    private T d_loadedObj;
    private List<Validateable> d_toValidate = new ArrayList<Validateable>();

    public DevicePnl(PyroMod pyroMod, Class<T> clazz, IDevcEditor<T> iDevcEditor, int n) {
        AlarmInfoPanel alarmInfoPanel;
        this.d_pyMod = pyroMod;
        this.d_editor = iDevcEditor;
        this.d_type = clazz;
        this.d_geomEditor = DevicePnl.test(n, 2) ? this.d_editor.createGeomEditor() : null;
        this.d_namePnl = DevicePnl.test(n, 1) ? new NamePnl(pyroMod, iDevcEditor.getDefName()) : null;
        this.d_alarmPanel = alarmInfoPanel = IMeasurer.class.isAssignableFrom(clazz) ? iDevcEditor.createAlarmPanel() : null;
        this.d_tripFlagsPanel = IDetector.class.isAssignableFrom(clazz) ? iDevcEditor.createTripPanel() : null;
        this.d_eventPanel = ISignalSink.class.isAssignableFrom(clazz) ? iDevcEditor.createCtrlInputPanel(pyroMod, this.d_namePnl) : null;
        guiListBuilder<Object> guiListBuilder2 = new guiListBuilder<Object>();
        guiListBuilder2.add(this.d_namePnl);
        guiListBuilder2.add(this.d_eventPanel);
        guiListBuilder2.add(iDevcEditor.getDataPanel());
        guiListBuilder2.addSeparator();
        guiListBuilder2.add(this.d_alarmPanel);
        guiListBuilder2.addSeparator();
        guiListBuilder2.add(this.d_tripFlagsPanel);
        guiListBuilder2.addSeparator();
        guiListBuilder2.add(this.d_geomEditor);
        GridBagHelper gridBagHelper = new GridBagHelper(this);
        for (Object t : guiListBuilder2.finalizeList()) {
            if (t instanceof IGridBagAdder) {
                ((IGridBagAdder)t).add(gridBagHelper);
                if (!(t instanceof Validateable)) continue;
                this.d_toValidate.add((Validateable)t);
                continue;
            }
            if (t instanceof Component) {
                gridBagHelper.addFilledRow(t);
                continue;
            }
            if (t != null) continue;
            gridBagHelper.addFilledRow(new JSeparator());
        }
        gridBagHelper.finalizeRows();
        if (this.d_eventPanel != null) {
            this.setMinimumSize(new Dimension(400, 0));
        }
    }

    public IDevcEditor<T> getDevcEditor() {
        return this.d_editor;
    }

    public Class<T> getDevcType() {
        return this.d_type;
    }

    private static final boolean test(int n, int n2) {
        return (n & n2) == n2;
    }

    public void load(T t) {
        IFreezable iFreezable;
        this.d_loadedObj = t;
        if (this.d_namePnl != null) {
            this.d_namePnl.load(t.getName());
        }
        this.d_editor.load(t);
        if (this.d_eventPanel != null) {
            if (this.d_namePnl != null) {
                this.d_eventPanel.setNameSrc(this.d_namePnl.getNameField(), Arrays.asList(t));
            }
            this.d_eventPanel.load(Arrays.asList((OneLogicInPin)((ISignalSink)t).getInputPin()));
        }
        if (this.d_alarmPanel != null) {
            iFreezable = (IMeasurer)t;
            assert (iFreezable.getNumMeasurements() == 1);
            this.d_alarmPanel.load(iFreezable.getQuantity(0), iFreezable.getMsrInfo(0).getAlarmInfo());
        }
        if (this.d_tripFlagsPanel != null) {
            iFreezable = (IDetector)t;
            this.d_tripFlagsPanel.load(iFreezable.getTripFlags());
        }
        if (this.d_geomEditor != null) {
            this.d_geomEditor.load(Arrays.asList(t));
        }
    }

    public T save(T t) {
        IFreezable iFreezable;
        if (t == null) {
            t = this.d_editor.create();
        }
        if (this.d_namePnl != null) {
            t.setName(this.d_namePnl.save());
        }
        this.d_editor.save(t);
        if (this.d_eventPanel != null) {
            this.d_eventPanel.save(Arrays.asList((OneLogicInPin)((ISignalSink)t).getInputPin()));
            t.changedEvt(new Object[0]);
        }
        if (this.d_alarmPanel != null) {
            iFreezable = (IMeasurer)t;
            assert (iFreezable.getNumMeasurements() == 1);
            iFreezable.getMsrInfo(0).setAlarmInfo(this.d_alarmPanel.save());
        }
        if (this.d_tripFlagsPanel != null) {
            iFreezable = (IDetector)t;
            iFreezable.setTripFlags(this.d_tripFlagsPanel.save());
        }
        if (this.d_geomEditor != null) {
            this.d_geomEditor.save(Arrays.asList(t));
            t.setGeom(t.getGeom().bakeIfRecommended());
        }
        return t;
    }

    @Override
    public boolean validateData(boolean bl, boolean bl2) {
        if (!super.validateData(bl, bl2)) {
            return false;
        }
        for (Validateable validateable : this.d_toValidate) {
            if (validateable.validateData(bl, bl2)) continue;
            return false;
        }
        if (!this.d_editor.validateData(this, this.d_loadedObj, bl, bl2)) {
            return false;
        }
        if (this.d_geomEditor != null && this.d_loadedObj != null && !this.d_geomEditor.validateData(Arrays.asList(this.d_loadedObj), bl, bl2)) {
            return false;
        }
        return this.d_eventPanel == null || this.d_loadedObj == null || this.d_eventPanel.validateData(this, (ISignalSink)this.d_loadedObj, bl, bl2);
    }
}

