/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.util.Arrays;
import java.util.Collection;
import java.util.Observable;
import java.util.Set;
import java.util.concurrent.Semaphore;
import java.util.function.Predicate;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroPrefs;
import pyrosim.PyroSim;
import pyrosim.domain.devices.IDevice;
import pyrosim.gui.CustomFDSPanel;
import pyrosim.gui.FDSRecordPreviewPanel;
import pyrosim.gui.InvisibleSplitPane;
import pyrosim.gui.devices.DevicePnl;
import pyrosim.gui.devices.IDevcEditor;
import pyrosim.io.fds.FDS;
import pyrosim.io.fds.FDSRenderRecord;
import thunderheadeng.gui.guiDialog;
import thunderheadeng.gui.guiPanel;

public class DeviceDlg<T extends IDevice>
extends guiDialog {
    private static final long serialVersionUID = -6407963949610169818L;
    private final DevicePnl<T> d_pnl;
    private final CustomFDSPanel d_customPnl;
    private final FDSRecordPreviewPanel d_previewPnl;
    private final int d_advancedIx;
    private T d_loaded = null;
    private static final String ADVANCED = Intl.intl("Advanced");

    public DeviceDlg(JFrame jFrame, PyroMod pyroMod, Class<T> clazz, IDevcEditor<T> iDevcEditor) {
        super((Window)jFrame, iDevcEditor.getDesc(), 9);
        Object object2;
        Object object3;
        Object object4;
        this.d_pnl = new DevicePnl<T>(pyroMod, clazz, iDevcEditor, 3);
        guiPanel guiPanel2 = this.getDialogPane();
        guiPanel2.setLayout(new BorderLayout());
        if (iDevcEditor.getCustomEnabled()) {
            this.d_pnl.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
            this.d_customPnl = new CustomFDSPanel(6);
            object4 = new JTabbedPane();
            ((JTabbedPane)object4).add(Intl.intl("Properties"), this.d_pnl);
            this.d_advancedIx = ((JTabbedPane)object4).getTabCount();
            ((JTabbedPane)object4).add(ADVANCED, this.d_customPnl);
            ((JTabbedPane)object4).addChangeListener(arg_0 -> this.lambda$new$323((JTabbedPane)object4, arg_0));
            object3 = new Semaphore(1);
            guiPanel2.addObserver((arg_0, arg_1) -> this.lambda$new$325((Semaphore)object3, (JTabbedPane)object4, arg_0, arg_1));
            object2 = object4;
            this.d_customPnl.load(Arrays.asList(iDevcEditor.create()));
            this.updateCustomTypes((JTabbedPane)object4);
        } else {
            object2 = this.d_pnl;
            this.d_customPnl = null;
            this.d_advancedIx = -1;
        }
        if (iDevcEditor.getPreviewEnabled() && PyroPrefs.getBoolean(PyroPrefs.PREF_RECORD_PREVIEW)) {
            object4 = iDevcEditor.getFDSPreviewTypes();
            object3 = arg_0 -> DeviceDlg.lambda$new$326((Set)object4, arg_0);
            this.d_previewPnl = new FDSRecordPreviewPanel(FDS.newRenderer(PyroSim.getApp().getMediator(), PyroSim.getApp().getFDSRenderProps()), (Predicate<FDSRenderRecord>)object3);
            this.d_previewPnl.setRenderDeps(true);
            InvisibleSplitPane invisibleSplitPane = new InvisibleSplitPane(0, true, (Component)object2, this.d_previewPnl);
            guiPanel2.add((Component)invisibleSplitPane, "Center");
            guiPanel2.addObserver((observable, object) -> this.preview());
            this.preview();
        } else {
            this.d_previewPnl = null;
            guiPanel2.add((Component)object2, "Center");
        }
        this.setResizable(true);
    }

    private void updateCustomTypes(JTabbedPane jTabbedPane) {
        Collection<String> collection = this.d_pnl.getDevcEditor().getCustomTypes();
        boolean bl = this.d_customPnl.setTypes(collection);
        if (bl) {
            jTabbedPane.setTitleAt(this.d_advancedIx, "<html><i>" + ADVANCED);
        }
    }

    public void load(T t) {
        this.d_pnl.load(t);
        if (this.d_customPnl != null) {
            this.d_customPnl.load(Arrays.asList(t));
        }
        this.d_loaded = t;
        this.preview();
    }

    public T save(T t) {
        T t2 = this.d_pnl.save(t);
        if (this.d_customPnl != null) {
            this.d_customPnl.save(Arrays.asList(t2));
        }
        return t2;
    }

    private void preview() {
        if (this.d_previewPnl == null) {
            return;
        }
        if (!this.getDialogPane().validateData(false, false)) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            try {
                IDevice iDevice = null;
                if (this.d_loaded != null) {
                    iDevice = (IDevice)this.d_loaded.clone();
                }
                iDevice = this.save(iDevice);
                this.d_previewPnl.setRecord(iDevice, true);
            }
            catch (Throwable throwable) {
                System.err.println("[02338fc] FDS Preview Failed: " + throwable.getMessage());
                throwable.printStackTrace();
            }
        });
    }

    private static /* synthetic */ boolean lambda$new$326(Set set, FDSRenderRecord fDSRenderRecord) {
        return set.contains(fDSRenderRecord.getType());
    }

    private /* synthetic */ void lambda$new$325(Semaphore semaphore, JTabbedPane jTabbedPane, Observable observable, Object object) {
        if (!semaphore.tryAcquire()) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            this.updateCustomTypes(jTabbedPane);
            semaphore.release();
        });
    }

    private /* synthetic */ void lambda$new$323(JTabbedPane jTabbedPane, ChangeEvent changeEvent) {
        jTabbedPane.setTitleAt(this.d_advancedIx, ADVANCED);
    }
}

