/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.domain.devices.IDevice;
import pyrosim.domain.devices.aspiration.Aspirator;
import pyrosim.domain.devices.aspiration.AspiratorSampler;
import pyrosim.domain.devices.detectors.HeatDetector;
import pyrosim.domain.devices.detectors.SmokeDetector;
import pyrosim.domain.devices.detectors.SprinklerLink;
import pyrosim.domain.devices.hvac.HvacDevice;
import pyrosim.domain.devices.measurers.AABoxMeasurer;
import pyrosim.domain.devices.measurers.FlowMeasurer;
import pyrosim.domain.devices.measurers.GasPointMeasurer;
import pyrosim.domain.devices.measurers.LayerMeasurer;
import pyrosim.domain.devices.measurers.PathObscurationMeasurer;
import pyrosim.domain.devices.measurers.SolidPointMeasurer;
import pyrosim.domain.devices.measurers.Thermocouple;
import pyrosim.domain.devices.simctrl.ASimCtrlDevice;
import pyrosim.domain.devices.sprayers.DryPipe;
import pyrosim.domain.devices.sprayers.Nozzle;
import pyrosim.domain.devices.sprayers.Sprinkler;
import pyrosim.domain.quantity.Quantity;
import pyrosim.gui.devices.AspiratorEditor;
import pyrosim.gui.devices.AspiratorSamplerEditor;
import pyrosim.gui.devices.DryPipeEditor;
import pyrosim.gui.devices.FlowMeasurerEditor;
import pyrosim.gui.devices.GasPointDevcEditor;
import pyrosim.gui.devices.HRRMsrEditor;
import pyrosim.gui.devices.HeatDetectorEditor;
import pyrosim.gui.devices.HvacDevcEditor;
import pyrosim.gui.devices.IDevcEditor;
import pyrosim.gui.devices.LayerMsrEditor;
import pyrosim.gui.devices.NozzleEditor;
import pyrosim.gui.devices.PathObscMsrEditor;
import pyrosim.gui.devices.SimControlEditor;
import pyrosim.gui.devices.SmokeDetectorEditor;
import pyrosim.gui.devices.SolidPointDeviceEditor;
import pyrosim.gui.devices.SprinklerEditor;
import pyrosim.gui.devices.SprinklerLinkEditor;

public class DevcEditorFactory {
    private static final Map<Class<? extends IDevice>, Class<? extends IDevcEditor>> s_editorMap = new HashMap<Class<? extends IDevice>, Class<? extends IDevcEditor>>();

    private static <T extends IDevice> void add(Class<T> clazz, Class<? extends IDevcEditor<T>> clazz2) {
        s_editorMap.put(clazz, clazz2);
    }

    public static Collection<Class<? extends IDevice>> getAllDevcTypes() {
        return s_editorMap.keySet();
    }

    public static <T extends IDevice> IDevcEditor<T> create(PyroMod pyroMod, Class<T> clazz, IDevcEditor.Mode mode, int n) {
        if (Thermocouple.class.isAssignableFrom(clazz)) {
            return new GasPointDevcEditor(pyroMod, Intl.intl("Thermocouple"), Intl.intl("THCP"), Quantity.THERMOCOUPLE.create(), mode);
        }
        if (ASimCtrlDevice.class.isAssignableFrom(clazz)) {
            return new SimControlEditor();
        }
        if (SolidPointMeasurer.class.isAssignableFrom(clazz)) {
            return new SolidPointDeviceEditor(pyroMod, mode);
        }
        if (GasPointMeasurer.class.isAssignableFrom(clazz)) {
            return new GasPointDevcEditor(pyroMod, mode);
        }
        if (HvacDevice.class.isAssignableFrom(clazz)) {
            return new HvacDevcEditor(pyroMod, mode, n);
        }
        Class<? extends IDevcEditor> clazz2 = s_editorMap.get(clazz);
        if (clazz2 != null) {
            for (Constructor<?> constructor : clazz2.getConstructors()) {
                try {
                    Class<?>[] classArray = constructor.getParameterTypes();
                    if (classArray.length == 1 && PyroMod.class.isAssignableFrom(classArray[0])) {
                        return (IDevcEditor)constructor.newInstance(pyroMod);
                    }
                    if (classArray.length == 0) {
                        return (IDevcEditor)constructor.newInstance(new Object[0]);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return null;
    }

    static {
        DevcEditorFactory.add(Aspirator.class, AspiratorEditor.class);
        DevcEditorFactory.add(AspiratorSampler.class, AspiratorSamplerEditor.class);
        DevcEditorFactory.add(ASimCtrlDevice.class, SimControlEditor.class);
        DevcEditorFactory.add(DryPipe.class, DryPipeEditor.class);
        DevcEditorFactory.add(FlowMeasurer.class, FlowMeasurerEditor.class);
        DevcEditorFactory.add(GasPointMeasurer.class, GasPointDevcEditor.class);
        DevcEditorFactory.add(HeatDetector.class, HeatDetectorEditor.class);
        DevcEditorFactory.add(AABoxMeasurer.class, HRRMsrEditor.class);
        DevcEditorFactory.add(LayerMeasurer.class, LayerMsrEditor.class);
        DevcEditorFactory.add(Nozzle.class, NozzleEditor.class);
        DevcEditorFactory.add(PathObscurationMeasurer.class, PathObscMsrEditor.class);
        DevcEditorFactory.add(SmokeDetector.class, SmokeDetectorEditor.class);
        DevcEditorFactory.add(SolidPointMeasurer.class, SolidPointDeviceEditor.class);
        DevcEditorFactory.add(Sprinkler.class, SprinklerEditor.class);
        DevcEditorFactory.add(SprinklerLink.class, SprinklerLinkEditor.class);
    }
}

