/*
 * Decompiled with CFR 0.152.
 */
package pyrosim.gui.devices;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import org.jscience.physics.units.Unit;
import pyrosim.Intl;
import pyrosim.PyroMod;
import pyrosim.PyroSim;
import pyrosim.domain.APyroObject;
import pyrosim.domain.devices.aspiration.Aspirator;
import pyrosim.domain.devices.aspiration.AspiratorSampler;
import pyrosim.domain.geom.FreePointLoc;
import pyrosim.gui.devices.ADevcEditor;
import pyrosim.gui.geom.FreePointGeomEditor;
import pyrosim.gui.geom.IGeomEditor;
import pyrosim.unitsystem.UnitSystem;
import pyrosim.util.NamedSorter;
import thunderheadeng.geometry.objs.IGeom;
import thunderheadeng.gui.GridBagHelper;
import thunderheadeng.gui.TitleSeparator;
import thunderheadeng.gui.ValueField;
import thunderheadeng.gui.ValueFields;
import thunderheadeng.gui.guiLabel;
import thunderheadeng.gui.guiPanel;
import thunderheadeng.gui.table.guiTable;
import thunderheadeng.gui.table.guiTableEditor;
import thunderheadeng.units.UnitDouble;
import thunderheadeng.util.SortCache;

public class AspiratorEditor
extends ADevcEditor<Aspirator> {
    private final AspiratorDataPanel d_dataPanel = new AspiratorDataPanel();
    private final SamplerPanel d_samplerPanel;

    public AspiratorEditor(PyroMod pyroMod) {
        this.d_samplerPanel = new SamplerPanel(pyroMod);
    }

    @Override
    public String getDesc() {
        return Intl.intl("Aspirator");
    }

    @Override
    public String getDefName() {
        return Intl.intl("ASP");
    }

    @Override
    public IGeomEditor<? extends IGeom> createGeomEditor() {
        return new FreePointGeomEditor();
    }

    @Override
    public guiPanel getDataPanel() {
        guiPanel guiPanel2 = new guiPanel();
        GridBagHelper gridBagHelper = new GridBagHelper(guiPanel2);
        gridBagHelper.addFilledRow(this.d_dataPanel);
        gridBagHelper.addFilledRow(new TitleSeparator(Intl.intl("Input Samplers")));
        gridBagHelper.addFilledRow(this.d_samplerPanel);
        gridBagHelper.finalizeRows();
        return guiPanel2;
    }

    @Override
    public boolean validateData(Component component, Aspirator aspirator, boolean bl, boolean bl2) {
        return true;
    }

    @Override
    public void load(Aspirator aspirator) {
        this.d_dataPanel.setFlowRate(aspirator.getBypassFlowrate());
        this.d_samplerPanel.load(aspirator);
    }

    @Override
    public Aspirator create() {
        return new Aspirator("", this.d_dataPanel.getFlowRate(), new FreePointLoc());
    }

    @Override
    public void save(Aspirator aspirator) {
        aspirator.setBypassFlowrate(this.d_dataPanel.getFlowRate());
        this.d_samplerPanel.save(aspirator);
    }

    public static class AspiratorDataPanel
    extends guiPanel {
        private static final long serialVersionUID = -1724769536556729000L;
        private final ValueField<UnitDouble> d_flowRate;

        public AspiratorDataPanel() {
            this.setLayout(new GridBagLayout());
            this.d_flowRate = ValueFields.udFld(new Aspirator("", null).getBypassFlowrate(), UnitSystem.getSource(38));
            GridBagHelper gridBagHelper = new GridBagHelper(this);
            gridBagHelper.addRow(Intl.intl("Bypass Flow Rate:"), this.d_flowRate);
            gridBagHelper.finalizeRows();
        }

        public UnitDouble getFlowRate() {
            return (UnitDouble)this.d_flowRate.getValue();
        }

        public void setFlowRate(UnitDouble unitDouble) {
            this.d_flowRate.setValue(unitDouble);
        }
    }

    private class SamplerPanel
    extends guiPanel {
        private static final long serialVersionUID = 5423362506775964122L;
        private final SamplerTableModel d_tableModel;
        private guiTable d_table;

        public SamplerPanel(PyroMod pyroMod) {
            super(new BorderLayout());
            this.d_tableModel = new SamplerTableModel(pyroMod);
            if (this.d_tableModel.getRowCount() > 0) {
                this.d_table = new guiTable((TableModel)this.d_tableModel, 0);
                guiTableEditor guiTableEditor2 = new guiTableEditor(this.d_table, 0);
                int n = this.d_table.autoSizeColumns(true, 100);
                guiTableEditor2.setPreferredSize(new Dimension(n, 100));
                this.add((Component)guiTableEditor2, "Center");
            } else {
                this.add((Component)new guiLabel(Intl.intl("There are currently no samplers in the model.")), "Center");
            }
        }

        public void load(Aspirator aspirator) {
            this.d_tableModel.load(aspirator);
        }

        public void save(Aspirator aspirator) {
            this.d_tableModel.save(aspirator);
        }

        private class SamplerTableModel
        extends AbstractTableModel {
            private static final long serialVersionUID = -1056606631145984560L;
            private final Unit d_frUnit;
            private final Unit d_delayUnit;
            private final boolean[] d_enabled;
            private final Double[] d_delays;
            private final Double[] d_flowrates;
            private final SortCache<AspiratorSampler> d_samplers;

            public SamplerTableModel(PyroMod pyroMod) {
                this.d_samplers = new SortCache<AspiratorSampler>(((APyroObject)pyroMod.getDevices()).flatten(AspiratorSampler.class), new NamedSorter());
                this.d_enabled = new boolean[this.d_samplers.size()];
                UnitSystem unitSystem = PyroSim.getApp().getUnitSystem();
                this.d_frUnit = unitSystem.getUnit(38);
                this.d_delayUnit = unitSystem.getUnit(2);
                Aspirator.SamplerLine samplerLine = new Aspirator.SamplerLine(null);
                Arrays.fill(this.d_enabled, false);
                this.d_delays = new Double[this.d_samplers.size()];
                Arrays.fill((Object[])this.d_delays, (Object)samplerLine.d_delay.getValue(this.d_delayUnit));
                this.d_flowrates = new Double[this.d_samplers.size()];
                Arrays.fill((Object[])this.d_flowrates, (Object)samplerLine.d_flowrate.getValue(this.d_frUnit));
            }

            public void save(Aspirator aspirator) {
                ArrayList<Aspirator.SamplerLine> arrayList = new ArrayList<Aspirator.SamplerLine>();
                for (int i = 0; i < this.d_enabled.length; ++i) {
                    if (!this.d_enabled[i] || this.d_flowrates[i] == null || this.d_delays[i] == null) continue;
                    UnitDouble unitDouble = new UnitDouble(this.d_flowrates[i], this.d_frUnit);
                    UnitDouble unitDouble2 = new UnitDouble(this.d_delays[i], this.d_delayUnit);
                    arrayList.add(new Aspirator.SamplerLine(this.d_samplers.get(i), unitDouble, unitDouble2));
                }
                aspirator.setSamplerLines(arrayList);
            }

            public void load(Aspirator aspirator) {
                for (Aspirator.SamplerLine samplerLine : aspirator.getSamplerLines()) {
                    int n = this.d_samplers.indexOf(samplerLine.d_sampler);
                    this.d_enabled[n] = true;
                    this.d_delays[n] = samplerLine.d_delay.getValue(this.d_delayUnit);
                    this.d_flowrates[n] = samplerLine.d_flowrate.getValue(this.d_frUnit);
                }
            }

            @Override
            public int getRowCount() {
                return this.d_samplers.size();
            }

            @Override
            public int getColumnCount() {
                return 4;
            }

            @Override
            public String getColumnName(int n) {
                switch (n) {
                    case 0: {
                        return Intl.intl("Enabled");
                    }
                    case 1: {
                        return Intl.intl("Sampler");
                    }
                    case 2: {
                        return String.format(Intl.intl("Transfer Delay (%s)"), this.d_delayUnit.toString());
                    }
                    case 3: {
                        return String.format(Intl.intl("Flowrate (%s)"), this.d_frUnit.toString());
                    }
                }
                return null;
            }

            @Override
            public Class<?> getColumnClass(int n) {
                switch (n) {
                    case 0: {
                        return Boolean.class;
                    }
                    case 1: {
                        return String.class;
                    }
                    case 2: {
                        return Double.class;
                    }
                    case 3: {
                        return Double.class;
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 == 0 || n2 == 2 || n2 == 3;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                switch (n2) {
                    case 0: {
                        return this.d_enabled[n];
                    }
                    case 1: {
                        return this.d_samplers.get(n).getName();
                    }
                    case 2: {
                        return this.d_delays[n];
                    }
                    case 3: {
                        return this.d_flowrates[n];
                    }
                }
                return null;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                switch (n2) {
                    case 0: {
                        if (object == null) break;
                        this.d_enabled[n] = (Boolean)object;
                        break;
                    }
                    case 2: {
                        this.d_delays[n] = (Double)object;
                        break;
                    }
                    case 3: {
                        this.d_flowrates[n] = (Double)object;
                    }
                }
                this.fireTableChanged(new TableModelEvent(this, n));
            }
        }
    }
}

